/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.domain;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.AttributeOverride;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.domain.LinkStatus;
import org.fao.geonet.domain.LinkType;
import org.fao.geonet.domain.MetadataLink;
import org.fao.geonet.domain.converter.LinkTypeConverter;
import org.fao.geonet.entitylistener.LinkEntityListenerManager;
import org.hibernate.annotations.SortNatural;
import org.hibernate.annotations.Type;

@Entity
@Table(name="Links")
@Cacheable
@Access(value=AccessType.PROPERTY)
@EntityListeners(value={LinkEntityListenerManager.class})
@SequenceGenerator(name="link_id_seq", initialValue=1, allocationSize=1)
public class Link
implements Serializable {
    static final String ID_SEQ_NAME = "link_id_seq";
    public static final String TABLE_NAME = "Links";
    public static final String ID_COLUMN_NAME = "id";
    public static final String LAST_CHECK_COLUMN_NAME = "dateandtime";
    private int _id;
    private String _url;
    private String _protocol;
    private LinkType _linkType = LinkType.HTTP;
    private Set<MetadataLink> records = new HashSet<MetadataLink>();
    private Set<LinkStatus> linkStatus = new TreeSet<LinkStatus>();
    private Integer lastState = 0;
    private ISODate lastCheck;

    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="link_id_seq")
    @Column(name="id", nullable=false)
    public int getId() {
        return this._id;
    }

    public Link setId(int id) {
        this._id = id;
        return this;
    }

    @Column(nullable=false)
    @Convert(converter=LinkTypeConverter.class)
    public LinkType getLinkType() {
        return this._linkType;
    }

    public Link setLinkType(LinkType _linkType) {
        this._linkType = _linkType;
        return this;
    }

    @Column(nullable=true)
    public String getProtocol() {
        return this._protocol;
    }

    public Link setProtocol(String protocol) {
        this._protocol = protocol;
        return this;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER, mappedBy="link", orphanRemoval=true)
    @OrderBy(value="checkDate DESC")
    @SortNatural
    public Set<LinkStatus> getLinkStatus() {
        return this.linkStatus;
    }

    public Link setLinkStatus(Set<LinkStatus> linkStatus) {
        this.linkStatus = linkStatus;
        return this;
    }

    public Integer getLastState() {
        return this.lastState;
    }

    public void setLastState(Integer lastState) {
        this.lastState = lastState;
    }

    @AttributeOverride(name="dateAndTimeUtc", column=@Column(name="dateandtime", length=30))
    public ISODate getLastCheck() {
        return this.lastCheck;
    }

    public void setLastCheck(ISODate lastCheck) {
        this.lastCheck = lastCheck;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="link", orphanRemoval=true)
    public Set<MetadataLink> getRecords() {
        return this.records;
    }

    public Link setRecords(Set<MetadataLink> records) {
        this.records = records;
        return this;
    }

    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="org.hibernate.type.TextType")
    @Column(unique=true)
    public String getUrl() {
        return this._url;
    }

    public Link setUrl(String url) {
        this._url = url;
        return this;
    }

    public void addStatus(LinkStatus linkStatus) {
        linkStatus.setLink(this);
        this.linkStatus.add(linkStatus);
        this.lastState = this.convertStatusToState(linkStatus);
        this.lastCheck = linkStatus.getCheckDate();
    }

    private Integer convertStatusToState(LinkStatus lastStatus) {
        if (lastStatus.isFailing().booleanValue()) {
            return -1;
        }
        return 1;
    }
}

