/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.domain;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.domain.User;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.ldap.userdetails.InetOrgPerson;

public class LDAPUser
extends InetOrgPerson
implements UserDetails {
    private static final long serialVersionUID = -879282571127799714L;
    private final String _userName;
    private Multimap<String, Profile> _groupsAndProfile = HashMultimap.create();
    private User _user;

    public LDAPUser(String username) {
        this._userName = username;
        this._user = new User();
        this._user.setProfile(Profile.RegisteredUser);
        this._user.setUsername(username);
    }

    public void addPrivilege(String group, Profile profile) {
        this._groupsAndProfile.put((Object)group, (Object)profile);
    }

    public Multimap<String, Profile> getPrivileges() {
        return this._groupsAndProfile;
    }

    public void setPrivileges(Multimap<String, Profile> privileges) {
        this._groupsAndProfile = privileges;
    }

    public User getUser() {
        return this._user;
    }

    public void setUser(User user) {
        this._user = user;
        user.setUsername(this._userName);
    }

    public Collection<GrantedAuthority> getAuthorities() {
        return this._user.getAuthorities();
    }

    public String getPassword() {
        return this._user.getUsername();
    }

    public String getUsername() {
        return this._user.getUsername();
    }

    public boolean isAccountNonExpired() {
        return this._user.isAccountNonExpired();
    }

    public boolean isAccountNonLocked() {
        return this._user.isAccountNonLocked();
    }

    public boolean isCredentialsNonExpired() {
        return this._user.isCredentialsNonExpired();
    }

    public boolean isEnabled() {
        return this._user.isEnabled();
    }

    public boolean equals(Object obj) {
        try {
            return super.equals(obj);
        }
        catch (Exception e) {
            return false;
        }
    }

    public int hashCode() {
        if (this.getDn() != null) {
            return super.hashCode();
        }
        return this.getUsername().hashCode();
    }
}

