/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.monitor.webapp;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricsRegistry;
import com.yammer.metrics.core.Timer;
import com.yammer.metrics.core.TimerContext;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public abstract class WebappMetricsFilter
implements Filter {
    private final String otherMetricName;
    private final Map<Integer, String> meterNamesByStatusCode;
    private final String registryAttribute;
    private ConcurrentMap<Integer, Meter> metersByStatusCode;
    private Meter otherMeter;
    private Counter activeRequests;
    private Timer requestTimer;

    public WebappMetricsFilter(String registryAttribute, Map<Integer, String> meterNamesByStatusCode, String otherMetricName) {
        this.registryAttribute = registryAttribute;
        this.otherMetricName = otherMetricName;
        this.meterNamesByStatusCode = meterNamesByStatusCode;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        MetricsRegistry metricsRegistry = this.getMetricsFactory(filterConfig);
        this.metersByStatusCode = new ConcurrentHashMap<Integer, Meter>(this.meterNamesByStatusCode.size());
        for (Map.Entry<Integer, String> entry : this.meterNamesByStatusCode.entrySet()) {
            this.metersByStatusCode.put(entry.getKey(), metricsRegistry.newMeter(WebappMetricsFilter.class, entry.getValue(), "responses", TimeUnit.SECONDS));
        }
        this.otherMeter = metricsRegistry.newMeter(WebappMetricsFilter.class, this.otherMetricName, "responses", TimeUnit.SECONDS);
        this.activeRequests = metricsRegistry.newCounter(WebappMetricsFilter.class, "activeRequests");
        this.requestTimer = metricsRegistry.newTimer(WebappMetricsFilter.class, "requests", TimeUnit.MILLISECONDS, TimeUnit.SECONDS);
    }

    private MetricsRegistry getMetricsFactory(FilterConfig filterConfig) {
        Object o = filterConfig.getServletContext().getAttribute(this.registryAttribute);
        MetricsRegistry metricsRegistry = o instanceof MetricsRegistry ? (MetricsRegistry)o : Metrics.defaultRegistry();
        return metricsRegistry;
    }

    public void destroy() {
        Metrics.defaultRegistry().shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        StatusExposingServletResponse wrappedResponse = new StatusExposingServletResponse((HttpServletResponse)response);
        this.activeRequests.inc();
        TimerContext context = this.requestTimer.time();
        try {
            chain.doFilter(request, (ServletResponse)wrappedResponse);
        }
        finally {
            context.stop();
            this.activeRequests.dec();
            this.markMeterForStatusCode(wrappedResponse.getStatus());
        }
    }

    private void markMeterForStatusCode(int status) {
        Meter metric = (Meter)this.metersByStatusCode.get(status);
        if (metric != null) {
            metric.mark();
        } else {
            this.otherMeter.mark();
        }
    }

    private static class StatusExposingServletResponse
    extends HttpServletResponseWrapper {
        private int httpStatus;

        public StatusExposingServletResponse(HttpServletResponse response) {
            super(response);
        }

        public void sendError(int sc) throws IOException {
            this.httpStatus = sc;
            super.sendError(sc);
        }

        public void sendError(int sc, String msg) throws IOException {
            this.httpStatus = sc;
            super.sendError(sc, msg);
        }

        public int getStatus() {
            return this.httpStatus;
        }

        public void setStatus(int sc) {
            this.httpStatus = sc;
            super.setStatus(sc);
        }
    }
}

