/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ows.wms;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.geotools.api.data.ResourceInfo;
import org.geotools.api.data.ServiceInfo;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.data.ows.AbstractOpenWebService;
import org.geotools.data.ows.GetCapabilitiesRequest;
import org.geotools.data.ows.GetCapabilitiesResponse;
import org.geotools.data.ows.OperationType;
import org.geotools.data.ows.Specification;
import org.geotools.geometry.GeneralBounds;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.http.HTTPClient;
import org.geotools.http.HTTPClientFinder;
import org.geotools.ows.ServiceException;
import org.geotools.ows.wms.CRSEnvelope;
import org.geotools.ows.wms.Layer;
import org.geotools.ows.wms.WMS1_0_0;
import org.geotools.ows.wms.WMS1_1_0;
import org.geotools.ows.wms.WMS1_1_1;
import org.geotools.ows.wms.WMS1_3_0;
import org.geotools.ows.wms.WMSCapabilities;
import org.geotools.ows.wms.WMSSpecification;
import org.geotools.ows.wms.request.DescribeLayerRequest;
import org.geotools.ows.wms.request.GetFeatureInfoRequest;
import org.geotools.ows.wms.request.GetLegendGraphicRequest;
import org.geotools.ows.wms.request.GetMapRequest;
import org.geotools.ows.wms.request.GetStylesRequest;
import org.geotools.ows.wms.request.PutStylesRequest;
import org.geotools.ows.wms.response.DescribeLayerResponse;
import org.geotools.ows.wms.response.GetFeatureInfoResponse;
import org.geotools.ows.wms.response.GetLegendGraphicResponse;
import org.geotools.ows.wms.response.GetMapResponse;
import org.geotools.ows.wms.response.GetStylesResponse;
import org.geotools.ows.wms.response.PutStylesResponse;
import org.geotools.ows.wms.xml.WMSSchema;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;

public class WebMapServer
extends AbstractOpenWebService<WMSCapabilities, Layer> {
    public WebMapServer(WMSCapabilities capabilities) throws IOException, ServiceException {
        super(capabilities.getRequest().getGetCapabilities().getGet(), HTTPClientFinder.createClient(), capabilities);
    }

    public WebMapServer(URL serverURL) throws IOException, ServiceException {
        super(serverURL);
    }

    public WebMapServer(URL serverURL, HTTPClient httpClient) throws IOException, ServiceException {
        super(serverURL, httpClient);
    }

    public WebMapServer(URL serverURL, HTTPClient httpClient, Map<String, Object> hints) throws IOException, ServiceException {
        super(serverURL, httpClient, null, hints);
    }

    public WebMapServer(URL serverURL, HTTPClient httpClient, Map<String, Object> hints, Map<String, String> headers) throws IOException, ServiceException {
        super(serverURL, httpClient, null, hints, headers);
    }

    public WebMapServer(URL serverURL, int timeout) throws IOException, ServiceException {
        super(serverURL, WebMapServer.getHttpClient(timeout));
    }

    public static HTTPClient getHttpClient(int timeout) {
        HTTPClient client = HTTPClientFinder.createClient();
        client.setReadTimeout(timeout);
        return client;
    }

    @Override
    protected void setupSpecifications() {
        this.specs = new Specification[4];
        this.specs[0] = new WMS1_0_0();
        this.specs[1] = new WMS1_1_0();
        this.specs[2] = new WMS1_1_1();
        this.specs[3] = new WMS1_3_0();
    }

    @Override
    protected ServiceInfo createInfo() {
        return new WMSInfo();
    }

    @Override
    protected ResourceInfo createInfo(Layer layer) {
        return new LayerInfo(layer);
    }

    @Override
    public GetCapabilitiesResponse issueRequest(GetCapabilitiesRequest request) throws IOException, ServiceException {
        return (GetCapabilitiesResponse)this.internalIssueRequest(request);
    }

    public GetMapResponse issueRequest(GetMapRequest request) throws IOException, ServiceException {
        return (GetMapResponse)this.internalIssueRequest(request);
    }

    public GetFeatureInfoResponse issueRequest(GetFeatureInfoRequest request) throws IOException, ServiceException {
        return (GetFeatureInfoResponse)this.internalIssueRequest(request);
    }

    public DescribeLayerResponse issueRequest(DescribeLayerRequest request) throws IOException, ServiceException {
        return (DescribeLayerResponse)this.internalIssueRequest(request);
    }

    public GetLegendGraphicResponse issueRequest(GetLegendGraphicRequest request) throws IOException, ServiceException {
        return (GetLegendGraphicResponse)this.internalIssueRequest(request);
    }

    public GetStylesResponse issueRequest(GetStylesRequest request) throws IOException, ServiceException {
        return (GetStylesResponse)this.internalIssueRequest(request);
    }

    public PutStylesResponse issueRequest(PutStylesRequest request) throws IOException, ServiceException {
        return (PutStylesResponse)this.internalIssueRequest(request);
    }

    @Override
    public WMSCapabilities getCapabilities() {
        return (WMSCapabilities)this.capabilities;
    }

    private WMSSpecification getSpecification() {
        return (WMSSpecification)this.specification;
    }

    private URL findURL(OperationType operation) {
        if (operation.getGet() != null) {
            return operation.getGet();
        }
        return this.serverURL;
    }

    public GetMapRequest createGetMapRequest() {
        URL onlineResource = this.findURL(this.getCapabilities().getRequest().getGetMap());
        return this.getSpecification().createGetMapRequest(onlineResource);
    }

    public GetFeatureInfoRequest createGetFeatureInfoRequest(GetMapRequest getMapRequest) {
        if (this.getCapabilities().getRequest().getGetFeatureInfo() == null) {
            throw new UnsupportedOperationException("This Web Map Server does not support GetFeatureInfo requests");
        }
        URL onlineResource = this.findURL(this.getCapabilities().getRequest().getGetFeatureInfo());
        GetFeatureInfoRequest request = this.getSpecification().createGetFeatureInfoRequest(onlineResource, getMapRequest);
        return request;
    }

    public DescribeLayerRequest createDescribeLayerRequest() throws UnsupportedOperationException {
        if (this.getCapabilities().getRequest().getDescribeLayer() == null) {
            throw new UnsupportedOperationException("Server does not specify a DescribeLayer operation. Cannot be performed");
        }
        URL onlineResource = this.getCapabilities().getRequest().getDescribeLayer().getGet();
        if (onlineResource == null) {
            onlineResource = this.serverURL;
        }
        DescribeLayerRequest request = this.getSpecification().createDescribeLayerRequest(onlineResource);
        return request;
    }

    public GetLegendGraphicRequest createGetLegendGraphicRequest() throws UnsupportedOperationException {
        if (this.getCapabilities().getRequest().getGetLegendGraphic() == null) {
            throw new UnsupportedOperationException("Server does not specify a GetLegendGraphic operation. Cannot be performed");
        }
        URL onlineResource = this.getCapabilities().getRequest().getGetLegendGraphic().getGet();
        if (onlineResource == null) {
            onlineResource = this.serverURL;
        }
        GetLegendGraphicRequest request = this.getSpecification().createGetLegendGraphicRequest(onlineResource);
        return request;
    }

    public GetStylesRequest createGetStylesRequest() throws UnsupportedOperationException {
        if (this.getCapabilities().getRequest().getGetStyles() == null) {
            throw new UnsupportedOperationException("Server does not specify a GetStyles operation. Cannot be performed");
        }
        URL onlineResource = this.getCapabilities().getRequest().getGetStyles().getGet();
        if (onlineResource == null) {
            onlineResource = this.serverURL;
        }
        GetStylesRequest request = this.getSpecification().createGetStylesRequest(onlineResource);
        return request;
    }

    public PutStylesRequest createPutStylesRequest() throws UnsupportedOperationException {
        if (this.getCapabilities().getRequest().getPutStyles() == null) {
            throw new UnsupportedOperationException("Server does not specify a PutStyles operation. Cannot be performed");
        }
        URL onlineResource = this.getCapabilities().getRequest().getPutStyles().getGet();
        if (onlineResource == null) {
            onlineResource = this.serverURL;
        }
        PutStylesRequest request = this.getSpecification().createPutStylesRequest(onlineResource);
        return request;
    }

    public GeneralBounds getEnvelope(Layer layer, CoordinateReferenceSystem crs) {
        return layer.getEnvelope(crs);
    }

    public class LayerInfo
    implements ResourceInfo {
        private ReferencedEnvelope bounds;
        private Set<String> keywords;
        private Icon icon;
        private Layer layer;

        LayerInfo(Layer layer) {
            this.layer = layer;
            Object env = null;
            CoordinateReferenceSystem crs = null;
            if (layer.getBoundingBoxes().isEmpty()) {
                env = layer.getEnvelope((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            } else {
                String epsg4326 = "EPSG:4326";
                String epsg4269 = "EPSG:4269";
                CRSEnvelope bbox = layer.getBoundingBoxes().containsKey(epsg4326) ? layer.getBoundingBoxes().get(epsg4326) : (layer.getBoundingBoxes().containsKey(epsg4269) ? layer.getBoundingBoxes().get(epsg4269) : layer.getBoundingBoxes().values().iterator().next());
                try {
                    crs = CRS.decode((String)bbox.getEPSGCode());
                    env = new ReferencedEnvelope(bbox.getMinX(), bbox.getMaxX(), bbox.getMinY(), bbox.getMaxY(), crs);
                }
                catch (FactoryException e) {
                    crs = DefaultGeographicCRS.WGS84;
                    env = layer.getEnvelope(crs);
                }
            }
            this.bounds = new ReferencedEnvelope(env.getMinimum(0), env.getMaximum(0), env.getMinimum(1), env.getMaximum(1), crs);
            String source = WebMapServer.this.getInfo().getSource().toString();
            this.keywords = new TreeSet<String>();
            if (layer.getKeywords() != null) {
                List<String> more = Arrays.asList(layer.getKeywords());
                this.keywords.addAll(more);
            }
            if (layer.getName() != null) {
                this.keywords.add(layer.getName());
            }
            if (layer.getTitle() != null) {
                this.keywords.add(layer.getTitle());
            }
            this.keywords.add(((WMSCapabilities)WebMapServer.this.capabilities).getService().getName());
            this.keywords.add(source);
            this.keywords.addAll(WebMapServer.this.getInfo().getKeywords());
        }

        @Override
        public ReferencedEnvelope getBounds() {
            return this.bounds;
        }

        @Override
        public CoordinateReferenceSystem getCRS() {
            return this.bounds.getCoordinateReferenceSystem();
        }

        @Override
        public String getDescription() {
            String description = this.layer.get_abstract();
            if (description != null && description.length() != 0) {
                return description;
            }
            return WebMapServer.this.getCapabilities().getService().get_abstract();
        }

        public synchronized Icon getIcon() {
            if (this.icon == null) {
                URL image = WebMapServer.class.getResource("image.png");
                this.icon = new ImageIcon(image);
                if (this.layer.getChildren() != null && this.layer.getChildren().length != 0) {
                    return this.icon;
                }
                OperationType getLegendGraphic = WebMapServer.this.getCapabilities().getRequest().getGetLegendGraphic();
                if (getLegendGraphic == null) {
                    return this.icon;
                }
                GetLegendGraphicRequest request = WebMapServer.this.createGetLegendGraphicRequest();
                request.setLayer(this.layer.getName());
                request.setWidth("16");
                request.setHeight("16");
                String desiredFormat = null;
                List<String> formats = getLegendGraphic.getFormats();
                if (formats.contains("image/png")) {
                    desiredFormat = "image/png";
                } else if (formats.contains("image/gif")) {
                    desiredFormat = "image/gif";
                } else {
                    return this.icon;
                }
                request.setFormat(desiredFormat);
                request.setStyle("");
                URL legendGraphics = request.getFinalURL();
                this.icon = new ImageIcon(legendGraphics);
            }
            return this.icon;
        }

        @Override
        public Set<String> getKeywords() {
            return this.keywords;
        }

        @Override
        public String getName() {
            return this.layer.getName();
        }

        @Override
        public URI getSchema() {
            return WebMapServer.this.getInfo().getSchema();
        }

        @Override
        public String getTitle() {
            String title = this.layer.getTitle();
            if (title != null && title.length() != 0) {
                return title;
            }
            return WebMapServer.this.getCapabilities().getService().getTitle();
        }
    }

    protected class WMSInfo
    implements ServiceInfo {
        private Set<String> keywords = new HashSet<String>();
        private Icon icon;

        WMSInfo() {
            String[] array;
            if (((WMSCapabilities)WebMapServer.this.capabilities).getService() != null && (array = ((WMSCapabilities)WebMapServer.this.capabilities).getService().getKeywordList()) != null) {
                this.keywords.addAll(Arrays.asList(array));
            }
            this.keywords.add("WMS");
            this.keywords.add(WebMapServer.this.serverURL.toString());
            URL globe2 = WebMapServer.class.getResource("Globe2.png");
            this.icon = new ImageIcon(globe2);
        }

        @Override
        public String getDescription() {
            Object description = null;
            if (WebMapServer.this.capabilities != null && ((WMSCapabilities)WebMapServer.this.capabilities).getService() != null) {
                description = ((WMSCapabilities)WebMapServer.this.capabilities).getService().get_abstract();
            }
            if (description == null) {
                description = "Web Map Server " + WebMapServer.this.serverURL;
            }
            return description;
        }

        public Icon getIcon() {
            return this.icon;
        }

        @Override
        public Set<String> getKeywords() {
            return this.keywords;
        }

        @Override
        public URI getPublisher() {
            try {
                return ((WMSCapabilities)WebMapServer.this.capabilities).getService().getContactInformation().getContactInfo().getOnLineResource().getLinkage();
            }
            catch (NullPointerException nullPointerException) {
                try {
                    return new URI(WebMapServer.this.serverURL.getProtocol() + ":" + WebMapServer.this.serverURL.getHost());
                }
                catch (URISyntaxException uRISyntaxException) {
                    return null;
                }
            }
        }

        @Override
        public URI getSchema() {
            return WMSSchema.NAMESPACE;
        }

        @Override
        public URI getSource() {
            try {
                URL source = WebMapServer.this.getCapabilities().getRequest().getGetCapabilities().getGet();
                return source.toURI();
            }
            catch (NullPointerException | URISyntaxException source) {
                try {
                    return WebMapServer.this.serverURL.toURI();
                }
                catch (URISyntaxException e) {
                    return null;
                }
            }
        }

        @Override
        public String getTitle() {
            if (WebMapServer.this.capabilities != null && ((WMSCapabilities)WebMapServer.this.capabilities).getService() != null) {
                return ((WMSCapabilities)WebMapServer.this.capabilities).getService().getTitle();
            }
            if (WebMapServer.this.serverURL == null) {
                return "Unavailable";
            }
            return WebMapServer.this.serverURL.toString();
        }
    }
}

