/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.schema.LinkPatternStreamer;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.fao.geonet.kernel.schema.LinkPatternStreamer.ILinkBuilder;
import org.fao.geonet.utils.Xml;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.springframework.util.StringUtils;

public class RawLinkPatternStreamer<L, M> {
    private static final Pattern SEARCH_URL_IN_STRING_REGEX = Pattern.compile("(http|ftp|https):\\/\\/([\\w_-]+(?:(?:\\.[\\w_-]+)+))([\\w.,@?^=%&:\\/~+#-]*[\\w@?^=%&\\/~+#-])?", 2);
    private Pattern pattern = SEARCH_URL_IN_STRING_REGEX;
    private Pattern excludePattern;
    private ILinkBuilder<L, M> linkBuilder;
    private List<Namespace> namespaces;
    private String rawTextXPath;

    public RawLinkPatternStreamer(ILinkBuilder linkBuilder, String excludePattern) {
        this.linkBuilder = linkBuilder;
        if (!StringUtils.isEmpty((Object)excludePattern)) {
            this.excludePattern = Pattern.compile(excludePattern);
        }
    }

    public void setRawTextXPath(String rawTextXPath) {
        this.rawTextXPath = rawTextXPath;
    }

    public void setNamespaces(List<Namespace> namespaces) {
        this.namespaces = namespaces;
    }

    public void processAllRawText(Element metadata, M ref) throws JDOMException {
        List encounteredLinks = Xml.selectNodes((Element)metadata, (String)this.rawTextXPath, this.namespaces);
        encounteredLinks.stream().forEach(rawTextElem -> this.processOneRawText((Element)rawTextElem, ref));
    }

    private void processOneRawText(Element rawTextElem, M ref) {
        Matcher m = this.pattern.matcher(rawTextElem.getValue());
        while (m.find()) {
            String url = m.toMatchResult().group();
            if (this.excludePattern != null && this.excludePattern.matcher(url).find()) continue;
            L link = this.linkBuilder.found(url);
            this.linkBuilder.persist(link, ref);
        }
    }
}

