/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.expressions;

import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.ColorExpression;
import com.github.sommeri.less4j.core.ast.CssString;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.FaultyExpression;
import com.github.sommeri.less4j.core.ast.FunctionExpression;
import com.github.sommeri.less4j.core.ast.ListExpression;
import com.github.sommeri.less4j.core.compiler.expressions.CatchAllMultiParameterFunction;
import com.github.sommeri.less4j.core.compiler.expressions.TypesConversionUtils;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.core.problems.ProblemsHandler;
import com.github.sommeri.less4j.utils.InStringCssPrinter;
import com.github.sommeri.less4j.utils.PrintUtils;
import java.util.Iterator;
import java.util.List;

class SvgGradient
extends CatchAllMultiParameterFunction {
    private final TypesConversionUtils conversions = new TypesConversionUtils();

    SvgGradient() {
    }

    @Override
    protected Expression evaluate(List<Expression> splitParameters, ProblemsHandler problemsHandler, FunctionExpression functionCall, HiddenTokenAwareTree token) {
        String direction = this.toDirection(splitParameters.get(0));
        String gradientDirectionSvg = "";
        List<Expression> stops = splitParameters.subList(1, splitParameters.size());
        String gradientType = "linear";
        String rectangleDimension = "x=\"0\" y=\"0\" width=\"1\" height=\"1\"";
        boolean useBase64 = true;
        if ("to bottom".equals(direction)) {
            gradientDirectionSvg = "x1=\"0%\" y1=\"0%\" x2=\"0%\" y2=\"100%\"";
        } else if ("to right".equals(direction)) {
            gradientDirectionSvg = "x1=\"0%\" y1=\"0%\" x2=\"100%\" y2=\"0%\"";
        } else if ("to bottom right".equals(direction)) {
            gradientDirectionSvg = "x1=\"0%\" y1=\"0%\" x2=\"100%\" y2=\"100%\"";
        } else if ("to top right".equals(direction)) {
            gradientDirectionSvg = "x1=\"0%\" y1=\"100%\" x2=\"100%\" y2=\"0%\"";
        } else if (direction != null && direction.startsWith("ellipse")) {
            gradientType = "radial";
            gradientDirectionSvg = "cx=\"50%\" cy=\"50%\" r=\"75%\"";
            rectangleDimension = "x=\"-50\" y=\"-50\" width=\"101\" height=\"101\"";
        } else {
            problemsHandler.wrongEnumeratedArgument(functionCall, "direction", "to bottom", "to right", "to bottom right", "to top right", "ellipse", "ellipse at center");
            return new FaultyExpression(functionCall);
        }
        StringBuilder returner = new StringBuilder("<?xml version=\"1.0\" ?>");
        returner.append("<svg xmlns=\"http://www.w3.org/2000/svg\" version=\"1.1\" width=\"100%\" height=\"100%\" viewBox=\"0 0 1 1\" preserveAspectRatio=\"none\">");
        returner.append("<");
        returner.append(gradientType);
        returner.append("Gradient id=\"gradient\" gradientUnits=\"userSpaceOnUse\" ");
        returner.append(gradientDirectionSvg);
        returner.append(">");
        Iterator<Expression> iterator = stops.iterator();
        boolean isFirstStop = true;
        while (iterator.hasNext()) {
            Expression stop = iterator.next();
            if (!this.addColorStop(returner, stop, isFirstStop, !iterator.hasNext(), functionCall, problemsHandler)) {
                return new FaultyExpression(functionCall);
            }
            isFirstStop = false;
        }
        returner.append("</").append(gradientType).append("Gradient>");
        returner.append("<rect ").append(rectangleDimension).append(" fill=\"url(#gradient)\" /></svg>");
        String result = useBase64 ? PrintUtils.base64Encode(returner.toString().getBytes()) : returner.toString();
        return this.toDataUri(functionCall.getUnderlyingStructure(), result, useBase64);
    }

    private Expression toDataUri(HiddenTokenAwareTree token, String data, boolean useBase64) {
        StringBuilder value = new StringBuilder("data:image/svg+xml");
        if (useBase64) {
            value.append(";base64");
        }
        value.append(",").append(data);
        CssString parameter = new CssString(token, value.toString(), "'");
        return new FunctionExpression(token, "url", parameter);
    }

    private boolean addColorStop(StringBuilder returner, Expression colorStop, boolean isFirst, boolean isLast, FunctionExpression errorNode, ProblemsHandler problemsHandler) {
        if (colorStop.getType() == ASTCssNodeType.LIST_EXPRESSION) {
            ListExpression list = (ListExpression)colorStop;
            List<Expression> expressions = list.getExpressions();
            if (expressions.isEmpty() || expressions.size() > 2) {
                problemsHandler.errorSvgGradientArgument(errorNode);
                return false;
            }
            Expression color = expressions.get(0);
            Expression position = expressions.size() > 1 ? expressions.get(1) : null;
            this.addColorStop(returner, color, position, isFirst, isLast, errorNode, problemsHandler);
        } else {
            this.addColorStop(returner, colorStop, null, isFirst, isLast, errorNode, problemsHandler);
        }
        return true;
    }

    private boolean addColorStop(StringBuilder returner, Expression colorE, Expression position, boolean isFirst, boolean isLast, FunctionExpression errorNode, ProblemsHandler problemsHandler) {
        if (colorE.getType() != ASTCssNodeType.COLOR_EXPRESSION) {
            problemsHandler.errorSvgGradientArgument(errorNode);
            return false;
        }
        if (!isLast && !isFirst && position == null) {
            problemsHandler.errorSvgGradientArgument(errorNode);
            return false;
        }
        ColorExpression color = (ColorExpression)colorE;
        String positionValue = position != null ? this.toCss(position) : (isFirst ? "0%" : "100%");
        returner.append("<stop offset=\"").append(positionValue);
        returner.append("\" stop-color=\"").append(color.getValueInHexadecimal());
        returner.append("\"");
        if (color.hasAlpha()) {
            returner.append(" stop-opacity=\"").append(PrintUtils.formatNumber(color.getAlpha())).append("\"");
        }
        returner.append("/>");
        return true;
    }

    private String toDirection(Expression direction) {
        String result = this.conversions.contentToString(direction);
        if (result != null) {
            return result;
        }
        return this.toCss(direction);
    }

    private String toCss(Expression direction) {
        InStringCssPrinter printer = new InStringCssPrinter();
        printer.append(direction);
        return printer.toString();
    }

    @Override
    protected boolean validateParameter(Expression parameter, int position, ProblemsHandler problemsHandler) {
        return true;
    }

    @Override
    protected int getMinParameters() {
        return 3;
    }

    @Override
    protected int getMaxParameters() {
        return Integer.MAX_VALUE;
    }

    @Override
    protected String getName() {
        return "svg-gradient";
    }
}

