/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageioimpl.plugins.tiff;

import it.geosolutions.imageio.plugins.tiff.TIFFTag;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;

public class TIFFLazyData {
    private ImageInputStream stream;
    private long startPosition;
    private int count;
    private int size;

    public TIFFLazyData(ImageInputStream stream, int type, int count) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException("Provided stream argument is null.");
        }
        if (count < 0) {
            throw new IllegalArgumentException("Provided count is negative.");
        }
        this.size = TIFFTag.getSizeOfType(type);
        this.stream = stream;
        this.startPosition = stream.getStreamPosition();
        this.count = count;
    }

    public long getAsLong(int index) {
        long val;
        this.checkIndex(index);
        try {
            this.stream.mark();
            this.stream.seek(this.startPosition + (long)(index * this.size));
            val = this.stream.readUnsignedInt();
            this.stream.reset();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return val;
    }

    public long getAsLong8(int index) {
        long val;
        this.checkIndex(index);
        try {
            this.stream.mark();
            this.stream.seek(this.startPosition + (long)(index * this.size));
            val = this.stream.readLong();
            this.stream.reset();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return val;
    }

    private void checkIndex(int index) {
        if (index > this.count) {
            throw new IllegalArgumentException("Specified index (" + index + ") must be lower than Count:" + this.count);
        }
    }
}

