/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.rio.ntriples;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.rio.RdfDocumentWriter;
import org.openrdf.rio.ntriples.NTriplesUtil;

public class NTriplesWriter
implements RdfDocumentWriter {
    private Writer _out;
    private boolean _writingStarted;

    public NTriplesWriter(OutputStream out) {
        this(new OutputStreamWriter(out));
    }

    public NTriplesWriter(Writer out) {
        this._out = out;
        this._writingStarted = false;
    }

    public void setNamespace(String prefix, String name) {
    }

    public void startDocument() throws IOException {
        if (this._writingStarted) {
            throw new RuntimeException("Document writing has already started");
        }
        this._writingStarted = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endDocument() throws IOException {
        if (!this._writingStarted) {
            throw new RuntimeException("Document writing has not yet started");
        }
        try {
            this._out.flush();
        }
        finally {
            this._writingStarted = false;
        }
    }

    public void writeStatement(Resource subj, URI pred, Value obj) throws IOException {
        if (!this._writingStarted) {
            throw new RuntimeException("Document writing has not yet been started");
        }
        this._writeResource(subj);
        this._out.write(" ");
        this._writeURI(pred);
        this._out.write(" ");
        if (obj instanceof Resource) {
            this._writeResource((Resource)obj);
        } else if (obj instanceof Literal) {
            this._writeLiteral((Literal)obj);
        }
        this._out.write(" .");
        this._writeNewLine();
    }

    public void writeComment(String comment) throws IOException {
        this._out.write("# ");
        this._out.write(comment);
        this._writeNewLine();
    }

    private void _writeResource(Resource res) throws IOException {
        if (res instanceof BNode) {
            this._writeBNode((BNode)res);
        } else {
            this._writeURI((URI)res);
        }
    }

    private void _writeURI(URI uri) throws IOException {
        this._out.write(NTriplesUtil.toNTriplesString(uri));
    }

    private void _writeBNode(BNode bNode) throws IOException {
        this._out.write(NTriplesUtil.toNTriplesString(bNode));
    }

    private void _writeLiteral(Literal lit) throws IOException {
        this._out.write(NTriplesUtil.toNTriplesString(lit));
    }

    private void _writeNewLine() throws IOException {
        this._out.write("\n");
    }
}

