/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.output;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.PdfWriter;
import java.io.OutputStream;
import org.mapfish.print.RenderingContext;
import org.mapfish.print.config.layout.Layout;
import org.mapfish.print.output.OutputFormat;
import org.mapfish.print.output.PrintParams;

public abstract class AbstractOutputFormat
implements OutputFormat {
    protected RenderingContext doPrint(PrintParams params) throws DocumentException {
        String layoutName = params.jsonSpec.getString("layout");
        Layout layout = params.config.getLayout(layoutName);
        if (layout == null) {
            throw new RuntimeException("Unknown layout '" + layoutName + "'");
        }
        Document doc = new Document(layout.getFirstPageSize(null, params.jsonSpec));
        PdfWriter writer = PdfWriter.getInstance((Document)doc, (OutputStream)params.outputStream);
        if (!layout.isSupportLegacyReader()) {
            writer.setFullCompression();
            writer.setPdfVersion(PdfWriter.PDF_VERSION_1_5);
            writer.setCompressionLevel(9);
        }
        RenderingContext context = new RenderingContext(doc, writer, params.config, params.jsonSpec, params.configDir.getPath(), layout, params.headers);
        layout.render(params.jsonSpec, context);
        doc.close();
        writer.close();
        context.getCustomBlocks().closeReaders();
        return context;
    }
}

