/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.map.readers;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.util.DOMUtil;
import org.mapfish.print.RenderingContext;
import org.mapfish.print.map.readers.HTTPMapReader;
import org.mapfish.print.map.readers.ServerInfoCache;
import org.mapfish.print.map.readers.ServiceInfo;
import org.mapfish.print.map.readers.TileCacheLayerInfo;
import org.pvalsecc.misc.URIUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class WMSServiceInfo
extends ServiceInfo {
    private static final Log LOGGER = LogFactory.getLog(WMSServiceInfo.class);
    private static final ServerInfoCache<WMSServiceInfo> cache = new ServerInfoCache<WMSServiceInfo>(new WMSServiceInfoLoader());
    private final Map<String, TileCacheLayerInfo> tileCacheLayers = new HashMap<String, TileCacheLayerInfo>();

    public static synchronized void clearCache() {
        cache.clearCache();
    }

    public static WMSServiceInfo getInfo(URI uri, RenderingContext context) {
        return cache.getInfo(uri, context);
    }

    public boolean isTileCache() {
        return !this.tileCacheLayers.isEmpty();
    }

    public TileCacheLayerInfo getTileCacheLayer(String layerName) {
        return this.tileCacheLayers.get(layerName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("WMSServerInfo");
        sb.append("{tileCacheLayers=").append(this.tileCacheLayers);
        sb.append('}');
        return sb.toString();
    }

    static class WMSServiceInfoLoader
    extends ServerInfoCache.ServiceInfoLoader<WMSServiceInfo> {
        WMSServiceInfoLoader() {
        }

        @Override
        public Log logger() {
            return LOGGER;
        }

        @Override
        public WMSServiceInfo createNewErrorResult() {
            return new WMSServiceInfo();
        }

        @Override
        public URL createURL(URI baseUrl, RenderingContext context) throws UnsupportedEncodingException, URISyntaxException, MalformedURLException {
            HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>();
            URIUtils.addParamOverride(queryParams, "SERVICE", "WMS");
            URIUtils.addParamOverride(queryParams, "REQUEST", "GetCapabilities");
            URIUtils.addParamOverride(queryParams, "VERSION", "1.1.1");
            URL url = URIUtils.addParams(baseUrl, queryParams, HTTPMapReader.OVERRIDE_ALL).toURL();
            return url;
        }

        @Override
        public WMSServiceInfo parseInfo(InputStream stream) throws ParserConfigurationException, IOException, SAXException {
            DocumentBuilder documentBuilder = ServiceInfo.documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    return new InputSource(new StringReader(""));
                }
            });
            Document doc = documentBuilder.parse(stream);
            NodeList tileSets = doc.getElementsByTagName("TileSet");
            boolean isTileCache = tileSets.getLength() > 0;
            WMSServiceInfo result = new WMSServiceInfo();
            if (isTileCache) {
                NodeList layers = doc.getElementsByTagName("Layer");
                for (int i = 0; i < tileSets.getLength(); ++i) {
                    Node tileSet = tileSets.item(i);
                    Node layer = layers.item(i + 1);
                    String resolutions = DOMUtil.getChildText((Node)DOMUtil.getFirstChildElement((Node)tileSet, (String)"Resolutions"));
                    int width = Integer.parseInt(DOMUtil.getChildText((Node)DOMUtil.getFirstChildElement((Node)tileSet, (String)"Width")));
                    int height = Integer.parseInt(DOMUtil.getChildText((Node)DOMUtil.getFirstChildElement((Node)tileSet, (String)"Height")));
                    Element bbox = DOMUtil.getFirstChildElement((Node)layer, (String)"BoundingBox");
                    float minX = Float.parseFloat(DOMUtil.getAttrValue((Element)bbox, (String)"minx"));
                    float minY = Float.parseFloat(DOMUtil.getAttrValue((Element)bbox, (String)"miny"));
                    float maxX = Float.parseFloat(DOMUtil.getAttrValue((Element)bbox, (String)"maxx"));
                    float maxY = Float.parseFloat(DOMUtil.getAttrValue((Element)bbox, (String)"maxy"));
                    String format = DOMUtil.getChildText((Node)DOMUtil.getFirstChildElement((Node)tileSet, (String)"Format"));
                    String layerName = DOMUtil.getChildText((Node)DOMUtil.getFirstChildElement((Node)layer, (String)"Name"));
                    TileCacheLayerInfo info = new TileCacheLayerInfo(resolutions, width, height, minX, minY, maxX, maxY, format);
                    result.tileCacheLayers.put(layerName, info);
                }
            }
            return result;
        }
    }
}

