/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.config.layout;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mapfish.print.config.layout.CellConfig;

public class CellException
extends CellConfig {
    private CoordMatcher row;
    private CoordMatcher col;
    private static final Pattern SIMPLE = Pattern.compile("^\\d+$");
    private static final Pattern RANGE = Pattern.compile("^(\\d+)-(\\d+)$");

    public boolean matches(int row, int col) {
        return !(this.row != null && !this.row.matches(row) || this.col != null && !this.col.matches(col));
    }

    public void setRow(String row) {
        this.row = this.createMatcher(row);
    }

    public void setCol(String col) {
        this.col = this.createMatcher(col);
    }

    private CoordMatcher createMatcher(String value) {
        Matcher simple = SIMPLE.matcher(value);
        if (simple.matches()) {
            return new IntCoordMatcher(Integer.parseInt(value));
        }
        Matcher range = RANGE.matcher(value);
        if (range.matches()) {
            return new IntCoordMatcher(Integer.parseInt(range.group(1)), Integer.parseInt(range.group(2)));
        }
        return new RegExpMatcher(value);
    }

    public static class RegExpMatcher
    implements CoordMatcher {
        private Pattern regexp;

        public RegExpMatcher(String value) {
            this.regexp = Pattern.compile(value);
        }

        @Override
        public boolean matches(int pos) {
            return this.regexp.matcher(Integer.toString(pos)).matches();
        }
    }

    public static class IntCoordMatcher
    implements CoordMatcher {
        private int min;
        private int max;

        public IntCoordMatcher(int min, int max) {
            this.min = min;
            this.max = max;
        }

        public IntCoordMatcher(int value) {
            this.min = value;
            this.max = value;
        }

        @Override
        public boolean matches(int pos) {
            return pos >= this.min && pos <= this.max;
        }

        public String toString() {
            return "IntCoordMatcher{min=" + this.min + ", max=" + this.max + "}";
        }
    }

    public static interface CoordMatcher {
        public boolean matches(int var1);
    }
}

