/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.lowagie.text.DocumentException;
import com.lowagie.text.FontFactory;
import com.lowagie.text.pdf.ByteBuffer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONWriter;
import org.mapfish.print.RenderingContext;
import org.mapfish.print.config.Config;
import org.mapfish.print.config.ConfigFactory;
import org.mapfish.print.output.OutputFactory;
import org.mapfish.print.output.OutputFormat;
import org.mapfish.print.output.PrintParams;
import org.mapfish.print.utils.PJsonObject;
import org.springframework.beans.factory.annotation.Autowired;

public class MapPrinter {
    private static final Logger LOGGER = LogManager.getLogger(MapPrinter.class);
    private Config config;
    private File configDir;
    @Autowired
    private OutputFactory outputFactory;
    @Autowired
    private ConfigFactory configFactory;
    @Autowired
    private MetricRegistry metricRegistry;
    private volatile boolean fontsInitialized = false;
    private int usages = 0;

    public MapPrinter setYamlConfigFile(File configFile) throws FileNotFoundException {
        this.config = this.configFactory.fromYaml(configFile);
        this.configDir = configFile.getParentFile();
        if (this.configDir == null) {
            try {
                this.configDir = new File(".").getCanonicalFile();
            }
            catch (IOException e) {
                this.configDir = new File(".");
            }
        }
        return this;
    }

    public MapPrinter setConfig(String strConfig) {
        this.config = this.configFactory.fromString(strConfig);
        return this;
    }

    public MapPrinter setConfig(InputStream inputConfig) {
        this.config = this.configFactory.fromInputStream(inputConfig);
        return this;
    }

    public MapPrinter setConfigDir(String configDir) {
        this.configDir = new File(configDir);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initFonts() {
        if (!this.fontsInitialized) {
            MapPrinter mapPrinter = this;
            synchronized (mapPrinter) {
                if (!this.fontsInitialized) {
                    FontFactory.defaultEmbedding = true;
                    TreeSet<String> fontPaths = this.config.getFonts();
                    if (fontPaths != null) {
                        String backSlashCompatiblePath = this.configDir.getPath().replace("\\", "/");
                        for (String fontPath : fontPaths) {
                            File fontFile = new File(fontPath = fontPath.replaceAll("\\$\\{configDir\\}", backSlashCompatiblePath));
                            if (fontFile.isDirectory()) {
                                FontFactory.registerDirectory((String)fontPath, (boolean)true);
                                continue;
                            }
                            FontFactory.register((String)fontPath);
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RenderingContext print(PJsonObject jsonSpec, OutputStream outputStream, Map<String, String> headers) throws DocumentException, InterruptedException {
        Timer.Context timer = this.metricRegistry.timer(this.getClass().getName()).time();
        try {
            this.initFonts();
            OutputFormat output = this.outputFactory.create(this.config, jsonSpec);
            PrintParams params = new PrintParams(this.config, this.configDir, jsonSpec, outputStream, headers);
            RenderingContext renderingContext = output.print(params);
            return renderingContext;
        }
        finally {
            long printTime = timer.stop();
            if (TimeUnit.SECONDS.toNanos(this.getConfig().getMaxPrintTimeBeforeWarningInSeconds()) < printTime) {
                LOGGER.warn("[Overtime Print] " + jsonSpec.getInternalObj());
            }
        }
    }

    public static PJsonObject parseSpec(String spec) {
        JSONObject jsonSpec;
        try {
            jsonSpec = new JSONObject(spec);
        }
        catch (JSONException e) {
            throw new RuntimeException("Cannot parse the spec file: " + e.getMessage() + ": " + spec, e);
        }
        return new PJsonObject(jsonSpec, "spec");
    }

    public void printClientConfig(JSONWriter json) throws JSONException {
        this.config.printClientConfig(json);
    }

    @PreDestroy
    public synchronized void stop() {
        --this.usages;
        if (this.config != null && this.usages <= 0) {
            this.usages = 0;
            this.config.close();
            this.config = null;
        }
    }

    public synchronized void start() {
        ++this.usages;
    }

    public String getOutputFilename(String layout, String defaultName) {
        String name = this.config.getOutputFilename(layout);
        return name == null ? defaultName : name;
    }

    public Config getConfig() {
        return this.config;
    }

    public OutputFormat getOutputFormat(PJsonObject jsonSpec) {
        return this.outputFactory.create(this.config, jsonSpec);
    }

    public boolean isRunning() {
        return this.config != null;
    }

    static {
        ByteBuffer.HIGH_PRECISION = true;
    }
}

