/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.vectors;

import org.apache.lucene.search.KnnByteVectorQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TopDocs;
import org.elasticsearch.search.profile.query.QueryProfiler;
import org.elasticsearch.search.vectors.ProfilingQuery;

public class ESKnnByteVectorQuery
extends KnnByteVectorQuery
implements ProfilingQuery {
    private long vectorOpsCount;

    public ESKnnByteVectorQuery(String field, byte[] target, int k, Query filter) {
        super(field, target, k, filter);
    }

    protected TopDocs mergeLeafResults(TopDocs[] perLeafResults) {
        TopDocs topK = super.mergeLeafResults(perLeafResults);
        this.vectorOpsCount = topK.totalHits.value;
        return topK;
    }

    @Override
    public void profile(QueryProfiler queryProfiler) {
        queryProfiler.setVectorOpsCount(this.vectorOpsCount);
    }
}

