/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.AggregatorReducer;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.CompensatedSum;
import org.elasticsearch.search.aggregations.metrics.InternalNumericMetricsAggregation;
import org.elasticsearch.search.aggregations.metrics.WeightedAvg;
import org.elasticsearch.search.aggregations.support.SamplingContext;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class InternalWeightedAvg
extends InternalNumericMetricsAggregation.SingleValue
implements WeightedAvg {
    private final double sum;
    private final double weight;

    InternalWeightedAvg(String name, double sum, double weight, DocValueFormat format, Map<String, Object> metadata) {
        super(name, format, metadata);
        this.sum = sum;
        this.weight = weight;
    }

    public InternalWeightedAvg(StreamInput in) throws IOException {
        super(in);
        this.sum = in.readDouble();
        this.weight = in.readDouble();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable(this.format);
        out.writeDouble(this.sum);
        out.writeDouble(this.weight);
    }

    static InternalWeightedAvg empty(String name, DocValueFormat format, Map<String, Object> metadata) {
        return new InternalWeightedAvg(name, 0.0, 0.0, format, metadata);
    }

    @Override
    public double value() {
        return this.getValue();
    }

    @Override
    public double getValue() {
        return this.sum / this.weight;
    }

    double getSum() {
        return this.sum;
    }

    double getWeight() {
        return this.weight;
    }

    DocValueFormat getFormatter() {
        return this.format;
    }

    @Override
    public String getWriteableName() {
        return "weighted_avg";
    }

    @Override
    protected AggregatorReducer getLeaderReducer(AggregationReduceContext reduceContext, int size) {
        return new AggregatorReducer(){
            final CompensatedSum sumCompensation = new CompensatedSum(0.0, 0.0);
            final CompensatedSum weightCompensation = new CompensatedSum(0.0, 0.0);

            @Override
            public void accept(InternalAggregation aggregation) {
                InternalWeightedAvg avg = (InternalWeightedAvg)aggregation;
                this.weightCompensation.add(avg.weight);
                this.sumCompensation.add(avg.sum);
            }

            @Override
            public InternalAggregation get() {
                return new InternalWeightedAvg(InternalWeightedAvg.this.getName(), this.sumCompensation.value(), this.weightCompensation.value(), InternalWeightedAvg.this.format, InternalWeightedAvg.this.getMetadata());
            }
        };
    }

    @Override
    public InternalAggregation finalizeSampling(SamplingContext samplingContext) {
        return this;
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(Aggregation.CommonFields.VALUE.getPreferredName(), this.weight != 0.0 ? Double.valueOf(this.getValue()) : null);
        if (this.weight != 0.0 && this.format != DocValueFormat.RAW) {
            builder.field(Aggregation.CommonFields.VALUE_AS_STRING.getPreferredName(), this.format.format(this.getValue()));
        }
        return builder;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.sum, this.weight, this.format.getWriteableName());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        InternalWeightedAvg other = (InternalWeightedAvg)obj;
        return Objects.equals(this.sum, other.sum) && Objects.equals(this.weight, other.weight) && Objects.equals(this.format.getWriteableName(), other.format.getWriteableName());
    }
}

