/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories;

import org.apache.lucene.index.IndexCommit;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.DelegatingActionListener;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.snapshots.IndexShardSnapshotFailedException;
import org.elasticsearch.index.snapshots.IndexShardSnapshotStatus;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.repositories.ShardSnapshotResult;
import org.elasticsearch.repositories.SnapshotIndexCommit;
import org.elasticsearch.snapshots.SnapshotId;

public final class SnapshotShardContext
extends DelegatingActionListener<ShardSnapshotResult, ShardSnapshotResult> {
    private final Store store;
    private final MapperService mapperService;
    private final SnapshotId snapshotId;
    private final IndexId indexId;
    private final SnapshotIndexCommit commitRef;
    @Nullable
    private final String shardStateIdentifier;
    private final IndexShardSnapshotStatus snapshotStatus;
    private final IndexVersion repositoryMetaVersion;
    private final long snapshotStartTime;

    public SnapshotShardContext(Store store, MapperService mapperService, SnapshotId snapshotId, IndexId indexId, SnapshotIndexCommit commitRef, @Nullable String shardStateIdentifier, IndexShardSnapshotStatus snapshotStatus, IndexVersion repositoryMetaVersion, long snapshotStartTime, ActionListener<ShardSnapshotResult> listener) {
        super(commitRef.closingBefore(listener));
        this.store = store;
        this.mapperService = mapperService;
        this.snapshotId = snapshotId;
        this.indexId = indexId;
        this.commitRef = commitRef;
        this.shardStateIdentifier = shardStateIdentifier;
        this.snapshotStatus = snapshotStatus;
        this.repositoryMetaVersion = repositoryMetaVersion;
        this.snapshotStartTime = snapshotStartTime;
    }

    public Store store() {
        return this.store;
    }

    public MapperService mapperService() {
        return this.mapperService;
    }

    public SnapshotId snapshotId() {
        return this.snapshotId;
    }

    public IndexId indexId() {
        return this.indexId;
    }

    public IndexCommit indexCommit() {
        return this.commitRef.indexCommit();
    }

    @Nullable
    public String stateIdentifier() {
        return this.shardStateIdentifier;
    }

    public IndexShardSnapshotStatus status() {
        return this.snapshotStatus;
    }

    public IndexVersion getRepositoryMetaVersion() {
        return this.repositoryMetaVersion;
    }

    public long snapshotStartTime() {
        return this.snapshotStartTime;
    }

    @Override
    public void onResponse(ShardSnapshotResult result) {
        this.delegate.onResponse(result);
    }

    public Releasable withCommitRef() {
        this.snapshotStatus.ensureNotAborted();
        if (this.commitRef.tryIncRef()) {
            return Releasables.releaseOnce(() -> ((SnapshotIndexCommit)this.commitRef).decRef());
        }
        this.snapshotStatus.ensureNotAborted();
        assert (false) : "commit ref closed early in state " + this.snapshotStatus;
        throw new IndexShardSnapshotFailedException(this.store.shardId(), "Store got closed concurrently");
    }
}

