/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.store;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.NoSuchFileException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FilterDirectory;

public abstract class ByteSizeDirectory
extends FilterDirectory {
    protected static long estimateSizeInBytes(Directory directory) throws IOException {
        String[] files;
        long estimatedSize = 0L;
        for (String file : files = directory.listAll()) {
            try {
                estimatedSize += directory.fileLength(file);
            }
            catch (FileNotFoundException | AccessDeniedException | NoSuchFileException iOException) {
                // empty catch block
            }
        }
        return estimatedSize;
    }

    protected ByteSizeDirectory(Directory in) {
        super(in);
    }

    public abstract long estimateSizeInBytes() throws IOException;

    public abstract long estimateDataSetSizeInBytes() throws IOException;
}

