/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.inject;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.elasticsearch.common.inject.ConfigurationException;
import org.elasticsearch.common.inject.InjectorImpl;
import org.elasticsearch.common.inject.MembersInjectorImpl;
import org.elasticsearch.common.inject.SingleMethodInjector;
import org.elasticsearch.common.inject.TypeLiteral;
import org.elasticsearch.common.inject.internal.Errors;
import org.elasticsearch.common.inject.internal.ErrorsException;
import org.elasticsearch.common.inject.internal.FailableCache;
import org.elasticsearch.common.inject.spi.InjectionPoint;

class MembersInjectorStore {
    private final InjectorImpl injector;
    private final FailableCache<TypeLiteral<?>, MembersInjectorImpl<?>> cache = new FailableCache<TypeLiteral<?>, MembersInjectorImpl<?>>(){

        @Override
        protected MembersInjectorImpl<?> create(TypeLiteral<?> type, Errors errors) throws ErrorsException {
            return MembersInjectorStore.this.createWithListeners(type, errors);
        }
    };

    MembersInjectorStore(InjectorImpl injector) {
        this.injector = injector;
    }

    public <T> MembersInjectorImpl<T> get(TypeLiteral<T> key, Errors errors) throws ErrorsException {
        return this.cache.get(key, errors);
    }

    private <T> MembersInjectorImpl<T> createWithListeners(TypeLiteral<T> type, Errors errors) throws ErrorsException {
        Set injectionPoints;
        int numErrorsBefore = errors.size();
        try {
            injectionPoints = InjectionPoint.forInstanceMethods(type);
        }
        catch (ConfigurationException e) {
            errors.merge(e.getErrorMessages());
            injectionPoints = (Set)e.getPartialValue();
        }
        List<SingleMethodInjector> injectors = this.getInjectors(injectionPoints, errors);
        errors.throwIfNewErrors(numErrorsBefore);
        return new MembersInjectorImpl<T>(this.injector, type, injectors);
    }

    List<SingleMethodInjector> getInjectors(Set<InjectionPoint> injectionPoints, Errors errors) {
        ArrayList<SingleMethodInjector> injectors = new ArrayList<SingleMethodInjector>();
        for (InjectionPoint injectionPoint : injectionPoints) {
            try {
                Errors errorsForMember = injectionPoint.isOptional() ? new Errors(injectionPoint) : errors.withSource(injectionPoint);
                SingleMethodInjector injector = new SingleMethodInjector(this.injector, injectionPoint, errorsForMember);
                injectors.add(injector);
            }
            catch (ErrorsException errorsException) {}
        }
        return Collections.unmodifiableList(injectors);
    }
}

