/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.coordination;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.cli.UserException;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.coordination.ElasticsearchNodeCommand;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.env.Environment;
import org.elasticsearch.gateway.PersistedClusterStateService;

public class RemoveIndexSettingsCommand
extends ElasticsearchNodeCommand {
    static final String SETTINGS_REMOVED_MSG = "Index settings were successfully removed from the cluster state";
    static final String CONFIRMATION_MSG = "------------------------------------------------------------------------\n\nYou should only run this tool if you have incompatible index settings in the\ncluster state that prevent the cluster from forming.\nThis tool can cause data loss and its use should be your last resort.\n\nDo you want to proceed?\n";
    private final OptionSpec<String> arguments;

    public RemoveIndexSettingsCommand() {
        super("Removes index settings from the cluster state");
        this.arguments = this.parser.nonOptions("index setting names");
    }

    @Override
    protected void processDataPaths(Terminal terminal, Path[] dataPaths, OptionSet options, Environment env) throws IOException, UserException {
        List settingsToRemove = this.arguments.values(options);
        if (settingsToRemove.isEmpty()) {
            throw new UserException(64, "Must supply at least one index setting to remove");
        }
        PersistedClusterStateService persistedClusterStateService = RemoveIndexSettingsCommand.createPersistedClusterStateService(env.settings(), dataPaths);
        terminal.println(Terminal.Verbosity.VERBOSE, (CharSequence)"Loading cluster state");
        Tuple<Long, ClusterState> termAndClusterState = RemoveIndexSettingsCommand.loadTermAndClusterState(persistedClusterStateService, env);
        ClusterState oldClusterState = (ClusterState)termAndClusterState.v2();
        Metadata.Builder newMetadataBuilder = Metadata.builder(oldClusterState.metadata());
        int changes = 0;
        for (IndexMetadata indexMetadata : oldClusterState.metadata()) {
            Settings oldSettings = indexMetadata.getSettings();
            Settings.Builder newSettings = Settings.builder().put(oldSettings);
            boolean removed = false;
            for (String settingToRemove : settingsToRemove) {
                for (String settingKey : oldSettings.keySet()) {
                    if (!Regex.simpleMatch(settingToRemove, settingKey)) continue;
                    terminal.println((CharSequence)("Index setting [" + settingKey + "] will be removed from index [" + indexMetadata.getIndex() + "]"));
                    newSettings.remove(settingKey);
                    removed = true;
                }
            }
            if (!removed) continue;
            newMetadataBuilder.put(IndexMetadata.builder(indexMetadata).settings(newSettings));
            ++changes;
        }
        if (changes == 0) {
            throw new UserException(64, "No index setting matching " + settingsToRemove + " were found on this node");
        }
        ClusterState newClusterState = ClusterState.builder(oldClusterState).metadata(newMetadataBuilder).build();
        terminal.println(Terminal.Verbosity.VERBOSE, (CharSequence)("[old cluster state = " + oldClusterState + ", new cluster state = " + newClusterState + "]"));
        RemoveIndexSettingsCommand.confirm(terminal, CONFIRMATION_MSG);
        try (PersistedClusterStateService.Writer writer = persistedClusterStateService.createWriter();){
            writer.writeFullStateAndCommit((Long)termAndClusterState.v1(), newClusterState);
        }
        terminal.println((CharSequence)SETTINGS_REMOVED_MSG);
    }
}

