/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.synonyms;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.synonyms.DeleteSynonymsAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.synonyms.SynonymsManagementAPIService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;

public class TransportDeleteSynonymsAction
extends HandledTransportAction<DeleteSynonymsAction.Request, AcknowledgedResponse> {
    private final SynonymsManagementAPIService synonymsManagementAPIService;

    @Inject
    public TransportDeleteSynonymsAction(TransportService transportService, ActionFilters actionFilters, Client client) {
        super("cluster:admin/synonyms/delete", transportService, actionFilters, DeleteSynonymsAction.Request::new, EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.synonymsManagementAPIService = new SynonymsManagementAPIService(client);
    }

    @Override
    protected void doExecute(Task task, DeleteSynonymsAction.Request request, ActionListener<AcknowledgedResponse> listener) {
        this.synonymsManagementAPIService.deleteSynonymsSet(request.synonymsSetId(), listener);
    }
}

