/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.diskusage;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.NoShardAvailableActionException;
import org.elasticsearch.action.admin.indices.diskusage.AnalyzeDiskUsageShardRequest;
import org.elasticsearch.action.admin.indices.diskusage.AnalyzeDiskUsageShardResponse;
import org.elasticsearch.action.admin.indices.diskusage.AnalyzeIndexDiskUsageRequest;
import org.elasticsearch.action.admin.indices.diskusage.AnalyzeIndexDiskUsageResponse;
import org.elasticsearch.action.admin.indices.diskusage.IndexDiskUsageAnalyzer;
import org.elasticsearch.action.admin.indices.diskusage.IndexDiskUsageStats;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.DefaultShardOperationFailedException;
import org.elasticsearch.action.support.broadcast.BroadcastRequest;
import org.elasticsearch.action.support.broadcast.TransportBroadcastAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportAnalyzeIndexDiskUsageAction
extends TransportBroadcastAction<AnalyzeIndexDiskUsageRequest, AnalyzeIndexDiskUsageResponse, AnalyzeDiskUsageShardRequest, AnalyzeDiskUsageShardResponse> {
    public static final ActionType<AnalyzeIndexDiskUsageResponse> TYPE = new ActionType("indices:admin/analyze_disk_usage");
    private final IndicesService indicesService;
    private final ThreadPool threadPool;

    @Inject
    public TransportAnalyzeIndexDiskUsageAction(ClusterService clusterService, TransportService transportService, IndicesService indexServices, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(TYPE.name(), clusterService, transportService, actionFilters, indexNameExpressionResolver, AnalyzeIndexDiskUsageRequest::new, AnalyzeDiskUsageShardRequest::new, transportService.getThreadPool().executor("analyze"));
        this.indicesService = indexServices;
        this.threadPool = transportService.getThreadPool();
    }

    @Override
    protected void doExecute(Task task, AnalyzeIndexDiskUsageRequest request, ActionListener<AnalyzeIndexDiskUsageResponse> listener) {
        new LimitingRequestPerNodeBroadcastAction(task, request, listener, 5).start();
    }

    @Override
    protected AnalyzeDiskUsageShardRequest newShardRequest(int numShards, ShardRouting shard, AnalyzeIndexDiskUsageRequest request) {
        return new AnalyzeDiskUsageShardRequest(shard.shardId(), request);
    }

    @Override
    protected AnalyzeDiskUsageShardResponse readShardResponse(StreamInput in) throws IOException {
        return new AnalyzeDiskUsageShardResponse(in);
    }

    @Override
    protected AnalyzeDiskUsageShardResponse shardOperation(AnalyzeDiskUsageShardRequest request, Task task) throws IOException {
        ShardId shardId = request.shardId();
        assert (task instanceof CancellableTask) : "AnalyzeDiskUsageShardRequest must create a cancellable task";
        CancellableTask cancellableTask = (CancellableTask)task;
        Runnable checkForCancellation = cancellableTask::ensureNotCancelled;
        IndexShard shard = this.indicesService.indexServiceSafe(shardId.getIndex()).getShard(shardId.id());
        try (Engine.IndexCommitRef commitRef = shard.acquireLastIndexCommit(request.flush);){
            IndexDiskUsageStats stats = IndexDiskUsageAnalyzer.analyze(shardId, commitRef.getIndexCommit(), checkForCancellation);
            AnalyzeDiskUsageShardResponse analyzeDiskUsageShardResponse = new AnalyzeDiskUsageShardResponse(shardId, stats);
            return analyzeDiskUsageShardResponse;
        }
    }

    @Override
    protected AnalyzeIndexDiskUsageResponse newResponse(AnalyzeIndexDiskUsageRequest request, AtomicReferenceArray<?> shardsResponses, ClusterState clusterState) {
        int successfulShards = 0;
        ArrayList<DefaultShardOperationFailedException> shardFailures = new ArrayList<DefaultShardOperationFailedException>();
        HashMap<String, IndexDiskUsageStats> combined = new HashMap<String, IndexDiskUsageStats>();
        for (int i = 0; i < shardsResponses.length(); ++i) {
            Object r = shardsResponses.get(i);
            if (r instanceof AnalyzeDiskUsageShardResponse) {
                AnalyzeDiskUsageShardResponse resp = (AnalyzeDiskUsageShardResponse)r;
                ++successfulShards;
                combined.compute(resp.getIndex(), (k, v) -> v == null ? resp.stats : v.add(resp.stats));
                continue;
            }
            if (r instanceof DefaultShardOperationFailedException) {
                DefaultShardOperationFailedException e = (DefaultShardOperationFailedException)r;
                shardFailures.add(e);
                continue;
            }
            if (r instanceof Exception) {
                Exception e = (Exception)r;
                shardFailures.add(new DefaultShardOperationFailedException(ExceptionsHelper.convertToElastic(e)));
                continue;
            }
            assert (false) : "unknown response [" + r + "]";
            throw new IllegalStateException("unknown response [" + r + "]");
        }
        return new AnalyzeIndexDiskUsageResponse(shardsResponses.length(), successfulShards, shardFailures.size(), shardFailures, combined);
    }

    @Override
    protected GroupShardsIterator<ShardIterator> shards(ClusterState clusterState, AnalyzeIndexDiskUsageRequest request, String[] concreteIndices) {
        GroupShardsIterator<ShardIterator> groups = this.clusterService.operationRouting().searchShards(clusterState, concreteIndices, null, null);
        for (ShardIterator group : groups) {
            if (group.size() != 0) continue;
            throw new NoShardAvailableActionException(group.shardId());
        }
        return groups;
    }

    @Override
    protected ClusterBlockException checkGlobalBlock(ClusterState state, AnalyzeIndexDiskUsageRequest request) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    @Override
    protected ClusterBlockException checkRequestBlock(ClusterState state, AnalyzeIndexDiskUsageRequest request, String[] concreteIndices) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_READ, concreteIndices);
    }

    final class LimitingRequestPerNodeBroadcastAction
    extends TransportBroadcastAction.AsyncBroadcastAction {
        private final Queue<ShardRequest> queue;
        private final Map<DiscoveryNode, AtomicInteger> sendingCounters;
        private final int maxConcurrentRequestsPerNode;

        LimitingRequestPerNodeBroadcastAction(Task task, AnalyzeIndexDiskUsageRequest request, ActionListener<AnalyzeIndexDiskUsageResponse> listener, int maxConcurrentRequestsPerNode) {
            super((TransportBroadcastAction)TransportAnalyzeIndexDiskUsageAction.this, task, (BroadcastRequest)request, listener);
            this.queue = new LinkedList<ShardRequest>();
            this.sendingCounters = ConcurrentCollections.newConcurrentMap();
            this.maxConcurrentRequestsPerNode = maxConcurrentRequestsPerNode;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void trySendRequests() {
            assert (!Thread.holdsLock(this));
            ArrayList<ShardRequest> readyRequests = new ArrayList<ShardRequest>();
            LimitingRequestPerNodeBroadcastAction limitingRequestPerNodeBroadcastAction = this;
            synchronized (limitingRequestPerNodeBroadcastAction) {
                Iterator it = this.queue.iterator();
                while (it.hasNext()) {
                    ShardRequest r = (ShardRequest)it.next();
                    AtomicInteger sending = this.sendingCounters.computeIfAbsent(r.node, k -> new AtomicInteger());
                    assert (0 <= sending.get() && sending.get() <= this.maxConcurrentRequestsPerNode) : sending;
                    if (sending.get() >= this.maxConcurrentRequestsPerNode) continue;
                    sending.incrementAndGet();
                    readyRequests.add(r);
                    it.remove();
                }
            }
            if (readyRequests.isEmpty()) {
                return;
            }
            Thread sendingThread = Thread.currentThread();
            for (ShardRequest r : readyRequests) {
                super.sendShardRequest(r.node, r.shardRequest, ActionListener.runAfter(r.handler, () -> this.onRequestResponded(sendingThread, r.node)));
            }
        }

        private void onRequestResponded(Thread sendingThread, DiscoveryNode node) {
            AtomicInteger sending = this.sendingCounters.get(node);
            assert (sending != null && 1 <= sending.get() && sending.get() <= this.maxConcurrentRequestsPerNode) : sending;
            sending.decrementAndGet();
            if (sendingThread == Thread.currentThread()) {
                TransportAnalyzeIndexDiskUsageAction.this.threadPool.generic().execute(this::trySendRequests);
            } else {
                this.trySendRequests();
            }
        }

        protected synchronized void sendShardRequest(DiscoveryNode node, AnalyzeDiskUsageShardRequest shardRequest, ActionListener<AnalyzeDiskUsageShardResponse> listener) {
            this.queue.add(new ShardRequest(node, shardRequest, listener));
        }

        @Override
        public void start() {
            super.start();
            this.trySendRequests();
        }
    }

    private record ShardRequest(DiscoveryNode node, AnalyzeDiskUsageShardRequest shardRequest, ActionListener<AnalyzeDiskUsageShardResponse> handler) {
    }
}

