/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.dangling.import_index;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.admin.indices.dangling.find.FindDanglingIndexRequest;
import org.elasticsearch.action.admin.indices.dangling.find.NodeFindDanglingIndexResponse;
import org.elasticsearch.action.admin.indices.dangling.find.TransportFindDanglingIndexAction;
import org.elasticsearch.action.admin.indices.dangling.import_index.ImportDanglingIndexRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.gateway.LocalAllocateDangledIndices;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;

public class TransportImportDanglingIndexAction
extends HandledTransportAction<ImportDanglingIndexRequest, AcknowledgedResponse> {
    public static final ActionType<AcknowledgedResponse> TYPE = new ActionType("cluster:admin/indices/dangling/import");
    private static final Logger logger = LogManager.getLogger(TransportImportDanglingIndexAction.class);
    private final LocalAllocateDangledIndices danglingIndexAllocator;
    private final NodeClient nodeClient;

    @Inject
    public TransportImportDanglingIndexAction(ActionFilters actionFilters, TransportService transportService, LocalAllocateDangledIndices danglingIndexAllocator, NodeClient nodeClient) {
        super(TYPE.name(), transportService, actionFilters, ImportDanglingIndexRequest::new, EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.danglingIndexAllocator = danglingIndexAllocator;
        this.nodeClient = nodeClient;
    }

    @Override
    protected void doExecute(Task task, final ImportDanglingIndexRequest importRequest, final ActionListener<AcknowledgedResponse> importListener) {
        this.findDanglingIndex(importRequest, new ActionListener<IndexMetadata>(){

            @Override
            public void onResponse(IndexMetadata indexMetaDataToImport) {
                if (!importRequest.isAcceptDataLoss()) {
                    importListener.onFailure(new IllegalArgumentException("accept_data_loss must be set to true"));
                    return;
                }
                final String indexName = indexMetaDataToImport.getIndex().getName();
                final String indexUUID = indexMetaDataToImport.getIndexUUID();
                TransportImportDanglingIndexAction.this.danglingIndexAllocator.allocateDangled(List.of(indexMetaDataToImport), new ActionListener<LocalAllocateDangledIndices.AllocateDangledResponse>(){

                    @Override
                    public void onResponse(LocalAllocateDangledIndices.AllocateDangledResponse allocateDangledResponse) {
                        importListener.onResponse(AcknowledgedResponse.TRUE);
                    }

                    @Override
                    public void onFailure(Exception e) {
                        logger.debug("Failed to import dangling index [" + indexName + "] [" + indexUUID + "]", (Throwable)e);
                        importListener.onFailure(e);
                    }
                });
            }

            @Override
            public void onFailure(Exception e) {
                logger.debug("Failed to find dangling index [" + importRequest.getIndexUUID() + "]", (Throwable)e);
                importListener.onFailure(e);
            }
        });
    }

    private void findDanglingIndex(ImportDanglingIndexRequest request, ActionListener<IndexMetadata> listener) {
        String indexUUID = request.getIndexUUID();
        this.nodeClient.execute(TransportFindDanglingIndexAction.TYPE, new FindDanglingIndexRequest(indexUUID), listener.delegateFailure((l, response) -> {
            if (response.hasFailures()) {
                String nodeIds = response.failures().stream().map(FailedNodeException::nodeId).collect(Collectors.joining(","));
                ElasticsearchException e = new ElasticsearchException("Failed to query nodes [" + nodeIds + "]", new Object[0]);
                for (FailedNodeException failure : response.failures()) {
                    logger.error("Failed to query node [" + failure.nodeId() + "]", (Throwable)failure);
                    e.addSuppressed(failure);
                }
                l.onFailure(e);
                return;
            }
            ArrayList<IndexMetadata> metaDataSortedByVersion = new ArrayList<IndexMetadata>();
            for (NodeFindDanglingIndexResponse each : response.getNodes()) {
                metaDataSortedByVersion.addAll(each.getDanglingIndexInfo());
            }
            metaDataSortedByVersion.sort(Comparator.comparingLong(IndexMetadata::getVersion));
            if (metaDataSortedByVersion.isEmpty()) {
                l.onFailure(new IllegalArgumentException("No dangling index found for UUID [" + indexUUID + "]"));
                return;
            }
            logger.debug("Metadata versions {} found for index UUID [{}], selecting the highest", metaDataSortedByVersion.stream().map(IndexMetadata::getVersion).toList(), (Object)indexUUID);
            l.onResponse((IndexMetadata)metaDataSortedByVersion.get(metaDataSortedByVersion.size() - 1));
        }));
    }
}

