/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.util;

import java.io.IOException;
import java.util.Arrays;
import org.apache.tika.Tika;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
public class FileMimetypeChecker {
    private static final String[] validImagesMimeTypes = new String[]{"image/gif", "image/png", "image/jpeg"};
    private static final String[] validThesaurusMimeTypes = new String[]{"application/xml", "application/rdf+xml"};
    private static final String[] validCsvMimeTypes = new String[]{"text/plain"};

    public void checkValidImageMimeType(MultipartFile file) throws IOException {
        this.checkValidMimeType(file, validImagesMimeTypes);
    }

    public void checkValidThesaurusMimeType(MultipartFile file) throws IOException {
        this.checkValidMimeType(file, validThesaurusMimeTypes);
    }

    public void checkValidCsvMimeType(MultipartFile file) throws IOException {
        this.checkValidMimeType(file, validCsvMimeTypes);
    }

    public void checkValidMimeType(MultipartFile file, String[] validMimeTypes) throws IOException {
        Tika tika = new Tika();
        String mimeType = tika.detect(file.getInputStream());
        if (Arrays.stream(validMimeTypes).noneMatch(m -> m.equals(mimeType))) {
            throw new IllegalArgumentException(String.format("File '%s' with type '%s' is not supported. To allow this file type, configure it in System Settings > Allowed file mime types to attach to a metadata record.", file.getOriginalFilename(), mimeType));
        }
    }
}

