/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.resources;

import java.io.File;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import jeeves.interfaces.Service;
import jeeves.server.ServiceConfig;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import org.apache.commons.io.FileUtils;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.Util;
import org.fao.geonet.ZipUtil;
import org.fao.geonet.api.exception.ResourceNotFoundException;
import org.fao.geonet.api.records.attachments.Store;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.Group;
import org.fao.geonet.domain.MetadataResourceVisibility;
import org.fao.geonet.domain.OperationAllowed;
import org.fao.geonet.domain.ReservedOperation;
import org.fao.geonet.domain.User;
import org.fao.geonet.exceptions.MetadataNotFoundEx;
import org.fao.geonet.exceptions.ResourceNotFoundEx;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.mef.MEFLib;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.lib.Lib;
import org.fao.geonet.repository.GroupRepository;
import org.fao.geonet.repository.OperationAllowedRepository;
import org.fao.geonet.repository.UserRepository;
import org.fao.geonet.services.Utils;
import org.fao.geonet.services.resources.handlers.IResourceDownloadHandler;
import org.fao.geonet.util.MailSender;
import org.fao.geonet.utils.BinaryFile;
import org.fao.geonet.utils.FilePathChecker;
import org.fao.geonet.utils.IO;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.jdom.Content;
import org.jdom.Element;
import org.springframework.core.io.Resource;

public class DownloadArchive
implements Service {
    private static final String FS = File.separator;
    private Path stylePath;

    private static String now() {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(cal.getTime());
    }

    public void init(Path appPath, ServiceConfig params) throws Exception {
        this.stylePath = appPath.resolve("xsl");
    }

    public Element exec(Element params, ServiceContext context) throws Exception {
        User user;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        DataManager dm = (DataManager)gc.getBean(DataManager.class);
        UserSession session = context.getUserSession();
        String id = Utils.getIdentifierFromParameters((Element)params, (ServiceContext)context);
        String access = Util.getParam((Element)params, (String)"access", (String)"public");
        Store store = (Store)context.getBean("resourceStore", Store.class);
        IMetadataUtils metadataUtils = (IMetadataUtils)context.getBean(IMetadataUtils.class);
        String uuid = metadataUtils.getMetadataUuid(id);
        if (access.equals("public")) {
            String fname = Util.getParam((Element)params, (String)"fname");
            FilePathChecker.verify((String)fname);
            try (Store.ResourceHolder resource = store.getResource(context, uuid, MetadataResourceVisibility.PUBLIC, fname, Boolean.valueOf(true));){
                Element element = BinaryFile.encode((int)200, (Resource)resource.getResource(), (int)resource.getMetadata().getMetadataId(), (String)resource.getMetadata().getFilename(), (boolean)false).getElement();
                return element;
            }
        }
        Element elData = (Element)session.getProperty("file.disclaimer");
        if (elData == null) {
            return new Element("response");
        }
        String idAllowed = elData.getChildText("id");
        if (idAllowed == null || !idAllowed.equals(id)) {
            return new Element("response");
        }
        boolean doNotify = false;
        Lib.resource.checkPrivilege(context, id, ReservedOperation.download);
        doNotify = true;
        String username = session.getUsername();
        if (username == null) {
            username = "internet";
        }
        String userId = session.getUserId();
        Element entered = new Element("entered").addContent((Collection)params.cloneContent());
        Element userDetails = new Element("userdetails");
        if (!username.equals("internet") && (user = ((UserRepository)context.getBean(UserRepository.class)).findOne(userId)) != null) {
            userDetails.addContent((Content)user.asXml());
        }
        AbstractMetadata info = ((IMetadataUtils)context.getBean(IMetadataUtils.class)).findOne(id);
        Path zFile = Files.createTempFile(username + "_" + info.getUuid(), ".zip", new FileAttribute[0]);
        try (FileSystem zipFs = ZipUtil.openZipFs((Path)zFile);){
            Object remoteURL;
            Element downloaded = new Element("downloaded");
            List files = params.getChildren("fname");
            for (Element elem : files) {
                String fname = elem.getText();
                try {
                    FilePathChecker.verify((String)fname);
                }
                catch (Exception ex) {
                    continue;
                }
                try {
                    Store.ResourceHolder resource = store.getResource(context, uuid, MetadataResourceVisibility.parse((String)access), fname, Boolean.valueOf(true));
                    try {
                        Element fileInfo = new Element("file");
                        BinaryFile details = BinaryFile.encode((int)200, (Resource)resource.getResource(), (int)resource.getMetadata().getMetadataId(), (String)resource.getMetadata().getFilename(), (boolean)false);
                        remoteURL = details.getElement().getAttributeValue("remotepath");
                        if (remoteURL != null) {
                            if (context.isDebugEnabled()) {
                                context.debug("Downloading " + (String)remoteURL + " to archive " + zFile.getFileName());
                            }
                            fileInfo.setAttribute("size", "unknown");
                            fileInfo.setAttribute("datemodified", "unknown");
                            fileInfo.setAttribute("name", (String)remoteURL);
                            this.notifyAndLog(doNotify, id, info.getUuid(), access, username, (String)remoteURL + " (local config: " + resource.getMetadata().getFilename() + ")", context);
                            fname = details.getElement().getAttributeValue("remotefile");
                        } else {
                            if (context.isDebugEnabled()) {
                                context.debug("Writing " + fname + " to archive " + zFile.getFileName());
                            }
                            fileInfo.setAttribute("size", Long.toString(resource.getMetadata().getSize()));
                            fileInfo.setAttribute("name", fname);
                            fileInfo.setAttribute("datemodified", sdf.format(resource.getMetadata().getLastModification()));
                            this.notifyAndLog(doNotify, id, info.getUuid(), access, username, resource.getMetadata().getFilename(), context);
                        }
                        Path dest = zipFs.getPath(fname, new String[0]);
                        try (OutputStream zos = Files.newOutputStream(dest, new OpenOption[0]);){
                            details.write(zos);
                        }
                        downloaded.addContent((Content)fileInfo);
                    }
                    finally {
                        if (resource == null) continue;
                        resource.close();
                    }
                }
                catch (ResourceNotFoundException e) {
                    throw new ResourceNotFoundEx(e.toString());
                }
            }
            boolean forEditing = false;
            boolean withValidationErrors = false;
            boolean keepXlinkAttributes = false;
            Element elMd = dm.getMetadata(context, id, forEditing, withValidationErrors, keepXlinkAttributes);
            if (elMd == null) {
                throw new MetadataNotFoundEx("Metadata not found - deleted?");
            }
            IResourceDownloadHandler downloadHook = (IResourceDownloadHandler)context.getBean("resourceDownloadHandler", IResourceDownloadHandler.class);
            Element response = downloadHook.onDownloadMultiple(context, params, Integer.parseInt(id), files);
            if (response != null) {
                remoteURL = response;
                return remoteURL;
            }
            Path briefXslt = this.stylePath.resolve("metadata-brief.xsl");
            Element elBrief = Xml.transform((Element)elMd, (Path)briefXslt);
            Element root = new Element("root");
            elBrief.setAttribute("changedate", info.getDataInfo().getChangeDate().getDateAndTime());
            elBrief.setAttribute("currdate", DownloadArchive.now());
            root.addContent((Content)elBrief);
            root.addContent((Content)downloaded);
            root.addContent((Content)entered);
            root.addContent((Content)userDetails);
            if (context.isDebugEnabled()) {
                context.debug("Passed to metadata-license-annex.xsl:\n " + Xml.getString((Element)root));
            }
            Path licenseAnnexXslt = this.stylePath.resolve("metadata-license-annex.xsl");
            try (OutputStream las = Files.newOutputStream(zipFs.getPath("license-annex.html", new String[0]), new OpenOption[0]);){
                Xml.transform((Element)root, (Path)licenseAnnexXslt, (OutputStream)las);
            }
            this.includeLicenseFiles(context, zipFs, root);
            Path outmef = MEFLib.doExport((ServiceContext)context, (String)info.getUuid(), (String)MEFLib.Format.PARTIAL.toString(), (boolean)false, (boolean)true, (boolean)true, (boolean)true, (boolean)true);
            Path toPath = zipFs.getPath("metadata.zip", new String[0]);
            Files.copy(outmef, toPath, new CopyOption[0]);
            FileUtils.deleteQuietly((File)outmef.toFile());
            Element element = BinaryFile.encode((int)200, (Path)zFile.toAbsolutePath().normalize(), (boolean)true).getElement();
            return element;
        }
    }

    private void includeLicenseFiles(ServiceContext context, FileSystem zipFs, Element root) throws Exception {
        Element license = Xml.selectElement((Element)root, (String)"metadata/*/licenseLink");
        if (license != null) {
            String licenseURL = license.getText();
            if (context.isDebugEnabled()) {
                context.debug("license URL = " + licenseURL);
            }
            Path licenseFilesDir = this.getLicenseFilesPath(licenseURL, context);
            if (context.isDebugEnabled()) {
                context.debug(" licenseFilesPath = " + licenseFilesDir);
            }
            if (licenseFilesDir != null && Files.exists(licenseFilesDir, new LinkOption[0])) {
                try (DirectoryStream<Path> paths = Files.newDirectoryStream(licenseFilesDir);){
                    for (Path licenseFile : paths) {
                        if (context.isDebugEnabled()) {
                            context.debug("adding " + licenseFile + " to zip file");
                        }
                        Files.copy(licenseFile, zipFs.getPath(licenseFile.getFileName().toString(), new String[0]), new CopyOption[0]);
                    }
                }
            }
        }
    }

    private Path getLicenseFilesPath(String licenseURL, ServiceContext context) throws MalformedURLException {
        URL url = new URL(licenseURL);
        String licenseFilesPath = url.getHost() + url.getPath();
        if (context.isDebugEnabled()) {
            context.debug("licenseFilesPath= " + licenseFilesPath);
        }
        Path path = context.getAppPath();
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        ServiceConfig configHandler = (ServiceConfig)gc.getBean(ServiceConfig.class);
        String licenseDirAsString = configHandler.getValue("licenseDir");
        if (licenseDirAsString == null) {
            return null;
        }
        Path licenseDir = IO.toPath((String)licenseDirAsString, (String[])new String[0]);
        if (!licenseDir.isAbsolute()) {
            licenseDir = path.resolve(licenseDir);
        }
        if (context.isDebugEnabled()) {
            context.debug("licenseDir = " + licenseDir);
        }
        return licenseDir.resolve(licenseFilesPath);
    }

    private void notifyAndLog(boolean doNotify, String id, String uuid, String access, String username, String theFile, ServiceContext context) throws Exception {
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        SettingManager sm = (SettingManager)gc.getBean(SettingManager.class);
        DataManager dm = (DataManager)gc.getBean(DataManager.class);
        if (access.equals("private")) {
            dm.increasePopularity(context, id);
        }
        if (doNotify) {
            String site = sm.getSiteId();
            String host = sm.getValue("system/feedback/mailServer/host");
            String port = sm.getValue("system/feedback/mailServer/port");
            String from = sm.getValue("system/feedback/email");
            String fromDescr = "GeoNetwork administrator";
            String dateTime = DownloadArchive.now();
            context.info("DOWNLOADED:" + theFile + "," + id + "," + uuid + "," + context.getIpAddress() + "," + username);
            if (host.trim().length() == 0 || from.trim().length() == 0) {
                if (context.isDebugEnabled()) {
                    context.debug("Skipping email notification");
                }
            } else {
                if (context.isDebugEnabled()) {
                    context.debug("Sending email notification for file : " + theFile);
                }
                OperationAllowedRepository opAllowedRepo = (OperationAllowedRepository)context.getBean(OperationAllowedRepository.class);
                List opsAllowed = opAllowedRepo.findByMetadataId(id);
                GroupRepository groupRepository = (GroupRepository)context.getBean(GroupRepository.class);
                for (OperationAllowed opAllowed : opsAllowed) {
                    Group group = (Group)groupRepository.findById((Object)opAllowed.getId().getGroupId()).get();
                    String name = group.getName();
                    String email = group.getEmail();
                    if (email.trim().length() == 0) continue;
                    String subject = "File " + theFile + " has been downloaded at " + dateTime;
                    String message = "GeoNetwork (site: " + site + ") notifies you, as supervisor of group " + name + " that data file " + theFile + " attached to metadata record with id number " + id + " (uuid: " + uuid + ") has been downloaded from address " + context.getIpAddress() + " by user " + username + ".";
                    try {
                        MailSender sender = new MailSender(context);
                        sender.send(host, Integer.parseInt(port), sm.getValue("system/feedback/mailServer/username"), sm.getValue("system/feedback/mailServer/password"), sm.getValueAsBool("system/feedback/mailServer/ssl"), sm.getValueAsBool("system/feedback/mailServer/tls"), sm.getValueAsBool("system/feedback/mailServer/ingoreSslCertificateErrors", false), from, fromDescr, email, null, subject, message);
                    }
                    catch (Exception e) {
                        Log.error((String)"geonetwork.resources", (String)e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
    }
}

