/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.users;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.servlet.http.HttpSession;
import jeeves.server.UserSession;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.users.model.MeResponse;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.kernel.AccessManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/{portal}/api/me"})
@Tag(name="me", description="Me operations")
@RestController
public class MeApi {
    @Autowired
    AccessManager accessManager;

    @Operation(summary="Get information about me", description="If not authenticated, return status 204 (NO_CONTENT), else return basic user information. This operation is usually used to know if current user is authenticated or not.It returns also info about groups and profiles.")
    @GetMapping(produces={"application/json"})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Authenticated. Return user details."), @ApiResponse(responseCode="204", description="Not authenticated.", content={@Content(schema=@Schema(hidden=true))})})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public ResponseEntity<MeResponse> getMe(@Parameter(hidden=true) HttpSession session) throws Exception {
        UserSession userSession = ApiUtils.getUserSession(session);
        if (userSession.isAuthenticated()) {
            MeResponse myInfos = new MeResponse().setId(userSession.getUserId()).setProfile(userSession.getProfile().name()).setUsername(userSession.getUsername()).setName(userSession.getName()).setSurname(userSession.getSurname()).setEmail(userSession.getEmailAddr()).setOrganisation(userSession.getOrganisation()).setAdmin(userSession.getProfile().equals((Object)Profile.Administrator)).setGroupsWithRegisteredUser(AccessManager.getGroups((UserSession)userSession, (Profile)Profile.RegisteredUser)).setGroupsWithEditor(AccessManager.getGroups((UserSession)userSession, (Profile)Profile.Editor)).setGroupsWithReviewer(AccessManager.getGroups((UserSession)userSession, (Profile)Profile.Reviewer)).setGroupsWithUserAdmin(AccessManager.getGroups((UserSession)userSession, (Profile)Profile.UserAdmin));
            return new ResponseEntity((Object)myInfos, HttpStatus.OK);
        }
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }
}

