/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.tools.i18n;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.persistence.metamodel.SingularAttribute;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.exception.ResourceNotFoundException;
import org.fao.geonet.api.tools.i18n.LanguageUtils;
import org.fao.geonet.api.tools.i18n.TranslationPackBuilder;
import org.fao.geonet.domain.Translations;
import org.fao.geonet.domain.Translations_;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.languages.IsoLanguagesMapper;
import org.fao.geonet.repository.SortUtils;
import org.fao.geonet.repository.TranslationsRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/{portal}/api/i18n"})
@Tag(name="tools", description="Utility operations")
@RestController
public class TranslationApi {
    @Autowired
    SchemaManager schemaManager;
    @Autowired
    LanguageUtils languageUtils;
    @Autowired
    TranslationsRepository translationsRepository;
    @Autowired
    TranslationPackBuilder translationPackBuilder;
    @Autowired
    IsoLanguagesMapper isoLanguagesMapper;

    @Operation(summary="List translations for database description table")
    @RequestMapping(value={"/db"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public Map<String, String> getTranslations(@RequestParam(required=false) List<String> type, ServletRequest request) throws Exception {
        Locale locale = this.languageUtils.parseAcceptLanguage(request.getLocales());
        String language = IsoLanguagesMapper.iso639_2T_to_iso639_2B((String)locale.getISO3Language());
        return this.translationPackBuilder.getDbTranslation(language, type);
    }

    @Operation(summary="List custom user translations")
    @RequestMapping(value={"/db/custom"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<Translations> getCustomTranslations(@RequestParam(required=false) List<String> type, ServletRequest request) throws Exception {
        Sort sort = SortUtils.createSort((SingularAttribute[])new SingularAttribute[]{Translations_.fieldName});
        return this.translationsRepository.findAll(sort);
    }

    @Operation(summary="Add or update all database translations.")
    @PutMapping(value={"/db/translations"}, produces={"application/json"})
    @PreAuthorize(value="hasAuthority('Administrator')")
    @ResponseStatus(value=HttpStatus.CREATED)
    public ResponseEntity addTranslations(@Parameter(name="values") @org.springframework.web.bind.annotation.RequestBody(required=true) List<Translations> values, @RequestParam(required=false) boolean replace) throws Exception {
        if (replace) {
            this.translationsRepository.deleteAll();
        }
        Map<String, Map<String, String>> translations = values.stream().filter(Objects::nonNull).collect(Collectors.groupingBy(Translations::getFieldName, Collectors.toMap(Translations::getLangId, Translations::getValue)));
        translations.forEach((key, t) -> this.updateTranslation((String)key, (Map<String, String>)t));
        this.translationPackBuilder.clearCache();
        return new ResponseEntity(HttpStatus.CREATED);
    }

    @Operation(summary="Remove all database translations.")
    @DeleteMapping(value={"/db/translations"}, produces={"application/json"})
    @PreAuthorize(value="hasAuthority('Administrator')")
    @ResponseStatus(value=HttpStatus.CREATED)
    public void removeAllTranslations() throws Exception {
        this.translationsRepository.deleteAll();
        this.translationPackBuilder.clearCache();
    }

    @Operation(summary="Add or update database translations for a key.", description="Database translations can be used to customize labels in the UI for different languages.")
    @PutMapping(value={"/db/translations/{key:.+}"}, produces={"application/json"})
    @PreAuthorize(value="hasAuthority('Administrator')")
    @ResponseStatus(value=HttpStatus.CREATED)
    public ResponseEntity addTranslationsFor(@PathVariable @Parameter(name="key", description="Untranslated key for which translations are provided.") String key, @Parameter(name="values") @RequestBody(description="An object where keys are valid 3-letter language codes (e.g. `eng` or `fre`) and values are custom translations for the corresponding language.", content={@Content(examples={@ExampleObject(value="{  \"eng\": \"my translation\",\n  \"ger\": \"meine \u00dcbersetzung\",\n  \"fre\": \"ma traduction\"\n}")})}) @org.springframework.web.bind.annotation.RequestBody(required=true) Map<String, String> values, @Parameter(name="replace", description="Set to `true` to erase all existing translations for that key") @RequestParam(required=false) boolean replace) throws Exception {
        if (replace) {
            this.translationsRepository.deleteAll((Iterable)this.translationsRepository.findAllByFieldName(key));
        }
        this.updateTranslation(key, values);
        this.translationPackBuilder.clearCache();
        return new ResponseEntity(HttpStatus.CREATED);
    }

    private void updateTranslation(String key, Map<String, String> values) {
        List translations = this.translationsRepository.findAllByFieldName(key);
        if (translations.size() == 0) {
            values.forEach((l, v) -> {
                Translations t = new Translations();
                t.setLangId(l);
                t.setFieldName(key);
                t.setValue(v);
                this.translationsRepository.save((Object)t);
            });
        } else {
            HashSet addedLanguages = new HashSet();
            translations.forEach(e -> {
                if (values.containsKey(e.getLangId())) {
                    e.setValue((String)values.get(e.getLangId()));
                    addedLanguages.add(e.getLangId());
                }
            });
            values.keySet().stream().filter(l -> !addedLanguages.contains(l)).forEach(l -> {
                Translations t = new Translations();
                t.setLangId(l);
                t.setFieldName(key);
                t.setValue((String)values.get(l));
                translations.add(t);
            });
            this.translationsRepository.saveAll((Iterable)translations);
        }
        this.translationPackBuilder.clearCache();
    }

    @Operation(summary="Delete database translations.", description="Delete custom translations stored in the database.")
    @DeleteMapping(value={"/db/translations/{key:.+}"}, produces={"application/json"})
    @PreAuthorize(value="hasAuthority('Administrator')")
    @ResponseStatus(value=HttpStatus.OK)
    public void deleteTranslations(@Parameter(name="key", description="Untranslated key for which all translations will be deleted.") @PathVariable String key, ServletRequest request) throws Exception {
        Locale locale = this.languageUtils.parseAcceptLanguage(request.getLocales());
        String language = IsoLanguagesMapper.iso639_2T_to_iso639_2B((String)locale.getISO3Language());
        List translations = this.translationsRepository.findAllByFieldName(key);
        if (translations.size() == 0) {
            throw new ResourceNotFoundException(String.format("Translation with key '%s' in language '%s' not found.", key, language));
        }
        this.translationsRepository.deleteInBatch((Iterable)translations);
        this.translationPackBuilder.clearCache();
    }

    @Operation(summary="List database translations (used to overrides client application translations).")
    @GetMapping(value={"/db/translations"}, produces={"application/json"})
    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", examples={@ExampleObject(value="{  \"translationKey1\": \"Translated Key One\",\n  \"translationKey2\": \"Translated Key Two\",\n  \"translationKey3\": \"Translated Key Three\"\n}")}, schema=@Schema(type="object", additionalPropertiesSchema=String.class))})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public Map<String, String> getDbTranslations(ServletRequest request) {
        Locale locale = this.languageUtils.parseAcceptLanguage(request.getLocales());
        String language = IsoLanguagesMapper.iso639_2T_to_iso639_2B((String)locale.getISO3Language());
        return this.translationPackBuilder.getAllDbTranslations(language);
    }

    @Operation(summary="Get list of translation packages.")
    @RequestMapping(value={"/packages"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public Map<String, List<String>> getTranslationsPackages() {
        return this.translationPackBuilder.getPackages();
    }

    @Operation(summary="Get a translation package.")
    @RequestMapping(value={"/packages/{pack}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public Map<String, String> getTranslationsPackage(@PathVariable String pack, ServletRequest request, HttpServletRequest httpRequest) {
        ServiceContext context = ApiUtils.createServiceContext(httpRequest);
        Locale locale = this.languageUtils.parseAcceptLanguage(request.getLocales());
        String language = IsoLanguagesMapper.iso639_2T_to_iso639_2B((String)locale.getISO3Language());
        return this.translationPackBuilder.getPack(language, pack, context);
    }

    @Operation(summary="Clean translation packages cache.")
    @RequestMapping(value={"/cache"}, method={RequestMethod.DELETE}, produces={"application/json"})
    @PreAuthorize(value="hasAuthority('Administrator')")
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public void cleanTranslationsPackagesCache() {
        this.translationPackBuilder.clearCache();
    }
}

