/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.registries;

import co.elastic.clients.elasticsearch.core.SearchResponse;
import co.elastic.clients.elasticsearch.core.search.Hit;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jeeves.server.context.ServiceContext;
import jeeves.xlink.XLink;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.api.registries.CollectResults;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.domain.Metadata;
import org.fao.geonet.domain.MetadataDataInfo;
import org.fao.geonet.domain.MetadataType;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.UpdateDatestamp;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.search.EsSearchManager;
import org.fao.geonet.kernel.search.IndexingMode;
import org.fao.geonet.repository.MetadataRepository;
import org.fao.geonet.util.Sha1Encoder;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.Text;

public class DirectoryUtils {
    public static final char SEPARATOR = '~';
    private static final String LOGGER = "geonetwork.registries.directory";

    public static Map<String, Exception> saveEntries(ServiceContext context, CollectResults collectResults, String sourceIdentifier, Integer owner, Integer groupOwner, boolean saveRecord) {
        DataManager dataManager = (DataManager)context.getBean(DataManager.class);
        IMetadataUtils metadataRepository = (IMetadataUtils)context.getBean(IMetadataUtils.class);
        Table<String, String, Element> entries = collectResults.getEntries();
        Iterator entriesIterator = entries.rowKeySet().iterator();
        AbstractMetadata record = collectResults.getRecord();
        boolean validate = false;
        boolean ufo = false;
        boolean notify = false;
        boolean publicForGroup = true;
        boolean refreshReaders = false;
        HashMap<String, Exception> errors = new HashMap<String, Exception>();
        while (entriesIterator.hasNext()) {
            String identifier = (String)entriesIterator.next();
            Map uuidAndEntry = entries.row((Object)identifier);
            String uuid = (String)uuidAndEntry.keySet().iterator().next();
            Element entry = (Element)uuidAndEntry.values().iterator().next();
            AbstractMetadata dbSubTemplate = metadataRepository.findOneByUuid(uuid);
            if (dbSubTemplate == null) {
                Metadata subtemplate = new Metadata();
                subtemplate.setUuid(uuid);
                subtemplate.getDataInfo().setSchemaId(record.getDataInfo().getSchemaId()).setRoot(entry.getQualifiedName()).setType(MetadataType.SUB_TEMPLATE);
                subtemplate.getSourceInfo().setSourceId(sourceIdentifier).setOwner(owner).setGroupOwner(groupOwner);
                try {
                    subtemplate = dataManager.insertMetadata(context, (AbstractMetadata)subtemplate, (Element)entry.clone(), IndexingMode.none, ufo, UpdateDatestamp.NO, publicForGroup, refreshReaders);
                    collectResults.getEntryIdentifiers().put(uuid, subtemplate.getId());
                }
                catch (Exception e) {
                    Log.error((String)LOGGER, (String)e.getMessage(), (Throwable)e);
                    errors.put(uuid, e);
                }
                continue;
            }
            try {
                dataManager.updateMetadata(context, "" + dbSubTemplate.getId(), (Element)entry.clone(), validate, ufo, context.getLanguage(), new ISODate().toString(), false, IndexingMode.none);
                collectResults.getEntryIdentifiers().put(uuid, dbSubTemplate.getId());
            }
            catch (Exception e) {
                Log.error((String)LOGGER, (String)e.getMessage(), (Throwable)e);
                errors.put(uuid, e);
            }
        }
        if (saveRecord) {
            try {
                dataManager.updateMetadata(context, "" + record.getId(), record.getXmlData(validate), validate, ufo, context.getLanguage(), new ISODate().toString(), true, IndexingMode.none);
            }
            catch (Exception e) {
                Log.error((String)LOGGER, (String)e.getMessage(), (Throwable)e);
            }
        }
        return errors;
    }

    public static CollectResults collectEntries(ServiceContext context, AbstractMetadata record, String xpath, String identifierXpath) throws Exception {
        return DirectoryUtils.collectEntries(context, record, xpath, identifierXpath, null, false, false, null);
    }

    public static CollectResults synchronizeEntries(ServiceContext context, AbstractMetadata record, String xpath, String identifierXpath, List<String> propertiesToCopy, boolean substituteAsXLink, String directoryFilterQuery) throws Exception {
        return DirectoryUtils.collectEntries(context, record, xpath, identifierXpath, propertiesToCopy, substituteAsXLink, true, directoryFilterQuery);
    }

    private static CollectResults collectEntries(ServiceContext context, AbstractMetadata record, String xpath, String identifierXpath, List<String> propertiesToCopy, boolean substituteAsXLink, boolean updateFromDirectory, String directoryFilterQuery) throws Exception {
        CollectResults collectResults = new CollectResults(record);
        HashMap<String, ArrayList<Namespace>> namespaceList = new HashMap<String, ArrayList<Namespace>>();
        MetadataRepository metadataRepository = (MetadataRepository)context.getBean(MetadataRepository.class);
        if (Log.isDebugEnabled((String)LOGGER)) {
            Log.debug((String)LOGGER, (Object)String.format("Collecting directory entries for record '%s' using XPath '%s' and identifier XPath '%s'.", record.getUuid(), xpath, identifierXpath));
        }
        Element md = record.getXmlData(false);
        MetadataDataInfo mdInfo = record.getDataInfo();
        String localXlinkUrlPrefix = "local://" + context.getLanguage() + "/subtemplate?uuid=";
        ArrayList<Namespace> metadataNamespaces = (ArrayList<Namespace>)namespaceList.get(mdInfo.getSchemaId());
        if (metadataNamespaces == null) {
            metadataNamespaces = new ArrayList<Namespace>();
            Namespace ns = md.getNamespace();
            if (ns != null) {
                metadataNamespaces.add(ns);
                metadataNamespaces.addAll(md.getAdditionalNamespaces());
                namespaceList.put(mdInfo.getSchemaId(), metadataNamespaces);
            }
        }
        List nodes = Xml.selectNodes((Element)md, (String)xpath, metadataNamespaces);
        if (Log.isDebugEnabled((String)LOGGER)) {
            Log.debug((String)LOGGER, (Object)String.format("%d nodes matching XPath '%s' in record '%s'.", nodes.size(), xpath, record.getUuid()));
        }
        int numberOfEntries = 0;
        boolean updated = false;
        for (Object o : nodes) {
            if (o instanceof Element) {
                String uuidAttribute;
                ++numberOfEntries;
                Element elem = (Element)o;
                if (Log.isDebugEnabled((String)LOGGER)) {
                    Log.debug((String)LOGGER, (Object)String.format("#%d. XML entry: %s", numberOfEntries, Xml.getString((Element)elem)));
                }
                String identifier = null;
                if (StringUtils.isNotEmpty((String)identifierXpath)) {
                    Object obj = Xml.selectSingle((Element)((Element)elem.clone()), (String)identifierXpath, metadataNamespaces);
                    if (obj instanceof Text) {
                        identifier = ((Text)obj).getTextNormalize();
                    } else if (obj instanceof Attribute) {
                        identifier = ((Attribute)obj).getValue();
                    } else if (obj instanceof String) {
                        identifier = (String)obj;
                    }
                }
                if (StringUtils.isEmpty(identifier) && StringUtils.isNotEmpty((String)(uuidAttribute = elem.getAttributeValue("uuid")))) {
                    identifier = uuidAttribute;
                }
                String uuid = StringUtils.isEmpty(identifier) ? (identifier = Sha1Encoder.encodeString((String)elem.getValue())) : Sha1Encoder.encodeString(identifier);
                if (Log.isDebugEnabled((String)LOGGER)) {
                    Log.debug((String)LOGGER, (Object)String.format("#%d. Entry identifier is '%s', uuid is '%s'.", numberOfEntries, identifier, uuid));
                }
                if (updateFromDirectory) {
                    if (Log.isDebugEnabled((String)LOGGER)) {
                        Log.debug((String)LOGGER, (Object)String.format("#%d. Searching '%s' in directory ...", numberOfEntries, uuid));
                    }
                    String searchIndexField = "uuid";
                    Element subTemplateElement = null;
                    if (StringUtils.isEmpty((String)searchIndexField)) {
                        Metadata subTemplate = metadataRepository.findOneByUuid(uuid);
                        if (subTemplate != null) {
                            subTemplateElement = subTemplate.getXmlData(false);
                        }
                    } else {
                        Metadata subTemplate;
                        HashMap<String, String> parameters = new HashMap<String, String>();
                        if (directoryFilterQuery != null) {
                            String[] tokens = directoryFilterQuery.split(":");
                            if (tokens.length == 2) {
                                parameters.put(tokens[0], tokens[1]);
                            } else {
                                Log.warning((String)LOGGER, (Object)String.format("Filter query for directory must be field:value format. '%s' is not.", directoryFilterQuery));
                            }
                        }
                        parameters.put(searchIndexField, uuid);
                        String entryUuid = DirectoryUtils.search(context, parameters);
                        if (entryUuid != null && (subTemplate = metadataRepository.findOneByUuid(entryUuid)) != null) {
                            uuid = subTemplate.getUuid();
                            subTemplateElement = subTemplate.getXmlData(false);
                        }
                    }
                    if (subTemplateElement == null) {
                        Log.debug((String)LOGGER, (Object)String.format("#%d. '%s' Not found in directory. Next.", numberOfEntries, uuid));
                        continue;
                    }
                    if (subTemplateElement.getName().equals(elem.getName())) {
                        Element parent = elem.getParentElement();
                        int iIndex = parent.indexOf((Content)elem);
                        parent.removeContent(iIndex);
                        if (!substituteAsXLink) {
                            DirectoryUtils.copyProperties(elem, subTemplateElement, propertiesToCopy, metadataNamespaces);
                            parent.addContent(iIndex, (Content)subTemplateElement);
                        } else {
                            StringBuffer params = new StringBuffer(localXlinkUrlPrefix);
                            params.append(uuid);
                            params.append(DirectoryUtils.getPropertiesAsParameters(elem, propertiesToCopy, metadataNamespaces));
                            parent.setAttribute("uuidref", uuid);
                            parent.setAttribute("href", params.toString(), XLink.NAMESPACE_XLINK);
                        }
                        updated = true;
                        continue;
                    }
                    Log.debug((String)LOGGER, (Object)String.format("#%d. One found in directory but with different root element name '%s'.", numberOfEntries, subTemplateElement.getName()));
                    continue;
                }
                collectResults.getEntries().put((Object)identifier, (Object)uuid, (Object)((Element)elem.clone()));
                continue;
            }
            Log.debug((String)LOGGER, (Object)String.format("#%d. Only element can be directory entries. Current element is '%s'.", numberOfEntries, o.getClass()));
        }
        if (updated) {
            collectResults.setUpdatedRecord(md);
        }
        return collectResults;
    }

    private static Element copyProperties(Element source, Element target, List<String> propertiesXpath, List<Namespace> ns) throws JDOMException {
        if (propertiesXpath != null) {
            for (String xpath : propertiesXpath) {
                String value = Xml.selectString((Element)source, (String)xpath, ns);
                if (!StringUtils.isNotEmpty((String)value)) continue;
                Object targetElement = Xml.selectSingle((Element)target, (String)xpath, ns);
                if (targetElement instanceof Attribute) {
                    ((Attribute)targetElement).setValue(value);
                    continue;
                }
                if (targetElement instanceof Text) {
                    ((Text)targetElement).setText(value);
                    continue;
                }
                if (!(targetElement instanceof Element)) continue;
                ((Element)targetElement).setText(value);
            }
        }
        return target;
    }

    private static String getPropertiesAsParameters(Element source, List<String> propertiesXpath, List<Namespace> ns) throws JDOMException {
        StringBuffer properties = new StringBuffer();
        for (String xpath : propertiesXpath) {
            String value = Xml.selectString((Element)source, (String)xpath, ns);
            if (!StringUtils.isNotEmpty((String)value)) continue;
            properties.append("&amp;").append("process=").append(xpath).append('~').append(value);
        }
        return properties.toString();
    }

    private static String search(ServiceContext context, Map<String, String> searchParameters) {
        EsSearchManager searchMan = (EsSearchManager)context.getBean(EsSearchManager.class);
        StringBuilder query = new StringBuilder("+isTemplate:s");
        for (Map.Entry<String, String> e : searchParameters.entrySet()) {
            query.append(String.format(" +%s:\"%s\"", e.getKey(), e.getValue()));
        }
        try {
            SearchResponse results = searchMan.query(query.toString(), null, 0, 1);
            if (results.hits().hits().size() > 0) {
                return ((Hit)results.hits().hits().get(0)).id();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

