/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.regions;

import com.google.common.collect.Lists;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jeeves.server.context.ServiceContext;
import org.apache.commons.lang3.StringUtils;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.records.extent.MapRenderer;
import org.fao.geonet.api.regions.ListRegionsResponse;
import org.fao.geonet.api.regions.ThesaurusBasedRegionsDAO;
import org.fao.geonet.api.regions.model.Category;
import org.fao.geonet.api.tools.i18n.LanguageUtils;
import org.fao.geonet.exceptions.BadParameterEx;
import org.fao.geonet.exceptions.LabelNotFoundException;
import org.fao.geonet.kernel.KeywordBean;
import org.fao.geonet.kernel.region.RegionsDAO;
import org.fao.geonet.kernel.region.Request;
import org.fao.geonet.kernel.setting.SettingManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.context.request.NativeWebRequest;

@RequestMapping(value={"/{portal}/api/regions"})
@Tag(name="regions", description="Regions operations")
@Controller(value="regions")
public class RegionsApi {
    @Autowired
    private LanguageUtils languageUtils;
    @Autowired
    private SettingManager settingManager;
    @Value(value="${metadata.extentApi.disableFullUrlBackgroundMapServices:true}")
    private boolean disableFullUrlBackgroundMapServices;

    public static Request createRequest(String label, String categoryId, int maxRecords, ServiceContext context, RegionsDAO dao) throws Exception {
        Request request = dao.createSearchRequest(context);
        if (label != null) {
            request.label(label);
        }
        if (categoryId != null) {
            request.categoryId(categoryId);
        }
        if (maxRecords > 0) {
            request.maxRecords(maxRecords);
        }
        return request;
    }

    @Operation(summary="Get list of regions")
    @RequestMapping(method={RequestMethod.GET}, produces={"application/xml", "application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List of regions.")})
    @ResponseBody
    public ListRegionsResponse getRegions(@RequestParam(required=false) String label, @RequestParam(required=false) String categoryId, @RequestParam(defaultValue="-1") int maxRecords, @Parameter(hidden=true) NativeWebRequest webRequest) throws Exception {
        HttpServletRequest nativeRequest = (HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class);
        ServiceContext context = ApiUtils.createServiceContext(nativeRequest);
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        Collection daos = applicationContext.getBeansOfType(RegionsDAO.class).values();
        ArrayList regions = Lists.newArrayList();
        for (RegionsDAO dao : daos) {
            if (!dao.includeInListing()) continue;
            Request request = RegionsApi.createRequest(label, categoryId, maxRecords, context, dao);
            regions.addAll(request.execute());
        }
        HttpServletResponse nativeResponse = (HttpServletResponse)webRequest.getNativeResponse(HttpServletResponse.class);
        nativeResponse.setHeader("Cache-Control", "no-cache");
        return new ListRegionsResponse(regions);
    }

    @Operation(summary="Get list of region types")
    @RequestMapping(path={"/types"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(responseCode="200", description="List of region types.")})
    @ResponseBody
    public List<Category> getRegionTypes(HttpServletRequest request) throws Exception {
        String language = this.languageUtils.getIso3langCode(request.getLocales());
        ServiceContext context = ApiUtils.createServiceContext(request);
        Collection daos = ApplicationContextHolder.get().getBeansOfType(RegionsDAO.class).values();
        ArrayList<Category> response = new ArrayList<Category>();
        for (RegionsDAO dao : daos) {
            if (dao instanceof ThesaurusBasedRegionsDAO) {
                List<KeywordBean> keywords = ((ThesaurusBasedRegionsDAO)dao).getRegionTopConcepts(context);
                if (keywords == null) continue;
                for (KeywordBean k : keywords) {
                    String label = "";
                    try {
                        label = k.getPreferredLabel(language);
                    }
                    catch (LabelNotFoundException ex) {
                        label = k.getDefaultValue();
                    }
                    Category c = new Category(k.getUriCode(), label);
                    response.add(c);
                }
                continue;
            }
            Collection ids = dao.getRegionCategoryIds(context);
            if (ids == null) continue;
            for (String id : ids) {
                Category c = new Category(id, null);
                response.add(c);
            }
        }
        return response;
    }

    @Operation(summary="Get geometry as image", description="A rendering of the geometry as a `png`.\n \n The coverage of the image is computed from the geometry envelope and size using scale factor configuration (See `regionGetMapExpandFactors` bean in `config-spring-geonetwork.xml`) to give enough context on where the geometry is. The smaller the geometry, the bigger the expand factor.\n\n If needed, when the factor is high, square image mode can be enabled (instead of proportional geometry size):\n\n ```xml\n <util:set id=\"regionGetMapExpandFactors\" set-class=\"java.util.TreeSet\">\n    <bean class=\"org.fao.geonet.api.records.extent.ExpandFactor\"\n          p:proportion=\".00005\" p:factor=\"256\" p:squareImage=\"true\"/>\n```\n")
    @RequestMapping(value={"/geom.png"}, produces={"image/png"}, method={RequestMethod.GET})
    public HttpEntity<byte[]> getGeomAsImage(@Parameter(description="(optional) the background map projection. If not passed uses the region/getmap/mapproj setting. If the setting is not set defaults to EPSG:4326") @RequestParam(value="mapsrs", required=false) String mapSrs, @Parameter(description="(optional) width of the image that is created. Only one of width and height are permitted") @RequestParam(value="width", required=false, defaultValue="300") Integer width, @Parameter(description="(optional) height of the image that is created. Only one of width and height are permitted") @RequestParam(value="height", required=false) Integer height, @Parameter(description="(optional) URL for loading a background image for regions or a key that references the namedBackgrounds (configured in config-spring-geonetwork.xml). A WMS Getmap request is the typical example. The URL must be parameterized with the following parameters: minx, maxx, miny, maxy, width, height") @RequestParam(value="background", required=false, defaultValue="settings") String background, @Parameter(description="(optional) a wkt or gml encoded geometry.") @RequestParam(value="geom", required=false) String geomParam, @Parameter(description="(optional) defines if geom is wkt or gml. Allowed values are wkt and gml. if not specified the it is assumed the geometry is wkt") @RequestParam(value="geomtype", defaultValue="WKT") String geomType, @Parameter(description="") @RequestParam(value="geomsrs", defaultValue="EPSG:4326") String geomSrs, @Parameter(description="(optional) Fill color with format RED,GREEN,BLUE,ALPHA") @RequestParam(value="", required=false, defaultValue="0,0,0,30") String fillColor, @Parameter(description="(optional) Stroke color with format RED,GREEN,BLUE,ALPHA") @RequestParam(value="", required=false, defaultValue="0,0,0,255") String strokeColor, @Parameter(hidden=true) NativeWebRequest nativeWebRequest, @Parameter(hidden=true) HttpServletRequest request) throws Exception {
        ServiceContext context = ApiUtils.createServiceContext(request);
        String srs = mapSrs;
        if (StringUtils.isBlank((CharSequence)srs)) {
            srs = StringUtils.defaultString((String)this.settingManager.getValue("region/getmap/mapproj", true), (String)"EPSG:4326");
        }
        if (width != null && height != null) {
            throw new BadParameterEx("width", (Object)"Only one of width and height can be defined currently.  Future versions may support this but it is not supported at the moment");
        }
        if (width == null && height == null) {
            throw new BadParameterEx("width", (Object)"One of width or height parameters must be included in the request");
        }
        if (background != null && background.startsWith("http") && this.disableFullUrlBackgroundMapServices) {
            throw new BadParameterEx("background", (Object)"Background layers from provided are not supported, use a preconfigured background layers map service.");
        }
        String outputFileName = "geom.png";
        String regionId = null;
        if (nativeWebRequest.checkNotModified(geomParam + srs + background)) {
            return null;
        }
        MapRenderer renderer = new MapRenderer(context);
        BufferedImage image = renderer.render(regionId, srs, width, height, background, geomParam, geomType, geomSrs, fillColor, strokeColor);
        if (image == null) {
            return null;
        }
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            ImageIO.write((RenderedImage)image, "png", out);
            HttpHeaders headers = new HttpHeaders();
            headers.add((Object)"Content-Disposition", (Object)("inline; filename=\"" + outputFileName + "\""));
            headers.add((Object)"Cache-Control", (Object)("public, max-age: " + TimeUnit.DAYS.toSeconds(5L)));
            headers.add((Object)"Content-Type", (Object)"image/png");
            HttpEntity httpEntity = new HttpEntity((Object)out.toByteArray(), (MultiValueMap)headers);
            return httpEntity;
        }
    }
}

