/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records;

import co.elastic.clients.elasticsearch.core.SearchResponse;
import co.elastic.clients.elasticsearch.core.search.Hit;
import co.elastic.clients.json.JsonData;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Joiner;
import jakarta.json.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import jeeves.server.context.ServiceContext;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.NodeInfo;
import org.fao.geonet.api.es.EsHTTPProxy;
import org.fao.geonet.api.records.model.related.AssociatedRecord;
import org.fao.geonet.api.records.model.related.RelatedItemOrigin;
import org.fao.geonet.api.records.model.related.RelatedItemType;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.ReservedOperation;
import org.fao.geonet.domain.Source;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.kernel.datamanager.IMetadataValidator;
import org.fao.geonet.kernel.datamanager.base.BaseMetadataUtils;
import org.fao.geonet.kernel.schema.AssociatedResource;
import org.fao.geonet.kernel.schema.AssociatedResourcesSchemaPlugin;
import org.fao.geonet.kernel.schema.SchemaPlugin;
import org.fao.geonet.kernel.search.EsFilterBuilder;
import org.fao.geonet.kernel.search.EsSearchManager;
import org.fao.geonet.kernel.setting.SettingInfo;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.lib.Lib;
import org.fao.geonet.repository.MetadataValidationRepository;
import org.fao.geonet.repository.SourceRepository;
import org.fao.geonet.repository.specification.MetadataValidationSpecs;
import org.fao.geonet.services.relations.Get;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.output.DOMOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.w3c.dom.Node;

public class MetadataUtils {
    public static final boolean FOR_EDITING = false;
    public static final boolean WITH_VALIDATION_ERRORS = false;
    public static final boolean KEEP_XLINK_ATTRIBUTES = false;
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"geonetwork.search");

    public static Node getAssociatedAsXml(String metadataUuid) {
        Element relations = new Element("relations");
        BaseMetadataUtils metadataUtils = (BaseMetadataUtils)ApplicationContextHolder.get().getBean(BaseMetadataUtils.class);
        AbstractMetadata metadataEntity = metadataUtils.findOneByUuid(metadataUuid);
        ServiceContext context = ServiceContext.get();
        try {
            Map<RelatedItemType, List<AssociatedRecord>> associated = MetadataUtils.getAssociated(context, metadataEntity, RelatedItemType.values(), 0, 100);
            for (Map.Entry<RelatedItemType, List<AssociatedRecord>> entry : associated.entrySet()) {
                for (AssociatedRecord record : entry.getValue()) {
                    Element relation = new Element(entry.getKey().name());
                    relation.setAttribute("uuid", record.getUuid());
                    relation.setAttribute("origin", record.getOrigin());
                    if (record.getProperties() != null) {
                        if (record.getProperties().get("associationType") != null) {
                            relation.setAttribute("associationType", record.getProperties().get("associationType"));
                        }
                        if (record.getProperties().get("initiativeType") != null) {
                            relation.setAttribute("initiativeType", record.getProperties().get("initiativeType"));
                        }
                        if (record.getProperties().get("resourceTitle") != null) {
                            relation.setAttribute("resourceTitle", record.getProperties().get("resourceTitle"));
                        }
                        if (record.getProperties().get("url") != null) {
                            relation.setAttribute("url", record.getProperties().get("url"));
                        }
                    }
                    relation.addContent((Content)Xml.getXmlFromJSON((String)record.getRecord().toPrettyString()));
                    relations.addContent((Content)relation);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        DOMOutputter outputter = new DOMOutputter();
        try {
            return outputter.output(new Document(relations));
        }
        catch (JDOMException e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<RelatedItemType, List<AssociatedRecord>> getAssociated(ServiceContext context, AbstractMetadata md, RelatedItemType[] types, int start, int size) throws Exception {
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        DataManager dm = (DataManager)gc.getBean(DataManager.class);
        SettingManager settingManager = (SettingManager)gc.getBean(SettingManager.class);
        EsSearchManager searchMan = (EsSearchManager)gc.getBean(EsSearchManager.class);
        Element xml = dm.getMetadata(context, "" + md.getId(), false, false, false);
        SchemaPlugin instance = SchemaManager.getSchemaPlugin((String)md.getDataInfo().getSchemaId());
        AssociatedResourcesSchemaPlugin schemaPlugin = instance instanceof AssociatedResourcesSchemaPlugin ? (AssociatedResourcesSchemaPlugin)instance : null;
        HashMap queries = new HashMap();
        HashSet allSearchedUuids = new HashSet();
        Arrays.stream(types).forEach(type -> {
            if (type == RelatedItemType.associated || type == RelatedItemType.hasfeaturecats || type == RelatedItemType.services || type == RelatedItemType.hassources) {
                queries.put(type, new RelatedTypeDetails(String.format("+%s:\"%s\"", EsSearchManager.RELATED_INDEX_FIELDS.get(type.value()), md.getUuid())));
            } else if (schemaPlugin != null && (type == RelatedItemType.siblings || type == RelatedItemType.parent || type == RelatedItemType.fcats || type == RelatedItemType.datasets || type == RelatedItemType.sources)) {
                Set listOfAssociatedResources = new HashSet();
                if (type == RelatedItemType.siblings) {
                    listOfAssociatedResources = schemaPlugin.getAssociatedResourcesUUIDs(xml);
                } else if (type == RelatedItemType.sources) {
                    listOfAssociatedResources = schemaPlugin.getAssociatedSources(xml);
                } else if (type == RelatedItemType.datasets) {
                    listOfAssociatedResources = schemaPlugin.getAssociatedDatasets(xml);
                } else if (type == RelatedItemType.parent) {
                    listOfAssociatedResources = schemaPlugin.getAssociatedParents(xml);
                } else if (type == RelatedItemType.fcats) {
                    listOfAssociatedResources = schemaPlugin.getAssociatedFeatureCatalogues(xml);
                }
                HashSet<String> remoteRecords = new HashSet<String>();
                if (type == RelatedItemType.parent || !listOfAssociatedResources.isEmpty()) {
                    Set<String> listOfUUIDs = listOfAssociatedResources.stream().map(AssociatedResource::getUuid).collect(Collectors.toSet());
                    HashMap<String, Map<String, String>> recordsProperties = new HashMap<String, Map<String, String>>();
                    for (AssociatedResource r : listOfAssociatedResources) {
                        HashMap<String, String> properties = new HashMap<String, String>();
                        properties.put("associationType", r.getAssociationType());
                        properties.put("initiativeType", r.getInitiativeType());
                        properties.put("resourceTitle", r.getTitle());
                        properties.put("url", r.getUrl());
                        recordsProperties.put(r.getUuid(), properties);
                        boolean isRemote = StringUtils.isNotEmpty((String)r.getUrl()) && !r.getUrl().startsWith(settingManager.getBaseURL());
                        if (!isRemote) continue;
                        remoteRecords.add(r.getUuid());
                    }
                    queries.put(type, new RelatedTypeDetails(String.format("(uuid:(%s)%s) AND (draft:\"n\" OR draft:\"e\")", listOfUUIDs.stream().collect(Collectors.joining("\" OR \"", "\"", "\"")), type == RelatedItemType.parent ? " OR childUuid:\"" + md.getUuid() + "\"" : ""), listOfUUIDs, recordsProperties, remoteRecords));
                    allSearchedUuids.addAll(listOfUUIDs);
                }
            } else if (schemaPlugin != null && type == RelatedItemType.brothersAndSisters) {
                Set listOfUUIDs = schemaPlugin.getAssociatedParentUUIDs(xml);
                queries.put(type, new RelatedTypeDetails(String.format("+%s:(%s) -uuid:\"%s\" AND (draft:\"n\" OR draft:\"e\")", EsSearchManager.RELATED_INDEX_FIELDS.get(type.value()), listOfUUIDs.stream().collect(Collectors.joining("\" OR \"", "\"", "\"")), md.getUuid()), listOfUUIDs));
                allSearchedUuids.addAll(listOfUUIDs);
            } else if (schemaPlugin != null && type == RelatedItemType.children) {
                Set listOfAssociated = schemaPlugin.getAssociatedResourcesUUIDs(xml);
                Set<String> isComposedOfList = listOfAssociated.stream().filter(e -> "isComposedOf".equals(e.getAssociationType())).map(AssociatedResource::getUuid).collect(Collectors.toSet());
                queries.put(type, new RelatedTypeDetails(String.format("(%s:\"%s\" OR uuid:(%s)) AND (draft:\"n\" OR draft:\"e\")", EsSearchManager.RELATED_INDEX_FIELDS.get(type.value()), md.getUuid(), isComposedOfList.stream().collect(Collectors.joining("\" OR \"", "\"", "\""))), isComposedOfList));
                allSearchedUuids.addAll(isComposedOfList);
            }
        });
        HashMap<RelatedItemType, List<AssociatedRecord>> associated = new HashMap<RelatedItemType, List<AssociatedRecord>>();
        HashSet<String> allCatalogueUuids = new HashSet<String>();
        String privilegesFilter = EsFilterBuilder.buildPermissionsFilter((ServiceContext)context);
        ObjectMapper mapper = new ObjectMapper();
        for (Map.Entry entry : queries.entrySet()) {
            RelatedTypeDetails relatedTypeDetails = (RelatedTypeDetails)entry.getValue();
            SearchResponse result = searchMan.query(relatedTypeDetails.getQuery(), privilegesFilter, EsSearchManager.FIELDLIST_RELATED, EsSearchManager.FIELDLIST_RELATED_SCRIPTED, start, size);
            Set<String> expectedUuids = relatedTypeDetails.getExpectedRecords();
            Set<String> remoteRecords = relatedTypeDetails.getRemoteRecords();
            ArrayList<AssociatedRecord> records = new ArrayList<AssociatedRecord>();
            if (!result.hits().hits().isEmpty()) {
                for (Hit e : result.hits().hits()) {
                    allCatalogueUuids.add(e.id());
                    AssociatedRecord associatedRecord = new AssociatedRecord();
                    associatedRecord.setUuid(e.id());
                    associatedRecord.setProperties(relatedTypeDetails.recordsProperties.get(e.id()));
                    if (!e.fields().isEmpty()) {
                        EsSearchManager.FIELDLIST_RELATED_SCRIPTED.keySet().forEach(f -> {
                            JsonData dc = (JsonData)e.fields().get(f);
                            if (dc != null) {
                                if (associatedRecord.getProperties() == null) {
                                    associatedRecord.setProperties(new HashMap<String, String>());
                                }
                                associatedRecord.getProperties().put((String)f, ((JsonValue)dc.toJson().asJsonArray().get(0)).toString().replaceAll("^\"|\"$", ""));
                            }
                        });
                    }
                    JsonNode source = (JsonNode)mapper.convertValue(e.source(), JsonNode.class);
                    ObjectNode doc = mapper.createObjectNode();
                    doc.set("_source", source);
                    EsHTTPProxy.addUserInfo(doc, context);
                    Iterator fieldNames = doc.fieldNames();
                    while (fieldNames.hasNext()) {
                        String field = (String)fieldNames.next();
                        if ("_source".equals(field)) continue;
                        ((ObjectNode)source).set(field, doc.get(field));
                    }
                    associatedRecord.setRecord(source);
                    associatedRecord.setOrigin(RelatedItemOrigin.catalog.name());
                    records.add(associatedRecord);
                    if (expectedUuids.contains(e.id())) {
                        expectedUuids.remove(e.id());
                    }
                    if (!remoteRecords.contains(e.id())) continue;
                    remoteRecords.remove(e.id());
                }
            }
            MetadataUtils.buildRemoteRecords(mapper, relatedTypeDetails, records);
            associated.put((RelatedItemType)((Object)entry.getKey()), records);
        }
        MetadataUtils.assignPortalOrigin(start, size, searchMan, associated, allCatalogueUuids);
        return associated;
    }

    private static void buildRemoteRecords(ObjectMapper mapper, RelatedTypeDetails relatedTypeDetails, List<AssociatedRecord> records) throws JsonProcessingException {
        for (String uuid : relatedTypeDetails.getRemoteRecords()) {
            AssociatedRecord associatedRecord = new AssociatedRecord();
            associatedRecord.setUuid(uuid);
            associatedRecord.setProperties(relatedTypeDetails.recordsProperties.get(uuid));
            associatedRecord.setRecord(mapper.readTree(MetadataUtils.buildRemoteRecord(relatedTypeDetails.recordsProperties.get(uuid))));
            associatedRecord.setOrigin(RelatedItemOrigin.remote.name());
            records.add(associatedRecord);
        }
    }

    private static void assignPortalOrigin(int start, int size, EsSearchManager searchMan, Map<RelatedItemType, List<AssociatedRecord>> associated, Set<String> allCatalogueUuids) throws Exception {
        Optional portal;
        SourceRepository sourceRepository = (SourceRepository)ApplicationContextHolder.get().getBean(SourceRepository.class);
        NodeInfo node = (NodeInfo)ApplicationContextHolder.get().getBean(NodeInfo.class);
        if (node != null && !"srv".equals(node.getId()) && (portal = sourceRepository.findById((Object)node.getId())).isPresent() && StringUtils.isNotEmpty((String)((Source)portal.get()).getFilter())) {
            String portalFilter = ((Source)portal.get()).getFilter();
            SearchResponse recordsInPortal = searchMan.query(String.format("+uuid:(%s)", allCatalogueUuids.stream().collect(Collectors.joining("\" OR \"", "\"", "\""))), portalFilter, EsSearchManager.FIELDLIST_UUID, start, size);
            HashSet<String> allPortalUuids = new HashSet<String>();
            if (!recordsInPortal.hits().hits().isEmpty()) {
                for (Hit e : recordsInPortal.hits().hits()) {
                    allPortalUuids.add(e.id());
                }
            }
            if (!allPortalUuids.isEmpty()) {
                associated.forEach((t, records) -> records.stream().filter(r -> allPortalUuids.contains(r.getUuid())).forEach(r -> r.setOrigin(RelatedItemOrigin.portal.name())));
            }
        }
    }

    private static String buildRemoteRecord(Map<String, String> props) {
        return props == null || props.get("resourceTitle") == null ? "{}" : String.format("{\"resourceTitleObject\": {\"default\": \"%s\"}}", StringEscapeUtils.escapeJson((String)props.get("resourceTitle")));
    }

    @Deprecated
    public static Element getRelated(ServiceContext context, int iId, String uuid, RelatedItemType[] type, int fromRecord, int toRecord) throws Exception {
        String origin;
        Element searchResult;
        String joinedUUIDs;
        Set listOfUUIDs;
        Source portal;
        String id = String.valueOf(iId);
        String from = "" + fromRecord;
        String to = "" + toRecord;
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        DataManager dm = (DataManager)gc.getBean(DataManager.class);
        EsSearchManager searchMan = (EsSearchManager)gc.getBean(EsSearchManager.class);
        Element relatedRecords = new Element("relations");
        String portalFilter = "";
        NodeInfo node = (NodeInfo)ApplicationContextHolder.get().getBean(NodeInfo.class);
        SourceRepository sourceRepository = (SourceRepository)ApplicationContextHolder.get().getBean(SourceRepository.class);
        if (node != null && !"srv".equals(node.getId()) && (portal = sourceRepository.findOneByUuid(node.getId())) != null) {
            portalFilter = portal.getFilter();
        }
        if (type == null || type.length == 0) {
            type = (RelatedItemType[])RelatedItemType.class.getEnumConstants();
        }
        ArrayList<RelatedItemType> listOfTypes = new ArrayList<RelatedItemType>(Arrays.asList(type));
        Element md = dm.getMetadata(context, id, false, false, false);
        Map mdIndexFields = searchMan.getDocument(uuid);
        String schemaIdentifier = dm.getMetadataSchema(id);
        SchemaPlugin instance = SchemaManager.getSchemaPlugin((String)schemaIdentifier);
        AssociatedResourcesSchemaPlugin schemaPlugin = null;
        if (instance instanceof AssociatedResourcesSchemaPlugin) {
            schemaPlugin = (AssociatedResourcesSchemaPlugin)instance;
        }
        if (listOfTypes.isEmpty() || listOfTypes.contains((Object)RelatedItemType.children)) {
            relatedRecords.addContent((Content)MetadataUtils.calculateResults("\"" + uuid + "\"", "children", from, to, null, portalFilter));
        }
        if (schemaPlugin != null && (listOfTypes.isEmpty() || listOfTypes.contains((Object)RelatedItemType.parent))) {
            listOfUUIDs = schemaPlugin.getAssociatedParentUUIDs(md);
            if (!listOfUUIDs.isEmpty()) {
                joinedUUIDs = "\"" + Joiner.on((String)"\" or \"").join((Iterable)listOfUUIDs) + "\"";
                relatedRecords.addContent((Content)MetadataUtils.calculateResults(joinedUUIDs, "parent", from, to, null, portalFilter));
            } else {
                relatedRecords.addContent((Content)new Element("parent"));
            }
            MetadataUtils.appendRemoteRecord("parent", mdIndexFields, relatedRecords.getChild("parent"));
        }
        if (schemaPlugin != null && listOfTypes.contains((Object)RelatedItemType.brothersAndSisters) && !(listOfUUIDs = schemaPlugin.getAssociatedParentUUIDs(md)).isEmpty()) {
            joinedUUIDs = "\"" + Joiner.on((String)"\" or \"").join((Iterable)listOfUUIDs) + "\"";
            relatedRecords.addContent((Content)MetadataUtils.calculateResults(joinedUUIDs, RelatedItemType.brothersAndSisters.value(), from, to, uuid, portalFilter));
        }
        if (schemaPlugin != null && (listOfTypes.isEmpty() || listOfTypes.contains((Object)RelatedItemType.siblings))) {
            Element container;
            Element response = new Element("response");
            Set listOfAssociatedResources = schemaPlugin.getAssociatedResourcesUUIDs(md);
            if (listOfAssociatedResources != null) {
                for (AssociatedResource resource : listOfAssociatedResources) {
                    searchResult = MetadataUtils.search("\"" + resource.getUuid() + "\"", RelatedItemType.siblings.value(), from, to, null, false);
                    origin = MetadataUtils.hasResult(searchResult) ? RelatedItemOrigin.portal.name() : RelatedItemOrigin.catalog.name();
                    Element sibContent = MetadataUtils.getRecord(resource.getUuid(), context, dm);
                    if (sibContent == null) continue;
                    Element sibling = new Element("sibling");
                    sibling.setAttribute("origin", origin);
                    sibling.setAttribute("initiative", resource.getInitiativeType());
                    sibling.setAttribute("association", resource.getAssociationType());
                    response.addContent((Content)sibling.addContent((Content)sibContent));
                }
            }
            if ((container = relatedRecords.getChild("siblings")) == null) {
                container = new Element("siblings");
                relatedRecords.addContent((Content)container);
            }
            container.addContent((Content)response);
            MetadataUtils.appendRemoteRecord("siblings", mdIndexFields, relatedRecords.getChild("siblings"));
        }
        if (listOfTypes.isEmpty() || listOfTypes.contains((Object)RelatedItemType.associated)) {
            relatedRecords.addContent((Content)MetadataUtils.calculateResults("\"" + uuid + "\"", "associated", from, to, null, portalFilter));
        }
        if (listOfTypes.isEmpty() || listOfTypes.contains((Object)RelatedItemType.services)) {
            relatedRecords.addContent((Content)MetadataUtils.calculateResults("\"" + uuid + "\"", "services", from, to, null, portalFilter));
        }
        if (schemaPlugin != null && (listOfTypes.isEmpty() || listOfTypes.contains((Object)RelatedItemType.datasets) || listOfTypes.contains((Object)RelatedItemType.fcats) || listOfTypes.contains((Object)RelatedItemType.sources))) {
            if (listOfTypes.isEmpty() || listOfTypes.contains((Object)RelatedItemType.datasets)) {
                listOfUUIDs = schemaPlugin.getAssociatedDatasetUUIDs(md);
                if (listOfUUIDs != null && !listOfUUIDs.isEmpty()) {
                    joinedUUIDs = "\"" + Joiner.on((String)"\" or \"").join((Iterable)listOfUUIDs) + "\"";
                    relatedRecords.addContent((Content)MetadataUtils.calculateResults(joinedUUIDs, "datasets", from, to, null, portalFilter));
                } else {
                    relatedRecords.addContent((Content)new Element("datasets"));
                }
                MetadataUtils.appendRemoteRecord("datasets", mdIndexFields, relatedRecords.getChild("datasets"));
            }
            if (listOfTypes.isEmpty() || listOfTypes.contains((Object)RelatedItemType.sources)) {
                listOfUUIDs = schemaPlugin.getAssociatedSourceUUIDs(md);
                if (listOfUUIDs != null && !listOfUUIDs.isEmpty()) {
                    joinedUUIDs = "\"" + Joiner.on((String)"\" or \"").join((Iterable)listOfUUIDs) + "\"";
                    relatedRecords.addContent((Content)MetadataUtils.calculateResults(joinedUUIDs, "sources", from, to, null, portalFilter));
                } else {
                    relatedRecords.addContent((Content)new Element("sources"));
                }
                MetadataUtils.appendRemoteRecord("sources", mdIndexFields, relatedRecords.getChild("sources"));
            }
            if (listOfTypes.isEmpty() || listOfTypes.contains((Object)RelatedItemType.fcats)) {
                listOfUUIDs = schemaPlugin.getAssociatedFeatureCatalogueUUIDs(md);
                Element fcat = new Element("fcats");
                if (listOfUUIDs != null && !listOfUUIDs.isEmpty()) {
                    for (String fcat_uuid : listOfUUIDs) {
                        searchResult = MetadataUtils.search("\"" + fcat_uuid + "\"", RelatedItemType.fcats.value(), from, to, null, false);
                        origin = MetadataUtils.hasResult(searchResult) ? RelatedItemOrigin.portal.name() : RelatedItemOrigin.catalog.name();
                        Element metadata = new Element("metadata");
                        Element response = new Element("response");
                        Element current = MetadataUtils.getRecord(fcat_uuid, context, dm);
                        if (current != null) {
                            metadata.setAttribute("origin", origin);
                            metadata.addContent((Content)current);
                        } else {
                            LOGGER.error("Feature catalogue with UUID {} referenced in {} was not found.", (Object)fcat_uuid, (Object)uuid);
                        }
                        response.addContent((Content)metadata);
                        fcat.addContent((Content)response);
                    }
                }
                relatedRecords.addContent((Content)fcat);
                MetadataUtils.appendRemoteRecord("fcats", mdIndexFields, fcat);
            }
        }
        if (listOfTypes.isEmpty() || listOfTypes.contains((Object)RelatedItemType.hassources)) {
            relatedRecords.addContent((Content)MetadataUtils.calculateResults("\"" + uuid + "\"", "hassources", from, to, null, portalFilter));
        }
        if (listOfTypes.isEmpty() || listOfTypes.contains((Object)RelatedItemType.related)) {
            relatedRecords.addContent((Content)new Element("related").addContent((Content)Get.getRelation(iId, "full", context)));
            relatedRecords.addContent((Content)MetadataUtils.calculateResults("\"" + uuid + "\"", "hasfeaturecats", from, to, null, portalFilter));
        }
        if (md != null && (listOfTypes.isEmpty() || listOfTypes.contains((Object)RelatedItemType.onlines) || listOfTypes.contains((Object)RelatedItemType.thumbnails))) {
            relatedRecords.addContent((Content)new Element("metadata").addContent((Content)md.clone()));
        }
        return relatedRecords;
    }

    private static Element search(String uuidQueryValue, String type, String from, String to, String exclude, boolean ignorePortalFilter) throws Exception {
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        EsSearchManager searchMan = (EsSearchManager)applicationContext.getBean(EsSearchManager.class);
        if (Log.isDebugEnabled((String)"geonetwork.search")) {
            Log.debug((String)"geonetwork.search", (Object)("Searching for: " + type));
        }
        int fromValue = Integer.parseInt(from);
        int toValue = Integer.parseInt(to);
        String excludeQuery = "";
        if (exclude != null) {
            excludeQuery = String.format(" -uuid:%s", exclude);
        }
        String portalFilter = null;
        if (!ignorePortalFilter) {
            Optional portal;
            SourceRepository sourceRepository = (SourceRepository)ApplicationContextHolder.get().getBean(SourceRepository.class);
            NodeInfo node = (NodeInfo)ApplicationContextHolder.get().getBean(NodeInfo.class);
            if (node != null && !"srv".equals(node.getId()) && (portal = sourceRepository.findById((Object)node.getId())).isPresent() && StringUtils.isNotEmpty((String)((Source)portal.get()).getFilter())) {
                portalFilter = ((Source)portal.get()).getFilter();
            }
        }
        SearchResponse result = searchMan.query(String.format("+%s:(%s)%s", EsSearchManager.RELATED_INDEX_FIELDS.get(type), uuidQueryValue, excludeQuery), ignorePortalFilter ? null : portalFilter, EsSearchManager.FIELDLIST_CORE, fromValue, toValue - fromValue);
        Element typeResponse = new Element(type.equals("brothersAndSisters") ? "siblings" : type);
        if (!result.hits().hits().isEmpty()) {
            Element response = new Element("response");
            ObjectMapper objectMapper = new ObjectMapper();
            result.hits().hits().forEach(e1 -> {
                Hit e = (Hit)e1;
                Element recordMetadata = new Element("metadata");
                Map source = (Map)objectMapper.convertValue(e.source(), Map.class);
                recordMetadata.addContent((Content)new Element("id").setText((String)source.get("id")));
                recordMetadata.addContent((Content)new Element("uuid").setText((String)source.get("uuid")));
                if (type.equals("brothersAndSisters")) {
                    recordMetadata.setAttribute("association", "brothersAndSisters");
                }
                MetadataUtils.setFieldFromIndexDocument(recordMetadata, source, "resourceTitle", "title");
                MetadataUtils.setFieldFromIndexDocument(recordMetadata, source, "resourceAbstract", "abstract");
                MetadataUtils.setFieldFromIndexDocument(recordMetadata, source, "operatesOn", "operatesOn");
                response.addContent((Content)recordMetadata);
            });
            typeResponse.addContent((Content)response);
        }
        return typeResponse;
    }

    private static void setFieldFromIndexDocument(Element recordMetadata, Map<String, Object> source, String fieldName, String elementName) {
        Object fields = source.get(fieldName + "Object");
        if (fields == null) {
            fields = source.get(fieldName);
        }
        if (fields instanceof ArrayList) {
            ((ArrayList)fields).forEach(field -> recordMetadata.addContent((Content)new Element(elementName).setText((String)field)));
        } else if (fields instanceof Map) {
            recordMetadata.addContent((Content)new Element(elementName).setText((String)((Map)fields).get("default")));
        } else if (fields instanceof String) {
            recordMetadata.addContent((Content)new Element(elementName).setText((String)fields));
        }
    }

    public static Set<String> getUuidsToExport(String query) throws Exception {
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        EsSearchManager searchMan = (EsSearchManager)applicationContext.getBean(EsSearchManager.class);
        HashSet<String> uuids = new HashSet<String>();
        HashSet<String> field = new HashSet<String>(1);
        field.add("uuid");
        int from = 0;
        SettingInfo si = (SettingInfo)applicationContext.getBean(SettingInfo.class);
        int size = Integer.parseInt(si.getSelectionMaxRecords());
        SearchResponse result = searchMan.query(query, null, from, size);
        if (!result.hits().hits().isEmpty()) {
            List elements = result.hits().hits();
            ObjectMapper objectMapper = new ObjectMapper();
            elements.forEach(e -> uuids.add((String)((Map)objectMapper.convertValue(e.source(), Map.class)).get("uuid")));
        }
        Log.info((String)"geonetwork.mef", (Object)("  Found " + uuids.size() + " record(s)."));
        return uuids;
    }

    private static Element getRecord(String uuid, ServiceContext context, DataManager dm) {
        Element content;
        block2: {
            content = null;
            try {
                String id = dm.getMetadataId(uuid);
                Lib.resource.checkPrivilege(context, id, ReservedOperation.view);
                content = dm.getMetadata(context, id, false, false, false);
            }
            catch (Exception e) {
                if (!Log.isDebugEnabled((String)"geonetwork.search")) break block2;
                Log.debug((String)"geonetwork.search", (Object)("Metadata " + uuid + " record is not visible for user."));
            }
        }
        return content;
    }

    public static boolean retrieveMetadataValidationStatus(AbstractMetadata metadata, ServiceContext context) throws Exception {
        boolean hasValidation;
        MetadataValidationRepository metadataValidationRepository = (MetadataValidationRepository)context.getBean(MetadataValidationRepository.class);
        IMetadataValidator validator = (IMetadataValidator)context.getBean(IMetadataValidator.class);
        DataManager dataManager = (DataManager)context.getBean(DataManager.class);
        boolean bl = hasValidation = metadataValidationRepository.count(MetadataValidationSpecs.hasMetadataId((int)metadata.getId())) > 0L;
        if (!hasValidation) {
            validator.doValidate(metadata, context.getLanguage());
            dataManager.indexMetadata("" + metadata.getId(), true);
        }
        boolean isInvalid = metadataValidationRepository.count(MetadataValidationSpecs.isInvalidAndRequiredForMetadata((int)metadata.getId())) > 0L;
        return isInvalid;
    }

    public static boolean isMetadataFieldValueExistingInOtherRecords(String metadataValue, String metadataField, String metadataUuidToExclude) {
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        EsSearchManager searchMan = (EsSearchManager)applicationContext.getBean(EsSearchManager.class);
        String esFieldName = "resourceTitleObject.\\\\*.keyword";
        if (metadataField.equals("altTitle")) {
            esFieldName = "resourceAltTitleObject.\\\\*.keyword";
        } else if (metadataField.equals("identifier")) {
            esFieldName = "resourceIdentifier.code";
        }
        boolean duplicatedMetadataValue = false;
        String jsonQuery = " {       \"query_string\": {       \"query\": \"+" + esFieldName + ":\\\"%s\\\" -uuid:\\\"%s\\\"\"       }}";
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            JsonNode esJsonQuery = objectMapper.readTree(String.format(jsonQuery, metadataValue, metadataUuidToExclude));
            SearchResponse queryResult = searchMan.query(esJsonQuery, EsSearchManager.FIELDLIST_UUID, 0, 5);
            duplicatedMetadataValue = !queryResult.hits().hits().isEmpty();
        }
        catch (Exception ex) {
            Log.error((String)"geonetwork.api", (String)ex.getMessage(), (Throwable)ex);
        }
        return duplicatedMetadataValue;
    }

    private static boolean hasResult(Element searchResponse) {
        if (!searchResponse.getChildren().isEmpty()) {
            Element containerResults = (Element)searchResponse.getChildren().get(0);
            return !containerResults.getChildren().isEmpty();
        }
        return false;
    }

    private static Element calculateResults(String uuidQueryValue, String type, String from, String to, String exclude, String portalFilter) throws Exception {
        Element results;
        block7: {
            block6: {
                results = MetadataUtils.search(uuidQueryValue, type, from, to, exclude, true);
                if (!StringUtils.isNotEmpty((String)portalFilter)) break block6;
                Element resultsForPortal = MetadataUtils.search(uuidQueryValue, type, from, to, exclude, false);
                HashSet<String> portalResultsUuids = new HashSet<String>();
                if (resultsForPortal.getChild("response") != null) {
                    for (Element r : resultsForPortal.getChild("response").getChildren()) {
                        String uuidValue = r.getChildText("uuid");
                        portalResultsUuids.add(uuidValue);
                    }
                }
                if (results.getChild("response") == null) break block7;
                for (Element r : results.getChild("response").getChildren()) {
                    String origin = RelatedItemOrigin.catalog.name();
                    String uuidValue = r.getChildText("uuid");
                    if (portalResultsUuids.contains(uuidValue)) {
                        origin = RelatedItemOrigin.portal.name();
                    }
                    r.setAttribute("origin", origin);
                }
                break block7;
            }
            if (results.getChild("response") != null) {
                for (Element r : results.getChild("response").getChildren()) {
                    r.setAttribute("origin", RelatedItemOrigin.portal.name());
                }
            }
        }
        return results;
    }

    private static void appendRemoteRecord(String type, Map<String, Object> mdIndexFields, Element typeRoot) {
        Object values = mdIndexFields.get("recordLink");
        if (values instanceof ArrayList) {
            Element responseRoot = null;
            if (typeRoot.getChild("response") != null) {
                responseRoot = typeRoot.getChild("response");
            } else {
                responseRoot = new Element("response");
                typeRoot.addContent((Content)responseRoot);
            }
            Element finalResponseRoot = responseRoot;
            ((ArrayList)values).forEach(recordLink -> {
                Map linkProperties;
                if (recordLink instanceof Map && type.equals((linkProperties = (Map)recordLink).get("type")) && "remote".equals(linkProperties.get("origin"))) {
                    Element recordMetadata = new Element("metadata");
                    recordMetadata.setAttribute("origin", RelatedItemOrigin.remote.name());
                    if (type.equals(RelatedItemType.siblings.value())) {
                        if (linkProperties.get("associationType") != null) {
                            recordMetadata.setAttribute("association", (String)linkProperties.get("associationType"));
                        }
                        if (linkProperties.get("initiativeType") != null) {
                            recordMetadata.setAttribute("initiative", (String)linkProperties.get("initiativeType"));
                        }
                    }
                    recordMetadata.addContent((Content)new Element("id").setText((String)linkProperties.get("to")));
                    recordMetadata.addContent((Content)new Element("uuid").setText((String)linkProperties.get("to")));
                    recordMetadata.addContent((Content)new Element("title").setText((String)linkProperties.get("title")));
                    recordMetadata.addContent((Content)new Element("url").setText((String)linkProperties.get("url")));
                    finalResponseRoot.addContent((Content)recordMetadata);
                }
            });
        }
    }

    public static class RelatedTypeDetails {
        private String query;
        private Set<String> expectedRecords = new HashSet<String>();
        private Set<String> remoteRecords = new HashSet<String>();
        private Map<String, Map<String, String>> recordsProperties = new HashMap<String, Map<String, String>>();

        public RelatedTypeDetails(String query) {
            this.query = query;
        }

        public RelatedTypeDetails(String query, Set<String> expectedRecords) {
            this.query = query;
            this.expectedRecords = expectedRecords;
        }

        public RelatedTypeDetails(String query, Set<String> expectedRecords, Map<String, Map<String, String>> recordsProperties) {
            this.query = query;
            this.expectedRecords = expectedRecords;
            this.recordsProperties = recordsProperties;
        }

        public RelatedTypeDetails(String query, Set<String> expectedRecords, Map<String, Map<String, String>> recordsProperties, Set<String> remoteRecords) {
            this.query = query;
            this.expectedRecords = expectedRecords;
            this.recordsProperties = recordsProperties;
            this.remoteRecords = remoteRecords;
        }

        public String getQuery() {
            return this.query;
        }

        public void setQuery(String query) {
            this.query = query;
        }

        public Set<String> getExpectedRecords() {
            return this.expectedRecords;
        }

        public void setExpectedRecords(Set<String> expectedRecords) {
            this.expectedRecords = expectedRecords;
        }

        public Map<String, Map<String, String>> getRecordsProperties() {
            return this.recordsProperties;
        }

        public void setRecordsProperties(Map<String, Map<String, String>> recordsProperties) {
            this.recordsProperties = recordsProperties;
        }

        public Set<String> getRemoteRecords() {
            return this.remoteRecords;
        }
    }
}

