/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import jeeves.server.context.ServiceContext;
import jeeves.services.ReadWriteController;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.exception.ResourceNotFoundException;
import org.fao.geonet.doi.client.DoiManager;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.DoiServer;
import org.fao.geonet.repository.DoiServerRepository;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/{portal}/api/records"})
@Tag(name="records", description="Metadata record operations")
@RestController(value="doi")
@PreAuthorize(value="hasAuthority('Editor')")
@ReadWriteController
public class DoiApi {
    private final DoiManager doiManager;
    private final DoiServerRepository doiServerRepository;

    DoiApi(DoiManager doiManager, DoiServerRepository doiServerRepository) {
        this.doiManager = doiManager;
        this.doiServerRepository = doiServerRepository;
    }

    @Operation(summary="Check that a record can be submitted to DataCite for DOI creation. DataCite requires some fields to be populated.")
    @GetMapping(value={"/{metadataUuid}/doi/{doiServerId}/checkPreConditions"}, produces={"application/json"})
    @PreAuthorize(value="hasAuthority('Editor')")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Record can be proposed to DataCite."), @ApiResponse(responseCode="404", description="Metadata not found."), @ApiResponse(responseCode="400", description="Record does not meet preconditions. Check error message."), @ApiResponse(responseCode="500", description="Service unavailable."), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to edit the resource.")})
    public ResponseEntity<Map<String, Boolean>> checkDoiStatus(@Parameter(description="Record UUID.", required=true) @PathVariable String metadataUuid, @Parameter(description="DOI server identifier", required=true) @PathVariable Integer doiServerId, @Parameter(hidden=true) HttpServletRequest request) throws Exception {
        AbstractMetadata metadata = ApiUtils.canEditRecord(metadataUuid, request);
        ServiceContext serviceContext = ApiUtils.createServiceContext(request);
        DoiServer doiServer = this.retrieveDoiServer(doiServerId);
        Map reportStatus = this.doiManager.check(serviceContext, doiServer, metadata, null);
        return new ResponseEntity((Object)reportStatus, HttpStatus.OK);
    }

    @Operation(summary="Check the DOI URL created based on current configuration and pattern.")
    @GetMapping(value={"/{metadataUuid}/doi/{doiServerId}/checkDoiUrl"}, produces={"text/plain"})
    @PreAuthorize(value="hasAuthority('Editor')")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="DOI URL created."), @ApiResponse(responseCode="404", description="Metadata not found."), @ApiResponse(responseCode="500", description="Service unavailable."), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to edit the resource.")})
    public ResponseEntity<String> checkDoiUrl(@Parameter(description="Record UUID.", required=true) @PathVariable String metadataUuid, @Parameter(description="DOI server identifier", required=true) @PathVariable Integer doiServerId, @Parameter(hidden=true) HttpServletRequest request) throws Exception {
        AbstractMetadata metadata = ApiUtils.canEditRecord(metadataUuid, request);
        DoiServer doiServer = this.retrieveDoiServer(doiServerId);
        return new ResponseEntity((Object)this.doiManager.checkDoiUrl(doiServer, metadata), HttpStatus.OK);
    }

    @Operation(summary="Submit a record to the Datacite metadata store in order to create a DOI.")
    @PutMapping(value={"/{metadataUuid}/doi/{doiServerId}"}, produces={"application/json"})
    @PreAuthorize(value="hasAuthority('Editor')")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Check status of the report."), @ApiResponse(responseCode="404", description="Metadata not found."), @ApiResponse(responseCode="500", description="Service unavailable."), @ApiResponse(responseCode="403", description="Operation not allowed. User needs to be able to edit the resource.")})
    public ResponseEntity<Map<String, String>> createDoi(@Parameter(description="Record UUID.", required=true) @PathVariable String metadataUuid, @Parameter(description="DOI server identifier", required=true) @PathVariable Integer doiServerId, @Parameter(hidden=true) HttpServletRequest request, @Parameter(hidden=true) HttpSession session) throws Exception {
        AbstractMetadata metadata = ApiUtils.canEditRecord(metadataUuid, request);
        ServiceContext serviceContext = ApiUtils.createServiceContext(request);
        DoiServer doiServer = this.retrieveDoiServer(doiServerId);
        Map doiInfo = this.doiManager.register(serviceContext, doiServer, metadata);
        return new ResponseEntity((Object)doiInfo, HttpStatus.CREATED);
    }

    @Operation(summary="Remove a DOI (this is not recommended, DOI are supposed to be persistent once created. This is mainly here for testing).")
    @DeleteMapping(value={"/{metadataUuid}/doi/{doiServerId}"}, produces={"application/json"})
    @PreAuthorize(value="hasAuthority('Administrator')")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="DOI unregistered.", content={@Content(schema=@Schema(hidden=true))}), @ApiResponse(responseCode="404", description="Metadata or DOI not found."), @ApiResponse(responseCode="500", description="Service unavailable."), @ApiResponse(responseCode="403", description="Operation not allowed. Only Administrators can access it.")})
    public ResponseEntity<Void> unregisterDoi(@Parameter(description="Record UUID.", required=true) @PathVariable String metadataUuid, @Parameter(hidden=true) HttpServletRequest request, @Parameter(description="DOI server identifier", required=true) @PathVariable Integer doiServerId, @Parameter(hidden=true) HttpSession session) throws Exception {
        AbstractMetadata metadata = ApiUtils.canEditRecord(metadataUuid, request);
        ServiceContext serviceContext = ApiUtils.createServiceContext(request);
        DoiServer doiServer = this.retrieveDoiServer(doiServerId);
        this.doiManager.unregisterDoi(doiServer, metadata, serviceContext);
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    private DoiServer retrieveDoiServer(Integer doiServerId) throws ResourceNotFoundException {
        Optional doiServerOpt = this.doiServerRepository.findOneById(doiServerId.intValue());
        if (doiServerOpt.isEmpty()) {
            throw new ResourceNotFoundException(String.format("DOI server with id '%s' not found.", doiServerId));
        }
        return (DoiServer)doiServerOpt.get();
    }
}

