/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.oaipmh;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.servlet.http.HttpServletRequest;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.kernel.oaipmh.OaiPmhDispatcher;
import org.fao.geonet.kernel.oaipmh.OaiPmhParams;
import org.jdom.Element;
import org.springdoc.api.annotations.ParameterObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/{portal}/api/oaipmh"})
@Tag(name="oaipmh", description="OAI-PMH server")
@RestController(value="oaipmh-server")
public class OaiPmhApi {
    @Autowired
    private OaiPmhDispatcher oaiPmhDispatcher;

    @Operation(summary="OAI-PMH server endpoint", description="[More information](https://docs.geonetwork-opensource.org/4.4/api/oai-pmh/)")
    @GetMapping(produces={"application/xml"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OAI-PMH server response.")})
    @ResponseBody
    public Element dispatch(@ParameterObject OaiPmhParams oaiPmhParams, HttpServletRequest request) {
        ServiceContext serviceContext = ApiUtils.createServiceContext(request);
        serviceContext.setService("api/oaipmh");
        return this.oaiPmhDispatcher.dispatch(oaiPmhParams, serviceContext);
    }
}

