/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.es;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.fao.geonet.api.es.JsonPathItem;

public class JsonStreamUtils {
    public static final JsonFactory jsonFactory = new JsonFactory((ObjectCodec)new ObjectMapper());

    public static void filterArrayElements(JsonParser parser, JsonGenerator generator, JsonFilter callback) throws Exception {
        if (parser.getCurrentToken() != JsonToken.START_ARRAY) {
            throw new RuntimeException("Expecting an array");
        }
        generator.writeStartArray();
        while (parser.nextToken() != JsonToken.END_ARRAY) {
            callback.apply(parser, generator);
        }
        generator.writeEndArray();
    }

    public static void filterObjectInPath(JsonParser parser, JsonGenerator generator, JsonFilter callback, List<JsonPathItem> path) throws Exception {
        if (parser.getCurrentToken() == JsonToken.START_OBJECT) {
            generator.writeStartObject();
            while (parser.nextToken() != JsonToken.END_OBJECT) {
                String name = parser.getCurrentName();
                Optional<JsonPathItem> pathFound = path.stream().filter(p -> p.getName().equals(name) || p.getName().equals("*")).findFirst();
                if (pathFound.isPresent()) {
                    generator.writeFieldName(name);
                    parser.nextToken();
                    if (pathFound.get().getSubitems().isEmpty()) {
                        callback.apply(parser, generator);
                        continue;
                    }
                    JsonStreamUtils.filterObjectInPath(parser, generator, callback, pathFound.get().getSubitems());
                    continue;
                }
                generator.copyCurrentStructure(parser);
            }
            generator.writeEndObject();
        } else if (parser.getCurrentToken() == JsonToken.START_ARRAY) {
            generator.writeStartArray();
            while (parser.nextToken() != JsonToken.END_ARRAY) {
                JsonStreamUtils.filterObjectInPath(parser, generator, callback, path);
            }
            generator.writeEndArray();
        } else {
            throw new RuntimeException("Unexpected element: " + parser.getCurrentName());
        }
    }

    public static void addInfoToDocs(JsonParser parser, JsonGenerator generator, TreeFilter callback) throws Exception {
        JsonPathItem hitsItem = JsonPathItem.create("hits").addSubitem("hits");
        JsonStreamUtils.filterObjectInPath(parser, generator, (par, gen) -> JsonStreamUtils.filterArrayElements(par, gen, (par1, gen1) -> JsonStreamUtils.filterTree(parser, generator, callback)), Collections.singletonList(hitsItem));
    }

    public static void addInfoToDocsMSearch(JsonParser parser, JsonGenerator generator, TreeFilter callback) throws Exception {
        JsonPathItem responsesItem = JsonPathItem.create("responses").addSubitem("hits").addSubitem("aggregations");
        responsesItem.getSubitem("hits").addSubitem("hits");
        responsesItem.getSubitem("aggregations").addSubitem("*");
        JsonPathItem aggregationChildrenItem = responsesItem.getSubitem("aggregations").getSubitem("*");
        aggregationChildrenItem.addSubitem("buckets");
        aggregationChildrenItem.getSubitem("buckets").addSubitem("docs");
        aggregationChildrenItem.getSubitem("buckets").getSubitem("docs").addSubitem("hits");
        aggregationChildrenItem.getSubitem("buckets").getSubitem("docs").getSubitem("hits").addSubitem("hits");
        JsonStreamUtils.filterObjectInPath(parser, generator, (par, gen) -> JsonStreamUtils.filterArrayElements(par, gen, (par1, gen1) -> JsonStreamUtils.filterTree(parser, generator, callback)), Collections.singletonList(responsesItem));
    }

    private static void filterTree(JsonParser parser, JsonGenerator generator, TreeFilter callback) throws Exception {
        if (parser.getCurrentToken() != JsonToken.START_OBJECT) {
            throw new RuntimeException("Expecting an object");
        }
        JsonNode tree = (JsonNode)parser.readValueAsTree();
        callback.apply((ObjectNode)tree);
        generator.writeTree((TreeNode)tree);
    }

    public static interface TreeFilter {
        public void apply(ObjectNode var1) throws Exception;
    }

    public static interface JsonFilter {
        public void apply(JsonParser var1, JsonGenerator var2) throws Exception;
    }
}

