/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api;

import com.google.common.collect.Sets;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.MissingResourceException;
import javax.servlet.http.HttpServletRequest;
import org.fao.geonet.api.ApiError;
import org.fao.geonet.api.exception.FeatureNotEnabledException;
import org.fao.geonet.api.exception.ForbiddenException;
import org.fao.geonet.api.exception.GeoPublisherException;
import org.fao.geonet.api.exception.GeonetMaxUploadSizeExceededException;
import org.fao.geonet.api.exception.InputStreamLimitExceededException;
import org.fao.geonet.api.exception.NoResultsFoundException;
import org.fao.geonet.api.exception.NotAllowedException;
import org.fao.geonet.api.exception.ResourceAlreadyExistException;
import org.fao.geonet.api.exception.ResourceNotFoundException;
import org.fao.geonet.api.exception.WebApplicationException;
import org.fao.geonet.api.tools.i18n.LanguageUtils;
import org.fao.geonet.doi.client.DoiClientException;
import org.fao.geonet.exceptions.ILocalizedException;
import org.fao.geonet.exceptions.ServiceNotAllowedEx;
import org.fao.geonet.exceptions.UserNotFoundEx;
import org.fao.geonet.exceptions.XSDValidationErrorEx;
import org.fao.geonet.inspire.validator.InspireValidatorException;
import org.fao.geonet.util.FileUtil;
import org.fao.geonet.utils.Log;
import org.json.JSONException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.InvalidMediaTypeException;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.UnsatisfiedServletRequestParameterException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.multipart.MaxUploadSizeExceededException;
import org.springframework.web.multipart.MultipartException;

@ControllerAdvice
public class GlobalExceptionController {
    private static final String API_EXCEPTION_MESSAGE_PREFIX = "api.exception.";
    private static final String API_EXCEPTION_MESSAGE_POSTFIX = ".message";
    private static final String API_EXCEPTION_DESCRIPTION_POSTFIX = ".description";
    @Autowired
    private LanguageUtils languageUtils;

    @ResponseBody
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ApiResponse(content={@Content(mediaType="application/json")})
    @ExceptionHandler(value={NotAllowedException.class})
    public ApiError notAllowedHandler(Exception exception, HttpServletRequest request) {
        this.storeApiErrorCause(exception);
        if (this.contentTypeNeedsBody(request)) {
            this.updateExceptionLocale(exception, request);
            ApiError apiError = new ApiError("forbidden", exception);
            apiError.setMessage(exception.getMessage());
            return apiError;
        }
        return null;
    }

    @ResponseBody
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    @ApiResponse(content={@Content(mediaType="application/json")})
    @ExceptionHandler(value={ServiceNotAllowedEx.class})
    public Object unauthorizedHandler(Exception exception) {
        this.storeApiErrorCause(exception);
        return new ApiError("unauthorized", exception);
    }

    @ResponseBody
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ApiResponse(content={@Content(mediaType="application/json")})
    @ExceptionHandler(value={SecurityException.class})
    public Object securityHandler(Exception exception) {
        this.storeApiErrorCause(exception);
        return new ApiError("forbidden", exception);
    }

    @ResponseBody
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ApiResponse(content={@Content(mediaType="application/json")})
    @ExceptionHandler(value={AccessDeniedException.class})
    public Object securityHandler(HttpServletRequest request, Exception exception) {
        this.storeApiErrorCause(exception);
        if (this.contentTypeNeedsBody(request)) {
            Object response = null;
            try {
                throw new ForbiddenException((Throwable)exception).withMessageKey("api.exception.forbidden").withDescriptionKey("api.exception.forbidden.description");
            }
            catch (ForbiddenException forbiddenException) {
                this.updateExceptionLocale((Exception)((Object)forbiddenException), request);
                return new ApiError("forbidden", (Exception)((Object)forbiddenException));
            }
        }
        return null;
    }

    @ResponseBody
    @ResponseStatus(value=HttpStatus.PAYLOAD_TOO_LARGE)
    @ApiResponse(content={@Content(mediaType="application/json")})
    @ExceptionHandler(value={MaxUploadSizeExceededException.class})
    public ApiError maxFileExceededHandler(Exception exception, HttpServletRequest request) {
        Exception ex;
        if (exception instanceof MaxUploadSizeExceededException) {
            long contentLength;
            long maxUploadSize = ((MaxUploadSizeExceededException)exception).getMaxUploadSize();
            long l = contentLength = exception instanceof InputStreamLimitExceededException ? ((InputStreamLimitExceededException)exception).getRemoteFileSize() : request.getContentLengthLong();
            if (contentLength > 0L && contentLength < maxUploadSize) {
                Log.warning((String)"geonetwork.resources", (Object)"Request content length is less than the maximum upload size but still caused an exception.");
            }
            ex = contentLength > maxUploadSize ? new GeonetMaxUploadSizeExceededException("uploadedResourceSizeExceededException", (Throwable)exception).withMessageKey("exception.maxUploadSizeExceeded", (Object[])new String[]{FileUtil.humanizeFileSize((long)maxUploadSize)}).withDescriptionKey("exception.maxUploadSizeExceeded.description", (Object[])new String[]{FileUtil.humanizeFileSize((long)contentLength), FileUtil.humanizeFileSize((long)maxUploadSize)}) : new GeonetMaxUploadSizeExceededException("uploadedResourceSizeExceededException", (Throwable)exception).withMessageKey("exception.maxUploadSizeExceeded", (Object[])new String[]{FileUtil.humanizeFileSize((long)maxUploadSize)}).withDescriptionKey("exception.maxUploadSizeExceededUnknownSize.description", (Object[])new String[]{FileUtil.humanizeFileSize((long)maxUploadSize)});
        } else {
            ex = exception;
        }
        this.storeApiErrorCause(ex);
        return new ApiError("max_file_exceeded", ex);
    }

    @ResponseBody
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ApiResponse(content={@Content(mediaType="application/json")})
    @ExceptionHandler(value={HttpMessageNotReadableException.class, Exception.class, InspireValidatorException.class, RuntimeException.class})
    public ApiError runtimeExceptionHandler(Exception exception, HttpServletRequest request) {
        this.storeApiErrorCause(exception);
        Log.error((String)"geonetwork", (String)exception.getMessage(), (Throwable)exception);
        if (this.contentTypeNeedsBody(request)) {
            return new ApiError("runtime_exception", exception);
        }
        return null;
    }

    @ResponseBody
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ApiResponse(content={@Content(mediaType="application/json")})
    @ExceptionHandler(value={FeatureNotEnabledException.class})
    public ApiError runtimeExceptionHandler(HttpServletRequest request, Exception exception) {
        this.storeApiErrorCause(exception);
        if (this.contentTypeNeedsBody(request)) {
            if (exception instanceof ILocalizedException && StringUtils.isEmpty((Object)((ILocalizedException)exception).getMessageKey())) {
                ((ILocalizedException)exception).setMessageKey("api.exception.resourceNotFound");
            }
            if (exception instanceof ILocalizedException && StringUtils.isEmpty((Object)((ILocalizedException)exception).getDescriptionKey())) {
                ((ILocalizedException)exception).setDescriptionKey("api.exception.resourceNotFound.description");
            }
            this.updateExceptionLocale(exception, request);
            return new ApiError("feature_disabled", exception);
        }
        return null;
    }

    @ResponseBody
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ApiResponse(content={@Content(mediaType="application/json")})
    @ExceptionHandler(value={WebApplicationException.class})
    public ApiError webappExceptionHandler(Exception exception) {
        this.storeApiErrorCause(exception);
        return new ApiError("webapplication_exception", exception);
    }

    @ResponseBody
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ApiResponse(content={@Content(mediaType="application/json")})
    @ExceptionHandler(value={FileNotFoundException.class, GeoPublisherException.class, NoResultsFoundException.class})
    public ApiError NotFoundHandler(Exception exception) {
        this.storeApiErrorCause(exception);
        return new ApiError("not_found", exception);
    }

    @ResponseBody
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ApiResponse(content={@Content(mediaType="application/json")})
    @ExceptionHandler(value={UserNotFoundEx.class, ResourceNotFoundException.class})
    public ApiError resourceNotFoundHandler(HttpServletRequest request, Exception exception) {
        this.storeApiErrorCause(exception);
        if (this.contentTypeNeedsBody(request)) {
            if (exception instanceof ILocalizedException && StringUtils.isEmpty((Object)((ILocalizedException)exception).getMessageKey())) {
                ((ILocalizedException)exception).setMessageKey("api.exception.resourceNotFound");
            }
            if (exception instanceof ILocalizedException && StringUtils.isEmpty((Object)((ILocalizedException)exception).getDescriptionKey())) {
                ((ILocalizedException)exception).setDescriptionKey("api.exception.resourceNotFound.description");
            }
            this.updateExceptionLocale(exception, request);
            return new ApiError("resource_not_found", exception);
        }
        return null;
    }

    private void updateExceptionLocale(Exception exception, HttpServletRequest request) {
        if (exception instanceof ILocalizedException && ((ILocalizedException)exception).getLocale() == null) {
            ((ILocalizedException)exception).setLocale(this.languageUtils.parseAcceptLanguage(request.getLocales()));
        }
    }

    private boolean contentTypeNeedsBody(HttpServletRequest request) {
        List<MediaType> requestMediaTypes = this.resolveMediaTypes((NativeWebRequest)new ServletWebRequest(request));
        HashSet allowedContentTypes = Sets.newHashSet((Object[])new MediaType[]{MediaType.APPLICATION_XML, MediaType.APPLICATION_XHTML_XML, MediaType.APPLICATION_JSON});
        int posHtmlMediaType = requestMediaTypes.indexOf(MediaType.TEXT_HTML);
        boolean requestedHtmlMediaType = false;
        if (posHtmlMediaType == 0) {
            requestedHtmlMediaType = true;
        } else if (posHtmlMediaType > -1) {
            List<MediaType> allowedContentTypesAndHtml = Arrays.asList(MediaType.APPLICATION_XML, MediaType.APPLICATION_XHTML_XML, MediaType.APPLICATION_JSON, MediaType.TEXT_HTML);
            ArrayList<MediaType> requestMediaTypes2 = new ArrayList<MediaType>(requestMediaTypes);
            requestMediaTypes2.retainAll(allowedContentTypesAndHtml);
            requestedHtmlMediaType = requestMediaTypes2.indexOf(MediaType.TEXT_HTML) == 0;
        }
        boolean needsBody = !Collections.disjoint(allowedContentTypes, requestMediaTypes) && !requestedHtmlMediaType;
        return needsBody;
    }

    public List<MediaType> resolveMediaTypes(NativeWebRequest request) {
        String header = request.getHeader("Accept");
        if (!StringUtils.hasText((String)header)) {
            return Collections.emptyList();
        }
        try {
            List mediaTypes = MediaType.parseMediaTypes((String)header);
            MediaType.sortBySpecificityAndQuality((List)mediaTypes);
            return mediaTypes;
        }
        catch (InvalidMediaTypeException ex) {
            return Collections.emptyList();
        }
    }

    @ResponseBody
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ApiResponse(content={@Content(mediaType="application/json")})
    @ExceptionHandler(value={ResourceAlreadyExistException.class})
    public ApiError resourceAlreadyExistHandler(HttpServletRequest request, Exception exception) {
        this.storeApiErrorCause(exception);
        if (this.contentTypeNeedsBody(request)) {
            if (exception instanceof ILocalizedException && StringUtils.isEmpty((Object)((ILocalizedException)exception).getMessageKey())) {
                ((ILocalizedException)exception).setMessageKey("api.exception.resourceAlreadyExists");
            }
            if (exception instanceof ILocalizedException && StringUtils.isEmpty((Object)((ILocalizedException)exception).getDescriptionKey())) {
                ((ILocalizedException)exception).setDescriptionKey("api.exception.resourceAlreadyExists.description");
            }
            this.updateExceptionLocale(exception, request);
            return new ApiError("resource_already_exist", exception);
        }
        return null;
    }

    @ResponseBody
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ApiResponse(content={@Content(mediaType="application/json")})
    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    public ApiError missingParameterHandler(Exception exception) {
        this.storeApiErrorCause(exception);
        return new ApiError("required_parameter_missing", exception);
    }

    @ResponseBody
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ApiResponse(content={@Content(mediaType="application/json")})
    @ExceptionHandler(value={UnsatisfiedServletRequestParameterException.class, IllegalArgumentException.class, XSDValidationErrorEx.class, JSONException.class, MultipartException.class, DoiClientException.class})
    public ApiError unsatisfiedParameterHandler(Exception exception, HttpServletRequest request) {
        this.storeApiErrorCause(exception);
        if (this.contentTypeNeedsBody(request)) {
            if (exception instanceof ILocalizedException && StringUtils.isEmpty((Object)((ILocalizedException)exception).getMessageKey())) {
                ((ILocalizedException)exception).setMessageKey("api.exception.unsatisfiedRequestParameter");
            }
            if (exception instanceof ILocalizedException && StringUtils.isEmpty((Object)((ILocalizedException)exception).getDescriptionKey())) {
                ((ILocalizedException)exception).setDescriptionKey("api.exception.unsatisfiedRequestParameter.description");
            }
            this.updateExceptionLocale(exception, request);
            return new ApiError("unsatisfied_request_parameter", exception);
        }
        return null;
    }

    @ResponseBody
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ApiResponse(content={@Content(mediaType="application/json")})
    @ExceptionHandler(value={MissingResourceException.class})
    public ApiError missingResourceHandler(Exception exception) {
        this.storeApiErrorCause(exception);
        return new ApiError("missing_resource_parameter", exception);
    }

    private void storeApiErrorCause(Exception exception) {
        RequestContextHolder.currentRequestAttributes().setAttribute("exception", (Object)exception, 0);
    }
}

