/*
 * Decompiled with CFR 0.152.
 */
package opendap.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringBufferInputStream;
import java.io.StringWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import opendap.dap.DAP2Exception;
import opendap.dap.DAS;
import opendap.dap.DDS;
import opendap.dap.Server.ServerDDS;
import opendap.dap.parser.ParseException;
import opendap.servers.www.jscriptCore;
import opendap.servers.www.wwwFactory;
import opendap.servers.www.wwwOutPut;

public class GetHTMLInterfaceHandler {
    private static final boolean _Debug = false;
    private String helpLocation = "http://www.opendap.org/user/guide-html/guide_20.html/";

    public void sendDataRequestForm(HttpServletRequest request, HttpServletResponse response, String dataSet, ServerDDS sdds, DAS myDAS) throws DAP2Exception, ParseException {
        int suffixIndex = request.getRequestURL().toString().lastIndexOf(".");
        String requestURL = request.getRequestURL().substring(0, suffixIndex);
        try {
            PrintWriter pw = new PrintWriter((OutputStream)response.getOutputStream());
            wwwOutPut wOut = new wwwOutPut(pw);
            DDS myDDS = this.getWebFormDDS(dataSet, sdds);
            jscriptCore jsc = new jscriptCore();
            pw.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\"\n\"http://www.w3.org/TR/REC-html40/loose.dtd\">\n<html><head><title>OPeNDAP Dataset Query Form</title>\n<base href=\"" + this.helpLocation + "\">\n" + "<script type=\"text/javascript\">\n" + "<!--\n");
            pw.flush();
            pw.println(jscriptCore.jScriptCode);
            pw.flush();
            pw.println("DODS_URL = new dods_url(\"" + requestURL + "\");\n" + "// -->\n" + "</script>\n" + "</head>\n" + "<body>\n" + "<p><h2 align='center'>OPeNDAP Dataset Access Form</h2>\n" + "<hr>\n" + "<font size=-1>Tested on Netscape 4.61 and Internet Explorer 5.00.</font>\n" + "<hr>\n" + "<form action=\"\">\n" + "<table>\n");
            pw.flush();
            wOut.writeDisposition(requestURL);
            pw.println("<tr><td><td><hr>\n");
            wOut.writeGlobalAttributes(myDAS, myDDS);
            pw.println("<tr><td><td><hr>\n");
            wOut.writeVariableEntries(myDAS, myDDS);
            pw.println("</table></form>\n");
            pw.println("<hr>\n");
            pw.println("<address>Send questions or comments to: <a href=\"mailto:support@unidata.ucar.edu\">support@unidata.ucar.edu</a></address></body></html>\n");
            pw.println("<hr>");
            pw.println("<h2>DDS:</h2>");
            pw.println("<pre>");
            myDDS.print(pw);
            pw.println("</pre>");
            pw.println("<hr>");
            pw.flush();
        }
        catch (IOException ioe) {
            System.out.println("OUCH! IOException: " + ioe.getMessage());
            ioe.printStackTrace(System.out);
        }
    }

    public DDS getWebFormDDS(String dataSet, ServerDDS sDDS) throws DAP2Exception, ParseException {
        wwwFactory wfactory = new wwwFactory();
        DDS wwwDDS = new DDS(dataSet, wfactory);
        StringWriter ddsSW = new StringWriter();
        sDDS.print(new PrintWriter(ddsSW));
        wwwDDS.parse(new StringBufferInputStream(ddsSW.toString()));
        return wwwDDS;
    }
}

