/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.builder;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.geometry.MismatchedDimensionException;
import org.geotools.api.geometry.MismatchedReferenceSystemException;
import org.geotools.api.geometry.Position;
import org.geotools.api.metadata.extent.GeographicBoundingBox;
import org.geotools.api.metadata.quality.EvaluationMethodType;
import org.geotools.api.metadata.quality.Result;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.ReferenceIdentifier;
import org.geotools.api.referencing.crs.CRSFactory;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.crs.EngineeringCRS;
import org.geotools.api.referencing.cs.CoordinateSystem;
import org.geotools.api.referencing.datum.DatumFactory;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.MathTransformFactory;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.api.referencing.operation.Transformation;
import org.geotools.api.util.InternationalString;
import org.geotools.geometry.GeneralBounds;
import org.geotools.geometry.GeneralPosition;
import org.geotools.metadata.i18n.Vocabulary;
import org.geotools.metadata.iso.extent.ExtentImpl;
import org.geotools.metadata.iso.extent.GeographicBoundingBoxImpl;
import org.geotools.metadata.iso.quality.PositionalAccuracyImpl;
import org.geotools.metadata.iso.quality.QuantitativeResultImpl;
import org.geotools.metadata.math.Statistics;
import org.geotools.referencing.CRS;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.cs.DefaultCartesianCS;
import org.geotools.referencing.operation.DefaultOperationMethod;
import org.geotools.referencing.operation.DefaultTransformation;
import org.geotools.referencing.operation.builder.MappedPosition;
import org.geotools.referencing.util.CRSUtilities;
import org.geotools.util.Classes;
import org.geotools.util.TableWriter;
import org.geotools.util.factory.Hints;

public abstract class MathTransformBuilder {
    private final List<MappedPosition> positions = new ArrayList<MappedPosition>();
    private final List<MappedPosition> unmodifiablePositions = Collections.unmodifiableList(this.positions);
    private CoordinateReferenceSystem sourceCRS;
    private CoordinateReferenceSystem targetCRS;
    private transient MathTransform transform;
    private transient Transformation transformation;
    protected final MathTransformFactory mtFactory;
    private final CRSFactory crsFactory;
    private final DatumFactory datumFactory;

    public MathTransformBuilder() {
        this(null);
    }

    public MathTransformBuilder(Hints hints) {
        this.mtFactory = ReferencingFactoryFinder.getMathTransformFactory(hints);
        this.crsFactory = ReferencingFactoryFinder.getCRSFactory(hints);
        this.datumFactory = ReferencingFactoryFinder.getDatumFactory(hints);
    }

    public String getName() {
        return Classes.getShortClassName((Object)this) + " fit";
    }

    public abstract int getMinimumPointCount();

    public int getDimension() {
        return 2;
    }

    public List<MappedPosition> getMappedPositions() {
        return this.unmodifiablePositions;
    }

    public void setMappedPositions(List<MappedPosition> positions) throws IllegalArgumentException, MismatchedDimensionException, MismatchedReferenceSystemException {
        CoordinateReferenceSystem source = this.ensureValid(MathTransformBuilder.getPoints(positions, false), "sourcePoints");
        CoordinateReferenceSystem target = this.ensureValid(MathTransformBuilder.getPoints(positions, true), "targetPoints");
        this.positions.clear();
        this.positions.addAll(positions);
        this.sourceCRS = source;
        this.targetCRS = target;
        this.transform = null;
    }

    private static Position[] getPoints(List<MappedPosition> positions, boolean target) {
        Position[] points = new Position[positions.size()];
        for (int i = 0; i < points.length; ++i) {
            MappedPosition mp = positions.get(i);
            points[i] = target ? mp.getTarget() : mp.getSource();
        }
        return points;
    }

    private void setPoints(Position[] points, boolean target) throws IllegalArgumentException {
        this.transform = null;
        boolean add = this.positions.isEmpty();
        if (!add && points.length != this.positions.size()) {
            throw new IllegalArgumentException("Mismatched array length.");
        }
        int dimension = this.getDimension();
        for (int i = 0; i < points.length; ++i) {
            MappedPosition mp;
            if (add) {
                mp = new MappedPosition(dimension);
                this.positions.add(mp);
            } else {
                mp = this.positions.get(i);
            }
            Position point = points[i];
            if (target) {
                mp.setTarget(point);
                continue;
            }
            mp.setSource(point);
        }
    }

    public Position[] getSourcePoints() {
        Position[] points = MathTransformBuilder.getPoints(this.getMappedPositions(), false);
        assert (this.ensureValid(points, "sourcePoints", this.sourceCRS));
        return points;
    }

    public void setSourcePoints(Position ... points) throws IllegalArgumentException, MismatchedDimensionException, MismatchedReferenceSystemException {
        this.sourceCRS = this.ensureValid(points, "sourcePoints");
        this.setPoints(points, false);
    }

    public Position[] getTargetPoints() {
        Position[] points = MathTransformBuilder.getPoints(this.getMappedPositions(), true);
        assert (this.ensureValid(points, "targetPoints", this.targetCRS));
        return points;
    }

    public void setTargetPoints(Position ... points) throws IllegalArgumentException, MismatchedDimensionException, MismatchedReferenceSystemException {
        this.targetCRS = this.ensureValid(points, "targetPoints");
        this.setPoints(points, true);
    }

    public void printPoints(Writer out, Locale locale) throws IOException {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        NumberFormat source = this.getNumberFormat(locale, false);
        NumberFormat target = this.getNumberFormat(locale, true);
        try (TableWriter table = new TableWriter(out, " \u2502 ");){
            table.setAlignment(1);
            table.writeHorizontalSeparator();
            try {
                int i;
                CoordinateSystem sourceCS = this.getSourceCRS().getCoordinateSystem();
                CoordinateSystem targetCS = this.getTargetCRS().getCoordinateSystem();
                int dimension = sourceCS.getDimension();
                for (i = 0; i < dimension; ++i) {
                    table.write(sourceCS.getAxis(i).getName().getCode());
                    table.nextColumn();
                }
                dimension = targetCS.getDimension();
                for (i = 0; i < dimension; ++i) {
                    table.write(targetCS.getAxis(i).getName().getCode());
                    table.nextColumn();
                }
                table.writeHorizontalSeparator();
            }
            catch (FactoryException factoryException) {
                // empty catch block
            }
            table.setAlignment(2);
            for (MappedPosition mp : this.getMappedPositions()) {
                int i;
                Position point = mp.getSource();
                int dimension = point.getDimension();
                for (i = 0; i < dimension; ++i) {
                    table.write(source.format(point.getOrdinate(i)));
                    table.nextColumn();
                }
                point = mp.getTarget();
                dimension = point.getDimension();
                for (i = 0; i < dimension; ++i) {
                    table.write(target.format(point.getOrdinate(i)));
                    table.nextColumn();
                }
                table.nextLine();
            }
            table.writeHorizontalSeparator();
            table.flush();
        }
    }

    public CoordinateReferenceSystem getSourceCRS() throws FactoryException {
        if (this.sourceCRS == null) {
            this.sourceCRS = this.createEngineeringCRS(false);
        }
        assert (this.sourceCRS.getCoordinateSystem().getDimension() == this.getDimension());
        return this.sourceCRS;
    }

    public CoordinateReferenceSystem getTargetCRS() throws FactoryException {
        if (this.targetCRS == null) {
            this.targetCRS = this.createEngineeringCRS(true);
        }
        assert (this.targetCRS.getCoordinateSystem().getDimension() == this.getDimension());
        return this.targetCRS;
    }

    private EngineeringCRS createEngineeringCRS(boolean target) throws FactoryException {
        CoordinateSystem cs;
        CoordinateReferenceSystem oppositeCRS;
        HashMap<String, String> properties = new HashMap<String, String>(4);
        properties.put("name", Vocabulary.format((int)252));
        GeographicBoundingBox validArea = this.getValidArea(target);
        if (validArea != null) {
            ExtentImpl extent = new ExtentImpl();
            extent.getGeographicElements().add(validArea);
            properties.put("domainOfValidity", (String)extent.unmodifiable());
        }
        CoordinateReferenceSystem coordinateReferenceSystem = oppositeCRS = target ? this.sourceCRS : this.targetCRS;
        if (oppositeCRS != null) {
            cs = oppositeCRS.getCoordinateSystem();
        } else {
            switch (this.getDimension()) {
                case 2: {
                    cs = DefaultCartesianCS.GENERIC_2D;
                    break;
                }
                case 3: {
                    cs = DefaultCartesianCS.GENERIC_3D;
                    break;
                }
                default: {
                    throw new FactoryException("Coordinate reference system is unspecified.");
                }
            }
        }
        return this.crsFactory.createEngineeringCRS(properties, this.datumFactory.createEngineeringDatum(properties), cs);
    }

    private NumberFormat getNumberFormat(Locale locale, boolean target) {
        int digits;
        NumberFormat format = NumberFormat.getNumberInstance(locale);
        GeneralBounds envelope = this.getEnvelope(target);
        double length = 0.0;
        int i = envelope.getDimension();
        while (--i >= 0) {
            double candidate = envelope.getSpan(i);
            if (!(candidate > length)) continue;
            length = candidate;
        }
        if (length > 0.0 && (digits = Math.max(0, 3 - (int)Math.ceil(Math.log10(length)))) < 16) {
            format.setMinimumFractionDigits(digits);
            format.setMaximumFractionDigits(digits);
        }
        return format;
    }

    private GeneralBounds getEnvelope(boolean target) {
        GeneralBounds envelope = null;
        CoordinateReferenceSystem crs = null;
        for (MappedPosition mp : this.getMappedPositions()) {
            Position point = target ? mp.getTarget() : mp.getSource();
            if (point == null) continue;
            if (envelope == null) {
                double[] coordinates = point.getCoordinate();
                envelope = new GeneralBounds(coordinates, coordinates);
            } else {
                envelope.add(point);
            }
            crs = MathTransformBuilder.getCoordinateReferenceSystem(point, crs);
        }
        if (envelope != null) {
            envelope.setCoordinateReferenceSystem(crs);
        }
        return envelope;
    }

    private GeographicBoundingBox getValidArea(boolean target) {
        GeneralBounds envelope = this.getEnvelope(target);
        if (envelope != null) {
            try {
                return new GeographicBoundingBoxImpl((Bounds)envelope);
            }
            catch (TransformException transformException) {
                // empty catch block
            }
        }
        return null;
    }

    private static CoordinateReferenceSystem getCoordinateReferenceSystem(Position point, CoordinateReferenceSystem previousCRS) throws MismatchedReferenceSystemException {
        CoordinateReferenceSystem candidate = point.getCoordinateReferenceSystem();
        if (candidate != null) {
            if (previousCRS == null) {
                return candidate;
            }
            if (!previousCRS.equals(candidate)) {
                throw new MismatchedReferenceSystemException("The coordinate reference system must be the same for all objects.");
            }
        }
        return previousCRS;
    }

    public Class<? extends CoordinateSystem> getCoordinateSystemType() {
        return CoordinateSystem.class;
    }

    private CoordinateReferenceSystem ensureValid(Position[] points, String label) throws IllegalArgumentException, MismatchedDimensionException, MismatchedReferenceSystemException {
        int necessaryNumber = this.getMinimumPointCount();
        if (points.length < necessaryNumber) {
            throw new IllegalArgumentException(MessageFormat.format("{0} points were specified, while {1} are required.", points.length, necessaryNumber));
        }
        CoordinateReferenceSystem crs = null;
        int dimension = this.getDimension();
        for (int i = 0; i < points.length; ++i) {
            Position point = points[i];
            int pointDim = point.getDimension();
            if (pointDim != dimension) {
                throw new MismatchedDimensionException(MessageFormat.format("Argument \"{0}\" has {1} dimensions, while {2} was expected.", label + "[" + i + "]", pointDim, dimension));
            }
            crs = MathTransformBuilder.getCoordinateReferenceSystem(point, crs);
        }
        if (crs != null) {
            CoordinateSystem cs = crs.getCoordinateSystem();
            if (!this.getCoordinateSystemType().isAssignableFrom(cs.getClass())) {
                ReferenceIdentifier arg0 = cs.getName();
                throw new MismatchedReferenceSystemException(MessageFormat.format("Coordinate system \"{0}\" is unsupported.", arg0));
            }
        }
        return crs;
    }

    private boolean ensureValid(Position[] points, String label, CoordinateReferenceSystem expected) {
        CoordinateReferenceSystem actual = this.ensureValid(points, label);
        return actual == null || actual == expected;
    }

    public Statistics getErrorStatistics() throws FactoryException {
        MathTransform mt = this.getMathTransform();
        Statistics stats = new Statistics();
        GeneralPosition buffer = new GeneralPosition(this.getDimension());
        for (MappedPosition mp : this.getMappedPositions()) {
            double error;
            try {
                error = mp.getError(mt, buffer);
            }
            catch (TransformException e) {
                throw new FactoryException("Can't transform some points that should be valid.", (Throwable)e);
            }
            stats.add(error);
        }
        return stats;
    }

    protected abstract MathTransform computeMathTransform() throws FactoryException;

    public final MathTransform getMathTransform() throws FactoryException {
        if (this.transform == null) {
            this.transform = this.computeMathTransform();
        }
        return this.transform;
    }

    public Transformation getTransformation() throws FactoryException {
        if (this.transformation == null) {
            double error;
            GeographicBoundingBox validArea;
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("name", this.getName());
            CoordinateReferenceSystem sourceCRS = this.getSourceCRS();
            CoordinateReferenceSystem targetCRS = this.getTargetCRS();
            GeographicBoundingBox sourceBox = CRS.getGeographicBoundingBox(sourceCRS);
            GeographicBoundingBox targetBox = CRS.getGeographicBoundingBox(targetCRS);
            if (sourceBox == null) {
                validArea = targetBox;
            } else if (targetBox == null) {
                validArea = sourceBox;
            } else {
                GeneralBounds area = new GeneralBounds(sourceBox);
                area.intersect(new GeneralBounds(sourceBox));
                try {
                    validArea = new GeographicBoundingBoxImpl((Bounds)area);
                }
                catch (TransformException e) {
                    throw new AssertionError((Object)e);
                }
            }
            if (validArea != null) {
                ExtentImpl extent = new ExtentImpl();
                extent.getGeographicElements().add(validArea);
                properties.put("domainOfValidity", (String)extent.unmodifiable());
            }
            if (!Double.isNaN(error = this.getErrorStatistics().rms())) {
                InternationalString description = Vocabulary.formatInternational((int)184);
                QuantitativeResultImpl result = new QuantitativeResultImpl();
                result.setValues(new double[]{error});
                result.setValueUnit(CRSUtilities.getUnit(targetCRS.getCoordinateSystem()));
                result.setErrorStatistic(description);
                PositionalAccuracyImpl accuracy = new PositionalAccuracyImpl((Result)result);
                accuracy.setEvaluationMethodType(EvaluationMethodType.DIRECT_INTERNAL);
                accuracy.setEvaluationMethodDescription(description);
                properties.put("coordinateOperationAccuracy", (String)accuracy.unmodifiable());
            }
            MathTransform transform = this.getMathTransform();
            this.transformation = new DefaultTransformation(properties, sourceCRS, targetCRS, transform, new DefaultOperationMethod(transform));
        }
        return this.transformation;
    }

    public String toString() {
        StringWriter out = new StringWriter();
        try {
            this.printPoints(out, null);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return out.toString();
    }
}

