/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory.epsg;

import java.sql.Connection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.geotools.referencing.factory.epsg.FactoryUsingSQL;
import org.geotools.util.factory.Hints;

public class FactoryUsingAnsiSQL
extends FactoryUsingSQL {
    private static final String[] ANSI = new String[]{"[Alias]", "epsg_alias", "[Area]", "epsg_area", "[Coordinate Axis]", "epsg_coordinateaxis", "[Coordinate Axis Name]", "epsg_coordinateaxisname", "[Coordinate_Operation]", "epsg_coordoperation", "[Coordinate_Operation Method]", "epsg_coordoperationmethod", "[Coordinate_Operation Parameter]", "epsg_coordoperationparam", "[Coordinate_Operation Parameter Usage]", "epsg_coordoperationparamusage", "[Coordinate_Operation Parameter Value]", "epsg_coordoperationparamvalue", "[Coordinate_Operation Path]", "epsg_coordoperationpath", "[Coordinate Reference System]", "epsg_coordinatereferencesystem", "[Coordinate System]", "epsg_coordinatesystem", "[Datum]", "epsg_datum", "[Ellipsoid]", "epsg_ellipsoid", "[Naming System]", "epsg_namingsystem", "[Prime Meridian]", "epsg_primemeridian", "[Supersession]", "epsg_supersession", "[Unit of Measure]", "epsg_unitofmeasure", "[Version History]", "epsg_versionhistory", "[ORDER]", "coord_axis_order"};
    protected final Map<String, String> map = new LinkedHashMap<String, String>();
    private String prefix = "epsg_";

    public FactoryUsingAnsiSQL(Hints userHints, Connection connection) {
        super(userHints, connection);
        for (int i = 0; i < ANSI.length; ++i) {
            this.map.put(ANSI[i], ANSI[++i]);
        }
    }

    public FactoryUsingAnsiSQL(Hints userHints, DataSource dataSource) {
        super(userHints, dataSource);
        for (int i = 0; i < ANSI.length; ++i) {
            this.map.put(ANSI[i], ANSI[++i]);
        }
    }

    public void setSchema(String schema) {
        int length = ((String)(schema = ((String)schema).trim())).length();
        if (length == 0) {
            throw new IllegalArgumentException((String)schema);
        }
        char separator = ((String)schema).charAt(length - 1);
        if (separator != '.' && separator != '_') {
            schema = (String)schema + ".";
        } else if (length == 1) {
            throw new IllegalArgumentException((String)schema);
        }
        for (Map.Entry<String, String> entry : this.map.entrySet()) {
            String tableName = entry.getValue();
            if (!tableName.startsWith(this.prefix)) continue;
            entry.setValue((String)schema + tableName.substring(this.prefix.length()));
        }
        this.prefix = schema;
    }

    @Override
    protected String adaptSQL(String statement) {
        StringBuilder modified = new StringBuilder(statement);
        Iterator<Map.Entry<String, String>> iterator = this.map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> stringStringEntry;
            Map.Entry<String, String> entry = stringStringEntry = iterator.next();
            String oldName = entry.getKey();
            String newName = entry.getValue();
            int start = 0;
            while ((start = modified.indexOf(oldName, start)) >= 0) {
                modified.replace(start, start + oldName.length(), newName);
                start += newName.length();
            }
        }
        return modified.toString();
    }
}

