/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry;

import java.text.MessageFormat;
import org.geotools.api.geometry.MismatchedDimensionException;
import org.geotools.api.geometry.Position;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.util.Classes;
import org.geotools.util.Utilities;

public abstract class AbstractPosition
implements Position {
    protected AbstractPosition() {
    }

    public Position getDirectPosition() {
        return this;
    }

    public void setPosition(Position position) {
        int dimension = this.getDimension();
        if (position != null) {
            AbstractPosition.ensureDimensionMatch("position", position.getDimension(), dimension);
            for (int i = 0; i < dimension; ++i) {
                this.setOrdinate(i, position.getOrdinate(i));
            }
        } else {
            for (int i = 0; i < dimension; ++i) {
                this.setOrdinate(i, Double.NaN);
            }
        }
    }

    public double[] getCoordinate() {
        double[] ordinates = new double[this.getDimension()];
        for (int i = 0; i < ordinates.length; ++i) {
            ordinates[i] = this.getOrdinate(i);
        }
        return ordinates;
    }

    public static void checkCoordinateReferenceSystemDimension(CoordinateReferenceSystem crs, int expected) throws MismatchedDimensionException {
        int dimension;
        if (crs != null && (dimension = crs.getCoordinateSystem().getDimension()) != expected) {
            String arg0 = crs.getName().getCode();
            throw new MismatchedDimensionException(MessageFormat.format("Argument \"{0}\" has {1} dimensions, while {2} was expected.", arg0, dimension, expected));
        }
    }

    static void ensureDimensionMatch(String name, int dimension, int expectedDimension) throws MismatchedDimensionException {
        if (dimension != expectedDimension) {
            throw new MismatchedDimensionException(MessageFormat.format("Argument \"{0}\" has {1} dimensions, while {2} was expected.", name, dimension, expectedDimension));
        }
    }

    public String toString() {
        return AbstractPosition.toString(this);
    }

    static String toString(Position position) {
        StringBuilder buffer = new StringBuilder(Classes.getShortClassName((Object)position)).append('[');
        int dimension = position.getDimension();
        for (int i = 0; i < dimension; ++i) {
            if (i != 0) {
                buffer.append(", ");
            }
            buffer.append(position.getOrdinate(i));
        }
        return buffer.append(']').toString();
    }

    public int hashCode() {
        return AbstractPosition.hashCode(this);
    }

    static int hashCode(Position position) {
        int dimension = position.getDimension();
        int code = 1;
        for (int i = 0; i < dimension; ++i) {
            long bits = Double.doubleToLongBits(position.getOrdinate(i));
            code = 31 * code + ((int)bits ^ (int)(bits >>> 32));
        }
        CoordinateReferenceSystem crs = position.getCoordinateReferenceSystem();
        if (crs != null) {
            code += crs.hashCode();
        }
        return code;
    }

    public boolean equals(Object object) {
        if (object instanceof Position) {
            Position that = (Position)object;
            int dimension = this.getDimension();
            if (dimension == that.getDimension()) {
                for (int i = 0; i < dimension; ++i) {
                    if (Utilities.equals((double)this.getOrdinate(i), (double)that.getOrdinate(i))) continue;
                    return false;
                }
                if (Utilities.equals((Object)this.getCoordinateReferenceSystem(), (Object)that.getCoordinateReferenceSystem())) {
                    assert (this.hashCode() == that.hashCode()) : this;
                    return true;
                }
            }
        }
        return false;
    }
}

