/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine;

import java.util.concurrent.TimeUnit;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.atlas.logging.Log;

public class Timeouts {
    public static Pair<Long, Long> parseTimeoutStr(String str2, TimeUnit unit) {
        try {
            if (str2.contains(",")) {
                String[] a = str2.split(",");
                if (a.length > 2) {
                    return null;
                }
                long x1 = Long.parseLong(a[0]);
                x1 = unit.toMillis(x1);
                long x2 = Long.parseLong(a[1]);
                x2 = unit.toMillis(x2);
                return Pair.create((Object)x1, (Object)x2);
            }
            long x = Long.parseLong(str2);
            x = unit.toMillis(x);
            return Pair.create((Object)-1L, (Object)x);
        }
        catch (Exception ex) {
            Log.warn(Timeouts.class, (String)("Failed to parse timeout string: " + str2 + ": " + ex.getMessage()));
            return null;
        }
    }
}

