/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.harvest.harvester.localfilesystem;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import jeeves.server.context.ServiceContext;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.domain.Metadata;
import org.fao.geonet.domain.MetadataType;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.GeonetworkDataDirectory;
import org.fao.geonet.kernel.HarvestValidationEnum;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.harvest.BaseAligner;
import org.fao.geonet.kernel.harvest.harvester.CategoryMapper;
import org.fao.geonet.kernel.harvest.harvester.GroupMapper;
import org.fao.geonet.kernel.harvest.harvester.HarvestResult;
import org.fao.geonet.kernel.harvest.harvester.csw.Aligner;
import org.fao.geonet.kernel.harvest.harvester.localfilesystem.LocalFileSytemAligner;
import org.fao.geonet.kernel.harvest.harvester.localfilesystem.LocalFilesystemHarvester;
import org.fao.geonet.kernel.harvest.harvester.localfilesystem.LocalFilesystemParams;
import org.fao.geonet.kernel.mef.MEFLib;
import org.fao.geonet.repository.MetadataRepository;
import org.fao.geonet.repository.Updater;
import org.fao.geonet.utils.Xml;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.XML;

class LocalFsHarvesterFileVisitor
extends SimpleFileVisitor<Path> {
    private final LocalFilesystemParams params;
    private final DataManager dataMan;
    private final LocalFilesystemHarvester harvester;
    private final HarvestResult result = new HarvestResult();
    private final IMetadataUtils repo;
    private final ServiceContext context;
    private final AtomicBoolean cancelMonitor;
    private final BaseAligner aligner;
    private final CategoryMapper localCateg;
    private final GroupMapper localGroups;
    private final Set<Integer> listOfRecords = Sets.newHashSet();
    private final Set<Integer> listOfRecordsToIndex = Sets.newHashSet();
    private boolean transformIt = false;
    private Path thisXslt;
    private long startTime;

    public LocalFsHarvesterFileVisitor(AtomicBoolean cancelMonitor, ServiceContext context, LocalFilesystemParams params, LocalFilesystemHarvester harvester) throws Exception {
        this.aligner = new LocalFileSytemAligner(cancelMonitor, params);
        this.cancelMonitor = cancelMonitor;
        this.context = context;
        if (!params.getImportXslt().equals("none")) {
            this.thisXslt = ((GeonetworkDataDirectory)ApplicationContextHolder.get().getBean(GeonetworkDataDirectory.class)).getXsltConversion(params.getImportXslt());
            this.transformIt = true;
        }
        this.localCateg = new CategoryMapper(context);
        this.localGroups = new GroupMapper(context);
        this.params = params;
        this.dataMan = (DataManager)context.getBean(DataManager.class);
        this.harvester = harvester;
        this.repo = (IMetadataUtils)context.getBean(IMetadataUtils.class);
        this.startTime = System.currentTimeMillis();
        harvester.getLogger().debug(String.format("Start visiting files at %s.", this.startTime));
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        if (this.cancelMonitor.get()) {
            return FileVisitResult.TERMINATE;
        }
        if (file == null || file.getFileName() == null) {
            return FileVisitResult.CONTINUE;
        }
        boolean isMef = MEFLib.isValidArchiveExtensionForMEF((String)file.getFileName().toString());
        boolean isXml = file.getFileName().toString().endsWith(".xml");
        boolean isJson = file.getFileName().toString().endsWith(".json");
        if (!(isMef || isXml || isJson)) {
            return FileVisitResult.CONTINUE;
        }
        try {
            ++this.result.totalMetadata;
            if (this.harvester.getLogger().isDebugEnabled() && this.result.totalMetadata % 1000 == 0) {
                long elapsedTime = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - this.startTime);
                this.harvester.getLogger().debug("{} records inserted in {} s ({} records/s).", new Object[]{this.result.totalMetadata, elapsedTime, (long)this.result.totalMetadata / elapsedTime});
            }
            if (isMef) {
                this.processMef(file);
            } else if (isJson) {
                this.processJson(file);
            } else {
                this.processXml(file);
            }
        }
        catch (Exception e) {
            this.harvester.getLogger().error("An error occurred while harvesting file {}. Error is: {}.", new Object[]{file.toAbsolutePath().normalize(), e.getMessage()});
        }
        return FileVisitResult.CONTINUE;
    }

    private void processJson(Path file) throws Exception {
        Element recordAsElement;
        Path filePath = file.toAbsolutePath().normalize();
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            this.harvester.getLogger().debug("reading file: {}", new Object[]{filePath});
            String uuid = com.google.common.io.Files.getNameWithoutExtension((String)file.getFileName().toString());
            String recordAsJson = objectMapper.readTree(filePath.toFile()).toString();
            JSONObject sanitizedJson = LocalFsHarvesterFileVisitor.sanitize(new JSONObject(recordAsJson));
            String recordAsXml = XML.toString((Object)sanitizedJson, (String)"record").replace("<@", "<").replace("</@", "</").replaceAll("(:)(?![^<>]*<)", "_");
            recordAsXml = Xml.stripNonValidXMLCharacters((String)recordAsXml);
            recordAsElement = Xml.loadString((String)recordAsXml, (boolean)false);
            recordAsElement.addContent((Content)new Element("uuid").setText(uuid));
        }
        catch (JsonProcessingException e) {
            this.harvester.getLogger().error("Error processing JSON from file {}, ignoring", new Object[]{filePath});
            this.harvester.getLogger().error("full stack", (Throwable)e);
            ++this.result.badFormat;
            return;
        }
        catch (JDOMException e) {
            this.harvester.getLogger().error("Error transforming JSON into XML from file {}, ignoring", new Object[]{filePath});
            this.harvester.getLogger().error("full stack", (Throwable)e);
            ++this.result.badFormat;
            return;
        }
        catch (Exception e) {
            this.harvester.getLogger().error("Error retrieving JSON from file {}, ignoring", new Object[]{filePath});
            this.harvester.getLogger().error("full stack", (Throwable)e);
            ++this.result.unretrievable;
            return;
        }
        this.processXmlData(file, recordAsElement);
    }

    public static JSONObject sanitize(JSONObject json) throws JSONException {
        JSONArray names = json.names();
        if (names != null) {
            for (int i = 0; i < names.length(); ++i) {
                Object value;
                String key = names.getString(i);
                if (key.contains(" ")) {
                    String oldKey = key;
                    key = key.replace(" ", "_");
                    json.put(key, json.get(oldKey));
                    json.remove(oldKey);
                }
                if ((value = json.opt(key)) instanceof JSONObject) {
                    LocalFsHarvesterFileVisitor.sanitize((JSONObject)value);
                    continue;
                }
                if (!(value instanceof JSONArray)) continue;
                LocalFsHarvesterFileVisitor.sanitize((JSONArray)value);
            }
        }
        return json;
    }

    public static JSONArray sanitize(JSONArray array) throws JSONException {
        for (int i = 0; i < array.length(); ++i) {
            Object value = array.get(i);
            if (value instanceof JSONObject) {
                LocalFsHarvesterFileVisitor.sanitize((JSONObject)value);
                continue;
            }
            if (!(value instanceof JSONArray)) continue;
            LocalFsHarvesterFileVisitor.sanitize((JSONArray)value);
        }
        return array;
    }

    private void processXml(Path file) throws Exception {
        Element xml;
        Path filePath = file.toAbsolutePath().normalize();
        try {
            this.harvester.getLogger().debug(String.format("reading file: %s", filePath));
            xml = Xml.loadFile((Path)file);
        }
        catch (JDOMException e) {
            this.harvester.getLogger().error("Error loading XML from file {}, ignoring", new Object[]{filePath});
            this.harvester.getLogger().error("full stack", (Throwable)e);
            ++this.result.badFormat;
            return;
        }
        catch (Exception e) {
            this.harvester.getLogger().error("Error retrieving XML from file {}, ignoring", new Object[]{filePath});
            this.harvester.getLogger().error("full stack", (Throwable)e);
            ++this.result.unretrievable;
            return;
        }
        this.processXmlData(file, xml);
    }

    private void processXmlData(Path file, Element rawXml) throws Exception {
        Path filePath = file.toAbsolutePath().normalize();
        Element xml = rawXml;
        if (this.transformIt) {
            try {
                xml = Xml.transform((Element)xml, (Path)this.thisXslt);
            }
            catch (Exception e) {
                this.harvester.getLogger().error("Cannot transform XML from file {}, ignoring. Error was: {}", new Object[]{filePath, e.getMessage()});
                ++this.result.badFormat;
                return;
            }
        }
        String schema = null;
        try {
            schema = this.dataMan.autodetectSchema(xml, null);
        }
        catch (Exception e) {
            ++this.result.unknownSchema;
            return;
        }
        try {
            Integer groupIdVal = null;
            if (StringUtils.isNotEmpty((String)this.params.getOwnerIdGroup())) {
                groupIdVal = Integer.parseInt(this.params.getOwnerIdGroup());
            }
            this.params.getValidate().validate(this.dataMan, this.context, xml, groupIdVal);
        }
        catch (Exception e) {
            this.harvester.getLogger().error("Cannot validate XML from file {}, ignoring. Error was: {}", new Object[]{filePath, e.getMessage()});
            ++this.result.doesNotValidate;
            return;
        }
        String uuid = this.getUuidFromFile(xml, filePath, schema);
        if (StringUtils.isEmpty((String)uuid)) {
            ++this.result.badFormat;
            return;
        }
        Aligner.applyBatchEdits(uuid, xml, schema, this.params.getBatchEdits(), this.context, null);
        String id = this.dataMan.getMetadataId(uuid);
        if (id == null) {
            String createDate = this.getCreateDate(file, xml, schema, uuid);
            id = this.addMetadata(xml, schema, uuid, createDate);
        } else {
            AbstractMetadata metadata = this.repo.findOne(id);
            if (!this.params.getUuid().equals(metadata.getHarvestInfo().getUuid())) {
                switch (this.params.getOverrideUuid()) {
                    case OVERRIDE: {
                        this.updateMetadata(file, filePath, xml, schema, id, metadata, true);
                        break;
                    }
                    case RANDOM: {
                        this.harvester.getLogger().debug("Generating random uuid for remote record with uuid " + metadata.getUuid());
                        String createDate = this.getCreateDate(file, xml, schema, uuid);
                        String newUuid = UUID.randomUUID().toString();
                        id = this.addMetadata(xml, schema, newUuid, createDate);
                        break;
                    }
                    case SKIP: {
                        this.harvester.getLogger().debug("Skipping record with uuid " + metadata.getUuid());
                        ++this.result.uuidSkipped;
                        ++this.result.unchangedMetadata;
                        break;
                    }
                }
            } else {
                this.updateMetadata(file, filePath, xml, schema, id, metadata, false);
            }
        }
        this.listOfRecords.add(Integer.valueOf(id));
    }

    private String getCreateDate(Path file, Element xml, String schema, String uuid) throws IOException {
        String createDate;
        if (this.params.checkFileLastModifiedForUpdate) {
            createDate = new ISODate(Files.getLastModifiedTime(file, new LinkOption[0]).toMillis(), false).getDateAndTime();
        } else {
            try {
                createDate = this.dataMan.extractDateModified(schema, xml);
            }
            catch (Exception ex) {
                this.harvester.getLogger().error("LocalFilesystemHarvester - addMetadata - can't get metadata modified date for metadata uuid= {} using current date for modified date", new Object[]{uuid});
                createDate = new ISODate().toString();
            }
        }
        return createDate;
    }

    private void updateMetadata(Path file, Path filePath, Element xml, String schema, String id, AbstractMetadata metadata, boolean force) throws Exception {
        if (this.params.checkFileLastModifiedForUpdate) {
            Date fileDate = new Date(Files.getLastModifiedTime(file, new LinkOption[0]).toMillis());
            ISODate modified = new ISODate();
            if (metadata.getDataInfo() != null) {
                modified = metadata.getDataInfo().getChangeDate();
            }
            Date recordDate = modified.toDate();
            String changeDate = new ISODate(fileDate.getTime(), false).getDateAndTime();
            this.harvester.getLogger().debug(" File date is: {} / record date is: {}", new Object[]{filePath, modified});
            if (DateUtils.truncate((Date)recordDate, (int)13).before(DateUtils.truncate((Date)fileDate, (int)13))) {
                this.harvester.getLogger().debug(String.format("  Db record is older than file. Updating record with id: %s", id));
                this.updateMedata(xml, id, changeDate, force);
            } else {
                this.harvester.getLogger().debug("  Db record is not older than last modified date of file. No need for update.");
                ++this.result.unchangedMetadata;
            }
        } else {
            String changeDate;
            this.harvester.getLogger().debug("  updating existing metadata, id is: " + id);
            try {
                changeDate = this.dataMan.extractDateModified(schema, xml);
            }
            catch (Exception ex) {
                this.harvester.getLogger().error("LocalFilesystemHarvester - updateMetadata - can't get metadata modified date for metadata id= {}, using current date for modified date", new Object[]{id});
                changeDate = new ISODate().toString();
            }
            this.updateMedata(xml, id, changeDate, force);
        }
    }

    private void processMef(Path file) {
        Path filePath = file.toAbsolutePath().normalize();
        this.harvester.getLogger().debug(String.format("reading file: %s", filePath));
        try {
            MEFLib.UuidAction uuidAction;
            String xsl = this.params.getImportXslt();
            MEFLib.Version version = MEFLib.getMEFVersion((Path)file);
            String fileType = version == MEFLib.Version.V1 ? "mef" : "mef2";
            String style = xsl == null || xsl.equals("none") ? "_none_" : xsl;
            MetadataType isTemplate = MetadataType.lookup((String)this.params.recordType);
            switch (this.params.getOverrideUuid()) {
                case SKIP: {
                    uuidAction = MEFLib.UuidAction.NOTHING;
                    break;
                }
                case RANDOM: {
                    uuidAction = MEFLib.UuidAction.GENERATEUUID;
                    break;
                }
                default: {
                    uuidAction = MEFLib.UuidAction.OVERWRITE;
                }
            }
            List ids = MEFLib.doImport((String)fileType, (MEFLib.UuidAction)uuidAction, (String)style, (String)this.params.getUuid(), (MetadataType)isTemplate, (String[])((String[])Iterables.toArray(this.params.getCategories(), String.class)), (String)this.params.getOwnerIdGroup(), (this.params.getValidate() != HarvestValidationEnum.NOVALIDATION ? 1 : 0) != 0, (boolean)false, (ServiceContext)this.context, (Path)file);
            for (String id : ids) {
                this.harvester.getLogger().debug(String.format("Metadata imported from MEF: %s", id));
                ((MetadataRepository)this.context.getBean(MetadataRepository.class)).update((Serializable)Integer.valueOf(id), (Updater)new Updater<Metadata>(){

                    public void apply(@Nonnull Metadata metadata) {
                        metadata.getHarvestInfo().setHarvested(true);
                        metadata.getHarvestInfo().setUuid(LocalFsHarvesterFileVisitor.this.params.getUuid());
                        metadata.getSourceInfo().setOwner(Integer.valueOf(LocalFsHarvesterFileVisitor.this.aligner.getOwner()));
                    }
                });
                this.aligner.addPrivileges(id, this.params.getPrivileges(), this.localGroups, this.context);
                this.listOfRecordsToIndex.add(Integer.valueOf(id));
                this.listOfRecords.add(Integer.valueOf(id));
                ++this.result.addedMetadata;
            }
        }
        catch (Exception e) {
            this.harvester.getLogger().error("Error retrieving MEF from file {}, ignoring", new Object[]{filePath});
            this.harvester.getLogger().error("Error: ", (Throwable)e);
            ++this.result.unretrievable;
        }
    }

    private String getUuidFromFile(Element xml, Path filePath, String schema) {
        String uuid = null;
        try {
            uuid = this.dataMan.extractUUID(schema, xml);
        }
        catch (Exception e) {
            this.harvester.getLogger().debug("Failed to extract metadata UUID for file {} using XSL extract-uuid. The record is probably a subtemplate. Will check uuid attribute on root element.", new Object[]{filePath});
            String uuidAttribute = xml.getAttributeValue("uuid");
            if (uuidAttribute != null) {
                this.harvester.getLogger().debug("Found uuid attribute {} for file {}.", new Object[]{uuidAttribute, filePath});
                uuid = uuidAttribute;
            }
            uuid = UUID.randomUUID().toString();
            this.harvester.getLogger().debug("No UUID found, the record will be assigned a random uuid {} for file {}.", new Object[]{uuid, filePath});
        }
        return uuid;
    }

    private String addMetadata(Element xml, String schema, String uuid, String createDate) throws Exception {
        this.harvester.getLogger().debug("adding new metadata");
        String id = this.harvester.addMetadata(xml, uuid, schema, this.localGroups, this.localCateg, createDate, this.aligner, false);
        this.listOfRecordsToIndex.add(Integer.valueOf(id));
        ++this.result.addedMetadata;
        return id;
    }

    private void updateMedata(Element xml, String id, String changeDate, boolean force) throws Exception {
        this.harvester.updateMetadata(xml, id, this.localGroups, this.localCateg, changeDate, this.aligner, force);
        this.listOfRecordsToIndex.add(Integer.valueOf(id));
        ++this.result.updatedMetadata;
    }

    public HarvestResult getResult() {
        return this.result;
    }

    public Set<Integer> getListOfRecords() {
        return this.listOfRecords;
    }

    public Set<Integer> getListOfRecordsToIndex() {
        return this.listOfRecordsToIndex;
    }
}

