/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.harvest.harvester;

import java.io.File;
import java.io.IOException;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import javax.persistence.metamodel.SingularAttribute;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.Logger;
import org.fao.geonet.csw.common.exceptions.InvalidParameterValueEx;
import org.fao.geonet.domain.Group;
import org.fao.geonet.domain.HarvestHistory;
import org.fao.geonet.domain.HarvestHistory_;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.domain.Source;
import org.fao.geonet.domain.SourceType;
import org.fao.geonet.domain.User;
import org.fao.geonet.exceptions.BadInputEx;
import org.fao.geonet.exceptions.BadParameterEx;
import org.fao.geonet.exceptions.JeevesException;
import org.fao.geonet.exceptions.OperationAbortedEx;
import org.fao.geonet.exceptions.UnknownHostEx;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.MetadataIndexerProcessor;
import org.fao.geonet.kernel.datamanager.IMetadataIndexer;
import org.fao.geonet.kernel.datamanager.IMetadataManager;
import org.fao.geonet.kernel.datamanager.IMetadataSchemaUtils;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.harvest.Common;
import org.fao.geonet.kernel.harvest.harvester.AbstractParams;
import org.fao.geonet.kernel.harvest.harvester.HarvestError;
import org.fao.geonet.kernel.harvest.harvester.HarvestResult;
import org.fao.geonet.kernel.harvest.harvester.Privileges;
import org.fao.geonet.kernel.security.SecurityProviderConfiguration;
import org.fao.geonet.kernel.security.SecurityProviderUtil;
import org.fao.geonet.kernel.setting.HarvesterSettingsManager;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.repository.GroupRepository;
import org.fao.geonet.repository.HarvestHistoryRepository;
import org.fao.geonet.repository.SortUtils;
import org.fao.geonet.repository.SourceRepository;
import org.fao.geonet.repository.UserRepository;
import org.fao.geonet.repository.specification.HarvestHistorySpecs;
import org.fao.geonet.repository.specification.MetadataSpecs;
import org.fao.geonet.resources.Resources;
import org.fao.geonet.services.harvesting.notifier.SendNotification;
import org.fao.geonet.util.LogUtil;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.QuartzSchedulerUtils;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;

public abstract class AbstractHarvester<T extends HarvestResult, P extends AbstractParams> {
    public static final String HARVESTER_GROUP_NAME = "HARVESTER_GROUP_NAME";
    private static final String SCHEDULER_ID = "abstractHarvester";
    private static final Integer SHORT_WAIT = 2;
    private static final Integer LONG_WAIT = 30;
    private final ReentrantLock lock = new ReentrantLock(false);
    protected final AtomicBoolean cancelMonitor = new AtomicBoolean(false);
    protected final List<HarvestError> errors = Collections.synchronizedList(new LinkedList());
    protected ServiceContext context;
    protected HarvesterSettingsManager harvesterSettingsManager;
    protected SettingManager settingManager;
    protected DataManager dataMan;
    protected IMetadataManager metadataManager;
    protected IMetadataUtils metadataUtils;
    protected IMetadataSchemaUtils metadataSchemaUtils;
    protected IMetadataIndexer metadataIndexer;
    protected P params;
    protected T result;
    protected Logger log = Log.createLogger((String)"geonetwork.harvester");
    private Element loadedInfo;
    private String id;
    private volatile Common.Status status;
    private Throwable error;
    private volatile boolean running = false;

    public Logger getLogger() {
        return this.log;
    }

    public static AbstractHarvester<?, ?> create(String type, ServiceContext context) throws BadParameterEx, OperationAbortedEx {
        if (type == null) {
            throw new BadParameterEx("type", null);
        }
        try {
            AbstractHarvester ah = (AbstractHarvester)context.getBean(type, AbstractHarvester.class);
            ah.setContext(context);
            return ah;
        }
        catch (Exception e) {
            throw new OperationAbortedEx("Cannot instantiate harvester of type " + type, (Object)e);
        }
    }

    protected void setContext(ServiceContext context) {
        this.context = context;
        this.dataMan = (DataManager)context.getBean(DataManager.class);
        this.metadataUtils = (IMetadataUtils)context.getBean(IMetadataUtils.class);
        this.harvesterSettingsManager = (HarvesterSettingsManager)context.getBean(HarvesterSettingsManager.class);
        this.settingManager = (SettingManager)context.getBean(SettingManager.class);
        this.metadataManager = (IMetadataManager)context.getBean(IMetadataManager.class);
        this.metadataSchemaUtils = (IMetadataSchemaUtils)context.getBean(IMetadataSchemaUtils.class);
        this.metadataIndexer = (IMetadataIndexer)context.getBean(IMetadataIndexer.class);
    }

    public void add(Element node) throws BadInputEx, SQLException {
        this.status = Common.Status.INACTIVE;
        this.error = null;
        this.id = this.doAdd(node);
    }

    public void init(Element node, ServiceContext context) throws BadInputEx, SchedulerException {
        this.id = node.getAttributeValue("id");
        this.status = Common.Status.parse(node.getChild("options").getChildText("status"));
        this.error = null;
        this.context = context;
        this.doInit(node);
        this.initInfo(context);
        if (this.status == Common.Status.ACTIVE) {
            this.doSchedule();
        }
    }

    private void initInfo(ServiceContext context) {
        HarvestHistoryRepository historyRepository = (HarvestHistoryRepository)context.getBean(HarvestHistoryRepository.class);
        Specification spec = HarvestHistorySpecs.hasHarvesterUuid((String)((AbstractParams)this.getParams()).getUuid());
        PageRequest pageRequest = PageRequest.of((int)0, (int)1, (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{SortUtils.createPath((SingularAttribute[])new SingularAttribute[]{HarvestHistory_.harvestDate})}));
        Page page = historyRepository.findAll(spec, (Pageable)pageRequest);
        if (page.hasContent()) {
            HarvestHistory history = (HarvestHistory)page.getContent().get(0);
            try {
                this.loadedInfo = history.getInfoAsXml();
            }
            catch (IOException | JDOMException throwable) {
                // empty catch block
            }
        }
    }

    private void doSchedule() throws SchedulerException {
        Scheduler scheduler = AbstractHarvester.getScheduler();
        JobDetail jobDetail = ((AbstractParams)this.getParams()).getJob();
        Trigger trigger = ((AbstractParams)this.getParams()).getTrigger();
        scheduler.scheduleJob(jobDetail, trigger);
    }

    private void doUnschedule() throws SchedulerException {
        AbstractHarvester.getScheduler().deleteJob(JobKey.jobKey((String)((AbstractParams)this.getParams()).getUuid(), (String)HARVESTER_GROUP_NAME));
    }

    public void doReschedule() throws SchedulerException {
        this.doUnschedule();
        this.doSchedule();
    }

    public TimeZone getTriggerTimezone() throws SchedulerException {
        Scheduler scheduler = AbstractHarvester.getScheduler();
        List jobTriggers = scheduler.getTriggersOfJob(JobKey.jobKey((String)((AbstractParams)this.getParams()).getUuid(), (String)HARVESTER_GROUP_NAME));
        for (Trigger t : jobTriggers) {
            if (!(t instanceof CronTrigger)) continue;
            CronTrigger ct = (CronTrigger)t;
            return ct.getTimeZone();
        }
        return null;
    }

    public static Scheduler getScheduler() throws SchedulerException {
        return QuartzSchedulerUtils.getScheduler((String)SCHEDULER_ID, (boolean)true);
    }

    public void shutdown() throws SchedulerException {
        AbstractHarvester.getScheduler().deleteJob(JobKey.jobKey((String)((AbstractParams)this.getParams()).getUuid(), (String)HARVESTER_GROUP_NAME));
    }

    public static void shutdownScheduler() throws SchedulerException {
        AbstractHarvester.getScheduler().shutdown(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws Exception {
        try {
            if (this.lock.tryLock(10L, TimeUnit.SECONDS)) {
                this.doUnschedule();
                IMetadataUtils metadataRepository = (IMetadataUtils)this.context.getBean(IMetadataUtils.class);
                SourceRepository sourceRepository = (SourceRepository)this.context.getBean(SourceRepository.class);
                Resources resources = (Resources)this.context.getBean(Resources.class);
                Specification ownedByHarvester = Specification.where((Specification)MetadataSpecs.hasHarvesterUuid((String)((AbstractParams)this.getParams()).getUuid()));
                HashSet<String> sources = new HashSet<String>();
                for (Integer metadataId : metadataRepository.findAllIdsBy(ownedByHarvester)) {
                    sources.add(this.metadataUtils.findOne(metadataId.intValue()).getSourceInfo().getSourceId());
                    this.metadataManager.deleteMetadata(this.context, "" + metadataId);
                }
                for (String sourceUuid : sources) {
                    Long ownedBySource = metadataRepository.count(Specification.where((Specification)MetadataSpecs.hasSource((String)sourceUuid)));
                    if (ownedBySource != 0L || sourceUuid.equals(((AbstractParams)this.params).getUuid()) || !sourceRepository.existsById((Object)sourceUuid)) continue;
                    this.removeIcon(resources, sourceUuid);
                    sourceRepository.deleteById((Object)sourceUuid);
                }
                this.doDestroy(resources);
            } else {
                this.log.error("Harvester '" + this.getID() + "' looks deadlocked.");
            }
        }
        catch (InterruptedException e) {
            this.log.error((Throwable)e);
        }
        finally {
            if (this.lock.isHeldByCurrentThread()) {
                this.lock.unlock();
            }
        }
    }

    public Common.OperResult start() throws SchedulerException {
        try {
            if (this.lock.tryLock(SHORT_WAIT.intValue(), TimeUnit.SECONDS)) {
                if (this.status != Common.Status.INACTIVE) {
                    Common.OperResult operResult = Common.OperResult.ALREADY_ACTIVE;
                    return operResult;
                }
                this.harvesterSettingsManager.setValue("harvesting/id:" + this.id + "/options/status", (Object)Common.Status.ACTIVE);
                this.status = Common.Status.ACTIVE;
                this.error = null;
                this.doSchedule();
                Common.OperResult operResult = Common.OperResult.OK;
                return operResult;
            }
            this.log.error("Harvester '" + this.getID() + "' looks deadlocked.");
        }
        catch (InterruptedException e) {
            this.log.error((Throwable)e);
        }
        finally {
            if (this.lock.isHeldByCurrentThread()) {
                this.lock.unlock();
            }
        }
        return Common.OperResult.ERROR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Common.OperResult stop(final Common.Status newStatus) throws SchedulerException {
        this.cancelMonitor.set(true);
        JobKey jobKey = JobKey.jobKey((String)((AbstractParams)this.getParams()).getUuid(), (String)HARVESTER_GROUP_NAME);
        if (AbstractHarvester.getScheduler().checkExists(jobKey)) {
            AbstractHarvester.getScheduler().interrupt(jobKey);
        }
        try {
            if (this.lock.tryLock(LONG_WAIT.intValue(), TimeUnit.SECONDS)) {
                this.running = false;
                this.harvesterSettingsManager.setValue("harvesting/id:" + this.id + "/options/status", (Object)newStatus);
                if (newStatus == Common.Status.INACTIVE) {
                    if (this.status != Common.Status.ACTIVE) {
                        Common.OperResult operResult = Common.OperResult.ALREADY_INACTIVE;
                        return operResult;
                    }
                    this.doUnschedule();
                }
                this.status = newStatus;
                Common.OperResult operResult = Common.OperResult.OK;
                return operResult;
            }
            this.log.error("Harvester '" + this.getID() + "' looks deadlocked.");
            new Thread(){

                @Override
                public void run() {
                    super.run();
                    try {
                        Thread.sleep(LONG_WAIT * 1000);
                    }
                    catch (InterruptedException e) {
                        AbstractHarvester.this.log.error((Throwable)e);
                    }
                    if (AbstractHarvester.this.running) {
                        AbstractHarvester.this.log.error("Forcefully stopping harvester '" + AbstractHarvester.this.getID() + "'.");
                        try {
                            AbstractHarvester.this.running = false;
                            AbstractHarvester.this.harvesterSettingsManager.setValue("harvesting/id:" + AbstractHarvester.this.id + "/options/status", (Object)newStatus);
                            AbstractHarvester.this.status = newStatus;
                            AbstractHarvester.this.doUnschedule();
                            AbstractHarvester.this.doSchedule();
                        }
                        catch (SchedulerException e) {
                            AbstractHarvester.this.log.error((Throwable)e);
                        }
                    }
                }
            }.start();
        }
        catch (InterruptedException e) {
            this.log.error((Throwable)e);
        }
        finally {
            if (this.lock.isHeldByCurrentThread()) {
                this.lock.unlock();
            }
        }
        return Common.OperResult.ERROR;
    }

    public Common.OperResult run() throws SchedulerException {
        try {
            if (this.lock.tryLock(SHORT_WAIT.intValue(), TimeUnit.SECONDS)) {
                if (this.status == Common.Status.INACTIVE) {
                    this.start();
                }
                if (this.running) {
                    Common.OperResult operResult = Common.OperResult.ALREADY_RUNNING;
                    return operResult;
                }
                AbstractHarvester.getScheduler().triggerJob(JobKey.jobKey((String)((AbstractParams)this.getParams()).getUuid(), (String)HARVESTER_GROUP_NAME));
                Common.OperResult operResult = Common.OperResult.OK;
                return operResult;
            }
            this.log.error("Harvester '" + this.getID() + "' looks deadlocked.");
        }
        catch (InterruptedException e) {
            this.log.error((Throwable)e);
        }
        finally {
            if (this.lock.isHeldByCurrentThread()) {
                this.lock.unlock();
            }
        }
        return Common.OperResult.ERROR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Common.OperResult invoke() {
        try {
            if (this.lock.tryLock(SHORT_WAIT.intValue(), TimeUnit.SECONDS)) {
                Common.Status oldStatus = this.status;
                try {
                    this.status = Common.Status.ACTIVE;
                    Common.OperResult operResult = this.harvest();
                    return operResult;
                }
                finally {
                    this.status = oldStatus;
                }
            }
            this.log.error("Harvester '" + this.getID() + "' looks deadlocked.");
        }
        catch (InterruptedException e) {
            this.log.error((Throwable)e);
        }
        finally {
            if (this.lock.isHeldByCurrentThread()) {
                this.lock.unlock();
            }
        }
        return Common.OperResult.ERROR;
    }

    public void update(Element node) throws BadInputEx, SQLException, SchedulerException {
        try {
            if (this.lock.tryLock(SHORT_WAIT.intValue(), TimeUnit.SECONDS)) {
                this.doUpdate(this.id, node);
                if (this.status == Common.Status.ACTIVE) {
                    this.doUnschedule();
                    this.error = null;
                    this.doSchedule();
                }
            } else {
                this.log.error("Harvester '" + this.getID() + "' looks deadlocked.");
            }
        }
        catch (InterruptedException e) {
            this.log.error((Throwable)e);
        }
        finally {
            if (this.lock.isHeldByCurrentThread()) {
                this.lock.unlock();
            }
        }
    }

    public String getID() {
        return this.id;
    }

    public void addInfo(Element node) {
        Element info = node.getChild("info");
        info.addContent((Content)new Element("running").setText("" + this.running));
        this.doAddInfo(node);
        if (this.error != null) {
            node.addContent((Content)JeevesException.toElement((Throwable)this.error));
        }
    }

    public void addHarvestInfo(Element info, String id, String uuid) {
        info.addContent((Content)new Element("type").setText(this.getType()));
    }

    public ServiceContext getServiceContext() {
        return this.context;
    }

    public Common.Status getStatus() {
        return this.status;
    }

    private void login() throws Exception {
        Optional userOptional;
        UserSession userSession;
        this.context.setIpAddress(null);
        SecurityProviderUtil securityProviderUtil = SecurityProviderConfiguration.getSecurityProviderUtil();
        if (securityProviderUtil != null && securityProviderUtil.loginServiceAccount() && (userSession = this.context.getUserSession()) != null && userSession.isAuthenticated()) {
            return;
        }
        String ownerId = ((AbstractParams)this.getParams()).getOwnerId();
        if (this.log.isDebugEnabled()) {
            this.log.debug("AbstractHarvester login: ownerId = " + ownerId);
        }
        UserRepository repository = (UserRepository)this.context.getBean(UserRepository.class);
        User user = null;
        if (StringUtils.isNotEmpty((String)ownerId) && (userOptional = repository.findById((Object)Integer.parseInt(ownerId))).isPresent()) {
            user = (User)userOptional.get();
        }
        if (user == null || StringUtils.isEmpty((String)ownerId) || !this.dataMan.existsUser(this.context, Integer.parseInt(ownerId))) {
            user = (User)repository.findAllByProfile(Profile.Administrator).get(0);
            ((AbstractParams)this.getParams()).setOwnerId(String.valueOf(user.getId()));
            if (this.log.isDebugEnabled()) {
                this.log.debug("AbstractHarvester login: picked Administrator  " + ownerId + " to run this job");
            }
        }
        UserSession session = new UserSession();
        session.loginAs(user);
        this.context.setUserSession(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Common.OperResult harvest() {
        Common.OperResult operResult;
        block15: {
            operResult = Common.OperResult.OK;
            Boolean releaseLock = false;
            try {
                if (this.lock.isHeldByCurrentThread() || (releaseLock = Boolean.valueOf(this.lock.tryLock(LONG_WAIT.intValue(), TimeUnit.SECONDS))).booleanValue()) {
                    long startTime = System.currentTimeMillis();
                    this.running = true;
                    this.cancelMonitor.set(false);
                    try {
                        String logfile = LogUtil.initializeHarvesterLog((String)this.getType(), (String)((AbstractParams)this.getParams()).getName());
                        this.log.info("Starting harvesting of " + ((AbstractParams)this.getParams()).getName());
                        this.error = null;
                        this.errors.clear();
                        Logger logger = this.log;
                        String nodeName = ((AbstractParams)this.getParams()).getName() + " (" + this.getClass().getSimpleName() + ")";
                        String lastRun = OffsetDateTime.now(ZoneOffset.UTC).format(DateTimeFormatter.ISO_DATE_TIME);
                        try {
                            this.login();
                            this.harvesterSettingsManager.setValue("harvesting/id:" + this.id + "/info/lastRun", (Object)lastRun);
                            logger.info("Started harvesting from node : " + nodeName);
                            HarvestWithIndexProcessor h = new HarvestWithIndexProcessor(this.dataMan, logger);
                            h.process(this.settingManager.getSiteId());
                            logger.info("Ended harvesting from node : " + nodeName);
                            if (((AbstractParams)this.getParams()).isOneRunOnly()) {
                                this.stop(Common.Status.INACTIVE);
                            }
                        }
                        catch (InvalidParameterValueEx e) {
                            logger.error("The harvester " + ((AbstractParams)this.getParams()).getName() + "[" + this.getType() + "] didn't accept some of the parameters sent.");
                            this.errors.add(new HarvestError(this.context, e));
                            this.error = e;
                            operResult = Common.OperResult.ERROR;
                        }
                        catch (UnknownHostException e) {
                            logger.error("The harvester " + ((AbstractParams)this.getParams()).getName() + "[" + this.getType() + "] host is unknown.");
                            this.error = new UnknownHostEx(e.getMessage());
                            this.errors.add(new HarvestError(this.context, this.error));
                            operResult = Common.OperResult.ERROR;
                        }
                        catch (Throwable t) {
                            operResult = Common.OperResult.ERROR;
                            logger.warning("Raised exception while harvesting from : " + nodeName);
                            logger.warning(" (C) Class   : " + t.getClass().getSimpleName());
                            logger.warning(" (C) Message : " + t.getMessage());
                            logger.error(t);
                            this.error = t;
                            this.errors.add(new HarvestError(this.context, t));
                        }
                        long elapsedTime = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - startTime);
                        this.logHarvest(logfile, logger, nodeName, lastRun, elapsedTime);
                        break block15;
                    }
                    finally {
                        this.cancelMonitor.set(false);
                        this.running = false;
                    }
                }
                this.log.error("Harvester '" + this.getID() + "' looks deadlocked.");
                this.log.error("Harvester '" + this.getID() + "' hasn't initiated.");
                operResult = Common.OperResult.ERROR;
            }
            catch (InterruptedException e) {
                this.log.error((Throwable)e);
            }
            finally {
                if (this.lock.isHeldByCurrentThread() && releaseLock.booleanValue()) {
                    this.lock.unlock();
                }
            }
        }
        return operResult;
    }

    private void logHarvest(String logfile, Logger logger, String nodeName, String lastRun, long elapsedTime) {
        try {
            Element priorLogfileEl;
            Element resultEl = this.getResult();
            if (this.error != null) {
                resultEl = JeevesException.toElement((Throwable)this.error);
            }
            if ((priorLogfileEl = resultEl.getChild("logfile")) != null) {
                logger.warning("Detected duplicate logfile: " + priorLogfileEl.getText());
                resultEl.getChildren().remove(priorLogfileEl);
            }
            Element logfileEl = new Element("logfile");
            logfileEl.setText(logfile);
            resultEl.addContent((Content)logfileEl);
            resultEl.addContent((Content)this.toElement(this.errors));
            HarvestHistoryRepository historyRepository = (HarvestHistoryRepository)this.context.getBean(HarvestHistoryRepository.class);
            HarvestHistory history = new HarvestHistory().setHarvesterType(this.getType()).setHarvesterName(((AbstractParams)this.getParams()).getName()).setHarvesterUuid(((AbstractParams)this.getParams()).getUuid()).setElapsedTime((int)elapsedTime).setHarvestDate(new ISODate(lastRun)).setParams(((AbstractParams)this.getParams()).getNodeElement()).setInfo(resultEl);
            historyRepository.save((Object)history);
            try {
                SendNotification.process(this.context, history.asXml(), this);
            }
            catch (Exception e2) {
                logger.error("Raised exception while attempting to send email");
                logger.error(" (C) Exc   : " + e2);
                logger.error((Throwable)e2);
            }
        }
        catch (Exception e) {
            logger.warning("Raised exception while attempting to store harvest history from : " + nodeName);
            logger.warning(" (C) Exc   : " + e.getMessage());
            logger.error((Throwable)e);
        }
    }

    private Element toElement(List<HarvestError> errors) {
        Element res = new Element("errors");
        for (HarvestError harvestError : errors) {
            Element herror = new Element("error");
            Element desc = new Element("description");
            desc.setText(harvestError.getDescription());
            herror.addContent((Content)desc);
            Element hint = new Element("hint");
            hint.setText(harvestError.getHint());
            herror.addContent((Content)hint);
            herror.addContent((Content)JeevesException.toElement((Throwable)harvestError.getOrigin()));
            res.addContent((Content)herror);
        }
        return res;
    }

    public List<HarvestError> getErrors() {
        return Collections.unmodifiableList(this.errors);
    }

    public final String getType() {
        String[] types = this.context.getApplicationContext().getBeanNamesForType(this.getClass());
        return types[0];
    }

    public P getParams() {
        return this.params;
    }

    private void doInit(Element node) throws BadInputEx {
        this.setParams(this.createParams());
        ((AbstractParams)this.params).create(node);
    }

    protected void doDestroy(Resources resources) {
        this.removeIcon(resources, ((AbstractParams)this.getParams()).getUuid());
        ((SourceRepository)this.context.getBean(SourceRepository.class)).deleteById((Object)((AbstractParams)this.getParams()).getUuid());
    }

    private void removeIcon(Resources resources, String uuid) {
        try {
            resources.deleteImageIfExists(uuid + ".gif", resources.locateLogosDir(this.context));
        }
        catch (IOException e) {
            Log.warning((String)("geonetwork.harvester." + this.getType()), (Object)("Unable to delete icon: " + uuid), (Throwable)e);
        }
    }

    private final String doAdd(Element node) throws BadInputEx, SQLException {
        this.params = this.createParams();
        ((AbstractParams)this.params).create(node);
        ((AbstractParams)this.params).setUuid(UUID.randomUUID().toString());
        String nodeId = this.harvesterSettingsManager.add("harvesting", (Object)"node", (Object)this.getType());
        this.storeNode(this.params, "id:" + nodeId);
        Source source = new Source(((AbstractParams)this.params).getUuid(), ((AbstractParams)this.params).getName(), ((AbstractParams)this.params).getTranslations(), SourceType.harvester);
        String icon = ((AbstractParams)this.params).getIcon();
        if (icon != null) {
            String filename = ((Resources)this.context.getBean(Resources.class)).copyLogo(this.context, "images" + File.separator + "harvesting" + File.separator + icon, ((AbstractParams)this.params).getUuid());
            source.setLogo(filename);
        }
        ((SourceRepository)this.context.getBean(SourceRepository.class)).save((Object)source);
        return nodeId;
    }

    private void doUpdate(String id, Element node) throws BadInputEx, SQLException {
        AbstractParams copy = ((AbstractParams)this.params).copy();
        copy.update(node);
        String lastRun = this.harvesterSettingsManager.getValue("harvesting/id:" + id + "/info/lastRun");
        String path = "harvesting/id:" + id;
        this.harvesterSettingsManager.removeChildren(path);
        this.storeNode(copy, path);
        this.harvesterSettingsManager.setValue("harvesting/id:" + id + "/info/lastRun", (Object)lastRun);
        Source source = new Source(copy.getUuid(), copy.getName(), copy.getTranslations(), SourceType.harvester);
        ((SourceRepository)this.context.getBean(SourceRepository.class)).save((Object)source);
        String icon = copy.getIcon();
        if (icon != null) {
            String filename = ((Resources)this.context.getBean(Resources.class)).copyLogo(this.context, "images" + File.separator + "harvesting" + File.separator + icon, copy.getUuid());
            source.setLogo(filename);
        }
        ((SourceRepository)this.context.getBean(SourceRepository.class)).save((Object)source);
        this.setParams(copy);
    }

    protected void doAddInfo(Element node) {
        if (this.result == null && this.loadedInfo == null) {
            return;
        }
        Element info = node.getChild("info");
        Element res = this.getResult();
        info.addContent((Content)res);
    }

    protected abstract void doHarvest(Logger var1) throws Exception;

    private void storeNode(P params, String path) throws SQLException {
        String siteId = this.harvesterSettingsManager.add(path, (Object)"site", (Object)"");
        String translations = this.harvesterSettingsManager.add("id:" + siteId, (Object)"translations", (Object)"");
        String optionsId = this.harvesterSettingsManager.add(path, (Object)"options", (Object)"");
        String infoId = this.harvesterSettingsManager.add(path, (Object)"info", (Object)"");
        String contentId = this.harvesterSettingsManager.add(path, (Object)"content", (Object)"");
        this.harvesterSettingsManager.add("id:" + siteId, (Object)"name", (Object)((AbstractParams)params).getName());
        for (Map.Entry<String, String> entry : ((AbstractParams)params).getTranslations().entrySet()) {
            this.harvesterSettingsManager.add("id:" + translations, (Object)entry.getKey(), (Object)entry.getValue());
        }
        this.harvesterSettingsManager.add("id:" + siteId, (Object)"uuid", (Object)((AbstractParams)params).getUuid());
        this.harvesterSettingsManager.add("id:" + siteId, (Object)"ownerId", (Object)((AbstractParams)params).getOwnerId());
        this.harvesterSettingsManager.add("id:" + siteId, (Object)"ownerUser", (Object)((AbstractParams)params).getOwnerIdUser());
        this.harvesterSettingsManager.add("id:" + siteId, (Object)"ownerGroup", (Object)((AbstractParams)params).getOwnerIdGroup());
        String useAccId = this.harvesterSettingsManager.add("id:" + siteId, (Object)"useAccount", (Object)((AbstractParams)params).isUseAccount());
        this.harvesterSettingsManager.add("id:" + useAccId, (Object)"username", (Object)((AbstractParams)params).getUsername());
        this.harvesterSettingsManager.add("id:" + useAccId, (Object)"password", (Object)((AbstractParams)params).getPassword(), true);
        this.harvesterSettingsManager.add("id:" + optionsId, (Object)"every", (Object)((AbstractParams)params).getEvery());
        this.harvesterSettingsManager.add("id:" + optionsId, (Object)"oneRunOnly", (Object)((AbstractParams)params).isOneRunOnly());
        this.harvesterSettingsManager.add("id:" + optionsId, (Object)"overrideUUID", (Object)((AbstractParams)params).getOverrideUuid());
        this.harvesterSettingsManager.add("id:" + optionsId, (Object)"ifRecordExistAppendPrivileges", (Object)((AbstractParams)params).isIfRecordExistAppendPrivileges());
        this.harvesterSettingsManager.add("id:" + optionsId, (Object)"status", (Object)this.status);
        this.harvesterSettingsManager.add("id:" + contentId, (Object)"importxslt", (Object)((AbstractParams)params).getImportXslt());
        this.harvesterSettingsManager.add("id:" + contentId, (Object)"batchEdits", (Object)((AbstractParams)params).getBatchEdits());
        this.harvesterSettingsManager.add("id:" + contentId, (Object)"validate", (Object)((AbstractParams)params).getValidate());
        this.harvesterSettingsManager.add("id:" + contentId, (Object)"translateContent", (Object)((AbstractParams)params).isTranslateContent());
        this.harvesterSettingsManager.add("id:" + contentId, (Object)"translateContentLangs", (Object)((AbstractParams)params).getTranslateContentLangs());
        this.harvesterSettingsManager.add("id:" + contentId, (Object)"translateContentFields", (Object)((AbstractParams)params).getTranslateContentFields());
        this.harvesterSettingsManager.add("id:" + infoId, (Object)"lastRun", (Object)"");
        this.storePrivileges(params, path);
        this.storeCategories(params, path);
        this.storeNodeExtra(params, path, siteId, optionsId);
    }

    private void storePrivileges(P params, String path) {
        String privId = this.harvesterSettingsManager.add(path, (Object)"privileges", (Object)"");
        for (Privileges p : ((AbstractParams)params).getPrivileges()) {
            String groupId = this.harvesterSettingsManager.add("id:" + privId, (Object)"group", (Object)p.getGroupId());
            for (int oper : p.getOperations()) {
                this.harvesterSettingsManager.add("id:" + groupId, (Object)"operation", (Object)oper);
            }
        }
    }

    private void storeCategories(P params, String path) {
        String categId = this.harvesterSettingsManager.add(path, (Object)"categories", (Object)"");
        for (String cId : ((AbstractParams)params).getCategories()) {
            this.harvesterSettingsManager.add("id:" + categId, (Object)"category", (Object)cId);
        }
    }

    protected void storeNodeExtra(P params, String path, String siteId, String optionsId) throws SQLException {
    }

    protected void setValue(Map<String, Object> values, String path, Element el, String name) {
        if (el == null) {
            return;
        }
        String value = el.getChildText(name);
        if (value != null) {
            values.put(path, value);
        }
    }

    protected void add(Element el, String name, int value) {
        el.addContent((Content)new Element(name).setText(Integer.toString(value)));
    }

    public void setParams(P params) {
        this.params = params;
    }

    public Element getResult() {
        Element res = new Element("result");
        if (this.result != null) {
            this.loadedInfo = null;
            this.add(res, "added", ((HarvestResult)this.result).addedMetadata);
            this.add(res, "atomicDatasetRecords", ((HarvestResult)this.result).atomicDatasetRecords);
            this.add(res, "badFormat", ((HarvestResult)this.result).badFormat);
            this.add(res, "collectionDatasetRecords", ((HarvestResult)this.result).collectionDatasetRecords);
            this.add(res, "datasetUuidExist", ((HarvestResult)this.result).datasetUuidExist);
            this.add(res, "privilegesAppendedOnExistingRecord", ((HarvestResult)this.result).privilegesAppendedOnExistingRecord);
            this.add(res, "doesNotValidate", ((HarvestResult)this.result).doesNotValidate);
            this.add(res, "xpathFilterExcluded", ((HarvestResult)this.result).xpathFilterExcluded);
            this.add(res, "duplicatedResource", ((HarvestResult)this.result).duplicatedResource);
            this.add(res, "fragmentsMatched", ((HarvestResult)this.result).fragmentsMatched);
            this.add(res, "fragmentsReturned", ((HarvestResult)this.result).fragmentsReturned);
            this.add(res, "fragmentsUnknownSchema", ((HarvestResult)this.result).fragmentsUnknownSchema);
            this.add(res, "incompatible", ((HarvestResult)this.result).incompatibleMetadata);
            this.add(res, "recordsBuilt", ((HarvestResult)this.result).recordsBuilt);
            this.add(res, "recordsUpdated", ((HarvestResult)this.result).recordsUpdated);
            this.add(res, "removed", ((HarvestResult)this.result).locallyRemoved);
            this.add(res, "serviceRecords", ((HarvestResult)this.result).serviceRecords);
            this.add(res, "subtemplatesAdded", ((HarvestResult)this.result).subtemplatesAdded);
            this.add(res, "subtemplatesRemoved", ((HarvestResult)this.result).subtemplatesRemoved);
            this.add(res, "subtemplatesUpdated", ((HarvestResult)this.result).subtemplatesUpdated);
            this.add(res, "total", ((HarvestResult)this.result).totalMetadata);
            this.add(res, "unchanged", ((HarvestResult)this.result).unchangedMetadata);
            this.add(res, "unknownSchema", ((HarvestResult)this.result).unknownSchema);
            this.add(res, "unretrievable", ((HarvestResult)this.result).unretrievable);
            this.add(res, "updated", ((HarvestResult)this.result).updatedMetadata);
            this.add(res, "thumbnails", ((HarvestResult)this.result).thumbnails);
            this.add(res, "thumbnailsFailed", ((HarvestResult)this.result).thumbnailsFailed);
        } else if (this.loadedInfo != null) {
            return (Element)this.loadedInfo.clone();
        }
        return res;
    }

    public void emptyResult() {
        this.result = null;
        this.loadedInfo = null;
    }

    public static String[] getHarvesterTypes(ServiceContext context) {
        return context.getApplicationContext().getBeanNamesForType(AbstractHarvester.class);
    }

    public static String[] getNonDisabledHarvesterTypes(ServiceContext context) {
        String[] availableTypes = context.getApplicationContext().getBeanNamesForType(AbstractHarvester.class);
        SettingManager localSettingManager = (SettingManager)context.getBean(SettingManager.class);
        String disabledTypesString = StringUtils.defaultIfBlank((String)localSettingManager.getValue("system/harvester/disabledHarvesterTypes"), (String)"");
        String[] disabledTypes = StringUtils.split((String)disabledTypesString.toLowerCase().replace(',', ' '), (String)" ");
        return Arrays.stream(availableTypes).filter(type -> Arrays.stream(disabledTypes).noneMatch(type::equalsIgnoreCase)).collect(Collectors.toList()).toArray(new String[0]);
    }

    public boolean isHarvesterTypeDisabled() {
        String[] disabledTypes = StringUtils.split((String)StringUtils.defaultIfBlank((String)this.settingManager.getValue("system/harvester/disabledHarvesterTypes"), (String)"").toLowerCase().replace(',', ' '), (String)" ");
        String type = this.getType();
        return Arrays.stream(disabledTypes).anyMatch(disabledType -> disabledType.equalsIgnoreCase(type));
    }

    public String getOwnerEmail() {
        String ownerId = ((AbstractParams)this.getParams()).getOwnerIdGroup();
        Group group = (Group)((GroupRepository)this.context.getBean(GroupRepository.class)).findById((Object)Integer.parseInt(ownerId)).get();
        return group.getEmail();
    }

    protected abstract P createParams();

    public class HarvestWithIndexProcessor
    extends MetadataIndexerProcessor {
        private final Logger logger;

        public HarvestWithIndexProcessor(DataManager dm, Logger logger) {
            super(dm);
            this.logger = logger;
        }

        public void process(String catalogueId) throws Exception {
            AbstractHarvester.this.doHarvest(this.logger);
        }
    }
}

