/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf.pdfbox;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.fontbox.cff.CFFCIDFont;
import org.apache.fontbox.cff.CFFCharset;
import org.apache.fontbox.cff.CFFEncoding;
import org.apache.fontbox.cff.CFFFont;
import org.apache.fontbox.cff.CFFISOAdobeCharset;
import org.apache.fontbox.cff.CFFParser;
import org.apache.fontbox.cff.CFFStandardEncoding;
import org.apache.fontbox.cff.CFFStandardString;
import org.apache.fontbox.cff.CFFType1Font;
import org.apache.fop.fonts.cff.CFFDataReader;
import org.apache.fop.fonts.truetype.FontFileReader;
import org.apache.fop.render.pdf.pdfbox.FontContainer;
import org.apache.fop.render.pdf.pdfbox.MergeFonts;
import org.apache.fop.render.pdf.pdfbox.OTFSubSetFile;

public class MergeCFFFonts
extends OTFSubSetFile
implements MergeFonts {
    protected List<Map<Integer, Integer>> subsetGlyphsList = new ArrayList<Map<Integer, Integer>>();
    private boolean fallbackIndex;
    private int charsetOffset;
    private int fontFileSize;
    private Set<String> used = new HashSet<String>();
    private List<String> strings = new ArrayList<String>();
    private List<Integer> chars = new ArrayList<Integer>();
    private List<String> added = new ArrayList<String>();
    private Map<Integer, Integer> range = new LinkedHashMap<Integer, Integer>();
    private int noOfFonts;
    private CFFEncoding encoding = null;

    public MergeCFFFonts() throws IOException {
        this.gidToSID = new LinkedHashMap();
        this.subsetCharStringsIndex = new ArrayList();
    }

    @Override
    public void readFont(InputStream is, String name, FontContainer fontContainer, Map<Integer, Integer> subsetGlyphs, boolean cid) throws IOException {
        this.embeddedName = name;
        CFFParser p = new CFFParser();
        FontFileReader fontFile = new FontFileReader(is);
        CFFFont ff = (CFFFont)p.parse(fontFile.getAllBytes()).get(0);
        if (this.used.containsAll(MergeCFFFonts.getStrings(ff).keySet())) {
            return;
        }
        this.fontFileSize += fontFile.getFileSize();
        this.fontFile = fontFile;
        this.used.addAll(MergeCFFFonts.getStrings(ff).keySet());
        if (this.fileFont == null) {
            this.fileFont = ff;
        }
        LinkedHashMap<Integer, Integer> sg = new LinkedHashMap<Integer, Integer>();
        for (int i = 0; i < ff.getNumCharStrings() + 1; ++i) {
            sg.put(i, i);
        }
        this.subsetGlyphsList.add(sg);
        this.cffReader = new CFFDataReader(fontFile);
        Iterator<Object> i = MergeCFFFonts.getSids(ff.getCharset()).iterator();
        while (i.hasNext()) {
            String data;
            int index;
            int n = i.next();
            if (n < 391 || (index = n - 391) > this.cffReader.getStringIndex().getNumObjects() || this.strings.contains(data = new String(this.cffReader.getStringIndex().getValue(index), "US-ASCII"))) continue;
            this.strings.add(data);
        }
        if (ff instanceof CFFType1Font) {
            this.encoding = ((CFFType1Font)ff).getEncoding();
            if (!(this.encoding instanceof CFFStandardEncoding)) {
                i = this.encoding.getCodeToNameMap().keySet().iterator();
                while (i.hasNext()) {
                    int n = (Integer)i.next();
                    if (this.chars.contains(n) || n == 0) continue;
                    this.chars.add(n);
                }
            }
        }
        this.setupMapping(ff.getCharset(), sg);
        for (Map.Entry entry : MergeCFFFonts.getStrings(ff).entrySet()) {
            if (this.added.contains(entry.getKey())) continue;
            this.subsetCharStringsIndex.add(entry.getValue());
            this.added.add((String)entry.getKey());
        }
        CFFCharset cSet = ff.getCharset();
        String string = cSet.getClass().getName();
        if (string.equals("org.apache.fontbox.cff.CFFParser$Format1Charset") || string.equals("org.apache.fontbox.cff.CFFParser$Format0Charset")) {
            for (int sid : MergeCFFFonts.getSids(cSet)) {
                this.range.put(sid, 0);
            }
        }
        ++this.noOfFonts;
    }

    private void setupMapping(CFFCharset charset, Map<Integer, Integer> sg) {
        int subsetGlyphIndex = 0;
        for (int sid : MergeCFFFonts.getSids(charset)) {
            if (!sg.containsKey(subsetGlyphIndex)) continue;
            int gid = sg.get(subsetGlyphIndex);
            if (sid < 391) {
                this.gidToSID.put(sg.get(gid), sid);
            } else {
                int index = sid - 391;
                if (index <= this.cffReader.getStringIndex().getNumObjects()) {
                    this.gidToSID.put(sg.get(gid), this.stringIndexData.size() + 391 - 1);
                } else {
                    this.gidToSID.put(sg.get(gid), index);
                }
            }
            ++subsetGlyphIndex;
        }
    }

    public static List<Integer> getSids(CFFCharset cSet) {
        ArrayList<Integer> sids = new ArrayList<Integer>();
        try {
            for (int gid = 0; gid < 1024; ++gid) {
                int sid = cSet.getCIDForGID(gid);
                if (sid == 0) continue;
                sids.add(sid);
            }
        }
        catch (IllegalStateException e) {
            try {
                final Method getSIDForGID = CFFCharset.class.getDeclaredMethod("getSIDForGID", Integer.TYPE);
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        getSIDForGID.setAccessible(true);
                        return null;
                    }
                });
                for (int gid = 0; gid < 1024; ++gid) {
                    int sid = (Integer)getSIDForGID.invoke((Object)cSet, gid);
                    if (sid == 0) continue;
                    sids.add(sid);
                }
            }
            catch (NoSuchMethodException e1) {
                throw new RuntimeException(e1);
            }
            catch (InvocationTargetException e1) {
                throw new RuntimeException(e1);
            }
            catch (IllegalAccessException e1) {
                throw new RuntimeException(e1);
            }
        }
        return sids;
    }

    public static Map<String, byte[]> getStrings(CFFFont ff) throws IOException {
        CFFCharset cs = ff.getCharset();
        List csbytes = ff.getCharStringBytes();
        LinkedHashMap<String, byte[]> strings = new LinkedHashMap<String, byte[]>();
        int i = 0;
        try {
            for (int gid = 0; gid < 256; ++gid) {
                String name = cs.getNameForGID(gid);
                if (name == null || i >= csbytes.size()) continue;
                strings.put(name, (byte[])csbytes.get(i));
                ++i;
            }
        }
        catch (IllegalStateException e) {
            strings.put(".notdef", (byte[])csbytes.get(0));
            for (int sid : MergeCFFFonts.getSids(ff.getCharset())) {
                if (i >= csbytes.size()) continue;
                strings.put(MergeCFFFonts.readString(sid), (byte[])csbytes.get(++i));
            }
        }
        return strings;
    }

    private static String readString(int index) throws IOException {
        if (index >= 0 && index <= 390) {
            return CFFStandardString.getName((int)index);
        }
        return "SID" + index;
    }

    @Override
    public byte[] getMergedFontSubset() throws IOException {
        if (this.noOfFonts == 1) {
            this.writeBytes(this.fontFile.getAllBytes());
            return super.getFontSubset();
        }
        this.createCFF();
        return super.getFontSubset();
    }

    protected void createCFF() throws IOException {
        boolean hasFDSelect;
        this.writeBytes(this.cffReader.getHeader());
        this.writeIndex(Arrays.asList(new byte[][]{this.fileFont.getName().getBytes("UTF-8")}));
        OTFSubSetFile.Offsets offsets = new OTFSubSetFile.Offsets();
        offsets.topDictData = this.currentPos + this.writeTopDICT();
        this.createCharStringData();
        this.writeStringIndex();
        LinkedHashMap topDICT = this.cffReader.getTopDictEntries();
        CFFDataReader.DICTEntry charString = (CFFDataReader.DICTEntry)topDICT.get("CharStrings");
        CFFDataReader.DICTEntry encodingEntry = (CFFDataReader.DICTEntry)topDICT.get("Encoding");
        boolean bl = hasFDSelect = this.cffReader.getFDSelect() != null;
        if (encodingEntry != null && charString.getOffset() > encodingEntry.getOffset()) {
            this.charsetOffset = this.currentPos;
            if (!this.fallbackIndex) {
                this.charsetOffset += 2;
            }
            this.writeCharsetTable(hasFDSelect, !this.fallbackIndex);
            offsets.encoding = this.currentPos;
            this.writeEncoding();
        } else {
            this.writeCard16(0);
            offsets.encoding = this.currentPos;
            this.writeEncoding();
            this.charsetOffset = this.currentPos;
            this.writeCharsetTable(hasFDSelect, false);
        }
        offsets.fdSelect = this.currentPos;
        if (hasFDSelect) {
            this.writeByte(0);
            for (int i = 0; i < this.subsetCharStringsIndex.size(); ++i) {
                this.writeByte(0);
            }
        }
        offsets.privateDict = this.currentPos;
        this.writePrivateDict();
        offsets.charString = this.currentPos;
        this.writeIndex(this.subsetCharStringsIndex);
        offsets.localIndex = this.currentPos;
        if (!this.subsetLocalIndexSubr.isEmpty()) {
            this.writeIndex(this.subsetLocalIndexSubr);
        }
        if (hasFDSelect) {
            offsets.fdArray = this.currentPos;
            ArrayList<byte[]> index = new ArrayList<byte[]>();
            int offset = this.currentPos + 5;
            for (CFFDataReader.FontDict fdFont : this.cffReader.getFDFonts()) {
                byte[] fdFontByteData = fdFont.getByteData();
                LinkedHashMap fdFontDict = this.cffReader.parseDictData(fdFontByteData);
                CFFDataReader.DICTEntry fdPrivate = (CFFDataReader.DICTEntry)fdFontDict.get("Private");
                this.updateOffset(fdFontByteData, fdPrivate.getOffset() + (Integer)fdPrivate.getOperandLengths().get(0), (Integer)fdPrivate.getOperandLengths().get(1), offset += fdFontByteData.length);
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                bos.write(fdFontByteData);
                bos.write(fdFont.getPrivateDictData());
                bos.write(new byte[3]);
                index.add(bos.toByteArray());
            }
            this.writeIndex(index, 1);
            this.updateCIDOffsets(offsets);
        } else {
            this.updateOffsets(offsets);
        }
    }

    protected void writeEncoding() throws IOException {
        if (!this.chars.isEmpty()) {
            this.writeCard16(this.chars.size());
            for (int i : this.chars) {
                this.writeByte(i);
            }
        }
    }

    protected void writeStringIndex() throws IOException {
        String notice;
        int stringIndexSize = this.stringIndexData.size();
        for (String s : this.strings) {
            this.stringIndexData.add(s.getBytes("US-ASCII"));
        }
        if (!this.stringIndexData.isEmpty()) {
            if (!this.strings.isEmpty() && !new String((byte[])this.stringIndexData.get(0), "UTF-8").equals(this.strings.get(0))) {
                for (int i = 0; i < stringIndexSize; ++i) {
                    this.stringIndexData.add(this.stringIndexData.remove(0));
                }
            } else {
                notice = (String)this.fileFont.getTopDict().get("Notice");
                if (notice != null && !(this.fileFont instanceof CFFCIDFont)) {
                    this.stringIndexData.add(notice.getBytes("ISO-8859-1"));
                }
            }
            this.stringIndexData.add(this.embeddedName.getBytes("UTF-8"));
            this.writeIndex(this.stringIndexData);
        } else {
            notice = (String)this.fileFont.getTopDict().get("Notice");
            if (notice != null) {
                this.writeIndex(Arrays.asList(notice.getBytes("ISO-8859-1"), this.embeddedName.getBytes("UTF-8")));
            } else {
                ArrayList<byte[]> sindex = new ArrayList<byte[]>();
                sindex.add(this.cffReader.getStringIndex().getData());
                if (sindex.size() > 1) {
                    this.fallbackIndex = true;
                    this.writeIndex(sindex);
                } else if (sindex.size() == 1) {
                    this.writeIndex(Arrays.asList(new byte[][]{this.embeddedName.getBytes("UTF-8")}));
                } else {
                    this.writeCard16(0);
                }
            }
        }
    }

    protected void createCharStringData() throws IOException {
        this.subsetLocalIndexSubr = new ArrayList();
        this.localUniques = new ArrayList();
        this.globalUniques = new ArrayList();
        this.localUniques.clear();
        this.globalUniques.clear();
    }

    protected void writeCharsetTable(boolean cidFont, boolean afterstringindex) throws IOException {
        if (this.range.isEmpty()) {
            this.writeByte(0);
            for (Map.Entry gid : this.gidToSID.entrySet()) {
                if (cidFont && (Integer)gid.getKey() == 0) continue;
                this.writeCard16(cidFont ? (Integer)gid.getKey() : (Integer)gid.getValue());
            }
        } else {
            this.writeFormat1CS(this.range, afterstringindex);
        }
    }

    private void writeFormat1CS(Map<Integer, Integer> range, boolean afterstringindex) {
        if (!afterstringindex) {
            this.charsetOffset += 2;
        }
        this.writeByte(0);
        this.writeCard16(1);
        this.updateStandardRange(range);
        for (Map.Entry<Integer, Integer> i : range.entrySet()) {
            this.writeCard16(i.getKey());
            this.writeByte(i.getValue());
        }
        this.writeByte(1);
    }

    private void updateStandardRange(Map<Integer, Integer> range) {
        block10: {
            block9: {
                if (!range.containsKey(391) || !range.containsKey(392)) break block9;
                boolean mixedCS = false;
                for (int i : range.keySet()) {
                    if (i >= 391 || i <= 1) continue;
                    mixedCS = true;
                    break;
                }
                if (mixedCS) break block10;
                if (range.containsKey(1)) {
                    range.clear();
                    range.put(1, 0);
                }
                int last = -1;
                boolean simpleRange = false;
                for (int i : range.keySet()) {
                    simpleRange = last + 1 == i;
                    last = i;
                }
                if (simpleRange) {
                    for (int i = 391; i < 391 + this.subsetCharStringsIndex.size(); ++i) {
                        range.put(i, 0);
                    }
                } else {
                    range.put(391, this.subsetCharStringsIndex.size());
                }
                break block10;
            }
            if (this.cffReader.getFDSelect() instanceof CFFDataReader.Format3FDSelect) {
                int last = -1;
                int count = 1;
                TreeSet<Integer> r = new TreeSet<Integer>(range.keySet());
                Iterator iterator = r.iterator();
                while (iterator.hasNext()) {
                    int i = (Integer)iterator.next();
                    if (last + count == i) {
                        range.remove(i);
                        range.put(last, count);
                        ++count;
                        continue;
                    }
                    last = i;
                    count = 1;
                }
            }
        }
    }

    @Override
    protected void updateFixedOffsets(Map<String, CFFDataReader.DICTEntry> topDICT, OTFSubSetFile.Offsets offsets) throws IOException {
        CFFDataReader.DICTEntry encodingEntry;
        CFFDataReader.DICTEntry charset = topDICT.get("charset");
        if (charset != null) {
            int oldCharsetOffset = offsets.topDictData + charset.getOffset();
            int oldCharset = Integer.parseInt(String.format("%02x", this.getFontSubset()[oldCharsetOffset] & 0xFF), 16);
            if (oldCharset >= 32 && oldCharset <= 246) {
                this.charsetOffset += 139;
            }
            this.updateOffset(oldCharsetOffset, charset.getOperandLength(), this.charsetOffset);
        }
        CFFDataReader.DICTEntry charString = topDICT.get("CharStrings");
        int oldCharStringOffset = offsets.topDictData + charString.getOffset();
        int oldString = Integer.parseInt(String.format("%02x", this.getFontSubset()[oldCharStringOffset] & 0xFF), 16);
        if (oldString >= 32 && oldString <= 246) {
            OTFSubSetFile.Offsets offsets2 = offsets;
            offsets2.charString = offsets2.charString + 139;
        }
        if (!(this.fileFont.getCharset() instanceof CFFISOAdobeCharset)) {
            this.updateOffset(oldCharStringOffset, charString.getOperandLength(), offsets.charString);
        }
        if ((encodingEntry = topDICT.get("Encoding")) != null && ((Number)encodingEntry.getOperands().get(0)).intValue() != 0 && ((Number)encodingEntry.getOperands().get(0)).intValue() != 1) {
            int oldEncodingOffset = offsets.topDictData + encodingEntry.getOffset();
            int oldEnc = Integer.parseInt(String.format("%02x", this.getFontSubset()[oldEncodingOffset] & 0xFF), 16);
            if (oldEnc >= 32 && oldEnc <= 246) {
                OTFSubSetFile.Offsets offsets3 = offsets;
                offsets3.encoding = offsets3.encoding + 139;
            } else {
                OTFSubSetFile.Offsets offsets4 = offsets;
                Integer n = offsets4.encoding;
                Integer n2 = offsets4.encoding = Integer.valueOf(offsets4.encoding - 1);
            }
            this.updateOffset(oldEncodingOffset, encodingEntry.getOperandLength(), offsets.encoding);
        }
    }
}

