/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.Validate;

public class RegexpProperties {
    private final Properties properties = new Properties();
    private static final String REGEX_KEY_VALUE = "(?m)\\s*(.*?)\\s*=\\s*(.*)\\s*$";
    private static final String REGEX_COMMENTS = "#.*";
    private static final Pattern PATTERN_KEY_VALUE = Pattern.compile("(?m)\\s*(.*?)\\s*=\\s*(.*)\\s*$");

    public Properties load(InputStream inputStream) throws IOException {
        Validate.notNull((Object)inputStream);
        String rawContent = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
        this.parseProperties(rawContent.replaceAll(REGEX_COMMENTS, ""));
        return this.properties;
    }

    private void parseProperties(String propertiesAsString) {
        String[] propertyEntries;
        for (String entry : propertyEntries = propertiesAsString.split("\\r?\\n")) {
            this.readPropertyEntry(entry);
        }
    }

    private void readPropertyEntry(String entry) {
        Matcher matcher = PATTERN_KEY_VALUE.matcher(entry);
        while (matcher.find()) {
            String key = matcher.group(1);
            String value = matcher.group(2);
            this.properties.put(key, value);
        }
    }
}

