/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.processor.factory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.model.group.processor.Minimize;
import ro.isdc.wro.model.resource.processor.ResourcePostProcessor;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;
import ro.isdc.wro.model.resource.processor.factory.ProcessorsFactory;

public class SimpleProcessorsFactory
implements ProcessorsFactory {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleProcessorsFactory.class);
    private final Collection<ResourcePreProcessor> preProcessors = new ArrayList<ResourcePreProcessor>();
    private final Collection<ResourcePostProcessor> postProcessors = new ArrayList<ResourcePostProcessor>();

    @Override
    public Collection<ResourcePreProcessor> getPreProcessors() {
        return Collections.unmodifiableCollection(this.preProcessors);
    }

    @Override
    public Collection<ResourcePostProcessor> getPostProcessors() {
        return Collections.unmodifiableCollection(this.postProcessors);
    }

    public void setResourcePreProcessors(Collection<ResourcePreProcessor> processors) {
        this.preProcessors.clear();
        if (processors != null) {
            this.preProcessors.addAll(processors);
        }
    }

    public void setResourcePostProcessors(Collection<ResourcePostProcessor> processors) {
        this.postProcessors.clear();
        if (processors != null) {
            this.postProcessors.addAll(processors);
        }
    }

    public SimpleProcessorsFactory addPreProcessor(ResourcePreProcessor processor) {
        this.preProcessors.add(processor);
        return this;
    }

    public SimpleProcessorsFactory addPostProcessor(ResourcePostProcessor processor) {
        if (processor.getClass().isAnnotationPresent(Minimize.class)) {
            LOG.warn("It is recommended to add minimize aware processors to pre processors instead of post processor, otherwise you won't be able to disable minimization on specific resources using minimize='false' attribute.");
        }
        this.postProcessors.add(processor);
        return this;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }
}

