/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.http.support;

import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.config.jmx.WroConfiguration;
import ro.isdc.wro.http.support.HttpHeader;
import ro.isdc.wro.util.WroUtil;

public class ResponseHeadersConfigurer {
    private static final Logger LOG = LoggerFactory.getLogger(ResponseHeadersConfigurer.class);
    private final String headersAsString;
    private final Long lastModifiedTimestamp = this.initTimestamp();
    private final Map<String, String> headersMap = new LinkedHashMap<String, String>(){

        @Override
        public String put(String key, String value) {
            return super.put(key.trim().toLowerCase(), value);
        }

        @Override
        public String get(Object key) {
            return (String)super.get(((String)key).toLowerCase());
        }
    };

    public static ResponseHeadersConfigurer noCache() {
        return new ResponseHeadersConfigurer(){

            @Override
            public void configureDefaultHeaders(Map<String, String> map) {
                ResponseHeadersConfigurer.addNoCacheHeaders(map);
            }
        };
    }

    public static ResponseHeadersConfigurer emptyHeaders() {
        return new ResponseHeadersConfigurer();
    }

    public static ResponseHeadersConfigurer fromConfig(final WroConfiguration config) {
        return new ResponseHeadersConfigurer(config.getHeader()){

            @Override
            public void configureDefaultHeaders(Map<String, String> map) {
                if (config.isCacheHttpEnabled()) {
                    if (config.isDebug()) {
                        ResponseHeadersConfigurer.addNoCacheHeaders(map);
                    } else {
                        Calendar cal = Calendar.getInstance();
                        cal.roll(1, 1);
                        map.put(HttpHeader.CACHE_CONTROL.toString(), config.getCacheHttpValue());
                        map.put(HttpHeader.EXPIRES.toString(), WroUtil.toDateAsString(cal.getTimeInMillis()));
                        map.put(HttpHeader.LAST_MODIFIED.toString(), WroUtil.toDateAsString(this.getLastModifiedTimestamp()));
                    }
                }
            }
        };
    }

    public static ResponseHeadersConfigurer withHeadersSet(String headersAsString) {
        return new ResponseHeadersConfigurer(headersAsString);
    }

    public ResponseHeadersConfigurer() {
        this(null);
    }

    public ResponseHeadersConfigurer(String headersAsString) {
        this.headersAsString = headersAsString;
        this.headersMap.clear();
        this.initHeaderValues();
    }

    private void initHeaderValues() {
        this.configureDefaultHeaders(this.headersMap);
        this.configureFromHeadersAsString();
        LOG.debug("Header Values: {}", this.headersMap);
    }

    private void configureFromHeadersAsString() {
        if (!StringUtils.isEmpty((CharSequence)this.headersAsString)) {
            try {
                if (this.headersAsString.contains("|")) {
                    String[] headerAsArray;
                    for (String header : headerAsArray = this.headersAsString.split("[|]")) {
                        this.parseHeader(header);
                    }
                } else {
                    this.parseHeader(this.headersAsString);
                }
            }
            catch (Exception e) {
                throw new WroRuntimeException("Invalid header init-param value: " + this.headersAsString + ". A correct value should have the following format: <HEADER_NAME1>: <VALUE1> | <HEADER_NAME2>: <VALUE2>. Ex: <look like this: Expires: Thu, 15 Apr 2010 20:00:00 GMT | Cache-Control: public", e);
            }
        }
    }

    private void parseHeader(String header) {
        LOG.debug("parseHeader: {}", (Object)header);
        String headerName = header.substring(0, header.indexOf(":"));
        if (!this.headersMap.containsKey(headerName)) {
            String value = header.substring(header.indexOf(":") + 1);
            this.headersMap.put(headerName, StringUtils.trim((String)value));
        }
    }

    public void configureDefaultHeaders(Map<String, String> map) {
    }

    private static void addNoCacheHeaders(Map<String, String> map) {
        map.put(HttpHeader.PRAGMA.toString(), "no-cache");
        map.put(HttpHeader.CACHE_CONTROL.toString(), "no-cache");
        map.put(HttpHeader.EXPIRES.toString(), "0");
    }

    public void setHeaders(HttpServletResponse response) {
        for (Map.Entry<String, String> entry : this.headersMap.entrySet()) {
            response.setHeader(entry.getKey(), entry.getValue());
        }
    }

    final Map<String, String> getHeadersMap() {
        return Collections.unmodifiableMap(this.headersMap);
    }

    public Long getLastModifiedTimestamp() {
        return this.lastModifiedTimestamp;
    }

    private long initTimestamp() {
        long timestamp = new Date().getTime();
        timestamp -= timestamp % 1000L;
        return timestamp;
    }
}

