/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.config.jmx;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.config.jmx.WroConfigurationMBean;
import ro.isdc.wro.config.support.ConfigConstants;
import ro.isdc.wro.config.support.DeploymentMode;

public class WroConfiguration
implements WroConfigurationMBean {
    private static final Logger LOG = LoggerFactory.getLogger(WroConfiguration.class);
    private boolean cacheGzippedContent = (Boolean)ConfigConstants.cacheGzippedContent.getDefaultPropertyValue();
    private boolean cacheHttpEnabled = (Boolean)ConfigConstants.cacheHttpEnabled.getDefaultPropertyValue();
    private String cacheHttpValue = (String)ConfigConstants.cacheHttpValue.getDefaultPropertyValue();
    private long cacheUpdatePeriod = (Long)ConfigConstants.cacheUpdatePeriod.getDefaultPropertyValue();
    private int connectionTimeout = (Integer)ConfigConstants.connectionTimeout.getDefaultPropertyValue();
    private boolean debug = (Boolean)ConfigConstants.debug.getDefaultPropertyValue();
    private DeploymentMode deploymentMode = (DeploymentMode)((Object)ConfigConstants.deploymentMode.getDefaultPropertyValue());
    private String encoding = (String)ConfigConstants.encoding.getDefaultPropertyValue();
    private boolean gzipEnabled = (Boolean)ConfigConstants.gzipResources.getDefaultPropertyValue();
    private String header = (String)ConfigConstants.header.getDefaultPropertyValue();
    private boolean ignoreEmptyGroup = (Boolean)ConfigConstants.ignoreEmptyGroup.getDefaultPropertyValue();
    private boolean ignoreFailingProcessor = (Boolean)ConfigConstants.ignoreFailingProcessor.getDefaultPropertyValue();
    private boolean ignoreMissingResources = (Boolean)ConfigConstants.ignoreMissingResources.getDefaultPropertyValue();
    private boolean jmxEnabled = (Boolean)ConfigConstants.jmxEnabled.getDefaultPropertyValue();
    private String mbeanName = (String)ConfigConstants.mbeanName.getDefaultPropertyValue();
    private boolean minimizeEnabled = (Boolean)ConfigConstants.minimizeEnabled.getDefaultPropertyValue();
    private long modelUpdatePeriod = (Long)ConfigConstants.modelUpdatePeriod.getDefaultPropertyValue();
    private boolean parallelPreprocessing = (Boolean)ConfigConstants.parallelPreprocessing.getDefaultPropertyValue();
    private long resourceWatcherUpdatePeriod = (Long)ConfigConstants.resourceWatcherUpdatePeriod.getDefaultPropertyValue();
    private boolean resourceWatcherAsync = (Boolean)ConfigConstants.resourceWatcherAsync.getDefaultPropertyValue();
    private String wroManagerClassName = (String)ConfigConstants.managerFactoryClassName.getDefaultPropertyValue();
    private final transient List<PropertyChangeListener> cacheUpdatePeriodListeners = new ArrayList<PropertyChangeListener>(1);
    private final transient List<PropertyChangeListener> modelUpdatePeriodListeners = new ArrayList<PropertyChangeListener>(1);

    public static String getObjectName() {
        return WroConfiguration.class.getPackage().getName() + ".jmx:type=" + WroConfiguration.class.getSimpleName();
    }

    public void destroy() {
        this.cacheUpdatePeriodListeners.clear();
        this.modelUpdatePeriodListeners.clear();
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (boolean)true);
    }

    public String getCacheHttpValue() {
        return this.cacheHttpValue;
    }

    @Override
    public long getCacheUpdatePeriod() {
        return this.cacheUpdatePeriod;
    }

    @Override
    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public DeploymentMode getDeploymentMode() {
        return this.deploymentMode;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    public String getHeader() {
        return this.header;
    }

    public String getMbeanName() {
        return this.mbeanName;
    }

    @Override
    public long getModelUpdatePeriod() {
        return this.modelUpdatePeriod;
    }

    @Override
    public final long getResourceWatcherUpdatePeriod() {
        return this.resourceWatcherUpdatePeriod;
    }

    public String getWroManagerClassName() {
        return this.wroManagerClassName;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    @Override
    public boolean isCacheGzippedContent() {
        return this.cacheGzippedContent;
    }

    public boolean isCacheHttpEnabled() {
        return this.cacheHttpEnabled;
    }

    @Override
    public boolean isDebug() {
        return this.debug;
    }

    @Override
    public boolean isGzipEnabled() {
        return this.gzipEnabled;
    }

    @Override
    public boolean isIgnoreEmptyGroup() {
        return this.ignoreEmptyGroup;
    }

    public boolean isIgnoreFailingProcessor() {
        return this.ignoreFailingProcessor;
    }

    @Override
    public boolean isIgnoreMissingResources() {
        return this.ignoreMissingResources;
    }

    public boolean isJmxEnabled() {
        return this.jmxEnabled;
    }

    @Override
    public boolean isMinimizeEnabled() {
        return this.minimizeEnabled;
    }

    public boolean isParallelPreprocessing() {
        return this.parallelPreprocessing;
    }

    public boolean isResourceWatcherAsync() {
        return this.resourceWatcherAsync;
    }

    public void registerCacheUpdatePeriodChangeListener(PropertyChangeListener listener) {
        this.cacheUpdatePeriodListeners.add(listener);
    }

    public void registerModelUpdatePeriodChangeListener(PropertyChangeListener listener) {
        this.modelUpdatePeriodListeners.add(listener);
    }

    @Override
    public void reloadCache() {
        this.reloadCacheWithNewValue(null);
    }

    private void reloadCacheWithNewValue(Long newValue) {
        long newValueAsPrimitive = newValue == null ? this.getCacheUpdatePeriod() : newValue.longValue();
        LOG.debug("invoking {} listeners", (Object)this.cacheUpdatePeriodListeners.size());
        for (PropertyChangeListener listener : this.cacheUpdatePeriodListeners) {
            PropertyChangeEvent event = new PropertyChangeEvent(this, "cache", this.getCacheUpdatePeriod(), newValueAsPrimitive);
            listener.propertyChange(event);
        }
    }

    @Override
    public void reloadModel() {
        LOG.debug("reloadModel");
        this.reloadModelWithNewValue(null);
    }

    private void reloadModelWithNewValue(Long newValue) {
        long newValueAsPrimitive = newValue == null ? this.getModelUpdatePeriod() : newValue.longValue();
        for (PropertyChangeListener listener : this.modelUpdatePeriodListeners) {
            PropertyChangeEvent event = new PropertyChangeEvent(this, "model", this.getModelUpdatePeriod(), newValueAsPrimitive);
            listener.propertyChange(event);
        }
    }

    @Override
    public void setCacheGzippedContent(boolean cacheGzippedContent) {
        this.cacheGzippedContent = cacheGzippedContent;
    }

    public void setCacheGzippedContent(Boolean cacheGzippedContent) {
        if (cacheGzippedContent != null) {
            this.setCacheGzippedContent((boolean)cacheGzippedContent);
        }
    }

    public void setCacheHttpEnabled(boolean cacheHttpEnabled) {
        this.cacheHttpEnabled = cacheHttpEnabled;
    }

    public void setCacheHttpEnabled(Boolean cacheHttpEnabled) {
        if (cacheHttpEnabled != null) {
            this.setCacheHttpEnabled((boolean)cacheHttpEnabled);
        }
    }

    public void setCacheHttpValue(String cacheHttpValue) {
        if (cacheHttpValue != null) {
            this.cacheHttpValue = cacheHttpValue;
        }
    }

    @Override
    public void setCacheUpdatePeriod(long period) {
        if (period != this.cacheUpdatePeriod) {
            this.reloadCacheWithNewValue(period);
        }
        this.cacheUpdatePeriod = period;
    }

    public void setCacheUpdatePeriod(Long period) {
        if (period != null) {
            this.setCacheUpdatePeriod((long)period);
        }
    }

    @Override
    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setConnectionTimeout(Integer connectionTimeout) {
        if (connectionTimeout != null) {
            this.setConnectionTimeout((int)connectionTimeout);
        }
    }

    @Override
    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setDebug(Boolean debug) {
        if (debug != null) {
            this.setDebug((boolean)debug);
        }
    }

    public void setDeploymentMode(DeploymentMode deploymentMode) {
        if (deploymentMode != null) {
            this.deploymentMode = deploymentMode;
        }
    }

    @Override
    public void setEncoding(String encoding) {
        if (encoding != null) {
            this.encoding = encoding;
        }
    }

    @Override
    public void setGzipEnabled(boolean enabled) {
        this.gzipEnabled = enabled;
    }

    public void setGzipEnabled(Boolean enabled) {
        if (enabled != null) {
            this.setGzipEnabled((boolean)enabled);
        }
    }

    public void setHeader(String header) {
        if (header != null) {
            this.header = header;
        }
    }

    @Override
    public void setIgnoreEmptyGroup(boolean ignoreEmptyGroup) {
        this.ignoreEmptyGroup = ignoreEmptyGroup;
    }

    public void setIgnoreEmptyGroup(Boolean ignoreEmptyGroup) {
        if (ignoreEmptyGroup != null) {
            this.setIgnoreEmptyGroup((boolean)ignoreEmptyGroup);
        }
    }

    public void setIgnoreFailingProcessor(boolean ignoreFailingProcessor) {
        this.ignoreFailingProcessor = ignoreFailingProcessor;
    }

    public void setIgnoreFailingProcessor(Boolean ignoreFailingProcessor) {
        if (ignoreFailingProcessor != null) {
            this.setIgnoreFailingProcessor((boolean)ignoreFailingProcessor);
        }
    }

    @Override
    public void setIgnoreMissingResources(boolean ignoreMissingResources) {
        this.ignoreMissingResources = ignoreMissingResources;
    }

    public void setIgnoreMissingResources(Boolean ignoreMissingResources) {
        if (ignoreMissingResources != null) {
            this.setIgnoreMissingResources((boolean)ignoreMissingResources);
        }
    }

    public void setJmxEnabled(boolean jmxEnabled) {
        this.jmxEnabled = jmxEnabled;
    }

    public void setJmxEnabled(Boolean jmxEnabled) {
        if (jmxEnabled != null) {
            this.setJmxEnabled((boolean)jmxEnabled);
        }
    }

    public void setMbeanName(String mbeanName) {
        if (mbeanName != null) {
            this.mbeanName = mbeanName;
        }
    }

    @Override
    public void setMinimizeEnabled(boolean minimizeEnabled) {
        this.minimizeEnabled = minimizeEnabled;
    }

    public void setMinimizeEnabled(Boolean minimizeEnabled) {
        if (minimizeEnabled != null) {
            this.setMinimizeEnabled((boolean)minimizeEnabled);
        }
    }

    @Override
    public void setModelUpdatePeriod(long period) {
        if (period != this.modelUpdatePeriod) {
            this.reloadModelWithNewValue(period);
        }
        this.modelUpdatePeriod = period;
    }

    public void setModelUpdatePeriod(Long period) {
        if (period != null) {
            this.setModelUpdatePeriod((long)period);
        }
    }

    public void setParallelPreprocessing(boolean parallelPreprocessing) {
        this.parallelPreprocessing = parallelPreprocessing;
    }

    public void setParallelPreprocessing(Boolean parallelPreprocessing) {
        if (parallelPreprocessing != null) {
            this.setParallelPreprocessing((boolean)parallelPreprocessing);
        }
    }

    public void setResourceWatcherAsync(boolean resourceWatcherAsync) {
        this.resourceWatcherAsync = resourceWatcherAsync;
    }

    public void setResourceWatcherAsync(Boolean resourceWatcherAsync) {
        if (resourceWatcherAsync != null) {
            this.setResourceWatcherAsync((boolean)resourceWatcherAsync);
        }
    }

    @Override
    public final void setResourceWatcherUpdatePeriod(long period) {
        this.resourceWatcherUpdatePeriod = period;
    }

    public void setResourceWatcherUpdatePeriod(Long period) {
        if (period != null) {
            this.setResourceWatcherUpdatePeriod((long)period);
        }
    }

    public void setWroManagerClassName(String wroManagerClassName) {
        if (wroManagerClassName != null) {
            this.wroManagerClassName = wroManagerClassName;
        }
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE).toString();
    }
}

