/**
 * Cesium - https://github.com/AnalyticalGraphicsInc/cesium
 *
 * Copyright 2011-2017 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/AnalyticalGraphicsInc/cesium/blob/master/LICENSE.md for full licensing details.
 */
define(["exports","./defined-2a4f2d00","./Check-e5651467","./freezeObject-a51e076f","./defaultValue-29c9b1af","./Math-7782f09e","./Cartesian2-ba70b51f","./defineProperties-c817531e","./RuntimeError-51c34ab4","./when-1faa3867"],function(e,I,n,t,P,Z,D,r,J,f){"use strict";function a(e){this._ellipsoid=P.defaultValue(e,D.Ellipsoid.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis}r.defineProperties(a.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}}),a.prototype.project=function(e,t){var n=this._semimajorAxis,r=e.longitude*n,a=e.latitude*n,i=e.height;return I.defined(t)?(t.x=r,t.y=a,t.z=i,t):new D.Cartesian3(r,a,i)},a.prototype.unproject=function(e,t){var n=this._oneOverSemimajorAxis,r=e.x*n,a=e.y*n,i=e.z;return I.defined(t)?(t.longitude=r,t.latitude=a,t.height=i,t):new D.Cartographic(r,a,i)};var s=t.freezeObject({OUTSIDE:-1,INTERSECTING:0,INSIDE:1});function o(e,t){this.start=P.defaultValue(e,0),this.stop=P.defaultValue(t,0)}function X(e,t,n,r,a,i,s,o,u){this[0]=P.defaultValue(e,0),this[1]=P.defaultValue(r,0),this[2]=P.defaultValue(s,0),this[3]=P.defaultValue(t,0),this[4]=P.defaultValue(a,0),this[5]=P.defaultValue(o,0),this[6]=P.defaultValue(n,0),this[7]=P.defaultValue(i,0),this[8]=P.defaultValue(u,0)}X.packedLength=9,X.pack=function(e,t,n){return n=P.defaultValue(n,0),t[n++]=e[0],t[n++]=e[1],t[n++]=e[2],t[n++]=e[3],t[n++]=e[4],t[n++]=e[5],t[n++]=e[6],t[n++]=e[7],t[n++]=e[8],t},X.unpack=function(e,t,n){return t=P.defaultValue(t,0),I.defined(n)||(n=new X),n[0]=e[t++],n[1]=e[t++],n[2]=e[t++],n[3]=e[t++],n[4]=e[t++],n[5]=e[t++],n[6]=e[t++],n[7]=e[t++],n[8]=e[t++],n},X.clone=function(e,t){if(I.defined(e))return I.defined(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):new X(e[0],e[3],e[6],e[1],e[4],e[7],e[2],e[5],e[8])},X.fromArray=function(e,t,n){return t=P.defaultValue(t,0),I.defined(n)||(n=new X),n[0]=e[t],n[1]=e[t+1],n[2]=e[t+2],n[3]=e[t+3],n[4]=e[t+4],n[5]=e[t+5],n[6]=e[t+6],n[7]=e[t+7],n[8]=e[t+8],n},X.fromColumnMajorArray=function(e,t){return X.clone(e,t)},X.fromRowMajorArray=function(e,t){return I.defined(t)?(t[0]=e[0],t[1]=e[3],t[2]=e[6],t[3]=e[1],t[4]=e[4],t[5]=e[7],t[6]=e[2],t[7]=e[5],t[8]=e[8],t):new X(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8])},X.fromQuaternion=function(e,t){var n=e.x*e.x,r=e.x*e.y,a=e.x*e.z,i=e.x*e.w,s=e.y*e.y,o=e.y*e.z,u=e.y*e.w,l=e.z*e.z,c=e.z*e.w,d=e.w*e.w,f=n-s-l+d,h=2*(r-c),p=2*(a+u),m=2*(r+c),y=s-n-l+d,v=2*(o-i),w=2*(a-u),C=2*(o+i),g=-n-s+l+d;return I.defined(t)?(t[0]=f,t[1]=m,t[2]=w,t[3]=h,t[4]=y,t[5]=C,t[6]=p,t[7]=v,t[8]=g,t):new X(f,h,p,m,y,v,w,C,g)},X.fromHeadingPitchRoll=function(e,t){var n=Math.cos(-e.pitch),r=Math.cos(-e.heading),a=Math.cos(e.roll),i=Math.sin(-e.pitch),s=Math.sin(-e.heading),o=Math.sin(e.roll),u=n*r,l=-a*s+o*i*r,c=o*s+a*i*r,d=n*s,f=a*r+o*i*s,h=-o*r+a*i*s,p=-i,m=o*n,y=a*n;return I.defined(t)?(t[0]=u,t[1]=d,t[2]=p,t[3]=l,t[4]=f,t[5]=m,t[6]=c,t[7]=h,t[8]=y,t):new X(u,l,c,d,f,h,p,m,y)},X.fromScale=function(e,t){return I.defined(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=e.y,t[5]=0,t[6]=0,t[7]=0,t[8]=e.z,t):new X(e.x,0,0,0,e.y,0,0,0,e.z)},X.fromUniformScale=function(e,t){return I.defined(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=e,t[5]=0,t[6]=0,t[7]=0,t[8]=e,t):new X(e,0,0,0,e,0,0,0,e)},X.fromCrossProduct=function(e,t){return I.defined(t)?(t[0]=0,t[1]=e.z,t[2]=-e.y,t[3]=-e.z,t[4]=0,t[5]=e.x,t[6]=e.y,t[7]=-e.x,t[8]=0,t):new X(0,-e.z,e.y,e.z,0,-e.x,-e.y,e.x,0)},X.fromRotationX=function(e,t){var n=Math.cos(e),r=Math.sin(e);return I.defined(t)?(t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=n,t[5]=r,t[6]=0,t[7]=-r,t[8]=n,t):new X(1,0,0,0,n,-r,0,r,n)},X.fromRotationY=function(e,t){var n=Math.cos(e),r=Math.sin(e);return I.defined(t)?(t[0]=n,t[1]=0,t[2]=-r,t[3]=0,t[4]=1,t[5]=0,t[6]=r,t[7]=0,t[8]=n,t):new X(n,0,r,0,1,0,-r,0,n)},X.fromRotationZ=function(e,t){var n=Math.cos(e),r=Math.sin(e);return I.defined(t)?(t[0]=n,t[1]=r,t[2]=0,t[3]=-r,t[4]=n,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t):new X(n,-r,0,r,n,0,0,0,1)},X.toArray=function(e,t){return I.defined(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8]]},X.getElementIndex=function(e,t){return 3*e+t},X.getColumn=function(e,t,n){var r=3*t,a=e[r],i=e[1+r],s=e[2+r];return n.x=a,n.y=i,n.z=s,n},X.setColumn=function(e,t,n,r){var a=3*t;return(r=X.clone(e,r))[a]=n.x,r[1+a]=n.y,r[2+a]=n.z,r},X.getRow=function(e,t,n){var r=e[t],a=e[t+3],i=e[t+6];return n.x=r,n.y=a,n.z=i,n},X.setRow=function(e,t,n,r){return(r=X.clone(e,r))[t]=n.x,r[t+3]=n.y,r[t+6]=n.z,r};var i=new D.Cartesian3;X.getScale=function(e,t){return t.x=D.Cartesian3.magnitude(D.Cartesian3.fromElements(e[0],e[1],e[2],i)),t.y=D.Cartesian3.magnitude(D.Cartesian3.fromElements(e[3],e[4],e[5],i)),t.z=D.Cartesian3.magnitude(D.Cartesian3.fromElements(e[6],e[7],e[8],i)),t};var u=new D.Cartesian3;X.getMaximumScale=function(e){return X.getScale(e,u),D.Cartesian3.maximumComponent(u)},X.multiply=function(e,t,n){var r=e[0]*t[0]+e[3]*t[1]+e[6]*t[2],a=e[1]*t[0]+e[4]*t[1]+e[7]*t[2],i=e[2]*t[0]+e[5]*t[1]+e[8]*t[2],s=e[0]*t[3]+e[3]*t[4]+e[6]*t[5],o=e[1]*t[3]+e[4]*t[4]+e[7]*t[5],u=e[2]*t[3]+e[5]*t[4]+e[8]*t[5],l=e[0]*t[6]+e[3]*t[7]+e[6]*t[8],c=e[1]*t[6]+e[4]*t[7]+e[7]*t[8],d=e[2]*t[6]+e[5]*t[7]+e[8]*t[8];return n[0]=r,n[1]=a,n[2]=i,n[3]=s,n[4]=o,n[5]=u,n[6]=l,n[7]=c,n[8]=d,n},X.add=function(e,t,n){return n[0]=e[0]+t[0],n[1]=e[1]+t[1],n[2]=e[2]+t[2],n[3]=e[3]+t[3],n[4]=e[4]+t[4],n[5]=e[5]+t[5],n[6]=e[6]+t[6],n[7]=e[7]+t[7],n[8]=e[8]+t[8],n},X.subtract=function(e,t,n){return n[0]=e[0]-t[0],n[1]=e[1]-t[1],n[2]=e[2]-t[2],n[3]=e[3]-t[3],n[4]=e[4]-t[4],n[5]=e[5]-t[5],n[6]=e[6]-t[6],n[7]=e[7]-t[7],n[8]=e[8]-t[8],n},X.multiplyByVector=function(e,t,n){var r=t.x,a=t.y,i=t.z,s=e[0]*r+e[3]*a+e[6]*i,o=e[1]*r+e[4]*a+e[7]*i,u=e[2]*r+e[5]*a+e[8]*i;return n.x=s,n.y=o,n.z=u,n},X.multiplyByScalar=function(e,t,n){return n[0]=e[0]*t,n[1]=e[1]*t,n[2]=e[2]*t,n[3]=e[3]*t,n[4]=e[4]*t,n[5]=e[5]*t,n[6]=e[6]*t,n[7]=e[7]*t,n[8]=e[8]*t,n},X.multiplyByScale=function(e,t,n){return n[0]=e[0]*t.x,n[1]=e[1]*t.x,n[2]=e[2]*t.x,n[3]=e[3]*t.y,n[4]=e[4]*t.y,n[5]=e[5]*t.y,n[6]=e[6]*t.z,n[7]=e[7]*t.z,n[8]=e[8]*t.z,n},X.negate=function(e,t){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t},X.transpose=function(e,t){var n=e[0],r=e[3],a=e[6],i=e[1],s=e[4],o=e[7],u=e[2],l=e[5],c=e[8];return t[0]=n,t[1]=r,t[2]=a,t[3]=i,t[4]=s,t[5]=o,t[6]=u,t[7]=l,t[8]=c,t};var l=new D.Cartesian3(1,1,1);X.getRotation=function(e,t){var n=D.Cartesian3.divideComponents(l,X.getScale(e,u),u);return t=X.multiplyByScale(e,n,t)};var h=[1,0,0],p=[2,2,1];function c(e){for(var t=0,n=0;n<3;++n){var r=e[X.getElementIndex(p[n],h[n])];t+=2*r*r}return Math.sqrt(t)}function d(e,t){for(var n=Z.CesiumMath.EPSILON15,r=0,a=1,i=0;i<3;++i){var s=Math.abs(e[X.getElementIndex(p[i],h[i])]);r<s&&(a=i,r=s)}var o=1,u=0,l=h[a],c=p[a];if(Math.abs(e[X.getElementIndex(c,l)])>n){var d,f=(e[X.getElementIndex(c,c)]-e[X.getElementIndex(l,l)])/2/e[X.getElementIndex(c,l)];u=(d=f<0?-1/(-f+Math.sqrt(1+f*f)):1/(f+Math.sqrt(1+f*f)))*(o=1/Math.sqrt(1+d*d))}return(t=X.clone(X.IDENTITY,t))[X.getElementIndex(l,l)]=t[X.getElementIndex(c,c)]=o,t[X.getElementIndex(c,l)]=u,t[X.getElementIndex(l,c)]=-u,t}var m=new X,y=new X;function G(e,t,n,r){this.x=P.defaultValue(e,0),this.y=P.defaultValue(t,0),this.z=P.defaultValue(n,0),this.w=P.defaultValue(r,0)}X.computeEigenDecomposition=function(e,t){var n=Z.CesiumMath.EPSILON20,r=0,a=0;I.defined(t)||(t={});for(var i=t.unitary=X.clone(X.IDENTITY,t.unitary),s=t.diagonal=X.clone(e,t.diagonal),o=n*function(e){for(var t=0,n=0;n<9;++n){var r=e[n];t+=r*r}return Math.sqrt(t)}(s);a<10&&c(s)>o;)d(s,m),X.transpose(m,y),X.multiply(s,m,s),X.multiply(y,s,s),X.multiply(i,m,i),2<++r&&(++a,r=0);return t},X.abs=function(e,t){return t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t},X.determinant=function(e){var t=e[0],n=e[3],r=e[6],a=e[1],i=e[4],s=e[7],o=e[2],u=e[5],l=e[8];return t*(i*l-u*s)+a*(u*r-n*l)+o*(n*s-i*r)},X.inverse=function(e,t){var n=e[0],r=e[1],a=e[2],i=e[3],s=e[4],o=e[5],u=e[6],l=e[7],c=e[8],d=X.determinant(e);return t[0]=s*c-l*o,t[1]=l*a-r*c,t[2]=r*o-s*a,t[3]=u*o-i*c,t[4]=n*c-u*a,t[5]=i*a-n*o,t[6]=i*l-u*s,t[7]=u*r-n*l,t[8]=n*s-i*r,X.multiplyByScalar(t,1/d,t)},X.equals=function(e,t){return e===t||I.defined(e)&&I.defined(t)&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[3]===t[3]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[7]===t[7]&&e[8]===t[8]},X.equalsEpsilon=function(e,t,n){return e===t||I.defined(e)&&I.defined(t)&&Math.abs(e[0]-t[0])<=n&&Math.abs(e[1]-t[1])<=n&&Math.abs(e[2]-t[2])<=n&&Math.abs(e[3]-t[3])<=n&&Math.abs(e[4]-t[4])<=n&&Math.abs(e[5]-t[5])<=n&&Math.abs(e[6]-t[6])<=n&&Math.abs(e[7]-t[7])<=n&&Math.abs(e[8]-t[8])<=n},X.IDENTITY=t.freezeObject(new X(1,0,0,0,1,0,0,0,1)),X.ZERO=t.freezeObject(new X(0,0,0,0,0,0,0,0,0)),X.COLUMN0ROW0=0,X.COLUMN0ROW1=1,X.COLUMN0ROW2=2,X.COLUMN1ROW0=3,X.COLUMN1ROW1=4,X.COLUMN1ROW2=5,X.COLUMN2ROW0=6,X.COLUMN2ROW1=7,X.COLUMN2ROW2=8,r.defineProperties(X.prototype,{length:{get:function(){return X.packedLength}}}),X.prototype.clone=function(e){return X.clone(this,e)},X.prototype.equals=function(e){return X.equals(this,e)},X.equalsArray=function(e,t,n){return e[0]===t[n]&&e[1]===t[n+1]&&e[2]===t[n+2]&&e[3]===t[n+3]&&e[4]===t[n+4]&&e[5]===t[n+5]&&e[6]===t[n+6]&&e[7]===t[n+7]&&e[8]===t[n+8]},X.prototype.equalsEpsilon=function(e,t){return X.equalsEpsilon(this,e,t)},X.prototype.toString=function(){return"("+this[0]+", "+this[3]+", "+this[6]+")\n("+this[1]+", "+this[4]+", "+this[7]+")\n("+this[2]+", "+this[5]+", "+this[8]+")"},G.fromElements=function(e,t,n,r,a){return I.defined(a)?(a.x=e,a.y=t,a.z=n,a.w=r,a):new G(e,t,n,r)},G.fromColor=function(e,t){return I.defined(t)?(t.x=e.red,t.y=e.green,t.z=e.blue,t.w=e.alpha,t):new G(e.red,e.green,e.blue,e.alpha)},G.clone=function(e,t){if(I.defined(e))return I.defined(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new G(e.x,e.y,e.z,e.w)},G.packedLength=4,G.pack=function(e,t,n){return n=P.defaultValue(n,0),t[n++]=e.x,t[n++]=e.y,t[n++]=e.z,t[n]=e.w,t},G.unpack=function(e,t,n){return t=P.defaultValue(t,0),I.defined(n)||(n=new G),n.x=e[t++],n.y=e[t++],n.z=e[t++],n.w=e[t],n},G.packArray=function(e,t){var n=e.length;I.defined(t)?t.length=4*n:t=new Array(4*n);for(var r=0;r<n;++r)G.pack(e[r],t,4*r);return t},G.unpackArray=function(e,t){var n=e.length;I.defined(t)?t.length=n/4:t=new Array(n/4);for(var r=0;r<n;r+=4){var a=r/4;t[a]=G.unpack(e,r,t[a])}return t},G.fromArray=G.unpack,G.maximumComponent=function(e){return Math.max(e.x,e.y,e.z,e.w)},G.minimumComponent=function(e){return Math.min(e.x,e.y,e.z,e.w)},G.minimumByComponent=function(e,t,n){return n.x=Math.min(e.x,t.x),n.y=Math.min(e.y,t.y),n.z=Math.min(e.z,t.z),n.w=Math.min(e.w,t.w),n},G.maximumByComponent=function(e,t,n){return n.x=Math.max(e.x,t.x),n.y=Math.max(e.y,t.y),n.z=Math.max(e.z,t.z),n.w=Math.max(e.w,t.w),n},G.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},G.magnitude=function(e){return Math.sqrt(G.magnitudeSquared(e))};var v=new G;G.distance=function(e,t){return G.subtract(e,t,v),G.magnitude(v)},G.distanceSquared=function(e,t){return G.subtract(e,t,v),G.magnitudeSquared(v)},G.normalize=function(e,t){var n=G.magnitude(e);return t.x=e.x/n,t.y=e.y/n,t.z=e.z/n,t.w=e.w/n,t},G.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z+e.w*t.w},G.multiplyComponents=function(e,t,n){return n.x=e.x*t.x,n.y=e.y*t.y,n.z=e.z*t.z,n.w=e.w*t.w,n},G.divideComponents=function(e,t,n){return n.x=e.x/t.x,n.y=e.y/t.y,n.z=e.z/t.z,n.w=e.w/t.w,n},G.add=function(e,t,n){return n.x=e.x+t.x,n.y=e.y+t.y,n.z=e.z+t.z,n.w=e.w+t.w,n},G.subtract=function(e,t,n){return n.x=e.x-t.x,n.y=e.y-t.y,n.z=e.z-t.z,n.w=e.w-t.w,n},G.multiplyByScalar=function(e,t,n){return n.x=e.x*t,n.y=e.y*t,n.z=e.z*t,n.w=e.w*t,n},G.divideByScalar=function(e,t,n){return n.x=e.x/t,n.y=e.y/t,n.z=e.z/t,n.w=e.w/t,n},G.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=-e.w,t},G.abs=function(e,t){return t.x=Math.abs(e.x),t.y=Math.abs(e.y),t.z=Math.abs(e.z),t.w=Math.abs(e.w),t};var w=new G;G.lerp=function(e,t,n,r){return G.multiplyByScalar(t,n,w),r=G.multiplyByScalar(e,1-n,r),G.add(w,r,r)};var C=new G;G.mostOrthogonalAxis=function(e,t){var n=G.normalize(e,C);return G.abs(n,n),t=n.x<=n.y?n.x<=n.z?n.x<=n.w?G.clone(G.UNIT_X,t):G.clone(G.UNIT_W,t):n.z<=n.w?G.clone(G.UNIT_Z,t):G.clone(G.UNIT_W,t):n.y<=n.z?n.y<=n.w?G.clone(G.UNIT_Y,t):G.clone(G.UNIT_W,t):n.z<=n.w?G.clone(G.UNIT_Z,t):G.clone(G.UNIT_W,t)},G.equals=function(e,t){return e===t||I.defined(e)&&I.defined(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},G.equalsArray=function(e,t,n){return e.x===t[n]&&e.y===t[n+1]&&e.z===t[n+2]&&e.w===t[n+3]},G.equalsEpsilon=function(e,t,n,r){return e===t||I.defined(e)&&I.defined(t)&&Z.CesiumMath.equalsEpsilon(e.x,t.x,n,r)&&Z.CesiumMath.equalsEpsilon(e.y,t.y,n,r)&&Z.CesiumMath.equalsEpsilon(e.z,t.z,n,r)&&Z.CesiumMath.equalsEpsilon(e.w,t.w,n,r)},G.ZERO=t.freezeObject(new G(0,0,0,0)),G.UNIT_X=t.freezeObject(new G(1,0,0,0)),G.UNIT_Y=t.freezeObject(new G(0,1,0,0)),G.UNIT_Z=t.freezeObject(new G(0,0,1,0)),G.UNIT_W=t.freezeObject(new G(0,0,0,1)),G.prototype.clone=function(e){return G.clone(this,e)},G.prototype.equals=function(e){return G.equals(this,e)},G.prototype.equalsEpsilon=function(e,t,n){return G.equalsEpsilon(this,e,t,n)},G.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"};var g=new Float32Array(1),x=256;G.packFloat=function(e,t){if(I.defined(t)||(t=new G),g[0]=e,0===(e=g[0]))return G.clone(G.ZERO,t);var n,r=e<0?1:0;isFinite(e)?(e=Math.abs(e),n=Math.floor(Z.CesiumMath.logBase(e,10))+1,e/=Math.pow(10,n)):(e=.1,n=38);var a=e*x;return t.x=Math.floor(a),a=(a-t.x)*x,t.y=Math.floor(a),a=(a-t.y)*x,t.z=Math.floor(a),t.w=2*(n+38)+r,t},G.unpackFloat=function(e){var t=e.w/2,n=Math.floor(t),r=2*(t-n);if(r=-(r=2*r-1),38<=(n-=38))return r<0?Number.NEGATIVE_INFINITY:Number.POSITIVE_INFINITY;var a=r*e.x*.00390625;return a+=r*e.y*(1/65536),(a+=r*e.z*(1/16777216))*Math.pow(10,n)};var E={};function O(e,t){I.defined(E[e])||(E[e]=!0,console.warn(P.defaultValue(t,e)))}function _(e,t){O(e,t)}function Q(e,t,n,r,a,i,s,o,u,l,c,d,f,h,p,m){this[0]=P.defaultValue(e,0),this[1]=P.defaultValue(a,0),this[2]=P.defaultValue(u,0),this[3]=P.defaultValue(f,0),this[4]=P.defaultValue(t,0),this[5]=P.defaultValue(i,0),this[6]=P.defaultValue(l,0),this[7]=P.defaultValue(h,0),this[8]=P.defaultValue(n,0),this[9]=P.defaultValue(s,0),this[10]=P.defaultValue(c,0),this[11]=P.defaultValue(p,0),this[12]=P.defaultValue(r,0),this[13]=P.defaultValue(o,0),this[14]=P.defaultValue(d,0),this[15]=P.defaultValue(m,0)}O.geometryOutlines="Entity geometry outlines are unsupported on terrain. Outlines will be disabled. To enable outlines, disable geometry terrain clamping by explicitly setting height to 0.",O.geometryZIndex="Entity geometry with zIndex are unsupported when height or extrudedHeight are defined.  zIndex will be ignored",O.geometryHeightReference="Entity corridor, ellipse, polygon or rectangle with heightReference must also have a defined height.  heightReference will be ignored",O.geometryExtrudedHeightReference="Entity corridor, ellipse, polygon or rectangle with extrudedHeightReference must also have a defined extrudedHeight.  extrudedHeightReference will be ignored",Q.packedLength=16,Q.pack=function(e,t,n){return n=P.defaultValue(n,0),t[n++]=e[0],t[n++]=e[1],t[n++]=e[2],t[n++]=e[3],t[n++]=e[4],t[n++]=e[5],t[n++]=e[6],t[n++]=e[7],t[n++]=e[8],t[n++]=e[9],t[n++]=e[10],t[n++]=e[11],t[n++]=e[12],t[n++]=e[13],t[n++]=e[14],t[n]=e[15],t},Q.unpack=function(e,t,n){return t=P.defaultValue(t,0),I.defined(n)||(n=new Q),n[0]=e[t++],n[1]=e[t++],n[2]=e[t++],n[3]=e[t++],n[4]=e[t++],n[5]=e[t++],n[6]=e[t++],n[7]=e[t++],n[8]=e[t++],n[9]=e[t++],n[10]=e[t++],n[11]=e[t++],n[12]=e[t++],n[13]=e[t++],n[14]=e[t++],n[15]=e[t],n},Q.clone=function(e,t){if(I.defined(e))return I.defined(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):new Q(e[0],e[4],e[8],e[12],e[1],e[5],e[9],e[13],e[2],e[6],e[10],e[14],e[3],e[7],e[11],e[15])},Q.fromArray=Q.unpack,Q.fromColumnMajorArray=function(e,t){return Q.clone(e,t)},Q.fromRowMajorArray=function(e,t){return I.defined(t)?(t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=e[1],t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=e[2],t[9]=e[6],t[10]=e[10],t[11]=e[14],t[12]=e[3],t[13]=e[7],t[14]=e[11],t[15]=e[15],t):new Q(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15])},Q.fromRotationTranslation=function(e,t,n){return t=P.defaultValue(t,D.Cartesian3.ZERO),I.defined(n)?(n[0]=e[0],n[1]=e[1],n[2]=e[2],n[3]=0,n[4]=e[3],n[5]=e[4],n[6]=e[5],n[7]=0,n[8]=e[6],n[9]=e[7],n[10]=e[8],n[11]=0,n[12]=t.x,n[13]=t.y,n[14]=t.z,n[15]=1,n):new Q(e[0],e[3],e[6],t.x,e[1],e[4],e[7],t.y,e[2],e[5],e[8],t.z,0,0,0,1)},Q.fromTranslationQuaternionRotationScale=function(e,t,n,r){I.defined(r)||(r=new Q);var a=n.x,i=n.y,s=n.z,o=t.x*t.x,u=t.x*t.y,l=t.x*t.z,c=t.x*t.w,d=t.y*t.y,f=t.y*t.z,h=t.y*t.w,p=t.z*t.z,m=t.z*t.w,y=t.w*t.w,v=o-d-p+y,w=2*(u-m),C=2*(l+h),g=2*(u+m),x=d-o-p+y,E=2*(f-c),O=2*(l-h),_=2*(f+c),S=-o-d+p+y;return r[0]=v*a,r[1]=g*a,r[2]=O*a,r[3]=0,r[4]=w*i,r[5]=x*i,r[6]=_*i,r[7]=0,r[8]=C*s,r[9]=E*s,r[10]=S*s,r[11]=0,r[12]=e.x,r[13]=e.y,r[14]=e.z,r[15]=1,r},Q.fromTranslationRotationScale=function(e,t){return Q.fromTranslationQuaternionRotationScale(e.translation,e.rotation,e.scale,t)},Q.fromTranslation=function(e,t){return Q.fromRotationTranslation(X.IDENTITY,e,t)},Q.fromScale=function(e,t){return I.defined(t)?(t[0]=e.x,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e.y,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e.z,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new Q(e.x,0,0,0,0,e.y,0,0,0,0,e.z,0,0,0,0,1)},Q.fromUniformScale=function(e,t){return I.defined(t)?(t[0]=e,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=e,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=e,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,t):new Q(e,0,0,0,0,e,0,0,0,0,e,0,0,0,0,1)};var S=new D.Cartesian3,b=new D.Cartesian3,M=new D.Cartesian3;Q.fromCamera=function(e,t){var n=e.position,r=e.direction,a=e.up;D.Cartesian3.normalize(r,S),D.Cartesian3.normalize(D.Cartesian3.cross(S,a,b),b),D.Cartesian3.normalize(D.Cartesian3.cross(b,S,M),M);var i=b.x,s=b.y,o=b.z,u=S.x,l=S.y,c=S.z,d=M.x,f=M.y,h=M.z,p=n.x,m=n.y,y=n.z,v=i*-p+s*-m+o*-y,w=d*-p+f*-m+h*-y,C=u*p+l*m+c*y;return I.defined(t)?(t[0]=i,t[1]=d,t[2]=-u,t[3]=0,t[4]=s,t[5]=f,t[6]=-l,t[7]=0,t[8]=o,t[9]=h,t[10]=-c,t[11]=0,t[12]=v,t[13]=w,t[14]=C,t[15]=1,t):new Q(i,s,o,v,d,f,h,w,-u,-l,-c,C,0,0,0,1)},Q.computePerspectiveFieldOfView=function(e,t,n,r,a){var i=1/Math.tan(.5*e),s=i/t,o=(r+n)/(n-r),u=2*r*n/(n-r);return a[0]=s,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=i,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=o,a[11]=-1,a[12]=0,a[13]=0,a[14]=u,a[15]=0,a},Q.computeOrthographicOffCenter=function(e,t,n,r,a,i,s){var o=1/(t-e),u=1/(r-n),l=1/(i-a),c=-(t+e)*o,d=-(r+n)*u,f=-(i+a)*l;return o*=2,u*=2,l*=-2,s[0]=o,s[1]=0,s[2]=0,s[3]=0,s[4]=0,s[5]=u,s[6]=0,s[7]=0,s[8]=0,s[9]=0,s[10]=l,s[11]=0,s[12]=c,s[13]=d,s[14]=f,s[15]=1,s},Q.computePerspectiveOffCenter=function(e,t,n,r,a,i,s){var o=2*a/(t-e),u=2*a/(r-n),l=(t+e)/(t-e),c=(r+n)/(r-n),d=-(i+a)/(i-a),f=-2*i*a/(i-a);return s[0]=o,s[1]=0,s[2]=0,s[3]=0,s[4]=0,s[5]=u,s[6]=0,s[7]=0,s[8]=l,s[9]=c,s[10]=d,s[11]=-1,s[12]=0,s[13]=0,s[14]=f,s[15]=0,s},Q.computeInfinitePerspectiveOffCenter=function(e,t,n,r,a,i){var s=2*a/(t-e),o=2*a/(r-n),u=(t+e)/(t-e),l=(r+n)/(r-n),c=-2*a;return i[0]=s,i[1]=0,i[2]=0,i[3]=0,i[4]=0,i[5]=o,i[6]=0,i[7]=0,i[8]=u,i[9]=l,i[10]=-1,i[11]=-1,i[12]=0,i[13]=0,i[14]=c,i[15]=0,i},Q.computeViewportTransformation=function(e,t,n,r){e=P.defaultValue(e,P.defaultValue.EMPTY_OBJECT);var a=P.defaultValue(e.x,0),i=P.defaultValue(e.y,0),s=P.defaultValue(e.width,0),o=P.defaultValue(e.height,0);t=P.defaultValue(t,0);var u=.5*s,l=.5*o,c=.5*((n=P.defaultValue(n,1))-t),d=u,f=l,h=c,p=a+u,m=i+l,y=t+c;return r[0]=d,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=f,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=h,r[11]=0,r[12]=p,r[13]=m,r[14]=y,r[15]=1,r},Q.computeView=function(e,t,n,r,a){return a[0]=r.x,a[1]=n.x,a[2]=-t.x,a[3]=0,a[4]=r.y,a[5]=n.y,a[6]=-t.y,a[7]=0,a[8]=r.z,a[9]=n.z,a[10]=-t.z,a[11]=0,a[12]=-D.Cartesian3.dot(r,e),a[13]=-D.Cartesian3.dot(n,e),a[14]=D.Cartesian3.dot(t,e),a[15]=1,a},Q.toArray=function(e,t){return I.defined(t)?(t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[3],t[4]=e[4],t[5]=e[5],t[6]=e[6],t[7]=e[7],t[8]=e[8],t[9]=e[9],t[10]=e[10],t[11]=e[11],t[12]=e[12],t[13]=e[13],t[14]=e[14],t[15]=e[15],t):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]]},Q.getElementIndex=function(e,t){return 4*e+t},Q.getColumn=function(e,t,n){var r=4*t,a=e[r],i=e[1+r],s=e[2+r],o=e[3+r];return n.x=a,n.y=i,n.z=s,n.w=o,n},Q.setColumn=function(e,t,n,r){var a=4*t;return(r=Q.clone(e,r))[a]=n.x,r[1+a]=n.y,r[2+a]=n.z,r[3+a]=n.w,r},Q.setTranslation=function(e,t,n){return n[0]=e[0],n[1]=e[1],n[2]=e[2],n[3]=e[3],n[4]=e[4],n[5]=e[5],n[6]=e[6],n[7]=e[7],n[8]=e[8],n[9]=e[9],n[10]=e[10],n[11]=e[11],n[12]=t.x,n[13]=t.y,n[14]=t.z,n[15]=e[15],n};var R=new D.Cartesian3;Q.setScale=function(e,t,n){var r=Q.getScale(e,R),a=D.Cartesian3.divideComponents(t,r,R);return Q.multiplyByScale(e,a,n)},Q.getRow=function(e,t,n){var r=e[t],a=e[t+4],i=e[t+8],s=e[t+12];return n.x=r,n.y=a,n.z=i,n.w=s,n},Q.setRow=function(e,t,n,r){return(r=Q.clone(e,r))[t]=n.x,r[t+4]=n.y,r[t+8]=n.z,r[t+12]=n.w,r};var A=new D.Cartesian3;Q.getScale=function(e,t){return t.x=D.Cartesian3.magnitude(D.Cartesian3.fromElements(e[0],e[1],e[2],A)),t.y=D.Cartesian3.magnitude(D.Cartesian3.fromElements(e[4],e[5],e[6],A)),t.z=D.Cartesian3.magnitude(D.Cartesian3.fromElements(e[8],e[9],e[10],A)),t};var T=new D.Cartesian3;Q.getMaximumScale=function(e){return Q.getScale(e,T),D.Cartesian3.maximumComponent(T)},Q.multiply=function(e,t,n){var r=e[0],a=e[1],i=e[2],s=e[3],o=e[4],u=e[5],l=e[6],c=e[7],d=e[8],f=e[9],h=e[10],p=e[11],m=e[12],y=e[13],v=e[14],w=e[15],C=t[0],g=t[1],x=t[2],E=t[3],O=t[4],_=t[5],S=t[6],b=t[7],M=t[8],R=t[9],A=t[10],T=t[11],z=t[12],q=t[13],I=t[14],P=t[15],D=r*C+o*g+d*x+m*E,N=a*C+u*g+f*x+y*E,U=i*C+l*g+h*x+v*E,F=s*C+c*g+p*x+w*E,V=r*O+o*_+d*S+m*b,L=a*O+u*_+f*S+y*b,B=i*O+l*_+h*S+v*b,W=s*O+c*_+p*S+w*b,j=r*M+o*R+d*A+m*T,k=a*M+u*R+f*A+y*T,Y=i*M+l*R+h*A+v*T,H=s*M+c*R+p*A+w*T,Z=r*z+o*q+d*I+m*P,J=a*z+u*q+f*I+y*P,X=i*z+l*q+h*I+v*P,G=s*z+c*q+p*I+w*P;return n[0]=D,n[1]=N,n[2]=U,n[3]=F,n[4]=V,n[5]=L,n[6]=B,n[7]=W,n[8]=j,n[9]=k,n[10]=Y,n[11]=H,n[12]=Z,n[13]=J,n[14]=X,n[15]=G,n},Q.add=function(e,t,n){return n[0]=e[0]+t[0],n[1]=e[1]+t[1],n[2]=e[2]+t[2],n[3]=e[3]+t[3],n[4]=e[4]+t[4],n[5]=e[5]+t[5],n[6]=e[6]+t[6],n[7]=e[7]+t[7],n[8]=e[8]+t[8],n[9]=e[9]+t[9],n[10]=e[10]+t[10],n[11]=e[11]+t[11],n[12]=e[12]+t[12],n[13]=e[13]+t[13],n[14]=e[14]+t[14],n[15]=e[15]+t[15],n},Q.subtract=function(e,t,n){return n[0]=e[0]-t[0],n[1]=e[1]-t[1],n[2]=e[2]-t[2],n[3]=e[3]-t[3],n[4]=e[4]-t[4],n[5]=e[5]-t[5],n[6]=e[6]-t[6],n[7]=e[7]-t[7],n[8]=e[8]-t[8],n[9]=e[9]-t[9],n[10]=e[10]-t[10],n[11]=e[11]-t[11],n[12]=e[12]-t[12],n[13]=e[13]-t[13],n[14]=e[14]-t[14],n[15]=e[15]-t[15],n},Q.multiplyTransformation=function(e,t,n){var r=e[0],a=e[1],i=e[2],s=e[4],o=e[5],u=e[6],l=e[8],c=e[9],d=e[10],f=e[12],h=e[13],p=e[14],m=t[0],y=t[1],v=t[2],w=t[4],C=t[5],g=t[6],x=t[8],E=t[9],O=t[10],_=t[12],S=t[13],b=t[14],M=r*m+s*y+l*v,R=a*m+o*y+c*v,A=i*m+u*y+d*v,T=r*w+s*C+l*g,z=a*w+o*C+c*g,q=i*w+u*C+d*g,I=r*x+s*E+l*O,P=a*x+o*E+c*O,D=i*x+u*E+d*O,N=r*_+s*S+l*b+f,U=a*_+o*S+c*b+h,F=i*_+u*S+d*b+p;return n[0]=M,n[1]=R,n[2]=A,n[3]=0,n[4]=T,n[5]=z,n[6]=q,n[7]=0,n[8]=I,n[9]=P,n[10]=D,n[11]=0,n[12]=N,n[13]=U,n[14]=F,n[15]=1,n},Q.multiplyByMatrix3=function(e,t,n){var r=e[0],a=e[1],i=e[2],s=e[4],o=e[5],u=e[6],l=e[8],c=e[9],d=e[10],f=t[0],h=t[1],p=t[2],m=t[3],y=t[4],v=t[5],w=t[6],C=t[7],g=t[8],x=r*f+s*h+l*p,E=a*f+o*h+c*p,O=i*f+u*h+d*p,_=r*m+s*y+l*v,S=a*m+o*y+c*v,b=i*m+u*y+d*v,M=r*w+s*C+l*g,R=a*w+o*C+c*g,A=i*w+u*C+d*g;return n[0]=x,n[1]=E,n[2]=O,n[3]=0,n[4]=_,n[5]=S,n[6]=b,n[7]=0,n[8]=M,n[9]=R,n[10]=A,n[11]=0,n[12]=e[12],n[13]=e[13],n[14]=e[14],n[15]=e[15],n},Q.multiplyByTranslation=function(e,t,n){var r=t.x,a=t.y,i=t.z,s=r*e[0]+a*e[4]+i*e[8]+e[12],o=r*e[1]+a*e[5]+i*e[9]+e[13],u=r*e[2]+a*e[6]+i*e[10]+e[14];return n[0]=e[0],n[1]=e[1],n[2]=e[2],n[3]=e[3],n[4]=e[4],n[5]=e[5],n[6]=e[6],n[7]=e[7],n[8]=e[8],n[9]=e[9],n[10]=e[10],n[11]=e[11],n[12]=s,n[13]=o,n[14]=u,n[15]=e[15],n};var z=new D.Cartesian3;Q.multiplyByUniformScale=function(e,t,n){return z.x=t,z.y=t,z.z=t,Q.multiplyByScale(e,z,n)},Q.multiplyByScale=function(e,t,n){var r=t.x,a=t.y,i=t.z;return 1===r&&1===a&&1===i?Q.clone(e,n):(n[0]=r*e[0],n[1]=r*e[1],n[2]=r*e[2],n[3]=0,n[4]=a*e[4],n[5]=a*e[5],n[6]=a*e[6],n[7]=0,n[8]=i*e[8],n[9]=i*e[9],n[10]=i*e[10],n[11]=0,n[12]=e[12],n[13]=e[13],n[14]=e[14],n[15]=1,n)},Q.multiplyByVector=function(e,t,n){var r=t.x,a=t.y,i=t.z,s=t.w,o=e[0]*r+e[4]*a+e[8]*i+e[12]*s,u=e[1]*r+e[5]*a+e[9]*i+e[13]*s,l=e[2]*r+e[6]*a+e[10]*i+e[14]*s,c=e[3]*r+e[7]*a+e[11]*i+e[15]*s;return n.x=o,n.y=u,n.z=l,n.w=c,n},Q.multiplyByPointAsVector=function(e,t,n){var r=t.x,a=t.y,i=t.z,s=e[0]*r+e[4]*a+e[8]*i,o=e[1]*r+e[5]*a+e[9]*i,u=e[2]*r+e[6]*a+e[10]*i;return n.x=s,n.y=o,n.z=u,n},Q.multiplyByPoint=function(e,t,n){var r=t.x,a=t.y,i=t.z,s=e[0]*r+e[4]*a+e[8]*i+e[12],o=e[1]*r+e[5]*a+e[9]*i+e[13],u=e[2]*r+e[6]*a+e[10]*i+e[14];return n.x=s,n.y=o,n.z=u,n},Q.multiplyByScalar=function(e,t,n){return n[0]=e[0]*t,n[1]=e[1]*t,n[2]=e[2]*t,n[3]=e[3]*t,n[4]=e[4]*t,n[5]=e[5]*t,n[6]=e[6]*t,n[7]=e[7]*t,n[8]=e[8]*t,n[9]=e[9]*t,n[10]=e[10]*t,n[11]=e[11]*t,n[12]=e[12]*t,n[13]=e[13]*t,n[14]=e[14]*t,n[15]=e[15]*t,n},Q.negate=function(e,t){return t[0]=-e[0],t[1]=-e[1],t[2]=-e[2],t[3]=-e[3],t[4]=-e[4],t[5]=-e[5],t[6]=-e[6],t[7]=-e[7],t[8]=-e[8],t[9]=-e[9],t[10]=-e[10],t[11]=-e[11],t[12]=-e[12],t[13]=-e[13],t[14]=-e[14],t[15]=-e[15],t},Q.transpose=function(e,t){var n=e[1],r=e[2],a=e[3],i=e[6],s=e[7],o=e[11];return t[0]=e[0],t[1]=e[4],t[2]=e[8],t[3]=e[12],t[4]=n,t[5]=e[5],t[6]=e[9],t[7]=e[13],t[8]=r,t[9]=i,t[10]=e[10],t[11]=e[14],t[12]=a,t[13]=s,t[14]=o,t[15]=e[15],t},Q.abs=function(e,t){return t[0]=Math.abs(e[0]),t[1]=Math.abs(e[1]),t[2]=Math.abs(e[2]),t[3]=Math.abs(e[3]),t[4]=Math.abs(e[4]),t[5]=Math.abs(e[5]),t[6]=Math.abs(e[6]),t[7]=Math.abs(e[7]),t[8]=Math.abs(e[8]),t[9]=Math.abs(e[9]),t[10]=Math.abs(e[10]),t[11]=Math.abs(e[11]),t[12]=Math.abs(e[12]),t[13]=Math.abs(e[13]),t[14]=Math.abs(e[14]),t[15]=Math.abs(e[15]),t},Q.equals=function(e,t){return e===t||I.defined(e)&&I.defined(t)&&e[12]===t[12]&&e[13]===t[13]&&e[14]===t[14]&&e[0]===t[0]&&e[1]===t[1]&&e[2]===t[2]&&e[4]===t[4]&&e[5]===t[5]&&e[6]===t[6]&&e[8]===t[8]&&e[9]===t[9]&&e[10]===t[10]&&e[3]===t[3]&&e[7]===t[7]&&e[11]===t[11]&&e[15]===t[15]},Q.equalsEpsilon=function(e,t,n){return e===t||I.defined(e)&&I.defined(t)&&Math.abs(e[0]-t[0])<=n&&Math.abs(e[1]-t[1])<=n&&Math.abs(e[2]-t[2])<=n&&Math.abs(e[3]-t[3])<=n&&Math.abs(e[4]-t[4])<=n&&Math.abs(e[5]-t[5])<=n&&Math.abs(e[6]-t[6])<=n&&Math.abs(e[7]-t[7])<=n&&Math.abs(e[8]-t[8])<=n&&Math.abs(e[9]-t[9])<=n&&Math.abs(e[10]-t[10])<=n&&Math.abs(e[11]-t[11])<=n&&Math.abs(e[12]-t[12])<=n&&Math.abs(e[13]-t[13])<=n&&Math.abs(e[14]-t[14])<=n&&Math.abs(e[15]-t[15])<=n},Q.getTranslation=function(e,t){return t.x=e[12],t.y=e[13],t.z=e[14],t},Q.getRotation=function(e,t){return _("Matrix4.getRotation","Matrix4.getRotation is deprecated and will be removed in Cesium 1.65. Use Matrix4.getMatrix3 instead."),Q.getMatrix3(e,t)},Q.getMatrix3=function(e,t){return t[0]=e[0],t[1]=e[1],t[2]=e[2],t[3]=e[4],t[4]=e[5],t[5]=e[6],t[6]=e[8],t[7]=e[9],t[8]=e[10],t};var K=new X,$=new X,ee=new G,te=new G(0,0,0,1);function N(e,t){this.center=D.Cartesian3.clone(P.defaultValue(e,D.Cartesian3.ZERO)),this.radius=P.defaultValue(t,0)}Q.inverse=function(e,t){var n=e[0],r=e[4],a=e[8],i=e[12],s=e[1],o=e[5],u=e[9],l=e[13],c=e[2],d=e[6],f=e[10],h=e[14],p=e[3],m=e[7],y=e[11],v=e[15],w=f*v,C=h*y,g=d*v,x=h*m,E=d*y,O=f*m,_=c*v,S=h*p,b=c*y,M=f*p,R=c*m,A=d*p,T=w*o+x*u+E*l-(C*o+g*u+O*l),z=C*s+_*u+M*l-(w*s+S*u+b*l),q=g*s+S*o+R*l-(x*s+_*o+A*l),I=O*s+b*o+A*u-(E*s+M*o+R*u),P=C*r+g*a+O*i-(w*r+x*a+E*i),D=w*n+S*a+b*i-(C*n+_*a+M*i),N=x*n+_*r+A*i-(g*n+S*r+R*i),U=E*n+M*r+R*a-(O*n+b*r+A*a),F=(w=a*l)*m+(x=i*o)*y+(E=r*u)*v-((C=i*u)*m+(g=r*l)*y+(O=a*o)*v),V=C*p+(_=n*l)*y+(M=a*s)*v-(w*p+(S=i*s)*y+(b=n*u)*v),L=g*p+S*m+(R=n*o)*v-(x*p+_*m+(A=r*s)*v),B=O*p+b*m+A*y-(E*p+M*m+R*y),W=g*f+O*h+C*d-(E*h+w*d+x*f),j=b*h+w*c+S*f-(_*f+M*h+C*c),k=_*d+A*h+x*c-(R*h+g*c+S*d),Y=R*f+E*c+M*d-(b*d+A*f+O*c),H=n*T+r*z+a*q+i*I;if(Math.abs(H)<Z.CesiumMath.EPSILON21){if(X.equalsEpsilon(Q.getMatrix3(e,K),$,Z.CesiumMath.EPSILON7)&&G.equals(Q.getRow(e,3,ee),te))return t[0]=0,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=0,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=0,t[11]=0,t[12]=-e[12],t[13]=-e[13],t[14]=-e[14],t[15]=1,t;throw new J.RuntimeError("matrix is not invertible because its determinate is zero.")}return H=1/H,t[0]=T*H,t[1]=z*H,t[2]=q*H,t[3]=I*H,t[4]=P*H,t[5]=D*H,t[6]=N*H,t[7]=U*H,t[8]=F*H,t[9]=V*H,t[10]=L*H,t[11]=B*H,t[12]=W*H,t[13]=j*H,t[14]=k*H,t[15]=Y*H,t},Q.inverseTransformation=function(e,t){var n=e[0],r=e[1],a=e[2],i=e[4],s=e[5],o=e[6],u=e[8],l=e[9],c=e[10],d=e[12],f=e[13],h=e[14],p=-n*d-r*f-a*h,m=-i*d-s*f-o*h,y=-u*d-l*f-c*h;return t[0]=n,t[1]=i,t[2]=u,t[3]=0,t[4]=r,t[5]=s,t[6]=l,t[7]=0,t[8]=a,t[9]=o,t[10]=c,t[11]=0,t[12]=p,t[13]=m,t[14]=y,t[15]=1,t},Q.IDENTITY=t.freezeObject(new Q(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1)),Q.ZERO=t.freezeObject(new Q(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0)),Q.COLUMN0ROW0=0,Q.COLUMN0ROW1=1,Q.COLUMN0ROW2=2,Q.COLUMN0ROW3=3,Q.COLUMN1ROW0=4,Q.COLUMN1ROW1=5,Q.COLUMN1ROW2=6,Q.COLUMN1ROW3=7,Q.COLUMN2ROW0=8,Q.COLUMN2ROW1=9,Q.COLUMN2ROW2=10,Q.COLUMN2ROW3=11,Q.COLUMN3ROW0=12,Q.COLUMN3ROW1=13,Q.COLUMN3ROW2=14,Q.COLUMN3ROW3=15,r.defineProperties(Q.prototype,{length:{get:function(){return Q.packedLength}}}),Q.prototype.clone=function(e){return Q.clone(this,e)},Q.prototype.equals=function(e){return Q.equals(this,e)},Q.equalsArray=function(e,t,n){return e[0]===t[n]&&e[1]===t[n+1]&&e[2]===t[n+2]&&e[3]===t[n+3]&&e[4]===t[n+4]&&e[5]===t[n+5]&&e[6]===t[n+6]&&e[7]===t[n+7]&&e[8]===t[n+8]&&e[9]===t[n+9]&&e[10]===t[n+10]&&e[11]===t[n+11]&&e[12]===t[n+12]&&e[13]===t[n+13]&&e[14]===t[n+14]&&e[15]===t[n+15]},Q.prototype.equalsEpsilon=function(e,t){return Q.equalsEpsilon(this,e,t)},Q.prototype.toString=function(){return"("+this[0]+", "+this[4]+", "+this[8]+", "+this[12]+")\n("+this[1]+", "+this[5]+", "+this[9]+", "+this[13]+")\n("+this[2]+", "+this[6]+", "+this[10]+", "+this[14]+")\n("+this[3]+", "+this[7]+", "+this[11]+", "+this[15]+")"};var U=new D.Cartesian3,F=new D.Cartesian3,V=new D.Cartesian3,L=new D.Cartesian3,B=new D.Cartesian3,W=new D.Cartesian3,j=new D.Cartesian3,k=new D.Cartesian3,Y=new D.Cartesian3,H=new D.Cartesian3,ne=new D.Cartesian3,re=new D.Cartesian3,q=4/3*Z.CesiumMath.PI;N.fromPoints=function(e,t){if(I.defined(t)||(t=new N),!I.defined(e)||0===e.length)return t.center=D.Cartesian3.clone(D.Cartesian3.ZERO,t.center),t.radius=0,t;var n,r=D.Cartesian3.clone(e[0],j),a=D.Cartesian3.clone(r,U),i=D.Cartesian3.clone(r,F),s=D.Cartesian3.clone(r,V),o=D.Cartesian3.clone(r,L),u=D.Cartesian3.clone(r,B),l=D.Cartesian3.clone(r,W),c=e.length;for(n=1;n<c;n++){D.Cartesian3.clone(e[n],r);var d=r.x,f=r.y,h=r.z;d<a.x&&D.Cartesian3.clone(r,a),d>o.x&&D.Cartesian3.clone(r,o),f<i.y&&D.Cartesian3.clone(r,i),f>u.y&&D.Cartesian3.clone(r,u),h<s.z&&D.Cartesian3.clone(r,s),h>l.z&&D.Cartesian3.clone(r,l)}var p=D.Cartesian3.magnitudeSquared(D.Cartesian3.subtract(o,a,k)),m=D.Cartesian3.magnitudeSquared(D.Cartesian3.subtract(u,i,k)),y=D.Cartesian3.magnitudeSquared(D.Cartesian3.subtract(l,s,k)),v=a,w=o,C=p;C<m&&(C=m,v=i,w=u),C<y&&(C=y,v=s,w=l);var g=Y;g.x=.5*(v.x+w.x),g.y=.5*(v.y+w.y),g.z=.5*(v.z+w.z);var x=D.Cartesian3.magnitudeSquared(D.Cartesian3.subtract(w,g,k)),E=Math.sqrt(x),O=H;O.x=a.x,O.y=i.y,O.z=s.z;var _=ne;_.x=o.x,_.y=u.y,_.z=l.z;var S=D.Cartesian3.midpoint(O,_,re),b=0;for(n=0;n<c;n++){D.Cartesian3.clone(e[n],r);var M=D.Cartesian3.magnitude(D.Cartesian3.subtract(r,S,k));b<M&&(b=M);var R=D.Cartesian3.magnitudeSquared(D.Cartesian3.subtract(r,g,k));if(x<R){var A=Math.sqrt(R);x=(E=.5*(E+A))*E;var T=A-E;g.x=(E*g.x+T*r.x)/A,g.y=(E*g.y+T*r.y)/A,g.z=(E*g.z+T*r.z)/A}}return E<b?(D.Cartesian3.clone(g,t.center),t.radius=E):(D.Cartesian3.clone(S,t.center),t.radius=b),t};var ae=new a,ie=new D.Cartesian3,se=new D.Cartesian3,oe=new D.Cartographic,ue=new D.Cartographic;N.fromRectangle2D=function(e,t,n){return N.fromRectangleWithHeights2D(e,t,0,0,n)},N.fromRectangleWithHeights2D=function(e,t,n,r,a){if(I.defined(a)||(a=new N),!I.defined(e))return a.center=D.Cartesian3.clone(D.Cartesian3.ZERO,a.center),a.radius=0,a;t=P.defaultValue(t,ae),D.Rectangle.southwest(e,oe),oe.height=n,D.Rectangle.northeast(e,ue),ue.height=r;var i=t.project(oe,ie),s=t.project(ue,se),o=s.x-i.x,u=s.y-i.y,l=s.z-i.z;a.radius=.5*Math.sqrt(o*o+u*u+l*l);var c=a.center;return c.x=i.x+.5*o,c.y=i.y+.5*u,c.z=i.z+.5*l,a};var le=[];N.fromRectangle3D=function(e,t,n,r){if(t=P.defaultValue(t,D.Ellipsoid.WGS84),n=P.defaultValue(n,0),I.defined(r)||(r=new N),!I.defined(e))return r.center=D.Cartesian3.clone(D.Cartesian3.ZERO,r.center),r.radius=0,r;var a=D.Rectangle.subsample(e,t,n,le);return N.fromPoints(a,r)},N.fromVertices=function(e,t,n,r){if(I.defined(r)||(r=new N),!I.defined(e)||0===e.length)return r.center=D.Cartesian3.clone(D.Cartesian3.ZERO,r.center),r.radius=0,r;t=P.defaultValue(t,D.Cartesian3.ZERO),n=P.defaultValue(n,3);var a=j;a.x=e[0]+t.x,a.y=e[1]+t.y,a.z=e[2]+t.z;var i,s=D.Cartesian3.clone(a,U),o=D.Cartesian3.clone(a,F),u=D.Cartesian3.clone(a,V),l=D.Cartesian3.clone(a,L),c=D.Cartesian3.clone(a,B),d=D.Cartesian3.clone(a,W),f=e.length;for(i=0;i<f;i+=n){var h=e[i]+t.x,p=e[i+1]+t.y,m=e[i+2]+t.z;a.x=h,a.y=p,a.z=m,h<s.x&&D.Cartesian3.clone(a,s),h>l.x&&D.Cartesian3.clone(a,l),p<o.y&&D.Cartesian3.clone(a,o),p>c.y&&D.Cartesian3.clone(a,c),m<u.z&&D.Cartesian3.clone(a,u),m>d.z&&D.Cartesian3.clone(a,d)}var y=D.Cartesian3.magnitudeSquared(D.Cartesian3.subtract(l,s,k)),v=D.Cartesian3.magnitudeSquared(D.Cartesian3.subtract(c,o,k)),w=D.Cartesian3.magnitudeSquared(D.Cartesian3.subtract(d,u,k)),C=s,g=l,x=y;x<v&&(x=v,C=o,g=c),x<w&&(x=w,C=u,g=d);var E=Y;E.x=.5*(C.x+g.x),E.y=.5*(C.y+g.y),E.z=.5*(C.z+g.z);var O=D.Cartesian3.magnitudeSquared(D.Cartesian3.subtract(g,E,k)),_=Math.sqrt(O),S=H;S.x=s.x,S.y=o.y,S.z=u.z;var b=ne;b.x=l.x,b.y=c.y,b.z=d.z;var M=D.Cartesian3.midpoint(S,b,re),R=0;for(i=0;i<f;i+=n){a.x=e[i]+t.x,a.y=e[i+1]+t.y,a.z=e[i+2]+t.z;var A=D.Cartesian3.magnitude(D.Cartesian3.subtract(a,M,k));R<A&&(R=A);var T=D.Cartesian3.magnitudeSquared(D.Cartesian3.subtract(a,E,k));if(O<T){var z=Math.sqrt(T);O=(_=.5*(_+z))*_;var q=z-_;E.x=(_*E.x+q*a.x)/z,E.y=(_*E.y+q*a.y)/z,E.z=(_*E.z+q*a.z)/z}}return _<R?(D.Cartesian3.clone(E,r.center),r.radius=_):(D.Cartesian3.clone(M,r.center),r.radius=R),r},N.fromEncodedCartesianVertices=function(e,t,n){if(I.defined(n)||(n=new N),!I.defined(e)||!I.defined(t)||e.length!==t.length||0===e.length)return n.center=D.Cartesian3.clone(D.Cartesian3.ZERO,n.center),n.radius=0,n;var r=j;r.x=e[0]+t[0],r.y=e[1]+t[1],r.z=e[2]+t[2];var a,i=D.Cartesian3.clone(r,U),s=D.Cartesian3.clone(r,F),o=D.Cartesian3.clone(r,V),u=D.Cartesian3.clone(r,L),l=D.Cartesian3.clone(r,B),c=D.Cartesian3.clone(r,W),d=e.length;for(a=0;a<d;a+=3){var f=e[a]+t[a],h=e[a+1]+t[a+1],p=e[a+2]+t[a+2];r.x=f,r.y=h,r.z=p,f<i.x&&D.Cartesian3.clone(r,i),f>u.x&&D.Cartesian3.clone(r,u),h<s.y&&D.Cartesian3.clone(r,s),h>l.y&&D.Cartesian3.clone(r,l),p<o.z&&D.Cartesian3.clone(r,o),p>c.z&&D.Cartesian3.clone(r,c)}var m=D.Cartesian3.magnitudeSquared(D.Cartesian3.subtract(u,i,k)),y=D.Cartesian3.magnitudeSquared(D.Cartesian3.subtract(l,s,k)),v=D.Cartesian3.magnitudeSquared(D.Cartesian3.subtract(c,o,k)),w=i,C=u,g=m;g<y&&(g=y,w=s,C=l),g<v&&(g=v,w=o,C=c);var x=Y;x.x=.5*(w.x+C.x),x.y=.5*(w.y+C.y),x.z=.5*(w.z+C.z);var E=D.Cartesian3.magnitudeSquared(D.Cartesian3.subtract(C,x,k)),O=Math.sqrt(E),_=H;_.x=i.x,_.y=s.y,_.z=o.z;var S=ne;S.x=u.x,S.y=l.y,S.z=c.z;var b=D.Cartesian3.midpoint(_,S,re),M=0;for(a=0;a<d;a+=3){r.x=e[a]+t[a],r.y=e[a+1]+t[a+1],r.z=e[a+2]+t[a+2];var R=D.Cartesian3.magnitude(D.Cartesian3.subtract(r,b,k));M<R&&(M=R);var A=D.Cartesian3.magnitudeSquared(D.Cartesian3.subtract(r,x,k));if(E<A){var T=Math.sqrt(A);E=(O=.5*(O+T))*O;var z=T-O;x.x=(O*x.x+z*r.x)/T,x.y=(O*x.y+z*r.y)/T,x.z=(O*x.z+z*r.z)/T}}return O<M?(D.Cartesian3.clone(x,n.center),n.radius=O):(D.Cartesian3.clone(b,n.center),n.radius=M),n},N.fromCornerPoints=function(e,t,n){I.defined(n)||(n=new N);var r=D.Cartesian3.midpoint(e,t,n.center);return n.radius=D.Cartesian3.distance(r,t),n},N.fromEllipsoid=function(e,t){return I.defined(t)||(t=new N),D.Cartesian3.clone(D.Cartesian3.ZERO,t.center),t.radius=e.maximumRadius,t};var ce=new D.Cartesian3;N.fromBoundingSpheres=function(e,t){if(I.defined(t)||(t=new N),!I.defined(e)||0===e.length)return t.center=D.Cartesian3.clone(D.Cartesian3.ZERO,t.center),t.radius=0,t;var n=e.length;if(1===n)return N.clone(e[0],t);if(2===n)return N.union(e[0],e[1],t);var r,a=[];for(r=0;r<n;r++)a.push(e[r].center);var i=(t=N.fromPoints(a,t)).center,s=t.radius;for(r=0;r<n;r++){var o=e[r];s=Math.max(s,D.Cartesian3.distance(i,o.center,ce)+o.radius)}return t.radius=s,t};var de=new D.Cartesian3,fe=new D.Cartesian3,he=new D.Cartesian3;N.fromOrientedBoundingBox=function(e,t){I.defined(t)||(t=new N);var n=e.halfAxes,r=X.getColumn(n,0,de),a=X.getColumn(n,1,fe),i=X.getColumn(n,2,he);return D.Cartesian3.add(r,a,r),D.Cartesian3.add(r,i,r),t.center=D.Cartesian3.clone(e.center,t.center),t.radius=D.Cartesian3.magnitude(r),t},N.clone=function(e,t){if(I.defined(e))return I.defined(t)?(t.center=D.Cartesian3.clone(e.center,t.center),t.radius=e.radius,t):new N(e.center,e.radius)},N.packedLength=4,N.pack=function(e,t,n){n=P.defaultValue(n,0);var r=e.center;return t[n++]=r.x,t[n++]=r.y,t[n++]=r.z,t[n]=e.radius,t},N.unpack=function(e,t,n){t=P.defaultValue(t,0),I.defined(n)||(n=new N);var r=n.center;return r.x=e[t++],r.y=e[t++],r.z=e[t++],n.radius=e[t],n};var pe=new D.Cartesian3,me=new D.Cartesian3;N.union=function(e,t,n){I.defined(n)||(n=new N);var r=e.center,a=e.radius,i=t.center,s=t.radius,o=D.Cartesian3.subtract(i,r,pe),u=D.Cartesian3.magnitude(o);if(u+s<=a)return e.clone(n),n;if(u+a<=s)return t.clone(n),n;var l=.5*(a+u+s),c=D.Cartesian3.multiplyByScalar(o,(l-a)/u,me);return D.Cartesian3.add(c,r,c),D.Cartesian3.clone(c,n.center),n.radius=l,n};var ye=new D.Cartesian3;N.expand=function(e,t,n){n=N.clone(e,n);var r=D.Cartesian3.magnitude(D.Cartesian3.subtract(t,n.center,ye));return r>n.radius&&(n.radius=r),n},N.intersectPlane=function(e,t){var n=e.center,r=e.radius,a=t.normal,i=D.Cartesian3.dot(a,n)+t.distance;return i<-r?s.OUTSIDE:i<r?s.INTERSECTING:s.INSIDE},N.transform=function(e,t,n){return I.defined(n)||(n=new N),n.center=Q.multiplyByPoint(t,e.center,n.center),n.radius=Q.getMaximumScale(t)*e.radius,n};var ve=new D.Cartesian3;N.distanceSquaredTo=function(e,t){var n=D.Cartesian3.subtract(e.center,t,ve);return D.Cartesian3.magnitudeSquared(n)-e.radius*e.radius},N.transformWithoutScale=function(e,t,n){return I.defined(n)||(n=new N),n.center=Q.multiplyByPoint(t,e.center,n.center),n.radius=e.radius,n};var we=new D.Cartesian3;N.computePlaneDistances=function(e,t,n,r){I.defined(r)||(r=new o);var a=D.Cartesian3.subtract(e.center,t,we),i=D.Cartesian3.dot(n,a);return r.start=i-e.radius,r.stop=i+e.radius,r};for(var Ce=new D.Cartesian3,ge=new D.Cartesian3,xe=new D.Cartesian3,Ee=new D.Cartesian3,Oe=new D.Cartesian3,_e=new D.Cartographic,Se=new Array(8),be=0;be<8;++be)Se[be]=new D.Cartesian3;var Me,Re=new a;N.projectTo2D=function(e,t,n){var r=(t=P.defaultValue(t,Re)).ellipsoid,a=e.center,i=e.radius,s=r.geodeticSurfaceNormal(a,Ce),o=D.Cartesian3.cross(D.Cartesian3.UNIT_Z,s,ge);D.Cartesian3.normalize(o,o);var u=D.Cartesian3.cross(s,o,xe);D.Cartesian3.normalize(u,u),D.Cartesian3.multiplyByScalar(s,i,s),D.Cartesian3.multiplyByScalar(u,i,u),D.Cartesian3.multiplyByScalar(o,i,o);var l=D.Cartesian3.negate(u,Oe),c=D.Cartesian3.negate(o,Ee),d=Se,f=d[0];D.Cartesian3.add(s,u,f),D.Cartesian3.add(f,o,f),f=d[1],D.Cartesian3.add(s,u,f),D.Cartesian3.add(f,c,f),f=d[2],D.Cartesian3.add(s,l,f),D.Cartesian3.add(f,c,f),f=d[3],D.Cartesian3.add(s,l,f),D.Cartesian3.add(f,o,f),D.Cartesian3.negate(s,s),f=d[4],D.Cartesian3.add(s,u,f),D.Cartesian3.add(f,o,f),f=d[5],D.Cartesian3.add(s,u,f),D.Cartesian3.add(f,c,f),f=d[6],D.Cartesian3.add(s,l,f),D.Cartesian3.add(f,c,f),f=d[7],D.Cartesian3.add(s,l,f),D.Cartesian3.add(f,o,f);for(var h=d.length,p=0;p<h;++p){var m=d[p];D.Cartesian3.add(a,m,m);var y=r.cartesianToCartographic(m,_e);t.project(y,m)}var v=(a=(n=N.fromPoints(d,n)).center).x,w=a.y,C=a.z;return a.x=C,a.y=v,a.z=w,n},N.isOccluded=function(e,t){return!t.isBoundingSphereVisible(e)},N.equals=function(e,t){return e===t||I.defined(e)&&I.defined(t)&&D.Cartesian3.equals(e.center,t.center)&&e.radius===t.radius},N.prototype.intersectPlane=function(e){return N.intersectPlane(this,e)},N.prototype.distanceSquaredTo=function(e){return N.distanceSquaredTo(this,e)},N.prototype.computePlaneDistances=function(e,t,n){return N.computePlaneDistances(this,e,t,n)},N.prototype.isOccluded=function(e){return N.isOccluded(this,e)},N.prototype.equals=function(e){return N.equals(this,e)},N.prototype.clone=function(e){return N.clone(this,e)},N.prototype.volume=function(){var e=this.radius;return q*e*e*e};var Ae,Te,ze,qe,Ie,Pe,De,Ne,Ue,Fe,Ve,Le,Be,We,je,ke,Ye,He={requestFullscreen:void 0,exitFullscreen:void 0,fullscreenEnabled:void 0,fullscreenElement:void 0,fullscreenchange:void 0,fullscreenerror:void 0},Ze={};function Je(e){for(var t=e.split("."),n=0,r=t.length;n<r;++n)t[n]=parseInt(t[n],10);return t}function Xe(){if(!I.defined(Te)&&(Te=!1,!$e())){var e=/ Chrome\/([\.0-9]+)/.exec(Ae.userAgent);null!==e&&(Te=!0,ze=Je(e[1]))}return Te}function Ge(){if(!I.defined(qe)&&(qe=!1,!Xe()&&!$e()&&/ Safari\/[\.0-9]+/.test(Ae.userAgent))){var e=/ Version\/([\.0-9]+)/.exec(Ae.userAgent);null!==e&&(qe=!0,Ie=Je(e[1]))}return qe}function Qe(){if(!I.defined(Pe)){Pe=!1;var e=/ AppleWebKit\/([\.0-9]+)(\+?)/.exec(Ae.userAgent);null!==e&&(Pe=!0,(De=Je(e[1])).isNightly=!!e[2])}return Pe}function Ke(){var e;I.defined(Ne)||(Ne=!1,"Microsoft Internet Explorer"===Ae.appName?null!==(e=/MSIE ([0-9]{1,}[\.0-9]{0,})/.exec(Ae.userAgent))&&(Ne=!0,Ue=Je(e[1])):"Netscape"===Ae.appName&&null!==(e=/Trident\/.*rv:([0-9]{1,}[\.0-9]{0,})/.exec(Ae.userAgent))&&(Ne=!0,Ue=Je(e[1])));return Ne}function $e(){if(!I.defined(Fe)){Fe=!1;var e=/ Edge\/([\.0-9]+)/.exec(Ae.userAgent);null!==e&&(Fe=!0,Ve=Je(e[1]))}return Fe}function et(){if(!I.defined(Le)){Le=!1;var e=/Firefox\/([\.0-9]+)/.exec(Ae.userAgent);null!==e&&(Le=!0,Be=Je(e[1]))}return Le}function tt(){if(!I.defined(Ye)){var e=document.createElement("canvas");e.setAttribute("style","image-rendering: -moz-crisp-edges;image-rendering: pixelated;");var t=e.style.imageRendering;(Ye=I.defined(t)&&""!==t)&&(ke=t)}return Ye}function nt(){return nt._result}r.defineProperties(Ze,{element:{get:function(){if(Ze.supportsFullscreen())return document[He.fullscreenElement]}},changeEventName:{get:function(){if(Ze.supportsFullscreen())return He.fullscreenchange}},errorEventName:{get:function(){if(Ze.supportsFullscreen())return He.fullscreenerror}},enabled:{get:function(){if(Ze.supportsFullscreen())return document[He.fullscreenEnabled]}},fullscreen:{get:function(){if(Ze.supportsFullscreen())return null!==Ze.element}}}),Ze.supportsFullscreen=function(){if(I.defined(Me))return Me;Me=!1;var e=document.body;if("function"==typeof e.requestFullscreen)return He.requestFullscreen="requestFullscreen",He.exitFullscreen="exitFullscreen",He.fullscreenEnabled="fullscreenEnabled",He.fullscreenElement="fullscreenElement",He.fullscreenchange="fullscreenchange",He.fullscreenerror="fullscreenerror",Me=!0;for(var t,n=["webkit","moz","o","ms","khtml"],r=0,a=n.length;r<a;++r){var i=n[r];"function"==typeof e[t=i+"RequestFullscreen"]?(He.requestFullscreen=t,Me=!0):"function"==typeof e[t=i+"RequestFullScreen"]&&(He.requestFullscreen=t,Me=!0),t=i+"ExitFullscreen","function"==typeof document[t]?He.exitFullscreen=t:(t=i+"CancelFullScreen","function"==typeof document[t]&&(He.exitFullscreen=t)),t=i+"FullscreenEnabled",void 0!==document[t]?He.fullscreenEnabled=t:(t=i+"FullScreenEnabled",void 0!==document[t]&&(He.fullscreenEnabled=t)),t=i+"FullscreenElement",void 0!==document[t]?He.fullscreenElement=t:(t=i+"FullScreenElement",void 0!==document[t]&&(He.fullscreenElement=t)),t=i+"fullscreenchange",void 0!==document["on"+t]&&("ms"===i&&(t="MSFullscreenChange"),He.fullscreenchange=t),t=i+"fullscreenerror",void 0!==document["on"+t]&&("ms"===i&&(t="MSFullscreenError"),He.fullscreenerror=t)}return Me},Ze.requestFullscreen=function(e,t){Ze.supportsFullscreen()&&e[He.requestFullscreen]({vrDisplay:t})},Ze.exitFullscreen=function(){Ze.supportsFullscreen()&&document[He.exitFullscreen]()},Ze._names=He,Ae="undefined"!=typeof navigator?navigator:{},nt._promise=void 0,nt._result=void 0,nt.initialize=function(){if(I.defined(nt._promise))return nt._promise;var e=f.when.defer();if(nt._promise=e.promise,$e())return nt._result=!1,e.resolve(nt._result),e.promise;var t=new Image;return t.onload=function(){nt._result=0<t.width&&0<t.height,e.resolve(nt._result)},t.onerror=function(){nt._result=!1,e.resolve(nt._result)},t.src="data:image/webp;base64,UklGRiIAAABXRUJQVlA4IBYAAAAwAQCdASoBAAEADsD+JaQAA3AAAAAA",e.promise},r.defineProperties(nt,{initialized:{get:function(){return I.defined(nt._result)}}});var rt=[];"undefined"!=typeof ArrayBuffer&&(rt.push(Int8Array,Uint8Array,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array),"undefined"!=typeof Uint8ClampedArray&&rt.push(Uint8ClampedArray),"undefined"!=typeof CanvasPixelArray&&rt.push(CanvasPixelArray));var at={isChrome:Xe,chromeVersion:function(){return Xe()&&ze},isSafari:Ge,safariVersion:function(){return Ge()&&Ie},isWebkit:Qe,webkitVersion:function(){return Qe()&&De},isInternetExplorer:Ke,internetExplorerVersion:function(){return Ke()&&Ue},isEdge:$e,edgeVersion:function(){return $e()&&Ve},isFirefox:et,firefoxVersion:function(){return et()&&Be},isWindows:function(){return I.defined(We)||(We=/Windows/i.test(Ae.appVersion)),We},hardwareConcurrency:P.defaultValue(Ae.hardwareConcurrency,3),supportsPointerEvents:function(){return I.defined(je)||(je=!et()&&"undefined"!=typeof PointerEvent&&(!I.defined(Ae.pointerEnabled)||Ae.pointerEnabled)),je},supportsImageRenderingPixelated:tt,supportsWebP:nt,imageRenderingValue:function(){return tt()?ke:void 0},typedArrayTypes:rt};function it(e,t,n,r){this.x=P.defaultValue(e,0),this.y=P.defaultValue(t,0),this.z=P.defaultValue(n,0),this.w=P.defaultValue(r,0)}at.supportsFullscreen=function(){return Ze.supportsFullscreen()},at.supportsTypedArrays=function(){return"undefined"!=typeof ArrayBuffer},at.supportsWebWorkers=function(){return"undefined"!=typeof Worker},at.supportsWebAssembly=function(){return"undefined"!=typeof WebAssembly&&!at.isEdge()};var st=new D.Cartesian3;it.fromAxisAngle=function(e,t,n){var r=t/2,a=Math.sin(r),i=(st=D.Cartesian3.normalize(e,st)).x*a,s=st.y*a,o=st.z*a,u=Math.cos(r);return I.defined(n)?(n.x=i,n.y=s,n.z=o,n.w=u,n):new it(i,s,o,u)};var ot=[1,2,0],ut=new Array(3);it.fromRotationMatrix=function(e,t){var n,r,a,i,s,o=e[X.COLUMN0ROW0],u=e[X.COLUMN1ROW1],l=e[X.COLUMN2ROW2],c=o+u+l;if(0<c)s=.5*(n=Math.sqrt(c+1)),n=.5/n,r=(e[X.COLUMN1ROW2]-e[X.COLUMN2ROW1])*n,a=(e[X.COLUMN2ROW0]-e[X.COLUMN0ROW2])*n,i=(e[X.COLUMN0ROW1]-e[X.COLUMN1ROW0])*n;else{var d=0;o<u&&(d=1),o<l&&u<l&&(d=2);var f=ot[d],h=ot[f];n=Math.sqrt(e[X.getElementIndex(d,d)]-e[X.getElementIndex(f,f)]-e[X.getElementIndex(h,h)]+1);var p=ut;p[d]=.5*n,n=.5/n,s=(e[X.getElementIndex(h,f)]-e[X.getElementIndex(f,h)])*n,p[f]=(e[X.getElementIndex(f,d)]+e[X.getElementIndex(d,f)])*n,p[h]=(e[X.getElementIndex(h,d)]+e[X.getElementIndex(d,h)])*n,r=-p[0],a=-p[1],i=-p[2]}return I.defined(t)?(t.x=r,t.y=a,t.z=i,t.w=s,t):new it(r,a,i,s)};var lt=new it,ct=new it,dt=new it,ft=new it;it.fromHeadingPitchRoll=function(e,t){return ft=it.fromAxisAngle(D.Cartesian3.UNIT_X,e.roll,lt),dt=it.fromAxisAngle(D.Cartesian3.UNIT_Y,-e.pitch,t),t=it.multiply(dt,ft,dt),ct=it.fromAxisAngle(D.Cartesian3.UNIT_Z,-e.heading,lt),it.multiply(ct,t,t)};var ht=new D.Cartesian3,pt=new D.Cartesian3,mt=new it,yt=new it,vt=new it;it.packedLength=4,it.pack=function(e,t,n){return n=P.defaultValue(n,0),t[n++]=e.x,t[n++]=e.y,t[n++]=e.z,t[n]=e.w,t},it.unpack=function(e,t,n){return t=P.defaultValue(t,0),I.defined(n)||(n=new it),n.x=e[t],n.y=e[t+1],n.z=e[t+2],n.w=e[t+3],n},it.packedInterpolationLength=3,it.convertPackedArrayForInterpolation=function(e,t,n,r){it.unpack(e,4*n,vt),it.conjugate(vt,vt);for(var a=0,i=n-t+1;a<i;a++){var s=3*a;it.unpack(e,4*(t+a),mt),it.multiply(mt,vt,mt),mt.w<0&&it.negate(mt,mt),it.computeAxis(mt,ht);var o=it.computeAngle(mt);r[s]=ht.x*o,r[1+s]=ht.y*o,r[2+s]=ht.z*o}},it.unpackInterpolationResult=function(e,t,n,r,a){I.defined(a)||(a=new it),D.Cartesian3.fromArray(e,0,pt);var i=D.Cartesian3.magnitude(pt);return it.unpack(t,4*r,yt),0===i?it.clone(it.IDENTITY,mt):it.fromAxisAngle(pt,i,mt),it.multiply(mt,yt,a)},it.clone=function(e,t){if(I.defined(e))return I.defined(t)?(t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t):new it(e.x,e.y,e.z,e.w)},it.conjugate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=e.w,t},it.magnitudeSquared=function(e){return e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w},it.magnitude=function(e){return Math.sqrt(it.magnitudeSquared(e))},it.normalize=function(e,t){var n=1/it.magnitude(e),r=e.x*n,a=e.y*n,i=e.z*n,s=e.w*n;return t.x=r,t.y=a,t.z=i,t.w=s,t},it.inverse=function(e,t){var n=it.magnitudeSquared(e);return t=it.conjugate(e,t),it.multiplyByScalar(t,1/n,t)},it.add=function(e,t,n){return n.x=e.x+t.x,n.y=e.y+t.y,n.z=e.z+t.z,n.w=e.w+t.w,n},it.subtract=function(e,t,n){return n.x=e.x-t.x,n.y=e.y-t.y,n.z=e.z-t.z,n.w=e.w-t.w,n},it.negate=function(e,t){return t.x=-e.x,t.y=-e.y,t.z=-e.z,t.w=-e.w,t},it.dot=function(e,t){return e.x*t.x+e.y*t.y+e.z*t.z+e.w*t.w},it.multiply=function(e,t,n){var r=e.x,a=e.y,i=e.z,s=e.w,o=t.x,u=t.y,l=t.z,c=t.w,d=s*o+r*c+a*l-i*u,f=s*u-r*l+a*c+i*o,h=s*l+r*u-a*o+i*c,p=s*c-r*o-a*u-i*l;return n.x=d,n.y=f,n.z=h,n.w=p,n},it.multiplyByScalar=function(e,t,n){return n.x=e.x*t,n.y=e.y*t,n.z=e.z*t,n.w=e.w*t,n},it.divideByScalar=function(e,t,n){return n.x=e.x/t,n.y=e.y/t,n.z=e.z/t,n.w=e.w/t,n},it.computeAxis=function(e,t){var n=e.w;if(Math.abs(n-1)<Z.CesiumMath.EPSILON6)return t.x=t.y=t.z=0,t;var r=1/Math.sqrt(1-n*n);return t.x=e.x*r,t.y=e.y*r,t.z=e.z*r,t},it.computeAngle=function(e){return Math.abs(e.w-1)<Z.CesiumMath.EPSILON6?0:2*Math.acos(e.w)};var wt=new it;it.lerp=function(e,t,n,r){return wt=it.multiplyByScalar(t,n,wt),r=it.multiplyByScalar(e,1-n,r),it.add(wt,r,r)};var Ct=new it,gt=new it,xt=new it;it.slerp=function(e,t,n,r){var a=it.dot(e,t),i=t;if(a<0&&(a=-a,i=Ct=it.negate(t,Ct)),1-a<Z.CesiumMath.EPSILON6)return it.lerp(e,i,n,r);var s=Math.acos(a);return gt=it.multiplyByScalar(e,Math.sin((1-n)*s),gt),xt=it.multiplyByScalar(i,Math.sin(n*s),xt),r=it.add(gt,xt,r),it.multiplyByScalar(r,1/Math.sin(s),r)},it.log=function(e,t){var n=Z.CesiumMath.acosClamped(e.w),r=0;return 0!==n&&(r=n/Math.sin(n)),D.Cartesian3.multiplyByScalar(e,r,t)},it.exp=function(e,t){var n=D.Cartesian3.magnitude(e),r=0;return 0!==n&&(r=Math.sin(n)/n),t.x=e.x*r,t.y=e.y*r,t.z=e.z*r,t.w=Math.cos(n),t};var Et=new D.Cartesian3,Ot=new D.Cartesian3,_t=new it,St=new it;it.computeInnerQuadrangle=function(e,t,n,r){var a=it.conjugate(t,_t);it.multiply(a,n,St);var i=it.log(St,Et);it.multiply(a,e,St);var s=it.log(St,Ot);return D.Cartesian3.add(i,s,i),D.Cartesian3.multiplyByScalar(i,.25,i),D.Cartesian3.negate(i,i),it.exp(i,_t),it.multiply(t,_t,r)},it.squad=function(e,t,n,r,a,i){var s=it.slerp(e,t,a,_t),o=it.slerp(n,r,a,St);return it.slerp(s,o,2*a*(1-a),i)};for(var bt=new it,Mt=1.9011074535173003,Rt=at.supportsTypedArrays()?new Float32Array(8):[],At=at.supportsTypedArrays()?new Float32Array(8):[],Tt=at.supportsTypedArrays()?new Float32Array(8):[],zt=at.supportsTypedArrays()?new Float32Array(8):[],qt=0;qt<7;++qt){var It=qt+1,Pt=2*It+1;Rt[qt]=1/(It*Pt),At[qt]=It/Pt}function Dt(e,t,n){for(var r,a,i=0,s=e.length-1;i<=s;)if((a=n(e[r=~~((i+s)/2)],t))<0)i=1+r;else{if(!(0<a))return r;s=r-1}return~(s+1)}function Nt(e,t,n,r,a){this.xPoleWander=e,this.yPoleWander=t,this.xPoleOffset=n,this.yPoleOffset=r,this.ut1MinusUtc=a}function Ut(){function C(e,t,n,r){n=n||" ";var a=e.length>=t?"":Array(1+t-e.length>>>0).join(n);return r?e+a:a+e}function g(e,t,n,r,a,i){var s=r-e.length;return 0<s&&(e=n||!a?C(e,r,i,n):e.slice(0,t.length)+C("",s,"0",!0)+e.slice(t.length)),e}function x(e,t,n,r,a,i,s){var o=e>>>0;return e=(n=n&&o&&{2:"0b",8:"0",16:"0x"}[t]||"")+C(o.toString(t),i||0,"0",!1),g(e,n,r,a,s)}function E(e,t,n,r,a,i){return null!=r&&(e=e.slice(0,r)),g(e,"",t,n,a,i)}var O=arguments,_=0,e=O[_++];return e.replace(/%%|%(\d+\$)?([-+\'#0 ]*)(\*\d+\$|\*|\d+)?(\.(\*\d+\$|\*|\d+))?([scboxXuideEfFgG])/g,function(e,t,n,r,a,i,s){var o,u,l,c,d;if("%%"==e)return"%";for(var f=!1,h="",p=!1,m=!1,y=" ",v=n.length,w=0;n&&w<v;w++)switch(n.charAt(w)){case" ":h=" ";break;case"+":h="+";break;case"-":f=!0;break;case"'":y=n.charAt(w+1);break;case"0":p=!0;break;case"#":m=!0}if((r=r?"*"==r?+O[_++]:"*"==r.charAt(0)?+O[r.slice(1,-1)]:+r:0)<0&&(r=-r,f=!0),!isFinite(r))throw new Error("sprintf: (minimum-)width must be finite");switch(i=i?"*"==i?+O[_++]:"*"==i.charAt(0)?+O[i.slice(1,-1)]:+i:-1<"fFeE".indexOf(s)?6:"d"==s?0:void 0,d=t?O[t.slice(0,-1)]:O[_++],s){case"s":return E(String(d),f,r,i,p,y);case"c":return E(String.fromCharCode(+d),f,r,i,p);case"b":return x(d,2,m,f,r,i,p);case"o":return x(d,8,m,f,r,i,p);case"x":return x(d,16,m,f,r,i,p);case"X":return x(d,16,m,f,r,i,p).toUpperCase();case"u":return x(d,10,m,f,r,i,p);case"i":case"d":return o=+d||0,d=(u=(o=Math.round(o-o%1))<0?"-":h)+C(String(Math.abs(o)),i,"0",!1),g(d,u,f,r,p);case"e":case"E":case"f":case"F":case"g":case"G":return u=(o=+d)<0?"-":h,l=["toExponential","toFixed","toPrecision"]["efg".indexOf(s.toLowerCase())],c=["toString","toUpperCase"]["eEfFgG".indexOf(s)%2],d=u+Math.abs(o)[l](i),g(d,u,f,r,p)[c]();default:return e}})}function Ft(e,t,n,r,a,i,s,o){this.year=e,this.month=t,this.day=n,this.hour=r,this.minute=a,this.second=i,this.millisecond=s,this.isLeapSecond=o}function Vt(e){return e%4==0&&e%100!=0||e%400==0}function Lt(e,t){this.julianDate=e,this.offset=t}Rt[7]=Mt/136,At[7]=8*Mt/17,it.fastSlerp=function(e,t,n,r){var a,i=it.dot(e,t);0<=i?a=1:(a=-1,i=-i);for(var s=i-1,o=1-n,u=n*n,l=o*o,c=7;0<=c;--c)Tt[c]=(Rt[c]*u-At[c])*s,zt[c]=(Rt[c]*l-At[c])*s;var d=a*n*(1+Tt[0]*(1+Tt[1]*(1+Tt[2]*(1+Tt[3]*(1+Tt[4]*(1+Tt[5]*(1+Tt[6]*(1+Tt[7])))))))),f=o*(1+zt[0]*(1+zt[1]*(1+zt[2]*(1+zt[3]*(1+zt[4]*(1+zt[5]*(1+zt[6]*(1+zt[7])))))))),h=it.multiplyByScalar(e,f,bt);return it.multiplyByScalar(t,d,r),it.add(h,r,r)},it.fastSquad=function(e,t,n,r,a,i){var s=it.fastSlerp(e,t,a,_t),o=it.fastSlerp(n,r,a,St);return it.fastSlerp(s,o,2*a*(1-a),i)},it.equals=function(e,t){return e===t||I.defined(e)&&I.defined(t)&&e.x===t.x&&e.y===t.y&&e.z===t.z&&e.w===t.w},it.equalsEpsilon=function(e,t,n){return e===t||I.defined(e)&&I.defined(t)&&Math.abs(e.x-t.x)<=n&&Math.abs(e.y-t.y)<=n&&Math.abs(e.z-t.z)<=n&&Math.abs(e.w-t.w)<=n},it.ZERO=t.freezeObject(new it(0,0,0,0)),it.IDENTITY=t.freezeObject(new it(0,0,0,1)),it.prototype.clone=function(e){return it.clone(this,e)},it.prototype.equals=function(e){return it.equals(this,e)},it.prototype.equalsEpsilon=function(e,t){return it.equalsEpsilon(this,e,t)},it.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"};var Bt=t.freezeObject({SECONDS_PER_MILLISECOND:.001,SECONDS_PER_MINUTE:60,MINUTES_PER_HOUR:60,HOURS_PER_DAY:24,SECONDS_PER_HOUR:3600,MINUTES_PER_DAY:1440,SECONDS_PER_DAY:86400,DAYS_PER_JULIAN_CENTURY:36525,PICOSECOND:1e-9,MODIFIED_JULIAN_DATE_DIFFERENCE:2400000.5}),Wt=t.freezeObject({UTC:0,TAI:1}),jt=new Ft,kt=[31,28,31,30,31,30,31,31,30,31,30,31];function Yt(e,t){return on.compare(e.julianDate,t.julianDate)}var Ht=new Lt;function Zt(e){Ht.julianDate=e;var t=on.leapSeconds,n=Dt(t,Ht,Yt);n<0&&(n=~n),n>=t.length&&(n=t.length-1);var r=t[n].offset;0<n&&r<on.secondsDifference(t[n].julianDate,e)&&(r=t[--n].offset);on.addSeconds(e,r,e)}function Jt(e,t){Ht.julianDate=e;var n=on.leapSeconds,r=Dt(n,Ht,Yt);if(r<0&&(r=~r),0===r)return on.addSeconds(e,-n[0].offset,t);if(r>=n.length)return on.addSeconds(e,-n[r-1].offset,t);var a=on.secondsDifference(n[r].julianDate,e);return 0===a?on.addSeconds(e,-n[r].offset,t):a<=1?void 0:on.addSeconds(e,-n[--r].offset,t)}function Xt(e,t,n){var r=t/Bt.SECONDS_PER_DAY|0;return e+=r,(t-=Bt.SECONDS_PER_DAY*r)<0&&(e--,t+=Bt.SECONDS_PER_DAY),n.dayNumber=e,n.secondsOfDay=t,n}function Gt(e,t,n,r,a,i,s){var o=(t-14)/12|0,u=e+4800+o,l=(1461*u/4|0)+(367*(t-2-12*o)/12|0)-(3*((u+100)/100|0)/4|0)+n-32075;(r-=12)<0&&(r+=24);var c=i+(r*Bt.SECONDS_PER_HOUR+a*Bt.SECONDS_PER_MINUTE+s*Bt.SECONDS_PER_MILLISECOND);return 43200<=c&&(l-=1),[l,c]}var Qt=/^(\d{4})$/,Kt=/^(\d{4})-(\d{2})$/,$t=/^(\d{4})-?(\d{3})$/,en=/^(\d{4})-?W(\d{2})-?(\d{1})?$/,tn=/^(\d{4})-?(\d{2})-?(\d{2})$/,nn=/([Z+\-])?(\d{2})?:?(\d{2})?$/,rn=/^(\d{2})(\.\d+)?/.source+nn.source,an=/^(\d{2}):?(\d{2})(\.\d+)?/.source+nn.source,sn=/^(\d{2}):?(\d{2}):?(\d{2})(\.\d+)?/.source+nn.source;function on(e,t,n){this.dayNumber=void 0,this.secondsOfDay=void 0,e=P.defaultValue(e,0),t=P.defaultValue(t,0),n=P.defaultValue(n,Wt.UTC);var r=0|e;Xt(r,t+=(e-r)*Bt.SECONDS_PER_DAY,this),n===Wt.UTC&&Zt(this)}on.fromGregorianDate=function(e,t){var n=Gt(e.year,e.month,e.day,e.hour,e.minute,e.second,e.millisecond);return I.defined(t)?(Xt(n[0],n[1],t),Zt(t),t):new on(n[0],n[1],Wt.UTC)},on.fromDate=function(e,t){var n=Gt(e.getUTCFullYear(),e.getUTCMonth()+1,e.getUTCDate(),e.getUTCHours(),e.getUTCMinutes(),e.getUTCSeconds(),e.getUTCMilliseconds());return I.defined(t)?(Xt(n[0],n[1],t),Zt(t),t):new on(n[0],n[1],Wt.UTC)},on.fromIso8601=function(e,t){var n,r,a,i,s=(e=e.replace(",",".")).split("T"),o=1,u=1,l=0,c=0,d=0,f=0,h=s[0],p=s[1];if(null!==(s=h.match(tn)))n=+s[1],o=+s[2],u=+s[3];else if(null!==(s=h.match(Kt)))n=+s[1],o=+s[2];else if(null!==(s=h.match(Qt)))n=+s[1];else{var m;if(null!==(s=h.match($t)))n=+s[1],m=+s[2],a=Vt(n);else if(null!==(s=h.match(en)))n=+s[1],m=7*+s[2]+(+s[3]||0)-new Date(Date.UTC(n,0,4)).getUTCDay()-3;(r=new Date(Date.UTC(n,0,1))).setUTCDate(m),o=r.getUTCMonth()+1,u=r.getUTCDate()}if(a=Vt(n),I.defined(p)){null!==(s=p.match(sn))?(l=+s[1],c=+s[2],d=+s[3],f=1e3*(s[4]||0),i=5):null!==(s=p.match(an))?(l=+s[1],c=+s[2],d=60*(s[3]||0),i=4):null!==(s=p.match(rn))&&(l=+s[1],c=60*(s[2]||0),i=3);var y=s[i],v=+s[i+1],w=+(s[i+2]||0);switch(y){case"+":l-=v,c-=w;break;case"-":l+=v,c+=w;break;case"Z":break;default:c+=new Date(Date.UTC(n,o-1,u,l,c)).getTimezoneOffset()}}var C=60===d;for(C&&d--;60<=c;)c-=60,l++;for(;24<=l;)l-=24,u++;for(r=a&&2===o?29:kt[o-1];r<u;)u-=r,12<++o&&(o-=12,n++),r=a&&2===o?29:kt[o-1];for(;c<0;)c+=60,l--;for(;l<0;)l+=24,u--;for(;u<1;)--o<1&&(o+=12,n--),u+=r=a&&2===o?29:kt[o-1];var g=Gt(n,o,u,l,c,d,f);return I.defined(t)?(Xt(g[0],g[1],t),Zt(t)):t=new on(g[0],g[1],Wt.UTC),C&&on.addSeconds(t,1,t),t},on.now=function(e){return on.fromDate(new Date,e)};var un=new on(0,0,Wt.TAI);function ln(e){if(e instanceof ln)this.scheme=e.scheme,this.authority=e.authority,this.path=e.path,this.query=e.query,this.fragment=e.fragment;else if(e){var t=cn.exec(e);this.scheme=t[1],this.authority=t[2],this.path=t[3],this.query=t[4],this.fragment=t[5]}}on.toGregorianDate=function(e,t){var n=!1,r=Jt(e,un);I.defined(r)||(on.addSeconds(e,-1,un),r=Jt(un,un),n=!0);var a=r.dayNumber,i=r.secondsOfDay;43200<=i&&(a+=1);var s=a+68569|0,o=4*s/146097|0,u=4e3*((s=s-((146097*o+3)/4|0)|0)+1)/1461001|0,l=80*(s=s-(1461*u/4|0)+31|0)/2447|0,c=s-(2447*l/80|0)|0,d=2+l-12*(s=l/11|0)|0,f=100*(o-49)+u+s|0,h=i/Bt.SECONDS_PER_HOUR|0,p=i-h*Bt.SECONDS_PER_HOUR,m=p/Bt.SECONDS_PER_MINUTE|0,y=0|(p-=m*Bt.SECONDS_PER_MINUTE),v=(p-y)/Bt.SECONDS_PER_MILLISECOND;return 23<(h+=12)&&(h-=24),n&&(y+=1),I.defined(t)?(t.year=f,t.month=d,t.day=c,t.hour=h,t.minute=m,t.second=y,t.millisecond=v,t.isLeapSecond=n,t):new Ft(f,d,c,h,m,y,v,n)},on.toDate=function(e){var t=on.toGregorianDate(e,jt),n=t.second;return t.isLeapSecond&&(n-=1),new Date(Date.UTC(t.year,t.month-1,t.day,t.hour,t.minute,n,t.millisecond))},on.toIso8601=function(e,t){var n=on.toGregorianDate(e,jt),r=n.year,a=n.month,i=n.day,s=n.hour,o=n.minute,u=n.second,l=n.millisecond;return 1e4===r&&1===a&&1===i&&0===s&&0===o&&0===u&&0===l&&(r=9999,a=12,i=31,s=24),I.defined(t)||0===l?I.defined(t)&&0!==t?Ut("%04d-%02d-%02dT%02d:%02d:%02d.%sZ",r,a,i,s,o,u,(.01*l).toFixed(t).replace(".","").slice(0,t)):Ut("%04d-%02d-%02dT%02d:%02d:%02dZ",r,a,i,s,o,u):Ut("%04d-%02d-%02dT%02d:%02d:%02d.%sZ",r,a,i,s,o,u,(.01*l).toString().replace(".",""))},on.clone=function(e,t){if(I.defined(e))return I.defined(t)?(t.dayNumber=e.dayNumber,t.secondsOfDay=e.secondsOfDay,t):new on(e.dayNumber,e.secondsOfDay,Wt.TAI)},on.compare=function(e,t){var n=e.dayNumber-t.dayNumber;return 0!=n?n:e.secondsOfDay-t.secondsOfDay},on.equals=function(e,t){return e===t||I.defined(e)&&I.defined(t)&&e.dayNumber===t.dayNumber&&e.secondsOfDay===t.secondsOfDay},on.equalsEpsilon=function(e,t,n){return e===t||I.defined(e)&&I.defined(t)&&Math.abs(on.secondsDifference(e,t))<=n},on.totalDays=function(e){return e.dayNumber+e.secondsOfDay/Bt.SECONDS_PER_DAY},on.secondsDifference=function(e,t){return(e.dayNumber-t.dayNumber)*Bt.SECONDS_PER_DAY+(e.secondsOfDay-t.secondsOfDay)},on.daysDifference=function(e,t){return e.dayNumber-t.dayNumber+(e.secondsOfDay-t.secondsOfDay)/Bt.SECONDS_PER_DAY},on.computeTaiMinusUtc=function(e){Ht.julianDate=e;var t=on.leapSeconds,n=Dt(t,Ht,Yt);return n<0&&(n=~n,--n<0&&(n=0)),t[n].offset},on.addSeconds=function(e,t,n){return Xt(e.dayNumber,e.secondsOfDay+t,n)},on.addMinutes=function(e,t,n){var r=e.secondsOfDay+t*Bt.SECONDS_PER_MINUTE;return Xt(e.dayNumber,r,n)},on.addHours=function(e,t,n){var r=e.secondsOfDay+t*Bt.SECONDS_PER_HOUR;return Xt(e.dayNumber,r,n)},on.addDays=function(e,t,n){return Xt(e.dayNumber+t,e.secondsOfDay,n)},on.lessThan=function(e,t){return on.compare(e,t)<0},on.lessThanOrEquals=function(e,t){return on.compare(e,t)<=0},on.greaterThan=function(e,t){return 0<on.compare(e,t)},on.greaterThanOrEquals=function(e,t){return 0<=on.compare(e,t)},on.prototype.clone=function(e){return on.clone(this,e)},on.prototype.equals=function(e){return on.equals(this,e)},on.prototype.equalsEpsilon=function(e,t){return on.equalsEpsilon(this,e,t)},on.prototype.toString=function(){return on.toIso8601(this)},on.leapSeconds=[new Lt(new on(2441317,43210,Wt.TAI),10),new Lt(new on(2441499,43211,Wt.TAI),11),new Lt(new on(2441683,43212,Wt.TAI),12),new Lt(new on(2442048,43213,Wt.TAI),13),new Lt(new on(2442413,43214,Wt.TAI),14),new Lt(new on(2442778,43215,Wt.TAI),15),new Lt(new on(2443144,43216,Wt.TAI),16),new Lt(new on(2443509,43217,Wt.TAI),17),new Lt(new on(2443874,43218,Wt.TAI),18),new Lt(new on(2444239,43219,Wt.TAI),19),new Lt(new on(2444786,43220,Wt.TAI),20),new Lt(new on(2445151,43221,Wt.TAI),21),new Lt(new on(2445516,43222,Wt.TAI),22),new Lt(new on(2446247,43223,Wt.TAI),23),new Lt(new on(2447161,43224,Wt.TAI),24),new Lt(new on(2447892,43225,Wt.TAI),25),new Lt(new on(2448257,43226,Wt.TAI),26),new Lt(new on(2448804,43227,Wt.TAI),27),new Lt(new on(2449169,43228,Wt.TAI),28),new Lt(new on(2449534,43229,Wt.TAI),29),new Lt(new on(2450083,43230,Wt.TAI),30),new Lt(new on(2450630,43231,Wt.TAI),31),new Lt(new on(2451179,43232,Wt.TAI),32),new Lt(new on(2453736,43233,Wt.TAI),33),new Lt(new on(2454832,43234,Wt.TAI),34),new Lt(new on(2456109,43235,Wt.TAI),35),new Lt(new on(2457204,43236,Wt.TAI),36),new Lt(new on(2457754,43237,Wt.TAI),37)],ln.prototype.scheme=null,ln.prototype.authority=null,ln.prototype.path="",ln.prototype.query=null,ln.prototype.fragment=null;var cn=new RegExp("^(?:([^:/?#]+):)?(?://([^/?#]*))?([^?#]*)(?:\\?([^#]*))?(?:#(.*))?$");ln.prototype.getScheme=function(){return this.scheme},ln.prototype.getAuthority=function(){return this.authority},ln.prototype.getPath=function(){return this.path},ln.prototype.getQuery=function(){return this.query},ln.prototype.getFragment=function(){return this.fragment},ln.prototype.isAbsolute=function(){return!!this.scheme&&!this.fragment},ln.prototype.isSameDocumentAs=function(e){return e.scheme==this.scheme&&e.authority==this.authority&&e.path==this.path&&e.query==this.query},ln.prototype.equals=function(e){return this.isSameDocumentAs(e)&&e.fragment==this.fragment},ln.prototype.normalize=function(){this.removeDotSegments(),this.scheme&&(this.scheme=this.scheme.toLowerCase()),this.authority&&(this.authority=this.authority.replace(hn,mn).replace(dn,pn)),this.path&&(this.path=this.path.replace(dn,pn)),this.query&&(this.query=this.query.replace(dn,pn)),this.fragment&&(this.fragment=this.fragment.replace(dn,pn))};var dn=/%[0-9a-z]{2}/gi,fn=/[a-zA-Z0-9\-\._~]/,hn=/(.*@)?([^@:]*)(:.*)?/;function pn(e){var t=unescape(e);return fn.test(t)?t:e.toUpperCase()}function mn(e,t,n,r){return(t||"")+n.toLowerCase()+(r||"")}function yn(e,t){if(null===e||"object"!=typeof e)return e;t=P.defaultValue(t,!1);var n=new e.constructor;for(var r in e)if(e.hasOwnProperty(r)){var a=e[r];t&&(a=yn(a,t)),n[r]=a}return n}function vn(e,t,n){n=P.defaultValue(n,!1);var r,a,i,s={},o=I.defined(e),u=I.defined(t);if(o)for(r in e)e.hasOwnProperty(r)&&(a=e[r],u&&n&&"object"==typeof a&&t.hasOwnProperty(r)?(i=t[r],s[r]="object"==typeof i?vn(a,i,n):a):s[r]=a);if(u)for(r in t)t.hasOwnProperty(r)&&!s.hasOwnProperty(r)&&(i=t[r],s[r]=i);return s}function wn(e,t){var n;return"undefined"!=typeof document&&(n=document),wn._implementation(e,t,n)}ln.prototype.resolve=function(e){var t=new ln;return this.scheme?(t.scheme=this.scheme,t.authority=this.authority,t.path=this.path,t.query=this.query):(t.scheme=e.scheme,this.authority?(t.authority=this.authority,t.path=this.path,t.query=this.query):(t.authority=e.authority,""==this.path?(t.path=e.path,t.query=this.query||e.query):("/"==this.path.charAt(0)?t.path=this.path:e.authority&&""==e.path?t.path="/"+this.path:t.path=e.path.substring(0,e.path.lastIndexOf("/")+1)+this.path,t.removeDotSegments(),t.query=this.query))),t.fragment=this.fragment,t},ln.prototype.removeDotSegments=function(){var e,t=this.path.split("/"),n=[],r=""==t[0];r&&t.shift();for(""==t[0]&&t.shift();t.length;)".."==(e=t.shift())?n.pop():"."!=e&&n.push(e);"."!=e&&".."!=e||n.push(""),r&&n.unshift(""),this.path=n.join("/")},ln.prototype.toString=function(){var e="";return this.scheme&&(e+=this.scheme+":"),this.authority&&(e+="//"+this.authority),e+=this.path,this.query&&(e+="?"+this.query),this.fragment&&(e+="#"+this.fragment),e},wn._implementation=function(e,t,n){if(!I.defined(t)){if(void 0===n)return e;t=P.defaultValue(n.baseURI,n.location.href)}var r=new ln(t);return new ln(e).resolve(r).toString()};var Cn,gn=/^blob:/i;function xn(e){return gn.test(e)}var En=/^data:/i;function On(e){return En.test(e)}var _n=Array.isArray;I.defined(_n)||(_n=function(e){return"[object Array]"===Object.prototype.toString.call(e)});var Sn=_n;var bn=t.freezeObject({UNISSUED:0,ISSUED:1,ACTIVE:2,RECEIVED:3,CANCELLED:4,FAILED:5}),Mn=t.freezeObject({TERRAIN:0,IMAGERY:1,TILES3D:2,OTHER:3});function Rn(e){e=P.defaultValue(e,P.defaultValue.EMPTY_OBJECT);var t=P.defaultValue(e.throttleByServer,!1),n=P.defaultValue(e.throttle,!1);this.url=e.url,this.requestFunction=e.requestFunction,this.cancelFunction=e.cancelFunction,this.priorityFunction=e.priorityFunction,this.priority=P.defaultValue(e.priority,0),this.throttle=n,this.throttleByServer=t,this.type=P.defaultValue(e.type,Mn.OTHER),this.serverKey=void 0,this.state=bn.UNISSUED,this.deferred=void 0,this.cancelled=!1}function An(e,t,n){this.statusCode=e,this.response=t,this.responseHeaders=n,"string"==typeof this.responseHeaders&&(this.responseHeaders=function(e){var t={};if(!e)return t;for(var n=e.split("\r\n"),r=0;r<n.length;++r){var a=n[r],i=a.indexOf(": ");if(0<i){var s=a.substring(0,i),o=a.substring(i+2);t[s]=o}}return t}(this.responseHeaders))}function Tn(){this._listeners=[],this._scopes=[],this._toRemove=[],this._insideRaiseEvent=!1}function zn(e,t){return t-e}function qn(e){this._comparator=e.comparator,this._array=[],this._length=0,this._maximumLength=void 0}function In(e,t,n){var r=e[t];e[t]=e[n],e[n]=r}Rn.prototype.cancel=function(){this.cancelled=!0},Rn.prototype.clone=function(e){return I.defined(e)?(e.url=this.url,e.requestFunction=this.requestFunction,e.cancelFunction=this.cancelFunction,e.priorityFunction=this.priorityFunction,e.priority=this.priority,e.throttle=this.throttle,e.throttleByServer=this.throttleByServer,e.type=this.type,e.serverKey=this.serverKey,e.state=this.RequestState.UNISSUED,e.deferred=void 0,e.cancelled=!1,e):new Rn(this)},An.prototype.toString=function(){var e="Request has failed.";return I.defined(this.statusCode)&&(e+=" Status Code: "+this.statusCode),e},r.defineProperties(Tn.prototype,{numberOfListeners:{get:function(){return this._listeners.length-this._toRemove.length}}}),Tn.prototype.addEventListener=function(e,t){this._listeners.push(e),this._scopes.push(t);var n=this;return function(){n.removeEventListener(e,t)}},Tn.prototype.removeEventListener=function(e,t){for(var n=this._listeners,r=this._scopes,a=-1,i=0;i<n.length;i++)if(n[i]===e&&r[i]===t){a=i;break}return-1!==a&&(this._insideRaiseEvent?(this._toRemove.push(a),n[a]=void 0,r[a]=void 0):(n.splice(a,1),r.splice(a,1)),!0)},Tn.prototype.raiseEvent=function(){var e;this._insideRaiseEvent=!0;var t=this._listeners,n=this._scopes,r=t.length;for(e=0;e<r;e++){var a=t[e];I.defined(a)&&t[e].apply(n[e],arguments)}var i=this._toRemove;if(0<(r=i.length)){for(i.sort(zn),e=0;e<r;e++){var s=i[e];t.splice(s,1),n.splice(s,1)}i.length=0}this._insideRaiseEvent=!1},r.defineProperties(qn.prototype,{length:{get:function(){return this._length}},internalArray:{get:function(){return this._array}},maximumLength:{get:function(){return this._maximumLength},set:function(e){this._maximumLength=e,this._length>e&&0<e&&(this._length=e,this._array.length=e)}},comparator:{get:function(){return this._comparator}}}),qn.prototype.reserve=function(e){e=P.defaultValue(e,this._length),this._array.length=e},qn.prototype.heapify=function(e){e=P.defaultValue(e,0);for(var t=this._length,n=this._comparator,r=this._array,a=-1,i=!0;i;){var s=2*(e+1),o=s-1;a=o<t&&n(r[o],r[e])<0?o:e,s<t&&n(r[s],r[a])<0&&(a=s),a!==e?(In(r,a,e),e=a):i=!1}},qn.prototype.resort=function(){for(var e=this._length,t=Math.ceil(e/2);0<=t;--t)this.heapify(t)},qn.prototype.insert=function(e){var t,n=this._array,r=this._comparator,a=this._maximumLength,i=this._length++;for(i<n.length?n[i]=e:n.push(e);0!==i;){var s=Math.floor((i-1)/2);if(!(r(n[i],n[s])<0))break;In(n,i,s),i=s}return I.defined(a)&&this._length>a&&(t=n[a],this._length=a),t},qn.prototype.pop=function(e){if(e=P.defaultValue(e,0),0!==this._length){var t=this._array,n=t[e];return In(t,e,--this._length),this.heapify(e),n}};var Pn={numberOfAttemptedRequests:0,numberOfActiveRequests:0,numberOfCancelledRequests:0,numberOfCancelledActiveRequests:0,numberOfFailedRequests:0,numberOfActiveRequestsEver:0,lastNumberOfActiveRequests:0},Dn=20,Nn=new qn({comparator:function(e,t){return e.priority-t.priority}});Nn.maximumLength=Dn,Nn.reserve(Dn);var Un=[],Fn={},Vn="undefined"!=typeof document?new ln(document.location.href):new ln,Ln=new Tn;function Bn(){}function Wn(e){I.defined(e.priorityFunction)&&(e.priority=e.priorityFunction())}function jn(e){var t=P.defaultValue(Bn.requestsByServer[e],Bn.maximumRequestsPerServer);return Fn[e]<t}function kn(e){return e.state===bn.UNISSUED&&(e.state=bn.ISSUED,e.deferred=f.when.defer()),e.deferred.promise}function Yn(e){var t=kn(e);return e.state=bn.ACTIVE,Un.push(e),++Pn.numberOfActiveRequests,++Pn.numberOfActiveRequestsEver,++Fn[e.serverKey],e.requestFunction().then(function(t){return function(e){t.state!==bn.CANCELLED&&(--Pn.numberOfActiveRequests,--Fn[t.serverKey],Ln.raiseEvent(),t.state=bn.RECEIVED,t.deferred.resolve(e))}}(e)).otherwise(function(t){return function(e){t.state!==bn.CANCELLED&&(++Pn.numberOfFailedRequests,--Pn.numberOfActiveRequests,--Fn[t.serverKey],Ln.raiseEvent(e),t.state=bn.FAILED,t.deferred.reject(e))}}(e)),t}function Hn(e){var t=e.state===bn.ACTIVE;e.state=bn.CANCELLED,++Pn.numberOfCancelledRequests,e.deferred.reject(),t&&(--Pn.numberOfActiveRequests,--Fn[e.serverKey],++Pn.numberOfCancelledActiveRequests),I.defined(e.cancelFunction)&&e.cancelFunction()}Bn.maximumRequests=50,Bn.maximumRequestsPerServer=6,Bn.requestsByServer={"api.cesium.com:443":18,"assets.cesium.com:443":18},Bn.throttleRequests=!0,Bn.debugShowStatistics=!1,Bn.requestCompletedEvent=Ln,r.defineProperties(Bn,{statistics:{get:function(){return Pn}},priorityHeapLength:{get:function(){return Dn},set:function(e){if(e<Dn)for(;Nn.length>e;){Hn(Nn.pop())}Dn=e,Nn.maximumLength=e,Nn.reserve(e)}}}),Bn.update=function(){var e,t,n=0,r=Un.length;for(e=0;e<r;++e)(t=Un[e]).cancelled&&Hn(t),t.state===bn.ACTIVE?0<n&&(Un[e-n]=t):++n;Un.length-=n;var a=Nn.internalArray,i=Nn.length;for(e=0;e<i;++e)Wn(a[e]);Nn.resort();for(var s=Math.max(Bn.maximumRequests-Un.length,0),o=0;o<s&&0<Nn.length;)(t=Nn.pop()).cancelled?Hn(t):!t.throttleByServer||jn(t.serverKey)?(Yn(t),++o):Hn(t);!function(){if(!Bn.debugShowStatistics)return;0===Pn.numberOfActiveRequests&&0<Pn.lastNumberOfActiveRequests&&(0<Pn.numberOfAttemptedRequests&&(console.log("Number of attempted requests: "+Pn.numberOfAttemptedRequests),Pn.numberOfAttemptedRequests=0),0<Pn.numberOfCancelledRequests&&(console.log("Number of cancelled requests: "+Pn.numberOfCancelledRequests),Pn.numberOfCancelledRequests=0),0<Pn.numberOfCancelledActiveRequests&&(console.log("Number of cancelled active requests: "+Pn.numberOfCancelledActiveRequests),Pn.numberOfCancelledActiveRequests=0),0<Pn.numberOfFailedRequests&&(console.log("Number of failed requests: "+Pn.numberOfFailedRequests),Pn.numberOfFailedRequests=0));Pn.lastNumberOfActiveRequests=Pn.numberOfActiveRequests}()},Bn.getServerKey=function(e){var t=new ln(e).resolve(Vn);t.normalize();var n=t.authority;/:/.test(n)||(n=n+":"+("https"===t.scheme?"443":"80"));var r=Fn[n];return I.defined(r)||(Fn[n]=0),n},Bn.request=function(e){if(On(e.url)||xn(e.url))return Ln.raiseEvent(),e.state=bn.RECEIVED,e.requestFunction();if(++Pn.numberOfAttemptedRequests,I.defined(e.serverKey)||(e.serverKey=Bn.getServerKey(e.url)),!e.throttleByServer||jn(e.serverKey)){if(!Bn.throttleRequests||!e.throttle)return Yn(e);if(!(Un.length>=Bn.maximumRequests)){Wn(e);var t=Nn.insert(e);if(I.defined(t)){if(t===e)return;Hn(t)}return kn(e)}}},Bn.clearForSpecs=function(){for(;0<Nn.length;){Hn(Nn.pop())}for(var e=Un.length,t=0;t<e;++t)Hn(Un[t]);Un.length=0,Fn={},Pn.numberOfAttemptedRequests=0,Pn.numberOfActiveRequests=0,Pn.numberOfCancelledRequests=0,Pn.numberOfCancelledActiveRequests=0,Pn.numberOfFailedRequests=0,Pn.numberOfActiveRequestsEver=0,Pn.lastNumberOfActiveRequests=0},Bn.numberOfActiveRequestsByServer=function(e){return Fn[e]},Bn.requestHeap=Nn;var Zn={},Jn={};Zn.add=function(e,t){var n=e.toLowerCase()+":"+t;I.defined(Jn[n])||(Jn[n]=!0)},Zn.remove=function(e,t){var n=e.toLowerCase()+":"+t;I.defined(Jn[n])&&delete Jn[n]},Zn.contains=function(e){var t=function(e){var t=new ln(e);t.normalize();var n=t.getAuthority();if(I.defined(n)){if(-1!==n.indexOf("@"))n=n.split("@")[1];if(-1===n.indexOf(":")){var r=t.getScheme();if(I.defined(r)||(r=(r=window.location.protocol).substring(0,r.length-1)),"http"===r)n+=":80";else{if("https"!==r)return;n+=":443"}}return n}}(e);return!(!I.defined(t)||!I.defined(Jn[t]))},Zn.clear=function(){Jn={}};var Xn,Gn=function(){try{var e=new XMLHttpRequest;return e.open("GET","#",!0),(e.responseType="blob")===e.responseType}catch(e){return!1}}();function Qn(e,t,n,r){var a,i=e.query;if(!I.defined(i)||0===i.length)return{};if(-1===i.indexOf("=")){var s={};s[i]=void 0,a=s}else a=function(e){var t={};if(""===e)return t;for(var n=e.replace(/\+/g,"%20").split(/[&;]/),r=0,a=n.length;r<a;++r){var i=n[r].split("="),s=decodeURIComponent(i[0]),o=i[1];o=I.defined(o)?decodeURIComponent(o):"";var u=t[s];"string"==typeof u?t[s]=[u,o]:Sn(u)?u.push(o):t[s]=o}return t}(i);t._queryParameters=n?tr(a,t._queryParameters,r):a,e.query=void 0}function Kn(e,t){var n=t._queryParameters,r=Object.keys(n);1!==r.length||I.defined(n[r[0]])?e.query=function(e){var t="";for(var n in e)if(e.hasOwnProperty(n)){var r=e[n],a=encodeURIComponent(n)+"=";if(Sn(r))for(var i=0,s=r.length;i<s;++i)t+=a+encodeURIComponent(r[i])+"&";else t+=a+encodeURIComponent(r)+"&"}return t=t.slice(0,-1)}(n):e.query=r[0]}function $n(e,t){return I.defined(e)?I.defined(e.clone)?e.clone():yn(e):t}function er(e){if(e.state===bn.ISSUED||e.state===bn.ACTIVE)throw new J.RuntimeError("The Resource is already being fetched.");e.state=bn.UNISSUED,e.deferred=void 0}function tr(e,t,n){if(!n)return vn(e,t);var r=yn(e,!0);for(var a in t)if(t.hasOwnProperty(a)){var i=r[a],s=t[a];I.defined(i)?(Array.isArray(i)||(i=r[a]=[i]),r[a]=i.concat(s)):r[a]=Array.isArray(s)?s.slice():s}return r}function nr(e){"string"==typeof(e=P.defaultValue(e,P.defaultValue.EMPTY_OBJECT))&&(e={url:e}),this._url=void 0,this._templateValues=$n(e.templateValues,{}),this._queryParameters=$n(e.queryParameters,{}),this.headers=$n(e.headers,{}),this.request=P.defaultValue(e.request,new Rn),this.proxy=e.proxy,this.retryCallback=e.retryCallback,this.retryAttempts=P.defaultValue(e.retryAttempts,0),this._retryCount=0;var t=new ln(e.url);Qn(t,this,!0,!0),t.fragment=void 0,this._url=t.toString()}function rr(e){var r=e.resource,a=e.flipY,i=e.preferImageBitmap,n=r.request;n.url=r.url,n.requestFunction=function(){var e=r.url,t=!1;r.isDataUri||r.isBlobUri||(t=r.isCrossOriginUrl);var n=f.when.defer();return nr._Implementations.createImage(e,t,n,a,i),n.promise};var t=Bn.request(n);if(I.defined(t))return t.otherwise(function(t){return n.state!==bn.FAILED?f.when.reject(t):r.retryOnError(t).then(function(e){return e?(n.state=bn.UNISSUED,n.deferred=void 0,rr({resource:r,flipY:a,preferImageBitmap:i})):f.when.reject(t)})})}nr.createIfNeeded=function(e){return e instanceof nr?e.getDerivedResource({request:e.request}):"string"!=typeof e?e:new nr({url:e})},nr.supportsImageBitmapOptions=function(){if(I.defined(Xn))return Xn;if("function"!=typeof createImageBitmap)return Xn=f.when.resolve(!1);return Xn=nr.fetchBlob({url:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAADUlEQVQImWP4////fwAJ+wP9CNHoHgAAAABJRU5ErkJggg=="}).then(function(e){return createImageBitmap(e,{imageOrientation:"flipY",premultiplyAlpha:"none"})}).then(function(e){return!0}).otherwise(function(){return!1})},r.defineProperties(nr,{isBlobSupported:{get:function(){return Gn}}}),r.defineProperties(nr.prototype,{queryParameters:{get:function(){return this._queryParameters}},templateValues:{get:function(){return this._templateValues}},url:{get:function(){return this.getUrlComponent(!0,!0)},set:function(e){var t=new ln(e);Qn(t,this,!1),t.fragment=void 0,this._url=t.toString()}},extension:{get:function(){return function(e){var t=new ln(e);t.normalize();var n=t.path,r=n.lastIndexOf("/");return-1!==r&&(n=n.substr(r+1)),n=-1===(r=n.lastIndexOf("."))?"":n.substr(r+1)}(this._url)}},isDataUri:{get:function(){return On(this._url)}},isBlobUri:{get:function(){return xn(this._url)}},isCrossOriginUrl:{get:function(){return function(e){I.defined(Cn)||(Cn=document.createElement("a")),Cn.href=window.location.href;var t=Cn.host,n=Cn.protocol;return Cn.href=e,Cn.href=Cn.href,n!==Cn.protocol||t!==Cn.host}(this._url)}},hasHeaders:{get:function(){return 0<Object.keys(this.headers).length}}}),nr.prototype.getUrlComponent=function(e,t){if(this.isDataUri)return this._url;var n=new ln(this._url);e&&Kn(n,this);var r=n.toString().replace(/%7B/g,"{").replace(/%7D/g,"}"),a=this._templateValues;return r=r.replace(/{(.*?)}/g,function(e,t){var n=a[t];return I.defined(n)?encodeURIComponent(n):e}),t&&I.defined(this.proxy)&&(r=this.proxy.getURL(r)),r},nr.prototype.setQueryParameters=function(e,t){this._queryParameters=t?tr(this._queryParameters,e,!1):tr(e,this._queryParameters,!1)},nr.prototype.appendQueryParameters=function(e){this._queryParameters=tr(e,this._queryParameters,!0)},nr.prototype.setTemplateValues=function(e,t){this._templateValues=t?vn(this._templateValues,e):vn(e,this._templateValues)},nr.prototype.getDerivedResource=function(e){var t=this.clone();if(t._retryCount=0,I.defined(e.url)){var n=new ln(e.url);Qn(n,t,!0,P.defaultValue(e.preserveQueryParameters,!1)),n.fragment=void 0,t._url=n.resolve(new ln(wn(this._url))).toString()}return I.defined(e.queryParameters)&&(t._queryParameters=vn(e.queryParameters,t._queryParameters)),I.defined(e.templateValues)&&(t._templateValues=vn(e.templateValues,t.templateValues)),I.defined(e.headers)&&(t.headers=vn(e.headers,t.headers)),I.defined(e.proxy)&&(t.proxy=e.proxy),I.defined(e.request)&&(t.request=e.request),I.defined(e.retryCallback)&&(t.retryCallback=e.retryCallback),I.defined(e.retryAttempts)&&(t.retryAttempts=e.retryAttempts),t},nr.prototype.retryOnError=function(e){var t=this.retryCallback;if("function"!=typeof t||this._retryCount>=this.retryAttempts)return f.when(!1);var n=this;return f.when(t(this,e)).then(function(e){return++n._retryCount,e})},nr.prototype.clone=function(e){return I.defined(e)||(e=new nr({url:this._url})),e._url=this._url,e._queryParameters=yn(this._queryParameters),e._templateValues=yn(this._templateValues),e.headers=yn(this.headers),e.proxy=this.proxy,e.retryCallback=this.retryCallback,e.retryAttempts=this.retryAttempts,e._retryCount=0,e.request=this.request.clone(),e},nr.prototype.getBaseUri=function(e){return function(e,t){var n="",r=e.lastIndexOf("/");return-1!==r&&(n=e.substring(0,r+1)),t&&(e=new ln(e),I.defined(e.query)&&(n+="?"+e.query),I.defined(e.fragment)&&(n+="#"+e.fragment)),n}(this.getUrlComponent(e),e)},nr.prototype.appendForwardSlash=function(){this._url=function(e){return 0!==e.length&&"/"===e[e.length-1]||(e+="/"),e}(this._url)},nr.prototype.fetchArrayBuffer=function(){return this.fetch({responseType:"arraybuffer"})},nr.fetchArrayBuffer=function(e){return new nr(e).fetchArrayBuffer()},nr.prototype.fetchBlob=function(){return this.fetch({responseType:"blob"})},nr.fetchBlob=function(e){return new nr(e).fetchBlob()},nr.prototype.fetchImage=function(e){e=P.defaultValue(e,P.defaultValue.EMPTY_OBJECT);var t=P.defaultValue(e.preferImageBitmap,!1),n=P.defaultValue(e.preferBlob,!1),r=P.defaultValue(e.flipY,!1);if(er(this.request),!Gn||this.isDataUri||this.isBlobUri||!this.hasHeaders&&!n)return rr({resource:this,flipY:r,preferImageBitmap:t});var a,i,s,o=this.fetchBlob();return I.defined(o)?nr.supportsImageBitmapOptions().then(function(e){return a=e&&t,o}).then(function(e){if(I.defined(e)){if(s=e,a)return nr.createImageBitmapFromBlob(e,{flipY:r,premultiplyAlpha:!1});var t=window.URL.createObjectURL(e);return rr({resource:i=new nr({url:t}),flipY:r,preferImageBitmap:!1})}}).then(function(e){if(I.defined(e))return e.blob=s,a||window.URL.revokeObjectURL(i.url),e}).otherwise(function(e){return I.defined(i)&&window.URL.revokeObjectURL(i.url),e.blob=s,f.when.reject(e)}):void 0},nr.fetchImage=function(e){return new nr(e).fetchImage({flipY:e.flipY,preferBlob:e.preferBlob,preferImageBitmap:e.preferImageBitmap})},nr.prototype.fetchText=function(){return this.fetch({responseType:"text"})},nr.fetchText=function(e){return new nr(e).fetchText()},nr.prototype.fetchJson=function(){var e=this.fetch({responseType:"text",headers:{Accept:"application/json,*/*;q=0.01"}});if(I.defined(e))return e.then(function(e){if(I.defined(e))return JSON.parse(e)})},nr.fetchJson=function(e){return new nr(e).fetchJson()},nr.prototype.fetchXML=function(){return this.fetch({responseType:"document",overrideMimeType:"text/xml"})},nr.fetchXML=function(e){return new nr(e).fetchXML()},nr.prototype.fetchJsonp=function(e){var t;for(e=P.defaultValue(e,"callback"),er(this.request);t="loadJsonp"+Math.random().toString().substring(2,8),I.defined(window[t]););return function n(r,a,i){var e={};e[a]=i;r.setQueryParameters(e);var s=r.request;s.url=r.url;s.requestFunction=function(){var t=f.when.defer();return window[i]=function(e){t.resolve(e);try{delete window[i]}catch(e){window[i]=void 0}},nr._Implementations.loadAndExecuteScript(r.url,i,t),t.promise};var t=Bn.request(s);if(!I.defined(t))return;return t.otherwise(function(t){return s.state!==bn.FAILED?f.when.reject(t):r.retryOnError(t).then(function(e){return e?(s.state=bn.UNISSUED,s.deferred=void 0,n(r,a,i)):f.when.reject(t)})})}(this,e,t)},nr.fetchJsonp=function(e){return new nr(e).fetchJsonp(e.callbackParameterName)},nr.prototype._makeRequest=function(o){var u=this;er(u.request);var l=u.request;l.url=u.url,l.requestFunction=function(){var e=o.responseType,t=vn(o.headers,u.headers),n=o.overrideMimeType,r=o.method,a=o.data,i=f.when.defer(),s=nr._Implementations.loadWithXhr(u.url,e,r,a,t,i,n);return I.defined(s)&&I.defined(s.abort)&&(l.cancelFunction=function(){s.abort()}),i.promise};var e=Bn.request(l);if(I.defined(e))return e.then(function(e){return e}).otherwise(function(t){return l.state!==bn.FAILED?f.when.reject(t):u.retryOnError(t).then(function(e){return e?(l.state=bn.UNISSUED,l.deferred=void 0,u.fetch(o)):f.when.reject(t)})})};var ar=/^data:(.*?)(;base64)?,(.*)$/;function ir(e,t){var n=decodeURIComponent(t);return e?atob(n):n}function sr(e,t){for(var n=ir(e,t),r=new ArrayBuffer(n.length),a=new Uint8Array(r),i=0;i<n.length;i++)a[i]=n.charCodeAt(i);return r}function or(e,t){switch(t){case"text":return e.toString("utf8");case"json":return JSON.parse(e.toString("utf8"));default:return new Uint8Array(e).buffer}}nr.prototype.fetch=function(e){return(e=$n(e,{})).method="GET",this._makeRequest(e)},nr.fetch=function(e){return new nr(e).fetch({responseType:e.responseType,overrideMimeType:e.overrideMimeType})},nr.prototype.delete=function(e){return(e=$n(e,{})).method="DELETE",this._makeRequest(e)},nr.delete=function(e){return new nr(e).delete({responseType:e.responseType,overrideMimeType:e.overrideMimeType,data:e.data})},nr.prototype.head=function(e){return(e=$n(e,{})).method="HEAD",this._makeRequest(e)},nr.head=function(e){return new nr(e).head({responseType:e.responseType,overrideMimeType:e.overrideMimeType})},nr.prototype.options=function(e){return(e=$n(e,{})).method="OPTIONS",this._makeRequest(e)},nr.options=function(e){return new nr(e).options({responseType:e.responseType,overrideMimeType:e.overrideMimeType})},nr.prototype.post=function(e,t){return n.Check.defined("data",e),(t=$n(t,{})).method="POST",t.data=e,this._makeRequest(t)},nr.post=function(e){return new nr(e).post(e.data,{responseType:e.responseType,overrideMimeType:e.overrideMimeType})},nr.prototype.put=function(e,t){return n.Check.defined("data",e),(t=$n(t,{})).method="PUT",t.data=e,this._makeRequest(t)},nr.put=function(e){return new nr(e).put(e.data,{responseType:e.responseType,overrideMimeType:e.overrideMimeType})},nr.prototype.patch=function(e,t){return n.Check.defined("data",e),(t=$n(t,{})).method="PATCH",t.data=e,this._makeRequest(t)},nr.patch=function(e){return new nr(e).patch(e.data,{responseType:e.responseType,overrideMimeType:e.overrideMimeType})},(nr._Implementations={}).createImage=function(t,n,r,a,i){nr.supportsImageBitmapOptions().then(function(e){if(e&&i)return nr.fetchBlob({url:t}).then(function(e){if(I.defined(e))return nr.createImageBitmapFromBlob(e,{flipY:a,premultiplyAlpha:!1});r.reject(new J.RuntimeError("Successfully retrieved "+t+" but it contained no content."))}).then(r.resolve);!function(e,t,n){var r=new Image;r.onload=function(){n.resolve(r)},r.onerror=function(e){n.reject(e)},t&&(Zn.contains(e)?r.crossOrigin="use-credentials":r.crossOrigin=""),r.src=e}(t,n,r)}).otherwise(r.reject)},nr.createImageBitmapFromBlob=function(e,t){return n.Check.defined("options",t),n.Check.typeOf.bool("options.flipY",t.flipY),n.Check.typeOf.bool("options.premultiplyAlpha",t.premultiplyAlpha),createImageBitmap(e,{imageOrientation:t.flipY?"flipY":"none",premultiplyAlpha:t.premultiplyAlpha?"premultiply":"none"})};var ur="undefined"==typeof XMLHttpRequest;function lr(e){if(e=P.defaultValue(e,P.defaultValue.EMPTY_OBJECT),this._dates=void 0,this._samples=void 0,this._dateColumn=-1,this._xPoleWanderRadiansColumn=-1,this._yPoleWanderRadiansColumn=-1,this._ut1MinusUtcSecondsColumn=-1,this._xCelestialPoleOffsetRadiansColumn=-1,this._yCelestialPoleOffsetRadiansColumn=-1,this._taiMinusUtcSecondsColumn=-1,this._columnCount=0,this._lastIndex=-1,this._downloadPromise=void 0,this._dataError=void 0,this._addNewLeapSeconds=P.defaultValue(e.addNewLeapSeconds,!0),I.defined(e.data))dr(this,e.data);else if(I.defined(e.url)){var t=nr.createIfNeeded(e.url),n=this;this._downloadPromise=f.when(t.fetchJson(),function(e){dr(n,e)},function(){n._dataError="An error occurred while retrieving the EOP data from the URL "+t.url+"."})}else dr(this,{columnNames:["dateIso8601","modifiedJulianDateUtc","xPoleWanderRadians","yPoleWanderRadians","ut1MinusUtcSeconds","lengthOfDayCorrectionSeconds","xCelestialPoleOffsetRadians","yCelestialPoleOffsetRadians","taiMinusUtcSeconds"],samples:[]})}function cr(e,t){return on.compare(e.julianDate,t)}function dr(e,t){if(I.defined(t.columnNames))if(I.defined(t.samples)){var n=t.columnNames.indexOf("modifiedJulianDateUtc"),r=t.columnNames.indexOf("xPoleWanderRadians"),a=t.columnNames.indexOf("yPoleWanderRadians"),i=t.columnNames.indexOf("ut1MinusUtcSeconds"),s=t.columnNames.indexOf("xCelestialPoleOffsetRadians"),o=t.columnNames.indexOf("yCelestialPoleOffsetRadians"),u=t.columnNames.indexOf("taiMinusUtcSeconds");if(n<0||r<0||a<0||i<0||s<0||o<0||u<0)e._dataError="Error in loaded EOP data: The columnNames property must include modifiedJulianDateUtc, xPoleWanderRadians, yPoleWanderRadians, ut1MinusUtcSeconds, xCelestialPoleOffsetRadians, yCelestialPoleOffsetRadians, and taiMinusUtcSeconds columns";else{var l,c=e._samples=t.samples,d=e._dates=[];e._dateColumn=n,e._xPoleWanderRadiansColumn=r,e._yPoleWanderRadiansColumn=a,e._ut1MinusUtcSecondsColumn=i,e._xCelestialPoleOffsetRadiansColumn=s,e._yCelestialPoleOffsetRadiansColumn=o,e._taiMinusUtcSecondsColumn=u,e._columnCount=t.columnNames.length,e._lastIndex=void 0;for(var f=e._addNewLeapSeconds,h=0,p=c.length;h<p;h+=e._columnCount){var m=c[h+n],y=c[h+u],v=new on(m+Bt.MODIFIED_JULIAN_DATE_DIFFERENCE,y,Wt.TAI);if(d.push(v),f){if(y!==l&&I.defined(l)){var w=on.leapSeconds,C=Dt(w,v,cr);if(C<0){var g=new Lt(v,y);w.splice(~C,0,g)}}l=y}}}}else e._dataError="Error in loaded EOP data: The samples property is required.";else e._dataError="Error in loaded EOP data: The columnNames property is required."}function fr(e,t,n,r,a){var i=n*r;a.xPoleWander=t[i+e._xPoleWanderRadiansColumn],a.yPoleWander=t[i+e._yPoleWanderRadiansColumn],a.xPoleOffset=t[i+e._xCelestialPoleOffsetRadiansColumn],a.yPoleOffset=t[i+e._yCelestialPoleOffsetRadiansColumn],a.ut1MinusUtc=t[i+e._ut1MinusUtcSecondsColumn]}function hr(e,t,n){return t+e*(n-t)}function pr(e,t,n,r,a,i,s){var o=e._columnCount;if(i>t.length-1)return s.xPoleWander=0,s.yPoleWander=0,s.xPoleOffset=0,s.yPoleOffset=0,s.ut1MinusUtc=0,s;var u=t[a],l=t[i];if(u.equals(l)||r.equals(u))return fr(e,n,a,o,s),s;if(r.equals(l))return fr(e,n,i,o,s),s;var c=on.secondsDifference(r,u)/on.secondsDifference(l,u),d=a*o,f=i*o,h=n[d+e._ut1MinusUtcSecondsColumn],p=n[f+e._ut1MinusUtcSecondsColumn],m=p-h;if(.5<m||m<-.5){var y=n[d+e._taiMinusUtcSecondsColumn],v=n[f+e._taiMinusUtcSecondsColumn];y!==v&&(l.equals(r)?h=p:p-=v-y)}return s.xPoleWander=hr(c,n[d+e._xPoleWanderRadiansColumn],n[f+e._xPoleWanderRadiansColumn]),s.yPoleWander=hr(c,n[d+e._yPoleWanderRadiansColumn],n[f+e._yPoleWanderRadiansColumn]),s.xPoleOffset=hr(c,n[d+e._xCelestialPoleOffsetRadiansColumn],n[f+e._xCelestialPoleOffsetRadiansColumn]),s.yPoleOffset=hr(c,n[d+e._yCelestialPoleOffsetRadiansColumn],n[f+e._yCelestialPoleOffsetRadiansColumn]),s.ut1MinusUtc=hr(c,h,p),s}function mr(e,t,n){this.heading=P.defaultValue(e,0),this.pitch=P.defaultValue(t,0),this.roll=P.defaultValue(n,0)}nr._Implementations.loadWithXhr=function(e,a,i,t,n,s,r){var o=ar.exec(e);if(null===o){if(!ur){var u=new XMLHttpRequest;if(Zn.contains(e)&&(u.withCredentials=!0),u.open(i,e,!0),I.defined(r)&&I.defined(u.overrideMimeType)&&u.overrideMimeType(r),I.defined(n))for(var l in n)n.hasOwnProperty(l)&&u.setRequestHeader(l,n[l]);I.defined(a)&&(u.responseType=a);var c=!1;return"string"==typeof e&&(c=0===e.indexOf("file://")||"undefined"!=typeof window&&"file://"===window.location.origin),u.onload=function(){if(!(u.status<200||300<=u.status)||c&&0===u.status){var e=u.response,t=u.responseType;if("HEAD"===i||"OPTIONS"===i){var n=u.getAllResponseHeaders().trim().split(/[\r\n]+/),r={};return n.forEach(function(e){var t=e.split(": "),n=t.shift();r[n]=t.join(": ")}),void s.resolve(r)}if(204===u.status)s.resolve();else if(!I.defined(e)||I.defined(a)&&t!==a)if("json"===a&&"string"==typeof e)try{s.resolve(JSON.parse(e))}catch(e){s.reject(e)}else(""===t||"document"===t)&&I.defined(u.responseXML)&&u.responseXML.hasChildNodes()?s.resolve(u.responseXML):""!==t&&"text"!==t||!I.defined(u.responseText)?s.reject(new J.RuntimeError("Invalid XMLHttpRequest response type.")):s.resolve(u.responseText);else s.resolve(e)}else s.reject(new An(u.status,u.response,u.getAllResponseHeaders()))},u.onerror=function(e){s.reject(new An)},u.send(t),u}!function(e,r,t,n,a,i){var s=global.require,o=s("url").parse(e),u="https:"===o.protocol?s("https"):s("http"),l=s("zlib"),c={protocol:o.protocol,hostname:o.hostname,port:o.port,path:o.path,query:o.query,method:t,headers:a};u.request(c).on("response",function(t){if(t.statusCode<200||300<=t.statusCode)i.reject(new An(t.statusCode,t,t.headers));else{var n=[];t.on("data",function(e){n.push(e)}),t.on("end",function(){var e=Buffer.concat(n);"gzip"===t.headers["content-encoding"]?l.gunzip(e,function(e,t){e?i.reject(new J.RuntimeError("Error decompressing response.")):i.resolve(or(t,r))}):i.resolve(or(e,r))})}}).on("error",function(e){i.reject(new An)}).end()}(e,a,i,0,n,s)}else s.resolve(function(e,t){t=P.defaultValue(t,"");var n=e[1],r=!!e[2],a=e[3];switch(t){case"":case"text":return ir(r,a);case"arraybuffer":return sr(r,a);case"blob":var i=sr(r,a);return new Blob([i],{type:n});case"document":return(new DOMParser).parseFromString(ir(r,a),n);case"json":return JSON.parse(ir(r,a))}}(o,a))},nr._Implementations.loadAndExecuteScript=function(e,t,n){return function(e){var t=f.when.defer(),n=document.createElement("script");n.async=!0,n.src=e;var r=document.getElementsByTagName("head")[0];return n.onload=function(){n.onload=void 0,r.removeChild(n),t.resolve()},n.onerror=function(e){t.reject(e)},r.appendChild(n),t.promise}(e).otherwise(n.reject)},(nr._DefaultImplementations={}).createImage=nr._Implementations.createImage,nr._DefaultImplementations.loadWithXhr=nr._Implementations.loadWithXhr,nr._DefaultImplementations.loadAndExecuteScript=nr._Implementations.loadAndExecuteScript,nr.DEFAULT=t.freezeObject(new nr({url:"undefined"==typeof document?"":document.location.href.split("?")[0]})),lr.NONE=t.freezeObject({getPromiseToLoad:function(){return f.when()},compute:function(e,t){return I.defined(t)?(t.xPoleWander=0,t.yPoleWander=0,t.xPoleOffset=0,t.yPoleOffset=0,t.ut1MinusUtc=0):t=new Nt(0,0,0,0,0),t}}),lr.prototype.getPromiseToLoad=function(){return f.when(this._downloadPromise)},lr.prototype.compute=function(e,t){if(I.defined(this._samples)){if(I.defined(t)||(t=new Nt(0,0,0,0,0)),0===this._samples.length)return t.xPoleWander=0,t.yPoleWander=0,t.xPoleOffset=0,t.yPoleOffset=0,t.ut1MinusUtc=0,t;var n=this._dates,r=this._lastIndex,a=0,i=0;if(I.defined(r)){var s=n[r],o=n[r+1],u=on.lessThanOrEquals(s,e),l=!I.defined(o),c=l||on.greaterThanOrEquals(o,e);if(u&&c)return a=r,!l&&o.equals(e)&&++a,i=a+1,pr(this,n,this._samples,e,a,i,t),t}var d=Dt(n,e,on.compare,this._dateColumn);return 0<=d?(d<n.length-1&&n[d+1].equals(e)&&++d,i=a=d):(a=(i=~d)-1)<0&&(a=0),this._lastIndex=a,pr(this,n,this._samples,e,a,i,t),t}if(I.defined(this._dataError))throw new J.RuntimeError(this._dataError)},mr.fromQuaternion=function(e,t){I.defined(t)||(t=new mr);var n=2*(e.w*e.y-e.z*e.x),r=1-2*(e.x*e.x+e.y*e.y),a=2*(e.w*e.x+e.y*e.z),i=1-2*(e.y*e.y+e.z*e.z),s=2*(e.w*e.z+e.x*e.y);return t.heading=-Math.atan2(s,i),t.roll=Math.atan2(a,r),t.pitch=-Z.CesiumMath.asinClamped(n),t},mr.fromDegrees=function(e,t,n,r){return I.defined(r)||(r=new mr),r.heading=e*Z.CesiumMath.RADIANS_PER_DEGREE,r.pitch=t*Z.CesiumMath.RADIANS_PER_DEGREE,r.roll=n*Z.CesiumMath.RADIANS_PER_DEGREE,r},mr.clone=function(e,t){if(I.defined(e))return I.defined(t)?(t.heading=e.heading,t.pitch=e.pitch,t.roll=e.roll,t):new mr(e.heading,e.pitch,e.roll)},mr.equals=function(e,t){return e===t||I.defined(e)&&I.defined(t)&&e.heading===t.heading&&e.pitch===t.pitch&&e.roll===t.roll},mr.equalsEpsilon=function(e,t,n,r){return e===t||I.defined(e)&&I.defined(t)&&Z.CesiumMath.equalsEpsilon(e.heading,t.heading,n,r)&&Z.CesiumMath.equalsEpsilon(e.pitch,t.pitch,n,r)&&Z.CesiumMath.equalsEpsilon(e.roll,t.roll,n,r)},mr.prototype.clone=function(e){return mr.clone(this,e)},mr.prototype.equals=function(e){return mr.equals(this,e)},mr.prototype.equalsEpsilon=function(e,t,n){return mr.equalsEpsilon(this,e,t,n)},mr.prototype.toString=function(){return"("+this.heading+", "+this.pitch+", "+this.roll+")"};var yr,vr,wr,Cr=/((?:.*\/)|^)Cesium\.js$/;function gr(e){return"undefined"==typeof document?e:(I.defined(yr)||(yr=document.createElement("a")),yr.href=e,yr.href=yr.href,yr.href)}function xr(){return I.defined(vr)||(e="undefined"!=typeof CESIUM_BASE_URL?CESIUM_BASE_URL:"object"==typeof define&&I.defined(define.amd)&&!define.amd.toUrlUndefined&&I.defined(require.toUrl)?wn("..",_r("Core/buildModuleUrl.js")):function(){for(var e=document.getElementsByTagName("script"),t=0,n=e.length;t<n;++t){var r=e[t].getAttribute("src"),a=Cr.exec(r);if(null!==a)return a[1]}}(),(vr=new nr({url:gr(e)})).appendForwardSlash()),vr;var e}function Er(e){return gr(require.toUrl("../"+e))}function Or(e){return xr().getDerivedResource({url:e}).url}function _r(e){return I.defined(wr)||(wr="object"==typeof define&&I.defined(define.amd)&&!define.amd.toUrlUndefined&&I.defined(require.toUrl)?Er:Or),wr(e)}function Sr(e,t,n){this.x=e,this.y=t,this.s=n}function br(e){e=P.defaultValue(e,P.defaultValue.EMPTY_OBJECT),this._xysFileUrlTemplate=nr.createIfNeeded(e.xysFileUrlTemplate),this._interpolationOrder=P.defaultValue(e.interpolationOrder,9),this._sampleZeroJulianEphemerisDate=P.defaultValue(e.sampleZeroJulianEphemerisDate,2442396.5),this._sampleZeroDateTT=new on(this._sampleZeroJulianEphemerisDate,0,Wt.TAI),this._stepSizeDays=P.defaultValue(e.stepSizeDays,1),this._samplesPerXysFile=P.defaultValue(e.samplesPerXysFile,1e3),this._totalSamples=P.defaultValue(e.totalSamples,27426),this._samples=new Array(3*this._totalSamples),this._chunkDownloadsInProgress=[];for(var t=this._interpolationOrder,n=this._denominators=new Array(t+1),r=this._xTable=new Array(t+1),a=Math.pow(this._stepSizeDays,t),i=0;i<=t;++i){n[i]=a,r[i]=i*this._stepSizeDays;for(var s=0;s<=t;++s)s!==i&&(n[i]*=i-s);n[i]=1/n[i]}this._work=new Array(t+1),this._coef=new Array(t+1)}_r._cesiumScriptRegex=Cr,_r._buildModuleUrlFromBaseUrl=Or,_r._clearBaseResource=function(){vr=void 0},_r.setBaseUrl=function(e){vr=nr.DEFAULT.getDerivedResource({url:e})},_r.getCesiumBaseUrl=xr;var Mr=new on(0,0,Wt.TAI);function Rr(e,t,n){var r=Mr;return r.dayNumber=t,r.secondsOfDay=n,on.daysDifference(r,e._sampleZeroDateTT)}function Ar(s,o){if(s._chunkDownloadsInProgress[o])return s._chunkDownloadsInProgress[o];var e,u=f.when.defer();s._chunkDownloadsInProgress[o]=u;var t=s._xysFileUrlTemplate;return e=I.defined(t)?t.getDerivedResource({templateValues:{0:o}}):new nr({url:_r("Assets/IAU2006_XYS/IAU2006_XYS_"+o+".json")}),f.when(e.fetchJson(),function(e){s._chunkDownloadsInProgress[o]=!1;for(var t=s._samples,n=e.samples,r=o*s._samplesPerXysFile*3,a=0,i=n.length;a<i;++a)t[r+a]=n[a];u.resolve()}),u.promise}br.prototype.preload=function(e,t,n,r){var a=Rr(this,e,t),i=Rr(this,n,r),s=a/this._stepSizeDays-this._interpolationOrder/2|0;s<0&&(s=0);var o=i/this._stepSizeDays-this._interpolationOrder/2|0+this._interpolationOrder;o>=this._totalSamples&&(o=this._totalSamples-1);for(var u=s/this._samplesPerXysFile|0,l=o/this._samplesPerXysFile|0,c=[],d=u;d<=l;++d)c.push(Ar(this,d));return f.when.all(c)},br.prototype.computeXysRadians=function(e,t,n){var r=Rr(this,e,t);if(!(r<0)){var a=r/this._stepSizeDays|0;if(!(a>=this._totalSamples)){var i=this._interpolationOrder,s=a-(i/2|0);s<0&&(s=0);var o=s+i;o>=this._totalSamples&&(s=(o=this._totalSamples-1)-i)<0&&(s=0);var u=!1,l=this._samples;if(I.defined(l[3*s])||(Ar(this,s/this._samplesPerXysFile|0),u=!0),I.defined(l[3*o])||(Ar(this,o/this._samplesPerXysFile|0),u=!0),!u){I.defined(n)?(n.x=0,n.y=0,n.s=0):n=new Sr(0,0,0);var c,d,f=r-s*this._stepSizeDays,h=this._work,p=this._denominators,m=this._coef,y=this._xTable;for(c=0;c<=i;++c)h[c]=f-y[c];for(c=0;c<=i;++c){for(m[c]=1,d=0;d<=i;++d)d!==c&&(m[c]*=h[d]);m[c]*=p[c];var v=3*(s+c);n.x+=m[c]*l[v++],n.y+=m[c]*l[v++],n.s+=m[c]*l[v]}return n}}}};var Tr={},zr={up:{south:"east",north:"west",west:"south",east:"north"},down:{south:"west",north:"east",west:"north",east:"south"},south:{up:"west",down:"east",west:"down",east:"up"},north:{up:"east",down:"west",west:"up",east:"down"},west:{up:"north",down:"south",north:"down",south:"up"},east:{up:"south",down:"north",north:"up",south:"down"}},qr={north:[-1,0,0],east:[0,1,0],up:[0,0,1],south:[1,0,0],west:[0,-1,0],down:[0,0,-1]},Ir={},Pr={east:new D.Cartesian3,north:new D.Cartesian3,up:new D.Cartesian3,west:new D.Cartesian3,south:new D.Cartesian3,down:new D.Cartesian3},Dr=new D.Cartesian3,Nr=new D.Cartesian3,Ur=new D.Cartesian3;Tr.localFrameToFixedFrameGenerator=function(s,o){if(!zr.hasOwnProperty(s)||!zr[s].hasOwnProperty(o))throw new n.DeveloperError("firstAxis and secondAxis must be east, north, up, west, south or down.");var e,u=zr[s][o],t=s+o;return I.defined(Ir[t])?e=Ir[t]:(e=function(e,t,n){if(I.defined(n)||(n=new Q),Z.CesiumMath.equalsEpsilon(e.x,0,Z.CesiumMath.EPSILON14)&&Z.CesiumMath.equalsEpsilon(e.y,0,Z.CesiumMath.EPSILON14)){var r=Z.CesiumMath.sign(e.z);D.Cartesian3.unpack(qr[s],0,Dr),"east"!==s&&"west"!==s&&D.Cartesian3.multiplyByScalar(Dr,r,Dr),D.Cartesian3.unpack(qr[o],0,Nr),"east"!==o&&"west"!==o&&D.Cartesian3.multiplyByScalar(Nr,r,Nr),D.Cartesian3.unpack(qr[u],0,Ur),"east"!==u&&"west"!==u&&D.Cartesian3.multiplyByScalar(Ur,r,Ur)}else{(t=P.defaultValue(t,D.Ellipsoid.WGS84)).geodeticSurfaceNormal(e,Pr.up);var a=Pr.up,i=Pr.east;i.x=-e.y,i.y=e.x,i.z=0,D.Cartesian3.normalize(i,Pr.east),D.Cartesian3.cross(a,i,Pr.north),D.Cartesian3.multiplyByScalar(Pr.up,-1,Pr.down),D.Cartesian3.multiplyByScalar(Pr.east,-1,Pr.west),D.Cartesian3.multiplyByScalar(Pr.north,-1,Pr.south),Dr=Pr[s],Nr=Pr[o],Ur=Pr[u]}return n[0]=Dr.x,n[1]=Dr.y,n[2]=Dr.z,n[3]=0,n[4]=Nr.x,n[5]=Nr.y,n[6]=Nr.z,n[7]=0,n[8]=Ur.x,n[9]=Ur.y,n[10]=Ur.z,n[11]=0,n[12]=e.x,n[13]=e.y,n[14]=e.z,n[15]=1,n},Ir[t]=e),e},Tr.eastNorthUpToFixedFrame=Tr.localFrameToFixedFrameGenerator("east","north"),Tr.northEastDownToFixedFrame=Tr.localFrameToFixedFrameGenerator("north","east"),Tr.northUpEastToFixedFrame=Tr.localFrameToFixedFrameGenerator("north","up"),Tr.northWestUpToFixedFrame=Tr.localFrameToFixedFrameGenerator("north","west");var Fr=new it,Vr=new D.Cartesian3(1,1,1),Lr=new Q;Tr.headingPitchRollToFixedFrame=function(e,t,n,r,a){r=P.defaultValue(r,Tr.eastNorthUpToFixedFrame);var i=it.fromHeadingPitchRoll(t,Fr),s=Q.fromTranslationQuaternionRotationScale(D.Cartesian3.ZERO,i,Vr,Lr);return a=r(e,n,a),Q.multiply(a,s,a)};var Br=new Q,Wr=new X;Tr.headingPitchRollQuaternion=function(e,t,n,r,a){var i=Tr.headingPitchRollToFixedFrame(e,t,n,r,Br),s=Q.getMatrix3(i,Wr);return it.fromRotationMatrix(s,a)};var jr=new D.Cartesian3(1,1,1),kr=new D.Cartesian3,Yr=new Q,Hr=new Q,Zr=new X,Jr=new it;Tr.fixedFrameToHeadingPitchRoll=function(e,t,n,r){t=P.defaultValue(t,D.Ellipsoid.WGS84),n=P.defaultValue(n,Tr.eastNorthUpToFixedFrame),I.defined(r)||(r=new mr);var a=Q.getTranslation(e,kr);if(D.Cartesian3.equals(a,D.Cartesian3.ZERO))return r.heading=0,r.pitch=0,r.roll=0,r;var i=Q.inverseTransformation(n(a,t,Yr),Yr),s=Q.setScale(e,jr,Hr);s=Q.setTranslation(s,D.Cartesian3.ZERO,s),i=Q.multiply(i,s,i);var o=it.fromRotationMatrix(Q.getMatrix3(i,Zr),Jr);return o=it.normalize(o,o),mr.fromQuaternion(o,r)};var Xr=Z.CesiumMath.TWO_PI/86400,Gr=new on;Tr.computeTemeToPseudoFixedMatrix=function(e,t){var n,r=(Gr=on.addSeconds(e,-on.computeTaiMinusUtc(e),Gr)).dayNumber,a=Gr.secondsOfDay,i=r-2451545,s=(24110.54841+(n=43200<=a?(.5+i)/Bt.DAYS_PER_JULIAN_CENTURY:(i-.5)/Bt.DAYS_PER_JULIAN_CENTURY)*(8640184.812866+n*(.093104+-62e-7*n)))*Xr%Z.CesiumMath.TWO_PI+(72921158553e-15+11772758384668e-32*(r-2451545.5))*((a+.5*Bt.SECONDS_PER_DAY)%Bt.SECONDS_PER_DAY),o=Math.cos(s),u=Math.sin(s);return I.defined(t)?(t[0]=o,t[1]=-u,t[2]=0,t[3]=u,t[4]=o,t[5]=0,t[6]=0,t[7]=0,t[8]=1,t):new X(o,u,0,-u,o,0,0,0,1)},Tr.iau2006XysData=new br,Tr.earthOrientationParameters=lr.NONE;var Qr=32.184;Tr.preloadIcrfFixed=function(e){var t=e.start.dayNumber,n=e.start.secondsOfDay+Qr,r=e.stop.dayNumber,a=e.stop.secondsOfDay+Qr,i=Tr.iau2006XysData.preload(t,n,r,a),s=Tr.earthOrientationParameters.getPromiseToLoad();return f.when.all([i,s])},Tr.computeIcrfToFixedMatrix=function(e,t){I.defined(t)||(t=new X);var n=Tr.computeFixedToIcrfMatrix(e,t);if(I.defined(n))return X.transpose(n,t)};var Kr=new Sr(0,0,0),$r=new Nt(0,0,0,0,0,0),ea=new X,ta=new X;Tr.computeFixedToIcrfMatrix=function(e,t){I.defined(t)||(t=new X);var n=Tr.earthOrientationParameters.compute(e,$r);if(I.defined(n)){var r=e.dayNumber,a=e.secondsOfDay+Qr,i=Tr.iau2006XysData.computeXysRadians(r,a,Kr);if(I.defined(i)){var s=i.x+n.xPoleOffset,o=i.y+n.yPoleOffset,u=1/(1+Math.sqrt(1-s*s-o*o)),l=ea;l[0]=1-u*s*s,l[3]=-u*s*o,l[6]=s,l[1]=-u*s*o,l[4]=1-u*o*o,l[7]=o,l[2]=-s,l[5]=-o,l[8]=1-u*(s*s+o*o);var c=X.fromRotationZ(-i.s,ta),d=X.multiply(l,c,ea),f=e.dayNumber-2451545,h=(e.secondsOfDay-on.computeTaiMinusUtc(e)+n.ut1MinusUtc)/Bt.SECONDS_PER_DAY,p=.779057273264+h+.00273781191135448*(f+h);p=p%1*Z.CesiumMath.TWO_PI;var m=X.fromRotationZ(p,ta),y=X.multiply(d,m,ea),v=Math.cos(n.xPoleWander),w=Math.cos(n.yPoleWander),C=Math.sin(n.xPoleWander),g=Math.sin(n.yPoleWander),x=r-2451545+a/Bt.SECONDS_PER_DAY,E=-47e-6*(x/=36525)*Z.CesiumMath.RADIANS_PER_DEGREE/3600,O=Math.cos(E),_=Math.sin(E),S=ta;return S[0]=v*O,S[1]=v*_,S[2]=C,S[3]=-w*_+g*C*O,S[4]=w*O+g*C*_,S[5]=-g*v,S[6]=-g*_-w*C*O,S[7]=g*O-w*C*_,S[8]=w*v,X.multiply(y,S,t)}}};var na=new G;Tr.pointToWindowCoordinates=function(e,t,n,r){return(r=Tr.pointToGLWindowCoordinates(e,t,n,r)).y=2*t[5]-r.y,r},Tr.pointToGLWindowCoordinates=function(e,t,n,r){I.defined(r)||(r=new D.Cartesian2);var a=na;return Q.multiplyByVector(e,G.fromElements(n.x,n.y,n.z,1,a),a),G.multiplyByScalar(a,1/a.w,a),Q.multiplyByVector(t,a,a),D.Cartesian2.fromCartesian4(a,r)};var ra=new D.Cartesian3,aa=new D.Cartesian3,ia=new D.Cartesian3;Tr.rotationMatrixFromPositionVelocity=function(e,t,n,r){var a=P.defaultValue(n,D.Ellipsoid.WGS84).geodeticSurfaceNormal(e,ra),i=D.Cartesian3.cross(t,a,aa);D.Cartesian3.equalsEpsilon(i,D.Cartesian3.ZERO,Z.CesiumMath.EPSILON6)&&(i=D.Cartesian3.clone(D.Cartesian3.UNIT_X,i));var s=D.Cartesian3.cross(i,t,ia);return D.Cartesian3.normalize(s,s),D.Cartesian3.cross(t,s,i),D.Cartesian3.negate(i,i),D.Cartesian3.normalize(i,i),I.defined(r)||(r=new X),r[0]=t.x,r[1]=t.y,r[2]=t.z,r[3]=i.x,r[4]=i.y,r[5]=i.z,r[6]=s.x,r[7]=s.y,r[8]=s.z,r};var sa=new Q(0,0,1,0,1,0,0,0,0,1,0,0,0,0,0,1),oa=new D.Cartographic,ua=new D.Cartesian3,la=new D.Cartesian3,ca=new X,da=new Q,fa=new Q;Tr.basisTo2D=function(e,t,n){var r=Q.getTranslation(t,la),a=e.ellipsoid,i=a.cartesianToCartographic(r,oa),s=e.project(i,ua);D.Cartesian3.fromElements(s.z,s.x,s.y,s);var o=Tr.eastNorthUpToFixedFrame(r,a,da),u=Q.inverseTransformation(o,fa),l=Q.getMatrix3(t,ca),c=Q.multiplyByMatrix3(u,l,n);return Q.multiply(sa,c,n),Q.setTranslation(n,s,n),n},Tr.wgs84To2DModelMatrix=function(e,t,n){var r=e.ellipsoid,a=Tr.eastNorthUpToFixedFrame(t,r,da),i=Q.inverseTransformation(a,fa),s=r.cartesianToCartographic(t,oa),o=e.project(s,ua);D.Cartesian3.fromElements(o.z,o.x,o.y,o);var u=Q.fromTranslation(o,da);return Q.multiply(sa,i,n),Q.multiply(u,n,n),n},e.BoundingSphere=N,e.Cartesian4=G,e.FeatureDetection=at,e.GeographicProjection=a,e.Intersect=s,e.Interval=o,e.Matrix3=X,e.Matrix4=Q,e.Quaternion=it,e.Resource=nr,e.Transforms=Tr,e.buildModuleUrl=_r,e.deprecationWarning=_,e.isArray=Sn,e.oneTimeWarning=O});
