/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.set;

import bak.pcj.LongCollection;
import bak.pcj.LongIterator;
import bak.pcj.hash.DefaultLongHashFunction;
import bak.pcj.hash.LongHashFunction;
import bak.pcj.hash.Primes;
import bak.pcj.set.AbstractLongSet;
import bak.pcj.set.LongSet;
import bak.pcj.util.Exceptions;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class LongChainedHashSet
extends AbstractLongSet
implements LongSet,
Cloneable,
Serializable {
    private static final int GROWTH_POLICY_RELATIVE = 0;
    private static final int GROWTH_POLICY_ABSOLUTE = 1;
    private static final int DEFAULT_GROWTH_POLICY = 0;
    public static final double DEFAULT_GROWTH_FACTOR = 1.0;
    public static final int DEFAULT_GROWTH_CHUNK = 10;
    public static final int DEFAULT_CAPACITY = 11;
    public static final double DEFAULT_LOAD_FACTOR = 0.75;
    private LongHashFunction keyhash;
    private int size;
    private transient long[][] data;
    private int growthPolicy;
    private double growthFactor;
    private int growthChunk;
    private double loadFactor;
    private int expandAt;

    private LongChainedHashSet(LongHashFunction keyhash, int capacity, int growthPolicy, double growthFactor, int growthChunk, double loadFactor) {
        if (keyhash == null) {
            Exceptions.nullArgument("hash function");
        }
        if (capacity < 0) {
            Exceptions.negativeArgument("capacity", String.valueOf(capacity));
        }
        if (growthFactor < 0.0) {
            Exceptions.negativeArgument("growthFactor", String.valueOf(growthFactor));
        }
        if (growthChunk < 0) {
            Exceptions.negativeArgument("growthChunk", String.valueOf(growthChunk));
        }
        if (loadFactor <= 0.0) {
            Exceptions.negativeOrZeroArgument("loadFactor", String.valueOf(loadFactor));
        }
        this.data = new long[capacity][];
        this.size = 0;
        this.expandAt = (int)Math.round(loadFactor * (double)capacity);
        this.growthPolicy = growthPolicy;
        this.growthFactor = growthFactor;
        this.growthChunk = growthChunk;
        this.loadFactor = loadFactor;
        this.keyhash = keyhash;
    }

    private LongChainedHashSet(int capacity, int growthPolicy, double growthFactor, int growthChunk, double loadFactor) {
        this(DefaultLongHashFunction.INSTANCE, capacity, growthPolicy, growthFactor, growthChunk, loadFactor);
    }

    public LongChainedHashSet() {
        this(11);
    }

    public LongChainedHashSet(LongCollection c) {
        this();
        this.addAll(c);
    }

    public LongChainedHashSet(long[] a) {
        this();
        int i = 0;
        while (i < a.length) {
            this.add(a[i]);
            ++i;
        }
    }

    public LongChainedHashSet(int capacity) {
        this(capacity, 0, 1.0, 10, 0.75);
    }

    public LongChainedHashSet(double loadFactor) {
        this(11, 0, 1.0, 10, loadFactor);
    }

    public LongChainedHashSet(int capacity, double loadFactor) {
        this(capacity, 0, 1.0, 10, loadFactor);
    }

    public LongChainedHashSet(int capacity, double loadFactor, double growthFactor) {
        this(capacity, 0, growthFactor, 10, loadFactor);
    }

    public LongChainedHashSet(int capacity, double loadFactor, int growthChunk) {
        this(capacity, 1, 1.0, growthChunk, loadFactor);
    }

    public LongChainedHashSet(LongHashFunction keyhash) {
        this(keyhash, 11, 0, 1.0, 10, 0.75);
    }

    public LongChainedHashSet(LongHashFunction keyhash, int capacity) {
        this(keyhash, capacity, 0, 1.0, 10, 0.75);
    }

    public LongChainedHashSet(LongHashFunction keyhash, double loadFactor) {
        this(keyhash, 11, 0, 1.0, 10, loadFactor);
    }

    public LongChainedHashSet(LongHashFunction keyhash, int capacity, double loadFactor) {
        this(keyhash, capacity, 0, 1.0, 10, loadFactor);
    }

    public LongChainedHashSet(LongHashFunction keyhash, int capacity, double loadFactor, double growthFactor) {
        this(keyhash, capacity, 0, growthFactor, 10, loadFactor);
    }

    public LongChainedHashSet(LongHashFunction keyhash, int capacity, double loadFactor, int growthChunk) {
        this(keyhash, capacity, 1, 1.0, growthChunk, loadFactor);
    }

    private void ensureCapacity(int elements) {
        if (elements >= this.expandAt) {
            int newcapacity = this.growthPolicy == 0 ? (int)((double)this.data.length * (1.0 + this.growthFactor)) : this.data.length + this.growthChunk;
            if ((double)newcapacity * this.loadFactor < (double)elements) {
                newcapacity = (int)Math.round((double)elements / this.loadFactor);
            }
            newcapacity = Primes.nextPrime(newcapacity);
            this.expandAt = (int)Math.round(this.loadFactor * (double)newcapacity);
            long[][] newdata = new long[newcapacity][];
            int i = 0;
            while (i < this.data.length) {
                long[] list = this.data[i];
                if (list != null) {
                    int n = 0;
                    while (n < list.length) {
                        long v = list[n];
                        int index = Math.abs(this.keyhash.hash(v)) % newdata.length;
                        newdata[index] = this.addList(newdata[index], v);
                        ++n;
                    }
                }
                ++i;
            }
            this.data = newdata;
        }
    }

    private long[] addList(long[] list, long v) {
        if (list == null) {
            return new long[]{v};
        }
        long[] newlist = new long[list.length + 1];
        int i = 0;
        while (i < list.length) {
            newlist[i] = list[i];
            ++i;
        }
        newlist[list.length] = v;
        return newlist;
    }

    private long[] removeList(long[] list, int index) {
        if (list.length == 1) {
            return null;
        }
        long[] newlist = new long[list.length - 1];
        int n = 0;
        int i = 0;
        while (i < index) {
            newlist[n++] = list[i];
            ++i;
        }
        int i2 = index + 1;
        while (i2 < list.length) {
            newlist[n++] = list[i2];
            ++i2;
        }
        return newlist;
    }

    private int searchList(long[] list, long v) {
        int i = 0;
        while (i < list.length) {
            if (list[i] == v) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean add(long v) {
        this.ensureCapacity(this.size + 1);
        int index = Math.abs(this.keyhash.hash(v)) % this.data.length;
        long[] list = this.data[index];
        if (list == null) {
            this.data[index] = new long[]{v};
            ++this.size;
            return true;
        }
        int i = 0;
        while (i < list.length) {
            if (list[i] == v) {
                return false;
            }
            ++i;
        }
        this.data[index] = this.addList(this.data[index], v);
        ++this.size;
        return true;
    }

    public LongIterator iterator() {
        return new LongIterator(){
            int currList = this.nextList(0);
            int currLong = 0;
            int lastList = -1;
            int lastLong;
            long lastValue;

            int nextList(int index) {
                while (index < LongChainedHashSet.this.data.length && LongChainedHashSet.this.data[index] == null) {
                    ++index;
                }
                return index < LongChainedHashSet.this.data.length ? index : -1;
            }

            public boolean hasNext() {
                return this.currList != -1;
            }

            public long next() {
                if (this.currList == -1) {
                    Exceptions.endOfIterator();
                }
                this.lastList = this.currList;
                this.lastLong = this.currLong;
                this.lastValue = LongChainedHashSet.this.data[this.currList][this.currLong];
                if (this.currLong == LongChainedHashSet.this.data[this.currList].length - 1) {
                    this.currList = this.nextList(this.currList + 1);
                    this.currLong = 0;
                } else {
                    ++this.currLong;
                }
                return this.lastValue;
            }

            public void remove() {
                if (this.lastList == -1) {
                    Exceptions.noElementToRemove();
                }
                if (this.currList == this.lastList) {
                    --this.currLong;
                }
                ((LongChainedHashSet)LongChainedHashSet.this).data[this.lastList] = LongChainedHashSet.this.removeList(LongChainedHashSet.this.data[this.lastList], this.lastLong);
                LongChainedHashSet.this.size--;
                this.lastList = -1;
            }
        };
    }

    public void trimToSize() {
    }

    public Object clone() {
        try {
            LongChainedHashSet c = (LongChainedHashSet)super.clone();
            c.data = new long[this.data.length][];
            System.arraycopy(this.data, 0, c.data, 0, this.data.length);
            return c;
        }
        catch (CloneNotSupportedException e) {
            Exceptions.cloning();
            throw new RuntimeException();
        }
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        this.size = 0;
    }

    public boolean contains(long v) {
        long[] list = this.data[Math.abs(this.keyhash.hash(v)) % this.data.length];
        if (list == null) {
            return false;
        }
        return this.searchList(list, v) != -1;
    }

    public int hashCode() {
        int h = 0;
        int i = 0;
        while (i < this.data.length) {
            long[] list = this.data[i];
            if (list != null) {
                int n = 0;
                while (n < list.length) {
                    h = (int)((long)h + list[n]);
                    ++n;
                }
            }
            ++i;
        }
        return h;
    }

    public boolean remove(long v) {
        int index = Math.abs(this.keyhash.hash(v)) % this.data.length;
        long[] list = this.data[index];
        if (list != null) {
            int lindex = this.searchList(list, v);
            if (lindex == -1) {
                return false;
            }
            this.data[index] = this.removeList(list, lindex);
            --this.size;
            return true;
        }
        return false;
    }

    public long[] toArray(long[] a) {
        if (a == null || a.length < this.size) {
            a = new long[this.size];
        }
        int p = 0;
        int i = 0;
        while (i < this.data.length) {
            long[] list = this.data[i];
            if (list != null) {
                int n = 0;
                while (n < list.length) {
                    a[p++] = list[n];
                    ++n;
                }
            }
            ++i;
        }
        return a;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.data.length);
        LongIterator i = this.iterator();
        while (i.hasNext()) {
            long x = i.next();
            s.writeLong(x);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.data = new long[s.readInt()][];
        int i = 0;
        while (i < this.size) {
            long v = s.readLong();
            int index = Math.abs(this.keyhash.hash(v)) % this.data.length;
            long[] list = this.data[index];
            this.data[index] = list == null ? new long[]{v} : this.addList(this.data[index], v);
            ++i;
        }
    }
}

