/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.map;

import bak.pcj.FloatIterator;
import bak.pcj.hash.DefaultFloatHashFunction;
import bak.pcj.hash.FloatHashFunction;
import bak.pcj.hash.Primes;
import bak.pcj.map.AbstractFloatKeyMap;
import bak.pcj.map.FloatKeyMap;
import bak.pcj.map.FloatKeyMapIterator;
import bak.pcj.set.AbstractFloatSet;
import bak.pcj.set.FloatSet;
import bak.pcj.util.Exceptions;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

public class FloatKeyOpenHashMap
extends AbstractFloatKeyMap
implements FloatKeyMap,
Cloneable,
Serializable {
    private static final int GROWTH_POLICY_RELATIVE = 0;
    private static final int GROWTH_POLICY_ABSOLUTE = 1;
    private static final int DEFAULT_GROWTH_POLICY = 0;
    public static final double DEFAULT_GROWTH_FACTOR = 1.0;
    public static final int DEFAULT_GROWTH_CHUNK = 10;
    public static final int DEFAULT_CAPACITY = 11;
    public static final double DEFAULT_LOAD_FACTOR = 0.75;
    private FloatHashFunction keyhash;
    private int size;
    private transient float[] keys;
    private transient Object[] values;
    private transient byte[] states;
    private static final byte EMPTY = 0;
    private static final byte OCCUPIED = 1;
    private static final byte REMOVED = 2;
    private transient int used;
    private int growthPolicy;
    private double growthFactor;
    private int growthChunk;
    private double loadFactor;
    private int expandAt;
    private transient FloatSet ckeys;
    private transient Collection cvalues;

    private FloatKeyOpenHashMap(FloatHashFunction keyhash, int capacity, int growthPolicy, double growthFactor, int growthChunk, double loadFactor) {
        if (keyhash == null) {
            Exceptions.nullArgument("hash function");
        }
        if (capacity < 0) {
            Exceptions.negativeArgument("capacity", String.valueOf(capacity));
        }
        if (growthFactor <= 0.0) {
            Exceptions.negativeOrZeroArgument("growthFactor", String.valueOf(growthFactor));
        }
        if (growthChunk <= 0) {
            Exceptions.negativeOrZeroArgument("growthChunk", String.valueOf(growthChunk));
        }
        if (loadFactor <= 0.0) {
            Exceptions.negativeOrZeroArgument("loadFactor", String.valueOf(loadFactor));
        }
        this.keyhash = keyhash;
        capacity = Primes.nextPrime(capacity);
        this.keys = new float[capacity];
        this.values = new Object[capacity];
        this.states = new byte[capacity];
        this.size = 0;
        this.expandAt = (int)Math.round(loadFactor * (double)capacity);
        this.used = 0;
        this.growthPolicy = growthPolicy;
        this.growthFactor = growthFactor;
        this.growthChunk = growthChunk;
        this.loadFactor = loadFactor;
    }

    private FloatKeyOpenHashMap(int capacity, int growthPolicy, double growthFactor, int growthChunk, double loadFactor) {
        this(DefaultFloatHashFunction.INSTANCE, capacity, growthPolicy, growthFactor, growthChunk, loadFactor);
    }

    public FloatKeyOpenHashMap() {
        this(11);
    }

    public FloatKeyOpenHashMap(FloatKeyMap map) {
        this();
        this.putAll(map);
    }

    public FloatKeyOpenHashMap(int capacity) {
        this(capacity, 0, 1.0, 10, 0.75);
    }

    public FloatKeyOpenHashMap(double loadFactor) {
        this(11, 0, 1.0, 10, loadFactor);
    }

    public FloatKeyOpenHashMap(int capacity, double loadFactor) {
        this(capacity, 0, 1.0, 10, loadFactor);
    }

    public FloatKeyOpenHashMap(int capacity, double loadFactor, double growthFactor) {
        this(capacity, 0, growthFactor, 10, loadFactor);
    }

    public FloatKeyOpenHashMap(int capacity, double loadFactor, int growthChunk) {
        this(capacity, 1, 1.0, growthChunk, loadFactor);
    }

    public FloatKeyOpenHashMap(FloatHashFunction keyhash) {
        this(keyhash, 11, 0, 1.0, 10, 0.75);
    }

    public FloatKeyOpenHashMap(FloatHashFunction keyhash, int capacity) {
        this(keyhash, capacity, 0, 1.0, 10, 0.75);
    }

    public FloatKeyOpenHashMap(FloatHashFunction keyhash, double loadFactor) {
        this(keyhash, 11, 0, 1.0, 10, loadFactor);
    }

    public FloatKeyOpenHashMap(FloatHashFunction keyhash, int capacity, double loadFactor) {
        this(keyhash, capacity, 0, 1.0, 10, loadFactor);
    }

    public FloatKeyOpenHashMap(FloatHashFunction keyhash, int capacity, double loadFactor, double growthFactor) {
        this(keyhash, capacity, 0, growthFactor, 10, loadFactor);
    }

    public FloatKeyOpenHashMap(FloatHashFunction keyhash, int capacity, double loadFactor, int growthChunk) {
        this(keyhash, capacity, 1, 1.0, growthChunk, loadFactor);
    }

    private void ensureCapacity(int elements) {
        if (elements >= this.expandAt) {
            int newcapacity = this.growthPolicy == 0 ? (int)((double)this.keys.length * (1.0 + this.growthFactor)) : this.keys.length + this.growthChunk;
            if ((double)newcapacity * this.loadFactor < (double)elements) {
                newcapacity = (int)Math.round((double)elements / this.loadFactor);
            }
            newcapacity = Primes.nextPrime(newcapacity);
            this.expandAt = (int)Math.round(this.loadFactor * (double)newcapacity);
            float[] newkeys = new float[newcapacity];
            Object[] newvalues = new Object[newcapacity];
            byte[] newstates = new byte[newcapacity];
            this.used = 0;
            int i = 0;
            while (i < this.keys.length) {
                if (this.states[i] == 1) {
                    ++this.used;
                    float k = this.keys[i];
                    Object v = this.values[i];
                    int h = Math.abs(this.keyhash.hash(k));
                    int n = h % newcapacity;
                    if (newstates[n] == 1) {
                        int c = 1 + h % (newcapacity - 2);
                        do {
                            if ((n -= c) >= 0) continue;
                            n += newcapacity;
                        } while (newstates[n] != 0);
                    }
                    newstates[n] = 1;
                    newvalues[n] = v;
                    newkeys[n] = k;
                }
                ++i;
            }
            this.keys = newkeys;
            this.values = newvalues;
            this.states = newstates;
        }
    }

    public FloatSet keySet() {
        if (this.ckeys == null) {
            this.ckeys = new KeySet();
        }
        return this.ckeys;
    }

    public Object put(float key, Object value) {
        int i;
        block5: {
            int h = Math.abs(this.keyhash.hash(key));
            i = h % this.keys.length;
            if (this.states[i] == 1) {
                if (this.keys[i] == key) {
                    Object oldValue = this.values[i];
                    this.values[i] = value;
                    return oldValue;
                }
                int c = 1 + h % (this.keys.length - 2);
                do {
                    if ((i -= c) < 0) {
                        i += this.keys.length;
                    }
                    if (this.states[i] == 0 || this.states[i] == 2) break block5;
                } while (this.states[i] != 1 || this.keys[i] != key);
                Object oldValue = this.values[i];
                this.values[i] = value;
                return oldValue;
            }
        }
        if (this.states[i] == 0) {
            ++this.used;
        }
        this.states[i] = 1;
        this.keys[i] = key;
        this.values[i] = value;
        ++this.size;
        this.ensureCapacity(this.used);
        return null;
    }

    public Collection values() {
        if (this.cvalues == null) {
            this.cvalues = new ValueCollection();
        }
        return this.cvalues;
    }

    public Object clone() {
        try {
            FloatKeyOpenHashMap c = (FloatKeyOpenHashMap)super.clone();
            c.keys = new float[this.keys.length];
            System.arraycopy(this.keys, 0, c.keys, 0, this.keys.length);
            c.values = new Object[this.values.length];
            System.arraycopy(this.values, 0, c.values, 0, this.values.length);
            c.states = new byte[this.states.length];
            System.arraycopy(this.states, 0, c.states, 0, this.states.length);
            c.cvalues = null;
            c.ckeys = null;
            return c;
        }
        catch (CloneNotSupportedException e) {
            Exceptions.cloning();
            return null;
        }
    }

    public FloatKeyMapIterator entries() {
        return new FloatKeyMapIterator(){
            int nextEntry = this.nextEntry(0);
            int lastEntry = -1;

            int nextEntry(int index) {
                while (index < FloatKeyOpenHashMap.this.keys.length && FloatKeyOpenHashMap.this.states[index] != 1) {
                    ++index;
                }
                return index;
            }

            public boolean hasNext() {
                return this.nextEntry < FloatKeyOpenHashMap.this.keys.length;
            }

            public void next() {
                if (!this.hasNext()) {
                    Exceptions.endOfIterator();
                }
                this.lastEntry = this.nextEntry;
                this.nextEntry = this.nextEntry(this.nextEntry + 1);
            }

            public void remove() {
                if (this.lastEntry == -1) {
                    Exceptions.noElementToRemove();
                }
                ((FloatKeyOpenHashMap)FloatKeyOpenHashMap.this).states[this.lastEntry] = 2;
                ((FloatKeyOpenHashMap)FloatKeyOpenHashMap.this).values[this.lastEntry] = null;
                FloatKeyOpenHashMap.this.size--;
                this.lastEntry = -1;
            }

            public float getKey() {
                if (this.lastEntry == -1) {
                    Exceptions.noElementToGet();
                }
                return FloatKeyOpenHashMap.this.keys[this.lastEntry];
            }

            public Object getValue() {
                if (this.lastEntry == -1) {
                    Exceptions.noElementToGet();
                }
                return FloatKeyOpenHashMap.this.values[this.lastEntry];
            }
        };
    }

    public void clear() {
        Arrays.fill(this.states, (byte)0);
        Arrays.fill(this.values, null);
        this.size = 0;
        this.used = 0;
    }

    public boolean containsKey(float key) {
        int h = Math.abs(this.keyhash.hash(key));
        int i = h % this.keys.length;
        if (this.states[i] != 0) {
            if (this.states[i] == 1 && this.keys[i] == key) {
                return true;
            }
            int c = 1 + h % (this.keys.length - 2);
            do {
                if ((i -= c) < 0) {
                    i += this.keys.length;
                }
                if (this.states[i] != 0) continue;
                return false;
            } while (this.states[i] != 1 || this.keys[i] != key);
            return true;
        }
        return false;
    }

    public boolean containsValue(Object value) {
        if (value == null) {
            int i = 0;
            while (i < this.states.length) {
                if (this.states[i] == 1 && this.values[i] == null) {
                    return true;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.states.length) {
                if (this.states[i] == 1 && value.equals(this.values[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public Object get(float key) {
        int h = Math.abs(this.keyhash.hash(key));
        int i = h % this.keys.length;
        if (this.states[i] != 0) {
            if (this.states[i] == 1 && this.keys[i] == key) {
                return this.values[i];
            }
            int c = 1 + h % (this.keys.length - 2);
            do {
                if ((i -= c) < 0) {
                    i += this.keys.length;
                }
                if (this.states[i] != 0) continue;
                return null;
            } while (this.states[i] != 1 || this.keys[i] != key);
            return this.values[i];
        }
        return null;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public Object remove(float key) {
        int h = Math.abs(this.keyhash.hash(key));
        int i = h % this.keys.length;
        if (this.states[i] != 0) {
            if (this.states[i] == 1 && this.keys[i] == key) {
                Object oldValue = this.values[i];
                this.values[i] = null;
                this.states[i] = 2;
                --this.size;
                return oldValue;
            }
            int c = 1 + h % (this.keys.length - 2);
            do {
                if ((i -= c) < 0) {
                    i += this.keys.length;
                }
                if (this.states[i] != 0) continue;
                return null;
            } while (this.states[i] != 1 || this.keys[i] != key);
            Object oldValue = this.values[i];
            this.values[i] = null;
            this.states[i] = 2;
            --this.size;
            return oldValue;
        }
        return null;
    }

    public int size() {
        return this.size;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.keys.length);
        FloatKeyMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            s.writeFloat(i.getKey());
            s.writeObject(i.getValue());
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.keys = new float[s.readInt()];
        this.states = new byte[this.keys.length];
        this.values = new Object[this.keys.length];
        this.used = this.size;
        int n = 0;
        while (n < this.size) {
            float key = s.readFloat();
            Object value = s.readObject();
            int h = Math.abs(this.keyhash.hash(key));
            int i = h % this.keys.length;
            if (this.states[i] != 0) {
                int c = 1 + h % (this.keys.length - 2);
                do {
                    if ((i -= c) >= 0) continue;
                    i += this.keys.length;
                } while (this.states[i] != 0);
            }
            this.states[i] = 1;
            this.keys[i] = key;
            this.values[i] = value;
            ++n;
        }
    }

    private class ValueCollection
    extends AbstractCollection {
        private ValueCollection() {
        }

        public void clear() {
            FloatKeyOpenHashMap.this.clear();
        }

        public boolean contains(Object v) {
            return FloatKeyOpenHashMap.this.containsValue(v);
        }

        public Iterator iterator() {
            return new Iterator(this){
                int nextEntry;
                int lastEntry;
                private final /* synthetic */ ValueCollection this$1;
                {
                    this.this$1 = this$1;
                    this.nextEntry = this.nextEntry(0);
                    this.lastEntry = -1;
                }

                int nextEntry(int index) {
                    while (index < FloatKeyOpenHashMap.access$200(ValueCollection.access$700(this.this$1)).length && FloatKeyOpenHashMap.access$300(ValueCollection.access$700(this.this$1))[index] != 1) {
                        ++index;
                    }
                    return index;
                }

                public boolean hasNext() {
                    return this.nextEntry < FloatKeyOpenHashMap.access$200(ValueCollection.access$700(this.this$1)).length;
                }

                public Object next() {
                    if (!this.hasNext()) {
                        Exceptions.endOfIterator();
                    }
                    this.lastEntry = this.nextEntry;
                    this.nextEntry = this.nextEntry(this.nextEntry + 1);
                    return FloatKeyOpenHashMap.access$400(ValueCollection.access$700(this.this$1))[this.lastEntry];
                }

                public void remove() {
                    if (this.lastEntry == -1) {
                        Exceptions.noElementToRemove();
                    }
                    FloatKeyOpenHashMap.access$300((FloatKeyOpenHashMap)ValueCollection.access$700((ValueCollection)this.this$1))[this.lastEntry] = 2;
                    FloatKeyOpenHashMap.access$400((FloatKeyOpenHashMap)ValueCollection.access$700((ValueCollection)this.this$1))[this.lastEntry] = null;
                    FloatKeyOpenHashMap.access$510(ValueCollection.access$700(this.this$1));
                    this.lastEntry = -1;
                }
            };
        }

        public int size() {
            return FloatKeyOpenHashMap.this.size;
        }

        static /* synthetic */ FloatKeyOpenHashMap access$700(ValueCollection x0) {
            return x0.FloatKeyOpenHashMap.this;
        }
    }

    private class KeySet
    extends AbstractFloatSet {
        private KeySet() {
        }

        public void clear() {
            FloatKeyOpenHashMap.this.clear();
        }

        public boolean contains(float v) {
            return FloatKeyOpenHashMap.this.containsKey(v);
        }

        public FloatIterator iterator() {
            return new FloatIterator(this){
                int nextEntry;
                int lastEntry;
                private final /* synthetic */ KeySet this$1;
                {
                    this.this$1 = this$1;
                    this.nextEntry = this.nextEntry(0);
                    this.lastEntry = -1;
                }

                int nextEntry(int index) {
                    while (index < FloatKeyOpenHashMap.access$200(KeySet.access$600(this.this$1)).length && FloatKeyOpenHashMap.access$300(KeySet.access$600(this.this$1))[index] != 1) {
                        ++index;
                    }
                    return index;
                }

                public boolean hasNext() {
                    return this.nextEntry < FloatKeyOpenHashMap.access$200(KeySet.access$600(this.this$1)).length;
                }

                public float next() {
                    if (!this.hasNext()) {
                        Exceptions.endOfIterator();
                    }
                    this.lastEntry = this.nextEntry;
                    this.nextEntry = this.nextEntry(this.nextEntry + 1);
                    return FloatKeyOpenHashMap.access$200(KeySet.access$600(this.this$1))[this.lastEntry];
                }

                public void remove() {
                    if (this.lastEntry == -1) {
                        Exceptions.noElementToRemove();
                    }
                    FloatKeyOpenHashMap.access$300((FloatKeyOpenHashMap)KeySet.access$600((KeySet)this.this$1))[this.lastEntry] = 2;
                    FloatKeyOpenHashMap.access$400((FloatKeyOpenHashMap)KeySet.access$600((KeySet)this.this$1))[this.lastEntry] = null;
                    FloatKeyOpenHashMap.access$510(KeySet.access$600(this.this$1));
                    this.lastEntry = -1;
                }
            };
        }

        public boolean remove(float v) {
            boolean result = FloatKeyOpenHashMap.this.containsKey(v);
            if (result) {
                FloatKeyOpenHashMap.this.remove(v);
            }
            return result;
        }

        public int size() {
            return FloatKeyOpenHashMap.this.size;
        }

        static /* synthetic */ FloatKeyOpenHashMap access$600(KeySet x0) {
            return x0.FloatKeyOpenHashMap.this;
        }
    }
}

