/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.map;

import bak.pcj.ShortCollection;
import bak.pcj.hash.DefaultDoubleHashFunction;
import bak.pcj.hash.DefaultShortHashFunction;
import bak.pcj.map.DoubleKeyShortMap;
import bak.pcj.map.DoubleKeyShortMapIterator;
import bak.pcj.map.MapDefaults;
import bak.pcj.set.DoubleSet;
import bak.pcj.util.Exceptions;

public abstract class AbstractDoubleKeyShortMap
implements DoubleKeyShortMap {
    protected AbstractDoubleKeyShortMap() {
    }

    public void clear() {
        DoubleKeyShortMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
    }

    public short remove(double key) {
        DoubleKeyShortMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            short value = i.getValue();
            i.remove();
            return value;
        }
        return MapDefaults.defaultShort();
    }

    public void putAll(DoubleKeyShortMap map) {
        DoubleKeyShortMapIterator i = map.entries();
        while (i.hasNext()) {
            i.next();
            this.put(i.getKey(), i.getValue());
        }
    }

    public boolean containsKey(double key) {
        DoubleKeyShortMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            return true;
        }
        return false;
    }

    public short get(double key) {
        DoubleKeyShortMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            return i.getValue();
        }
        return MapDefaults.defaultShort();
    }

    public boolean containsValue(short value) {
        DoubleKeyShortMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getValue() != value) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DoubleKeyShortMap)) {
            return false;
        }
        DoubleKeyShortMap map = (DoubleKeyShortMap)obj;
        if (this.size() != map.size()) {
            return false;
        }
        DoubleKeyShortMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            double k = i.getKey();
            if (map.containsKey(k) && map.lget() == i.getValue()) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h = 0;
        DoubleKeyShortMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            h += DefaultDoubleHashFunction.INSTANCE.hash(i.getKey()) ^ DefaultShortHashFunction.INSTANCE.hash(i.getValue());
        }
        return h;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size() {
        int size = 0;
        DoubleKeyShortMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            ++size;
        }
        return size;
    }

    public short tget(double key) {
        short value = this.get(key);
        if (value == MapDefaults.defaultShort() && !this.containsKey(key)) {
            Exceptions.noSuchMapping(String.valueOf(key));
        }
        return value;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append('[');
        DoubleKeyShortMapIterator i = this.entries();
        while (i.hasNext()) {
            if (s.length() > 1) {
                s.append(',');
            }
            i.next();
            s.append(String.valueOf(i.getKey()));
            s.append("->");
            s.append(String.valueOf(i.getValue()));
        }
        s.append(']');
        return s.toString();
    }

    public void trimToSize() {
    }

    public abstract ShortCollection values();

    public abstract short put(double var1, short var3);

    public abstract short lget();

    public abstract DoubleSet keySet();

    public abstract DoubleKeyShortMapIterator entries();
}

