/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.map;

import bak.pcj.DoubleCollection;
import bak.pcj.hash.DefaultDoubleHashFunction;
import bak.pcj.map.DoubleKeyDoubleMap;
import bak.pcj.map.DoubleKeyDoubleMapIterator;
import bak.pcj.map.MapDefaults;
import bak.pcj.set.DoubleSet;
import bak.pcj.util.Exceptions;

public abstract class AbstractDoubleKeyDoubleMap
implements DoubleKeyDoubleMap {
    protected AbstractDoubleKeyDoubleMap() {
    }

    public void clear() {
        DoubleKeyDoubleMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
    }

    public double remove(double key) {
        DoubleKeyDoubleMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            double value = i.getValue();
            i.remove();
            return value;
        }
        return MapDefaults.defaultDouble();
    }

    public void putAll(DoubleKeyDoubleMap map) {
        DoubleKeyDoubleMapIterator i = map.entries();
        while (i.hasNext()) {
            i.next();
            this.put(i.getKey(), i.getValue());
        }
    }

    public boolean containsKey(double key) {
        DoubleKeyDoubleMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            return true;
        }
        return false;
    }

    public double get(double key) {
        DoubleKeyDoubleMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            return i.getValue();
        }
        return MapDefaults.defaultDouble();
    }

    public boolean containsValue(double value) {
        DoubleKeyDoubleMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getValue() != value) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DoubleKeyDoubleMap)) {
            return false;
        }
        DoubleKeyDoubleMap map = (DoubleKeyDoubleMap)obj;
        if (this.size() != map.size()) {
            return false;
        }
        DoubleKeyDoubleMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            double k = i.getKey();
            if (map.containsKey(k) && map.lget() == i.getValue()) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h = 0;
        DoubleKeyDoubleMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            h += DefaultDoubleHashFunction.INSTANCE.hash(i.getKey()) ^ DefaultDoubleHashFunction.INSTANCE.hash(i.getValue());
        }
        return h;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size() {
        int size = 0;
        DoubleKeyDoubleMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            ++size;
        }
        return size;
    }

    public double tget(double key) {
        double value = this.get(key);
        if (value == MapDefaults.defaultDouble() && !this.containsKey(key)) {
            Exceptions.noSuchMapping(String.valueOf(key));
        }
        return value;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append('[');
        DoubleKeyDoubleMapIterator i = this.entries();
        while (i.hasNext()) {
            if (s.length() > 1) {
                s.append(',');
            }
            i.next();
            s.append(String.valueOf(i.getKey()));
            s.append("->");
            s.append(String.valueOf(i.getValue()));
        }
        s.append(']');
        return s.toString();
    }

    public void trimToSize() {
    }

    public abstract DoubleCollection values();

    public abstract double put(double var1, double var3);

    public abstract double lget();

    public abstract DoubleSet keySet();

    public abstract DoubleKeyDoubleMapIterator entries();
}

