/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.map;

import bak.pcj.ByteCollection;
import bak.pcj.hash.DefaultByteHashFunction;
import bak.pcj.hash.DefaultDoubleHashFunction;
import bak.pcj.map.DoubleKeyByteMap;
import bak.pcj.map.DoubleKeyByteMapIterator;
import bak.pcj.map.MapDefaults;
import bak.pcj.set.DoubleSet;
import bak.pcj.util.Exceptions;

public abstract class AbstractDoubleKeyByteMap
implements DoubleKeyByteMap {
    protected AbstractDoubleKeyByteMap() {
    }

    public void clear() {
        DoubleKeyByteMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
    }

    public byte remove(double key) {
        DoubleKeyByteMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            byte value = i.getValue();
            i.remove();
            return value;
        }
        return MapDefaults.defaultByte();
    }

    public void putAll(DoubleKeyByteMap map) {
        DoubleKeyByteMapIterator i = map.entries();
        while (i.hasNext()) {
            i.next();
            this.put(i.getKey(), i.getValue());
        }
    }

    public boolean containsKey(double key) {
        DoubleKeyByteMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            return true;
        }
        return false;
    }

    public byte get(double key) {
        DoubleKeyByteMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getKey() != key) continue;
            return i.getValue();
        }
        return MapDefaults.defaultByte();
    }

    public boolean containsValue(byte value) {
        DoubleKeyByteMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            if (i.getValue() != value) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DoubleKeyByteMap)) {
            return false;
        }
        DoubleKeyByteMap map = (DoubleKeyByteMap)obj;
        if (this.size() != map.size()) {
            return false;
        }
        DoubleKeyByteMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            double k = i.getKey();
            if (map.containsKey(k) && map.lget() == i.getValue()) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h = 0;
        DoubleKeyByteMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            h += DefaultDoubleHashFunction.INSTANCE.hash(i.getKey()) ^ DefaultByteHashFunction.INSTANCE.hash(i.getValue());
        }
        return h;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size() {
        int size = 0;
        DoubleKeyByteMapIterator i = this.entries();
        while (i.hasNext()) {
            i.next();
            ++size;
        }
        return size;
    }

    public byte tget(double key) {
        byte value = this.get(key);
        if (value == MapDefaults.defaultByte() && !this.containsKey(key)) {
            Exceptions.noSuchMapping(String.valueOf(key));
        }
        return value;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append('[');
        DoubleKeyByteMapIterator i = this.entries();
        while (i.hasNext()) {
            if (s.length() > 1) {
                s.append(',');
            }
            i.next();
            s.append(String.valueOf(i.getKey()));
            s.append("->");
            s.append(String.valueOf(i.getValue()));
        }
        s.append(']');
        return s.toString();
    }

    public void trimToSize() {
    }

    public abstract ByteCollection values();

    public abstract byte put(double var1, byte var3);

    public abstract byte lget();

    public abstract DoubleSet keySet();

    public abstract DoubleKeyByteMapIterator entries();
}

